/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.notification;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.RingtoneManager;
import android.support.v4.app.NotificationCompat;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.notification.WearableNotificationWithVoice;
import com.applozic.mobicomkit.broadcast.NotificationBroadcastReceiver;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.contact.Contact;
import java.io.InputStream;
import java.net.HttpURLConnection;

public class NotificationService {
    private static final int NOTIFICATION_ID = 1000;
    private Context context;
    private int iconResourceId;
    private int wearable_action_title;
    private int wearable_action_label;
    private int wearable_send_icon;
    private static final String NOTIFICATION_SMALL_ICON_METADATA = "com.applozic.mobicomkit.notification.smallIcon";

    public NotificationService(int iconResourceID, Context context, int wearable_action_label, int wearable_action_title, int wearable_send_icon) {
        this.context = context;
        this.iconResourceId = iconResourceID;
        this.wearable_action_label = wearable_action_label;
        this.wearable_action_title = wearable_action_title;
        this.wearable_send_icon = wearable_send_icon;
    }

    public void notifyUser(Contact contact, Message message) {
        Intent intent = new Intent();
        intent.putExtra("message_json", GsonUtils.getJsonFromObject((Object)message, Message.class));
        intent.setAction(NotificationBroadcastReceiver.LAUNCH_APP);
        intent.setClass(this.context, NotificationBroadcastReceiver.class);
        Integer smallIconResourceId = Utils.getMetaDataValueForResources((Context)this.context, (String)NOTIFICATION_SMALL_ICON_METADATA) != null ? Utils.getMetaDataValueForResources((Context)this.context, (String)NOTIFICATION_SMALL_ICON_METADATA) : this.iconResourceId;
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)((int)(System.currentTimeMillis() & 0xFFFFFFFL)), (Intent)intent, (int)0);
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(this.context).setSmallIcon(smallIconResourceId.intValue()).setLargeIcon(BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)this.iconResourceId)).setCategory("msg").setPriority(2).setWhen(System.currentTimeMillis()).setContentTitle((CharSequence)contact.getDisplayName()).setContentText((CharSequence)message.getMessage()).setSound(RingtoneManager.getDefaultUri((int)2));
        mBuilder.setContentIntent(pendingIntent);
        mBuilder.setAutoCancel(true);
        if (message.hasAttachment()) {
            try {
                FileMeta fileMeta = message.getFileMetas();
                HttpURLConnection httpConn = new MobiComKitClientService(this.context).openHttpConnection(fileMeta.getThumbnailUrl());
                int response = httpConn.getResponseCode();
                if (response == 200) {
                    InputStream in = httpConn.getInputStream();
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)in);
                    String imageName = fileMeta.getBlobKeyString() + "." + FileUtils.getFileFormat((String)fileMeta.getName());
                    FileClientService.saveImageToInternalStorage(bitmap, imageName, this.context, fileMeta.getContentType());
                    mBuilder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(bitmap));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        WearableNotificationWithVoice notificationWithVoice = new WearableNotificationWithVoice(mBuilder, this.wearable_action_title, this.wearable_action_label, this.wearable_send_icon, message.getContactIds().hashCode());
        notificationWithVoice.setCurrentContext(this.context);
        notificationWithVoice.setPendingIntent(pendingIntent);
        try {
            notificationWithVoice.sendNotification();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

