/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.notification;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.UserDetail;
import com.applozic.mobicomkit.api.conversation.MessageClientService;
import com.applozic.mobicomkit.api.conversation.MobiComConversationService;
import com.applozic.mobicomkit.api.conversation.SyncCallService;
import com.applozic.mobicomkit.api.notification.MessageDeleteContent;
import com.applozic.mobicomkit.api.people.ContactContent;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.contact.ContactService;
import com.applozic.mobicomkit.contact.database.ContactDatabase;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;

public class MobiComPushReceiver {
    public static final String MTCOM_PREFIX = "MT_";
    public static final List<String> notificationKeyList = new ArrayList<String>();
    private static final String TAG = "MobiComPushReceiver";

    public static boolean isMobiComPushNotification(Intent intent) {
        Log.i((String)TAG, (String)"checking for Applozic notification.");
        return MobiComPushReceiver.isMobiComPushNotification(intent.getExtras());
    }

    public static boolean isMobiComPushNotification(Bundle bundle) {
        String payLoad = bundle.getString("collapse_key");
        Log.i((String)TAG, (String)("Received notification: " + payLoad));
        if (payLoad != null && payLoad.contains(MTCOM_PREFIX) || notificationKeyList.contains(payLoad)) {
            return true;
        }
        for (String key : notificationKeyList) {
            payLoad = bundle.getString(key);
            if (payLoad == null) continue;
            return true;
        }
        return false;
    }

    public static void processMessage(Context context, Bundle bundle) {
        if (bundle != null) {
            String message = bundle.getString("collapse_key");
            String deleteConversationForContact = bundle.getString(notificationKeyList.get(6));
            String deleteSms = bundle.getString(notificationKeyList.get(4));
            String multipleMessageDelete = bundle.getString(notificationKeyList.get(5));
            String mtexterUser = bundle.getString(notificationKeyList.get(7));
            String payloadForDelivered = bundle.getString(notificationKeyList.get(2));
            if (TextUtils.isEmpty((CharSequence)payloadForDelivered)) {
                payloadForDelivered = bundle.getString(notificationKeyList.get(17));
            }
            String userConnected = bundle.getString(notificationKeyList.get(15));
            String userDisconnected = bundle.getString(notificationKeyList.get(16));
            MobiComPushReceiver.processMessage(context, bundle, message, deleteConversationForContact, deleteSms, multipleMessageDelete, mtexterUser, payloadForDelivered, userConnected, userDisconnected);
        }
    }

    public static void processMessage(final Context context, Bundle bundle, String message, String deleteConversationForContact, String deleteSms, String multipleMessageDelete, String mtexterUser, String payloadForDelivered, String userConnected, String userDisconnected) {
        String userId;
        Gson gson;
        SyncCallService syncCallService = SyncCallService.getInstance(context);
        final MessageClientService messageClientService = new MessageClientService(context);
        if (!TextUtils.isEmpty((CharSequence)payloadForDelivered)) {
            syncCallService.updateDeliveryStatus(payloadForDelivered);
        }
        if (!TextUtils.isEmpty((CharSequence)deleteConversationForContact)) {
            MobiComConversationService conversationService = new MobiComConversationService(context);
            conversationService.deleteConversationFromDevice(deleteConversationForContact);
            BroadcastService.sendConversationDeleteBroadcast(context, BroadcastService.INTENT_ACTIONS.DELETE_CONVERSATION.toString(), deleteConversationForContact, "success");
        }
        if (!TextUtils.isEmpty((CharSequence)mtexterUser)) {
            Log.i((String)TAG, (String)("Received GCM message MTEXTER_USER: " + mtexterUser));
            if (mtexterUser.contains("{")) {
                gson = new Gson();
                ContactContent contactContent = (ContactContent)gson.fromJson(mtexterUser, ContactContent.class);
                ContactService.addUsersToContact(context, contactContent.getContactNumber(), contactContent.getAppVersion(), true);
            } else {
                String[] details = mtexterUser.split(",");
                ContactService.addUsersToContact(context, details[0], Short.parseShort(details[1]), true);
            }
        }
        if (!TextUtils.isEmpty((CharSequence)userConnected)) {
            userId = userConnected;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    UserDetail[] userDetail = messageClientService.getUserDetails(userId);
                    if (userDetail != null) {
                        for (UserDetail userDetails : userDetail) {
                            if (userDetails == null || !userDetails.isConnected()) continue;
                            new ContactDatabase(context).updateConnectedOrDisconnectedStatus(userId, userDetails.isConnected());
                        }
                    }
                }
            }).start();
        }
        if (!TextUtils.isEmpty((CharSequence)userDisconnected)) {
            userId = userDisconnected;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    UserDetail[] userDetail = messageClientService.getUserDetails(userId);
                    if (userDetail != null) {
                        for (UserDetail userDetails : userDetail) {
                            if (userDetails == null || userDetails.getLastSeenAtTime() == null) continue;
                            ContactDatabase contactDatabase = new ContactDatabase(context);
                            contactDatabase.updateConnectedOrDisconnectedStatus(userId, userDetails.isConnected());
                            contactDatabase.updateLastSeenTimeAt(userId, userDetails.getLastSeenAtTime());
                        }
                    }
                }
            }).start();
        }
        if (!TextUtils.isEmpty((CharSequence)multipleMessageDelete)) {
            gson = new GsonBuilder().setPrettyPrinting().create();
            MessageDeleteContent messageDeleteContent = (MessageDeleteContent)gson.fromJson(multipleMessageDelete, MessageDeleteContent.class);
            for (String deletedSmsKeyString : messageDeleteContent.getDeleteKeyStrings()) {
                MobiComPushReceiver.processDeleteSingleMessageRequest(context, deletedSmsKeyString, messageDeleteContent.getContactNumber());
            }
        }
        if (!TextUtils.isEmpty((CharSequence)deleteSms)) {
            String contactNumbers = deleteSms.split(",").length > 1 ? deleteSms.split(",")[1] : null;
            MobiComPushReceiver.processDeleteSingleMessageRequest(context, deleteSms.split(",")[0], contactNumbers);
        }
        String messageKey = bundle.getString(notificationKeyList.get(0));
        if (!notificationKeyList.get(1).equalsIgnoreCase(message)) {
            if (!TextUtils.isEmpty((CharSequence)messageKey)) {
                Log.i((String)TAG, (String)("MT sync for key: " + messageKey));
                syncCallService.syncMessages(messageKey);
            } else if (notificationKeyList.get(0).equalsIgnoreCase(message)) {
                syncCallService.syncMessages(null);
            } else if (!notificationKeyList.get(3).equalsIgnoreCase(message) && notificationKeyList.get(18).equals(message)) {
                String contactId = bundle.getString(notificationKeyList.get(18));
                Log.i((String)TAG, (String)("Got conversation read for contactId: " + contactId));
                syncCallService.updateDeliveryStatusForContact(contactId);
            }
        }
    }

    private static void processDeleteSingleMessageRequest(Context context, String deletedSmsKeyString, String contactNumber) {
        MobiComConversationService conversationService = new MobiComConversationService(context);
        contactNumber = conversationService.deleteMessageFromDevice(deletedSmsKeyString, contactNumber);
        BroadcastService.sendMessageDeleteBroadcast(context, BroadcastService.INTENT_ACTIONS.DELETE_MESSAGE.toString(), deletedSmsKeyString, contactNumber);
    }

    public static void processMessageAsync(final Context context, final Bundle bundle) {
        if (MobiComUserPreference.getInstance(context).isLoggedIn()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    MobiComPushReceiver.processMessage(context, bundle);
                }
            }).start();
        }
    }

    public static void processMessageAsync(Context context, Intent intent) {
        MobiComPushReceiver.processMessageAsync(context, intent.getExtras());
    }

    static {
        notificationKeyList.add("MT_SYNC");
        notificationKeyList.add("MT_MARK_ALL_MESSAGE_AS_READ");
        notificationKeyList.add("MT_DELIVERED");
        notificationKeyList.add("MT_SYNC_PENDING");
        notificationKeyList.add("MT_DELETE_MESSAGE");
        notificationKeyList.add("MT_DELETE_MULTIPLE_MESSAGE");
        notificationKeyList.add("MT_DELETE_MESSAGE_CONTACT");
        notificationKeyList.add("MTEXTER_USER");
        notificationKeyList.add("MT_CONTACT_VERIFIED");
        notificationKeyList.add("MT_CONTACT_UPDATED");
        notificationKeyList.add("MT_DEVICE_CONTACT_SYNC");
        notificationKeyList.add("MT_EMAIL_VERIFIED");
        notificationKeyList.add("MT_DEVICE_CONTACT_MESSAGE");
        notificationKeyList.add("MT_CANCEL_CALL");
        notificationKeyList.add("MT_MESSAGE");
        notificationKeyList.add("MT_USER_CONNECTED");
        notificationKeyList.add("MT_USER_DISCONNECTED");
        notificationKeyList.add("MT_MESSAGE_DELIVERED_READ");
        notificationKeyList.add("MT_CONVERSATION_READ");
    }
}

