/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.conversation;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.attachment.FileClientService;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicomkit.api.conversation.Message;
import com.applozic.mobicomkit.api.conversation.MessageClientService;
import com.applozic.mobicomkit.api.conversation.MessageIntentService;
import com.applozic.mobicomkit.api.conversation.MobiComMessageService;
import com.applozic.mobicomkit.api.conversation.database.MessageDatabaseService;
import com.applozic.mobicomkit.broadcast.BroadcastService;
import com.applozic.mobicomkit.contact.AppContactService;
import com.applozic.mobicommons.file.FileUtils;
import com.applozic.mobicommons.json.AnnotationExclusionStrategy;
import com.applozic.mobicommons.json.ArrayAdapterFactory;
import com.applozic.mobicommons.json.GsonUtils;
import com.applozic.mobicommons.people.contact.Contact;
import com.applozic.mobicommons.people.group.Group;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapterFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class MobiComConversationService {
    private static final String TAG = "Conversation";
    public static final String SERVER_SYNC = "SERVER_SYNC_";
    private SharedPreferences sharedPreferences;
    protected Context context = null;
    protected MessageClientService messageClientService;
    protected MessageDatabaseService messageDatabaseService;

    public MobiComConversationService(Context context) {
        this.context = context;
        this.messageClientService = new MessageClientService(context);
        this.messageDatabaseService = new MessageDatabaseService(context);
        this.sharedPreferences = context.getSharedPreferences(MobiComKitClientService.getApplicationKey(context), 0);
    }

    public void sendMessage(Message message) {
        this.sendMessage(message, MessageIntentService.class);
    }

    public void sendMessage(Message message, Class messageIntentClass) {
        Intent intent = new Intent(this.context, messageIntentClass);
        intent.putExtra("message_json", GsonUtils.getJsonFromObject((Object)message, Message.class));
        this.context.startService(intent);
    }

    public List<Message> getLatestMessagesGroupByPeople() {
        return this.getLatestMessagesGroupByPeople(null);
    }

    public synchronized List<Message> getLatestMessagesGroupByPeople(Long createdAt) {
        boolean emptyTable = this.messageDatabaseService.isMessageTableEmpty();
        if (emptyTable) {
            this.getMessages(null, null, null, null);
        }
        List<Message> messageList = this.messageDatabaseService.getMessages(createdAt);
        Iterator<Message> messageIterator = messageList.iterator();
        while (messageIterator.hasNext()) {
            Message message = messageIterator.next();
            if (!message.isSentToMany()) continue;
            messageIterator.remove();
        }
        return messageList;
    }

    public List<Message> getMessages(String userId, Long startTime, Long endTime) {
        return this.getMessages(startTime, endTime, new Contact(userId), null);
    }

    public synchronized List<Message> getMessages(Long startTime, Long endTime, Contact contact, Group group) {
        String data;
        ArrayList<Message> messageList = new ArrayList<Message>();
        AppContactService baseContactService = new AppContactService(this.context);
        List<Message> cachedMessageList = this.messageDatabaseService.getMessages(startTime, endTime, contact, group);
        if (!cachedMessageList.isEmpty() && (cachedMessageList.size() > 1 || this.wasServerCallDoneBefore(contact, group))) {
            Log.i((String)TAG, (String)("cachedMessageList size is : " + cachedMessageList.size()));
            return cachedMessageList;
        }
        try {
            data = this.messageClientService.getMessages(contact, group, startTime, endTime);
            Log.i((String)TAG, (String)("Received response from server for Messages: " + data));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return cachedMessageList;
        }
        if (data == null || TextUtils.isEmpty((CharSequence)data) || data.equals("UnAuthorized Access") || !data.contains("{")) {
            if (group != null && group.getGroupId() != null) {
                return cachedMessageList;
            }
            return cachedMessageList;
        }
        if (contact != null || group != null) {
            this.sharedPreferences.edit().putBoolean(SERVER_SYNC + (contact != null ? contact.getContactIds() : group.getGroupId()), true).commit();
        }
        try {
            Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new ArrayAdapterFactory()).setExclusionStrategies(new ExclusionStrategy[]{new AnnotationExclusionStrategy()}).create();
            JsonParser parser = new JsonParser();
            String element = parser.parse(data).getAsJsonObject().get("message").toString();
            Message[] messages = (Message[])gson.fromJson(element, Message[].class);
            MobiComUserPreference userPreferences = MobiComUserPreference.getInstance(this.context);
            String connectedUsersResponse = parser.parse(data).getAsJsonObject().get("connectedUsers").toString();
            String[] connectedUserIds = (String[])GsonUtils.getObjectFromJson((String)connectedUsersResponse, String[].class);
            if (messages != null && messages.length > 0 && cachedMessageList.size() > 0 && cachedMessageList.get(0).isLocalMessage() && cachedMessageList.get(0).equals(messages[0])) {
                Log.i((String)TAG, (String)"Both messages are same.");
                this.deleteMessage(cachedMessageList.get(0));
            }
            new MobiComMessageService(this.context, MessageIntentService.class).processContactFromMessages(Arrays.asList(messages));
            for (Message message : messages) {
                if (message.isCall() && !userPreferences.isDisplayCallRecordEnable() || message.getTo() == null) continue;
                if (connectedUserIds != null && connectedUserIds.length > 0) {
                    for (String userId : connectedUserIds) {
                        if (!message.getTo().equals(userId)) continue;
                        Contact connectedContact = new Contact();
                        connectedContact.setUserId(userId);
                        connectedContact.setConnected(true);
                        connectedContact.setContactNumber(userId);
                        baseContactService.upsert(connectedContact);
                    }
                }
                if (message.hasAttachment()) {
                    this.setFilePathifExist(message);
                }
                messageList.add(message);
                this.messageDatabaseService.createMessage(message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        messageList.removeAll(cachedMessageList);
        messageList.addAll(cachedMessageList);
        Collections.sort(messageList, new Comparator<Message>(){

            @Override
            public int compare(Message lhs, Message rhs) {
                return lhs.getCreatedAtTime().compareTo(rhs.getCreatedAtTime());
            }
        });
        return messageList;
    }

    private boolean wasServerCallDoneBefore(Contact contact, Group group) {
        return this.sharedPreferences.getBoolean(SERVER_SYNC + contact.getContactIds(), false);
    }

    private void setFilePathifExist(Message message) {
        FileMeta fileMeta = message.getFileMetas();
        File file = FileClientService.getFilePath(fileMeta.getBlobKeyString() + "." + FileUtils.getFileFormat((String)fileMeta.getName()), this.context, fileMeta.getContentType());
        if (file.exists()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(file.getAbsolutePath());
            message.setFilePaths(arrayList);
        }
    }

    public boolean deleteMessage(Message message, Contact contact) {
        if (!message.isSentToServer()) {
            this.deleteMessageFromDevice(message, contact != null ? contact.getContactIds() : null);
            return true;
        }
        String response = this.messageClientService.deleteMessage(message, contact);
        if ("success".equals(response)) {
            this.deleteMessageFromDevice(message, contact != null ? contact.getContactIds() : null);
        } else {
            this.messageDatabaseService.updateDeleteSyncStatus(message, "1");
        }
        return true;
    }

    public boolean deleteMessage(Message message) {
        return this.deleteMessage(message, null);
    }

    public String deleteMessageFromDevice(Message message, String contactNumber) {
        if (message == null) {
            return null;
        }
        return this.messageDatabaseService.deleteMessage(message, contactNumber);
    }

    public void deleteConversationFromDevice(String contactNumber) {
        this.messageDatabaseService.deleteConversation(contactNumber);
    }

    public void deleteAndBroadCast(final Contact contact, boolean deleteFromServer) {
        this.deleteConversationFromDevice(contact.getContactIds());
        if (deleteFromServer) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    MobiComConversationService.this.messageClientService.deleteConversationThreadFromServer(contact);
                }
            }).start();
        }
        BroadcastService.sendConversationDeleteBroadcast(this.context, BroadcastService.INTENT_ACTIONS.DELETE_CONVERSATION.toString(), contact.getContactIds(), "success");
    }

    public void deleteSync(Contact contact) {
        String response = this.messageClientService.syncDeleteConversationThreadFromServer(contact);
        if ("success".equals(response)) {
            this.messageDatabaseService.deleteConversation(contact.getContactIds());
        }
        BroadcastService.sendConversationDeleteBroadcast(this.context, BroadcastService.INTENT_ACTIONS.DELETE_CONVERSATION.toString(), contact.getContactIds(), response);
    }

    public String deleteMessageFromDevice(String keyString, String contactNumber) {
        return this.deleteMessageFromDevice(this.messageDatabaseService.getMessage(keyString), contactNumber);
    }
}

