/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.attachment;

import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Environment;
import android.util.Log;
import com.applozic.mobicomkit.api.HttpRequestUtils;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.attachment.FileMeta;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.applozic.mobicommons.commons.image.ImageUtils;
import com.applozic.mobicommons.file.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.Date;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

public class FileClientService
extends MobiComKitClientService {
    public static final String MOBI_TEXTER_IMAGES_FOLDER = "/image";
    public static final String MOBI_TEXTER_VIDEOS_FOLDER = "/video";
    public static final String MOBI_TEXTER_OTHER_FILES_FOLDER = "/other";
    public static final String MOBI_TEXTER_THUMBNAIL_SUFIX = "/.Thumbnail";
    public static final String FILE_UPLOAD_URL = "/rest/ws/aws/file/url";
    public static final String IMAGE_DIR = "image";
    private static final String TAG = "FileClientService";
    private HttpRequestUtils httpRequestUtils;
    private static final String MAIN_FOLDER_META_DATA = "main_folder_name";

    public FileClientService(Context context) {
        super(context);
        this.httpRequestUtils = new HttpRequestUtils(context);
    }

    public String getFileUploadUrl() {
        return this.FILE_BASE_URL + FILE_UPLOAD_URL;
    }

    public static File getFilePath(String fileName, Context context, String contentType, boolean isThumbnail) {
        File dir;
        if ("mounted".equals(Environment.getExternalStorageState())) {
            String folder = "/" + Utils.getMetaDataValue((Context)context, (String)MAIN_FOLDER_META_DATA) + MOBI_TEXTER_OTHER_FILES_FOLDER;
            if (contentType.startsWith(IMAGE_DIR)) {
                folder = "/" + Utils.getMetaDataValue((Context)context, (String)MAIN_FOLDER_META_DATA) + MOBI_TEXTER_IMAGES_FOLDER;
            } else if (contentType.startsWith("video")) {
                folder = "/" + Utils.getMetaDataValue((Context)context, (String)MAIN_FOLDER_META_DATA) + MOBI_TEXTER_VIDEOS_FOLDER;
            }
            if (isThumbnail) {
                folder = folder + MOBI_TEXTER_THUMBNAIL_SUFIX;
            }
            if (!(dir = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + folder)).exists()) {
                dir.mkdirs();
            }
        } else {
            ContextWrapper cw = new ContextWrapper(context);
            dir = cw.getDir(IMAGE_DIR, 0);
        }
        File filePath = new File(dir, fileName);
        return filePath;
    }

    public static String saveImageToInternalStorage(Bitmap bitmapImage, String fileName, Context context, String contentType) {
        File filePath = FileClientService.getFilePath(fileName, context, contentType, true);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filePath);
            bitmapImage.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filePath.getAbsolutePath();
    }

    public static File getFilePath(String fileName, Context context, String contentType) {
        return FileClientService.getFilePath(fileName, context, contentType, false);
    }

    public Bitmap loadThumbnailImage(Context context, FileMeta fileMeta, int reqWidth, int reqHeight) {
        try {
            Bitmap attachedImage = null;
            String thumbnailUrl = fileMeta.getThumbnailUrl();
            String contentType = fileMeta.getContentType();
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            String imageName = fileMeta.getBlobKeyString() + "." + FileUtils.getFileFormat((String)fileMeta.getName());
            String imageLocalPath = FileClientService.getFilePath(imageName, context, fileMeta.getContentType(), true).getAbsolutePath();
            if (imageLocalPath != null) {
                try {
                    attachedImage = BitmapFactory.decodeFile((String)imageLocalPath);
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)("File not found on local storage: " + ex.getMessage()));
                }
            }
            if (attachedImage == null) {
                HttpURLConnection connection = new MobiComKitClientService(context).openHttpConnection(thumbnailUrl);
                if (connection.getResponseCode() == 200) {
                    attachedImage = BitmapFactory.decodeStream((InputStream)connection.getInputStream());
                    imageLocalPath = FileClientService.saveImageToInternalStorage(attachedImage, imageName, context, contentType);
                } else {
                    Log.w((String)TAG, (String)("Download is failed response code is ...." + connection.getResponseCode()));
                }
            }
            options.inSampleSize = ImageUtils.calculateInSampleSize((BitmapFactory.Options)options, (int)200, (int)reqHeight);
            options.inJustDecodeBounds = false;
            attachedImage = BitmapFactory.decodeFile((String)imageLocalPath, (BitmapFactory.Options)options);
            return attachedImage;
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            Log.e((String)TAG, (String)("File not found on server: " + ex.getMessage()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.e((String)TAG, (String)("Exception fetching file from server: " + ex.getMessage()));
        }
        return null;
    }

    public String uploadBlobImage(String path) throws UnsupportedEncodingException, AuthenticationException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpPost httppost = new HttpPost(this.getUploadKey());
        BasicScheme scheme = new BasicScheme();
        httppost.addHeader(scheme.authenticate((Credentials)this.getCredentials(), (HttpRequest)httppost));
        this.httpRequestUtils.addGlobalHeaders((HttpRequest)httppost);
        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            String fileName = path.substring(path.lastIndexOf("/") + 1);
            FileBody fileBody = new FileBody(new File(path), ContentType.create((String)FileUtils.getMimeType((String)path)), fileName);
            builder.addPart("files[]", (ContentBody)fileBody);
            HttpEntity entity = builder.build();
            httppost.setEntity(entity);
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            Log.d((String)TAG, (String)("Image uploaded: " + response.getStatusLine()));
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("Image not uploaded: Exception:" + e.toString()));
            return null;
        }
    }

    public String getUploadKey() {
        return this.httpRequestUtils.getResponse(this.getCredentials(), this.getFileUploadUrl() + "?" + new Date().getTime(), "text/plain", "text/plain");
    }
}

