/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

public class HttpRequestUtils {
    private Context context;
    private static final String TAG = "HttpRequestUtils";
    private static String SOURCE_HEADER = "Source";
    private static String SOURCE_HEADER_VALUE = "1";
    public static String APPLICATION_KEY_HEADER = "Application-Key";
    public static String USERID_HEADER = "UserId-Enabled";
    public static String USERID_HEADER_VALUE = "true";
    public static String DEVICE_KEY_HEADER = "Device-Key";

    public HttpRequestUtils(Context context) {
        this.context = context;
    }

    private void log(String message) {
        Log.i((String)TAG, (String)message);
    }

    public InputStream getInputStreamFromUrl(String url) throws Exception {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpResponse response = httpclient.execute((HttpUriRequest)new HttpGet(url));
        return response.getEntity().getContent();
    }

    public String postData(UsernamePasswordCredentials credentials, String url, String contentType, String accept, String data) {
        return this.postData(credentials, url, contentType, accept, data, null);
    }

    public String postData(UsernamePasswordCredentials credentials, String url, String contentType, String accept, String data, List<NameValuePair> nameValuePairs) {
        Log.i((String)TAG, (String)("Calling url: " + url));
        HttpPost request = new HttpPost();
        try {
            request.setURI(new URI(url));
            this.addGlobalHeaders((HttpRequest)request);
            if (nameValuePairs != null && !nameValuePairs.isEmpty()) {
                request.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
            }
            if (!TextUtils.isEmpty((CharSequence)contentType)) {
                request.addHeader("Content-Type", contentType);
            }
            if (!TextUtils.isEmpty((CharSequence)accept)) {
                request.addHeader("Accept", accept);
            }
            request.addHeader(new BasicScheme().authenticate((Credentials)credentials, (HttpRequest)request));
            DefaultHttpClient httpclient = new DefaultHttpClient();
            if (nameValuePairs != null && !nameValuePairs.isEmpty()) {
                request.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
            }
            if (!TextUtils.isEmpty((CharSequence)data)) {
                request.setEntity((HttpEntity)new StringEntity(data, "UTF-8"));
            }
            HttpEntity httpEntity = httpclient.execute((HttpUriRequest)request).getEntity();
            BufferedReader br = new BufferedReader(new InputStreamReader(httpEntity.getContent(), "UTF-8"));
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Log.i((String)TAG, (String)("Response: " + sb.toString()));
            return sb.toString();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (AuthenticationException e) {
            e.printStackTrace();
        }
        Log.e((String)TAG, (String)"Http call failed");
        return null;
    }

    public String getStringFromUrl(String url) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(this.getInputStreamFromUrl(url), "UTF-8"));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public String postJsonToServer(String url, String data) throws Exception {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpPost httppost = new HttpPost(url);
        httppost.addHeader("Content-Type", "application/json");
        this.addGlobalHeaders((HttpRequest)httppost);
        StringEntity entity = new StringEntity(data, "UTF-8");
        httppost.setEntity((HttpEntity)entity);
        HttpResponse httpResponse = httpclient.execute((HttpUriRequest)httppost);
        String response = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        this.log("response for post call is:" + response);
        return response;
    }

    public String getStringFromUrlWithPost(String url, String data) throws Exception {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpPost httppost = new HttpPost(url);
        httppost.addHeader("Content-Type", "application/xml");
        this.addGlobalHeaders((HttpRequest)httppost);
        StringEntity entity = new StringEntity(data, "UTF-8");
        httppost.setEntity((HttpEntity)entity);
        HttpResponse httpResponse = httpclient.execute((HttpUriRequest)httppost);
        String response = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        this.log("response for post call is: " + response);
        return response;
    }

    public String getResponse(UsernamePasswordCredentials credentials, String url, String contentType, String accept) {
        Log.i((String)TAG, (String)("Calling url: " + url));
        HttpGet request = new HttpGet();
        try {
            request.setURI(new URI(url));
            if (!TextUtils.isEmpty((CharSequence)contentType)) {
                request.addHeader("Content-Type", contentType);
            }
            if (!TextUtils.isEmpty((CharSequence)accept)) {
                request.addHeader("Accept", accept);
            }
            request.addHeader(new BasicScheme().authenticate((Credentials)credentials, (HttpRequest)request));
            this.addGlobalHeaders((HttpRequest)request);
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpEntity httpEntity = httpclient.execute((HttpUriRequest)request).getEntity();
            if (httpEntity == null) {
                return null;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(httpEntity.getContent(), "UTF-8"));
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return sb.toString();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (AuthenticationException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void addGlobalHeaders(HttpRequest request) {
        request.addHeader(APPLICATION_KEY_HEADER, MobiComKitClientService.getApplicationKey(this.context));
        request.addHeader(SOURCE_HEADER, SOURCE_HEADER_VALUE);
        request.addHeader(USERID_HEADER, USERID_HEADER_VALUE);
        request.addHeader(DEVICE_KEY_HEADER, MobiComUserPreference.getInstance(this.context).getDeviceKeyString());
    }
}

