/*
 * Decompiled with CFR 0.152.
 */
package com.applozic.mobicomkit.api.account.register;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.applozic.mobicomkit.api.HttpRequestUtils;
import com.applozic.mobicomkit.api.MobiComKitClientService;
import com.applozic.mobicomkit.api.account.register.RegistrationResponse;
import com.applozic.mobicomkit.api.account.user.MobiComUserPreference;
import com.applozic.mobicomkit.api.account.user.User;
import com.applozic.mobicomkit.exception.InvalidApplicationException;
import com.applozic.mobicommons.commons.core.utils.ContactNumberUtils;
import com.applozic.mobicommons.commons.core.utils.Utils;
import com.google.gson.Gson;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.TimeZone;

public class RegisterUserClientService
extends MobiComKitClientService {
    private static final String TAG = "RegisterUserClient";
    private static final String INVALID_APP_ID = "INVALID_APPLICATIONID";
    public static final String CREATE_ACCOUNT_URL = "/rest/ws/registration/v1/register";
    public static final Short MOBICOMKIT_VERSION_CODE = 71;
    private HttpRequestUtils httpRequestUtils;

    public RegisterUserClientService(Context context) {
        this.context = context;
        this.httpRequestUtils = new HttpRequestUtils(context);
    }

    public String getCreateAccountUrl() {
        return this.getBaseUrl() + CREATE_ACCOUNT_URL;
    }

    public RegistrationResponse createAccount(User user) throws Exception {
        MobiComUserPreference mobiComUserPreference = MobiComUserPreference.getInstance(this.context);
        Gson gson = new Gson();
        user.setAppVersionCode(MOBICOMKIT_VERSION_CODE);
        user.setApplicationId(RegisterUserClientService.getApplicationKey(this.context));
        user.setRegistrationId(mobiComUserPreference.getDeviceRegistrationId());
        Log.i((String)TAG, (String)("Net status" + Utils.isInternetAvailable((Context)this.context)));
        if (!Utils.isInternetAvailable((Context)this.context)) {
            throw new ConnectException("No Internet Connection");
        }
        Log.i((String)TAG, (String)("Registration json " + gson.toJson((Object)user)));
        String response = this.httpRequestUtils.postJsonToServer(this.getCreateAccountUrl(), gson.toJson((Object)user));
        Log.i((String)TAG, (String)("Registration response is: " + response));
        if (response.contains("<html")) {
            throw new UnknownHostException("Error 404");
        }
        if (response.contains(INVALID_APP_ID)) {
            throw new InvalidApplicationException("Invalid Application Id");
        }
        RegistrationResponse registrationResponse = (RegistrationResponse)gson.fromJson(response, RegistrationResponse.class);
        mobiComUserPreference.setCountryCode(user.getCountryCode());
        mobiComUserPreference.setUserId(user.getUserId());
        mobiComUserPreference.setContactNumber(user.getContactNumber());
        mobiComUserPreference.setEmailVerified(user.isEmailVerified());
        mobiComUserPreference.setDisplayName(user.getDisplayName());
        mobiComUserPreference.setDeviceKeyString(registrationResponse.getDeviceKeyString());
        mobiComUserPreference.setEmailIdValue(user.getEmailId());
        mobiComUserPreference.setSuUserKeyString(registrationResponse.getSuUserKeyString());
        mobiComUserPreference.setLastSyncTime(String.valueOf(registrationResponse.getLastSyncTime()));
        return registrationResponse;
    }

    public RegistrationResponse createAccount(String email, String userId, String phoneNumber, String displayName, String pushNotificationId) throws Exception {
        User user = new User();
        user.setEmailId(email);
        user.setUserId(userId);
        user.setDeviceType(Short.valueOf("1"));
        user.setPrefContactAPI(Short.valueOf("2"));
        user.setTimezone(TimeZone.getDefault().getID());
        user.setRegistrationId(pushNotificationId);
        user.setDisplayName(displayName);
        MobiComUserPreference mobiComUserPreference = MobiComUserPreference.getInstance(this.context);
        user.setCountryCode(mobiComUserPreference.getCountryCode());
        user.setContactNumber(ContactNumberUtils.getPhoneNumber((String)phoneNumber, (String)mobiComUserPreference.getCountryCode()));
        return this.createAccount(user);
    }

    public RegistrationResponse updatePushNotificationId(String pushNotificationId) throws Exception {
        MobiComUserPreference pref = MobiComUserPreference.getInstance(this.context);
        RegistrationResponse registrationResponse = null;
        if (!TextUtils.isEmpty((CharSequence)pushNotificationId)) {
            pref.setDeviceRegistrationId(pushNotificationId);
        }
        if (pref.isRegistered()) {
            registrationResponse = this.createAccount(pref.getEmailIdValue(), pref.getUserId(), pref.getContactNumber(), pref.getDisplayName(), pushNotificationId);
        }
        return registrationResponse;
    }
}

