/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.utils;

import android.net.Uri;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final char[] a = "0123456789abcdef".toCharArray();

    public static int parseInt(String string2) {
        return StringUtils.parseInt(string2, 0);
    }

    public static int parseInt(String string2, int n9) {
        if (StringUtils.isNumeric(string2)) {
            n9 = Integer.parseInt(string2);
        }
        return n9;
    }

    public static long parseLong(String string2, long l9) {
        if (StringUtils.isNumeric(string2)) {
            l9 = Long.parseLong(string2);
        }
        return l9;
    }

    public static float parseFloat(String string2, float f9) {
        try {
            return Float.parseFloat(string2);
        }
        catch (Throwable throwable) {
            return f9;
        }
    }

    public static boolean containsIgnoreCase(String string2, String string3) {
        return StringUtils.isValidString(string2) && StringUtils.isValidString(string3) && string2.toLowerCase().contains(string3.toLowerCase());
    }

    public static boolean isValidString(String string2) {
        return TextUtils.isEmpty((CharSequence)string2) ^ true;
    }

    public static String defaultIfEmpty(String string2, String string3) {
        if (!StringUtils.isValidString(string2)) {
            string2 = string3;
        }
        return string2;
    }

    public static String emptyIfNull(String string2) {
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public static String replace(String string2, String string3, String string4) {
        if (string4 != null) {
            if (string2 != null && string2.length() >= 1) {
                if (string3 != null && string3.length() >= 1) {
                    StringBuilder stringBuilder;
                    StringBuilder stringBuilder2 = stringBuilder;
                    int n9 = new StringBuilder(string2).indexOf(string3);
                    while (n9 != -1) {
                        int n10 = n9;
                        stringBuilder2.replace(n10, n10 + string3.length(), string4);
                        n9 = stringBuilder2.indexOf(string3, n9 + string4.length());
                    }
                    return stringBuilder2.toString();
                }
                return string2;
            }
            return string2;
        }
        throw new IllegalArgumentException("No replacement target specified");
    }

    public static String replace(String object, Map<String, String> object2) {
        if (object != null && object2 != null) {
            object2 = object2.entrySet().iterator();
            while (object2.hasNext()) {
                String string2 = object;
                object = (Map.Entry)object2.next();
                object = string2.replace((CharSequence)object.getKey(), (CharSequence)object.getValue());
            }
            return object;
        }
        return object;
    }

    public static void replaceAll(StringBuffer stringBuffer, String string2, String string3) {
        if (!TextUtils.isEmpty((CharSequence)stringBuffer) && !TextUtils.isEmpty((CharSequence)string2)) {
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                int n9 = stringBuffer.indexOf(string2);
                while (n9 != -1) {
                    int n10 = n9;
                    stringBuffer.replace(n10, n10 + string2.length(), string3);
                    n9 = stringBuffer.indexOf(string2, n9 + string3.length());
                }
                return;
            }
            throw new IllegalArgumentException("No replacement target specified");
        }
    }

    public static boolean isNumeric(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        int n9 = string2.charAt(0);
        n9 = n9 != 45 && n9 != 43 ? 0 : 1;
        int n10 = string2.length();
        if (n9 == 1 && n10 == 1) {
            return false;
        }
        while (n9 < n10) {
            if (!Character.isDigit(string2.charAt(n9))) {
                return false;
            }
            ++n9;
        }
        return true;
    }

    public static boolean isAlphaNumeric(String string2) {
        if (StringUtils.isValidString(string2)) {
            return string2.matches("^[a-zA-Z0-9]*$");
        }
        return false;
    }

    public static String prefixToIndex(int n9, String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        return string2.substring(0, Math.min(n9, string2.length()));
    }

    public static String encodeUriString(String string2) {
        return StringUtils.isValidString(string2) ? Uri.encode((String)string2) : "";
    }

    public static String appendQueryParameter(String string2, String string3, String string4) {
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
            Uri.Builder builder = Uri.parse((String)string2).buildUpon();
            builder.appendQueryParameter(string3, string4);
            return builder.build().toString();
        }
        return string2;
    }

    public static String appendQueryParameters(String string2, Map<String, String> treeMap, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        if (treeMap != null && !treeMap.isEmpty()) {
            if (bl) {
                Comparator comparator;
                TreeMap treeMap2;
                TreeMap treeMap3 = treeMap2;
                Comparator comparator2 = comparator;
                comparator = new Comparator(){

                    public int a(String string2, String string3) {
                        return string2.compareToIgnoreCase(string3);
                    }
                };
                new TreeMap(comparator2).putAll(treeMap);
                treeMap = treeMap3;
            }
            string2 = Uri.parse((String)string2).buildUpon();
            for (Map.Entry entry : treeMap.entrySet()) {
                string2.appendQueryParameter((String)entry.getKey(), (String)entry.getValue());
            }
            return string2.build().toString();
        }
        return string2;
    }

    public static String getHost(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "";
        }
        return (string2 = Uri.parse((String)string2)).getHost() != null ? string2.getHost() : "";
    }

    public static String getHostAndPath(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "";
        }
        Uri uri = Uri.parse((String)string2);
        string2 = StringUtils.emptyIfNull(uri.getHost());
        return string2 + StringUtils.emptyIfNull(uri.getPath());
    }

    public static String toHttpsString(String string2) {
        if (string2.startsWith("http://")) {
            return string2.replace("http://", "https://");
        }
        return string2;
    }

    public static String toFullSHA1Hash(String string2) {
        return StringUtils.a(string2, -1);
    }

    public static String toShortSHA1Hash(String string2) {
        return StringUtils.a(string2, 16);
    }

    private static String a(String string2, Integer n9) {
        Throwable throwable2;
        block6: {
            String string3;
            block5: {
                Integer n10;
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    return "";
                }
                try {
                    n10 = n9;
                    MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                    messageDigest.update(string2.getBytes("UTF-8"));
                    string3 = StringUtils.toHexString(messageDigest.digest());
                }
                catch (Throwable throwable2) {}
                if (n10 <= 0) break block5;
                return string3.substring(0, Math.min(n9, string3.length()));
                break block6;
            }
            return string3;
        }
        throw new RuntimeException("SHA-1 for \"" + string2 + "\" failed.", throwable2);
    }

    public static String toHexString(byte[] byArray) {
        if (byArray != null) {
            char[] cArray = new char[byArray.length * 2];
            for (int i9 = 0; i9 < byArray.length; ++i9) {
                int n9 = i9 * 2;
                char[] cArray2 = a;
                byte by = byArray[i9];
                cArray[n9] = cArray2[(by & 0xF0) >>> 4];
                cArray[++n9] = a[by & 0xF];
            }
            return new String(cArray);
        }
        throw new IllegalArgumentException("No data specified");
    }

    public static String toHumanReadableString(String stringArray) {
        StringBuilder stringBuilder;
        if (!StringUtils.isValidString((String)stringArray)) {
            return "";
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(stringArray.length());
        for (String string2 : stringArray.split("_")) {
            if (!StringUtils.isValidString(string2)) continue;
            if (string2.equals("id")) {
                stringBuilder2.append(string2.toUpperCase(Locale.ENGLISH));
            } else {
                Locale locale = Locale.ENGLISH;
                stringBuilder2.append(string2.substring(0, 1).toUpperCase(locale)).append(string2.substring(1).toLowerCase(locale));
            }
            stringBuilder2.append(" ");
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        return stringBuilder3.deleteCharAt(stringBuilder3.length() - 1).toString();
    }

    public static Boolean endsWith(String string2, List<String> object) {
        object = object.iterator();
        while (object.hasNext()) {
            if (!string2.endsWith((String)object.next())) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean containsAtLeastOneSubstring(String string2, List<String> object) {
        object = object.iterator();
        while (object.hasNext()) {
            if (!string2.contains((String)object.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWithAtLeastOnePrefix(String string2, List<String> object) {
        object = object.iterator();
        while (object.hasNext()) {
            if (!string2.startsWith((String)object.next())) continue;
            return true;
        }
        return false;
    }

    public static SpannedString createListItemDetailSpannedString(String string2, int n9) {
        return StringUtils.createSpannedString(string2, n9, 16);
    }

    public static SpannedString createListItemDetailSubSpannedString(String string2, int n9) {
        return StringUtils.createSpannedString(string2, n9, 12, 1);
    }

    public static SpannedString createSpannedString(String string2, int n9, int n10) {
        return StringUtils.createSpannedString(string2, n9, n10, 0);
    }

    public static SpannedString createSpannedString(String string2, int n9, int n10, int n11) {
        StyleSpan styleSpan;
        AbsoluteSizeSpan absoluteSizeSpan;
        ForegroundColorSpan foregroundColorSpan;
        SpannableString spannableString;
        SpannableString spannableString2 = spannableString;
        spannableString = new SpannableString((CharSequence)string2);
        string2 = foregroundColorSpan;
        foregroundColorSpan = new ForegroundColorSpan(n9);
        n9 = spannableString.length();
        spannableString.setSpan((Object)string2, 0, n9, 33);
        string2 = absoluteSizeSpan;
        absoluteSizeSpan = new AbsoluteSizeSpan(n10, true);
        n9 = spannableString.length();
        spannableString.setSpan((Object)string2, 0, n9, 33);
        string2 = styleSpan;
        styleSpan = new StyleSpan(n11);
        n9 = spannableString.length();
        spannableString.setSpan((Object)string2, 0, n9, 33);
        return new SpannedString((CharSequence)spannableString2);
    }

    public static void addLinks(Spannable spannable, Pattern object, ClickableSpan clickableSpan, boolean bl) {
        object = ((Pattern)object).matcher((CharSequence)spannable);
        while (((Matcher)object).find()) {
            StyleSpan styleSpan;
            Object object2 = object;
            int n9 = ((Matcher)object2).start();
            int n10 = ((Matcher)object2).end();
            spannable.setSpan((Object)clickableSpan, n9, n10, 33);
            if (!bl) continue;
            StyleSpan styleSpan2 = styleSpan;
            styleSpan = new StyleSpan(1);
            spannable.setSpan((Object)styleSpan2, n9, n10, 256);
        }
    }

    public static String toDigitsOnlyVersionString(String stringArray) {
        ArrayList<String> arrayList;
        if (TextUtils.isEmpty((CharSequence)stringArray)) {
            return "";
        }
        stringArray = stringArray.split("\\.");
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>(stringArray.length);
        block0: for (String string2 : stringArray) {
            if (!StringUtils.isValidString(string2)) continue;
            for (String string3 : string2.split("[^0-9]+")) {
                if (!StringUtils.isValidString(string3)) continue;
                arrayList2.add(string3);
                continue block0;
            }
        }
        return TextUtils.join((CharSequence)".", arrayList2);
    }

    public static String join(CharSequence charSequence, List<?> object) {
        if (object != null && !object.isEmpty()) {
            StringBuilder stringBuilder;
            List<?> list = object;
            object = stringBuilder;
            stringBuilder = new StringBuilder();
            Iterator<?> iterator = list.iterator();
            while (iterator.hasNext()) {
                ((StringBuilder)object).append(iterator.next());
                ((StringBuilder)object).append(charSequence);
            }
            Object object2 = object;
            int n9 = ((StringBuilder)object2).length() - charSequence.length();
            ((StringBuilder)object2).delete(n9, ((StringBuilder)object2).length());
            return ((StringBuilder)object2).toString();
        }
        return "";
    }

    public static Matcher match(String string2, String string3) {
        return Pattern.compile(string3).matcher(string2);
    }

    public static List<String> getRegexMatches(Matcher matcher, int n9) {
        ArrayList<String> arrayList;
        matcher.reset();
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        while (matcher.find()) {
            String string2 = matcher.group(n9);
            if (!StringUtils.isValidString(string2)) continue;
            arrayList2.add(string2);
        }
        return arrayList2;
    }
}

