package com.applovin.sdk;

import android.net.Uri;

import androidx.annotation.Nullable;

/**
 * This interface contains settings that enable the AppLovin Terms and Privacy Policy Flow.
 */
public interface AppLovinTermsAndPrivacyPolicyFlowSettings
{
    /**
     * Whether or not the consent flow is currently enabled.
     */
    boolean isEnabled();

    /**
     * Set whether to enable the consent flow or not.
     */
    void setEnabled(final boolean enabled);

    /**
     * Whether or not to show the Terms and Privacy Policy alert in GDPR regions prior to presenting the CMP prompt. The alert will show non-GDPR regions regardless of this setting.
     * Defaults to {@code false}.
     */
    boolean shouldShowTermsAndPrivacyPolicyAlertInGdpr();

    /**
     * Set whether or not to show the Terms and Privacy Policy alert in GDPR regions prior to presenting the CMP prompt.
     */
    void setShowTermsAndPrivacyPolicyAlertInGdpr(final boolean showTermsAndPrivacyPolicyAlertInGdpr);

    /**
     * Get the current privacy policy URL.
     */
    @Nullable
    Uri getPrivacyPolicyUri();

    /**
     * Set the privacy policy URL.
     */
    void setPrivacyPolicyUri(final Uri privacyPolicyUri);

    /**
     * Get the current terms of service URL.
     */
    @Nullable
    Uri getTermsOfServiceUri();

    /**
     * Set the terms of service URL.
     */
    void setTermsOfServiceUri(final Uri termsOfServiceUri);

    /**
     * The current debug geography of the user.
     */
    AppLovinSdkConfiguration.ConsentFlowUserGeography getDebugUserGeography();

    /**
     * Set debug user geography. You may use this to test CMP flow by setting this to {@link AppLovinSdkConfiguration.ConsentFlowUserGeography#GDPR}.
     * <p>
     * The flow would only be shown to new users. If you wish to test the flow after completing the CMP prompt, you would need to delete and re-install the app.
     * <p>
     * NOTE: The debug geography is used only when the app is in debug mode.
     */
    void setDebugUserGeography(final AppLovinSdkConfiguration.ConsentFlowUserGeography debugUserGeography);
}
