/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.utils;

import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.n;
import com.applovin.impl.sdk.utils.StringUtils;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CollectionUtils {
    public static <K, V> boolean isEmpty(@Nullable Map<K, V> map) {
        return map == null || map.isEmpty();
    }

    public static <E> boolean isEmpty(@Nullable Collection<E> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> boolean addObjectIfExists(@Nullable T t8, List<T> list) {
        if (t8 != null) {
            return list.add(t8);
        }
        return false;
    }

    public static <T> boolean addUniqueObjectIfExists(@Nullable T t8, List<T> list) {
        if (t8 != null && !list.contains(t8)) {
            return list.add(t8);
        }
        return false;
    }

    public static <T> void addUniqueObjectsIfExists(@Nullable List<T> object, List<T> list) {
        if (object == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object e9 = object.next();
            if (list.contains(e9)) continue;
            list.add(e9);
        }
    }

    public static <K, V> Map<K, V> map(Map<K, V> map) {
        if (map == null) {
            return new HashMap();
        }
        return new HashMap<K, V>(map);
    }

    @Nullable
    public static <T> Set<T> getDifferenceSet(@Nullable Set<T> set, @Nullable Set<T> set2) {
        if (set == null) {
            return null;
        }
        if (set2 == null) {
            return new HashSet<T>(set);
        }
        HashSet<T> hashSet = new HashSet<T>(set);
        ((AbstractCollection)hashSet).removeAll(set2);
        return hashSet;
    }

    public static List<String> explode(String string2) {
        return CollectionUtils.explode(string2, ",\\s*");
    }

    public static List<String> explode(String string2, String string3) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return Collections.emptyList();
        }
        return Arrays.asList(string2.split(string3));
    }

    public static String implode(Collection<String> collection, int n8) {
        return CollectionUtils.implode(collection, ",", n8);
    }

    public static String implode(Collection<String> object, String string2, int n8) {
        if (string2 != null) {
            if (object != null && object.size() >= 1) {
                StringBuilder stringBuilder;
                Collection<String> collection = object;
                object = stringBuilder;
                stringBuilder = new StringBuilder();
                int n9 = 0;
                for (String string3 : collection) {
                    if (n9 >= n8) break;
                    ++n9;
                    ((StringBuilder)object).append(string3).append(string2);
                }
                if (((StringBuilder)object).length() > string2.length()) {
                    Object object2 = object;
                    ((StringBuilder)object2).setLength(((StringBuilder)object2).length() - string2.length());
                }
                return ((StringBuilder)object).toString();
            }
            return "";
        }
        throw new IllegalArgumentException("No glue specified");
    }

    public static List<String> removeTrimmedEmptyStrings(List<String> arrayList) {
        ArrayList<String> arrayList2;
        if (arrayList == null) {
            return null;
        }
        ArrayList<String> arrayList3 = arrayList;
        arrayList = arrayList2;
        arrayList2 = new ArrayList<String>();
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            String string2 = ((String)iterator.next()).trim();
            if (TextUtils.isEmpty((CharSequence)string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static <T> List<T> synchronizedList() {
        return CollectionUtils.synchronizedList(-1);
    }

    public static <T> List<T> synchronizedList(int n8) {
        if (n8 >= 0) {
            return Collections.synchronizedList(new ArrayList(n8));
        }
        return Collections.synchronizedList(new ArrayList());
    }

    public static HashMap<String, String> hashMap(String string2, String string3) {
        return (HashMap)CollectionUtils.map(string2, string3);
    }

    public static <K, V> Map<K, V> map(K k8, V v8) {
        HashMap<K, V> hashMap = new HashMap<K, V>(1);
        hashMap.put(k8, v8);
        return hashMap;
    }

    public static Bundle toBundle(Map<String, ?> map) {
        if (map != null && map.size() != 0) {
            Bundle bundle;
            Bundle bundle2 = bundle;
            bundle = new Bundle();
            for (String string2 : map.keySet()) {
                Object obj = map.get(string2);
                if (obj instanceof Map) {
                    bundle2.putBundle(string2, CollectionUtils.toBundle((Map)obj));
                    continue;
                }
                if (obj instanceof Boolean) {
                    bundle2.putBoolean(string2, ((Boolean)obj).booleanValue());
                    continue;
                }
                if (obj instanceof String) {
                    bundle2.putString(string2, (String)obj);
                    continue;
                }
                if (obj instanceof Integer) {
                    bundle2.putInt(string2, ((Integer)obj).intValue());
                    continue;
                }
                if (obj instanceof Long) {
                    bundle2.putLong(string2, ((Long)obj).longValue());
                    continue;
                }
                if (obj instanceof Double) {
                    bundle2.putDouble(string2, ((Double)obj).doubleValue());
                    continue;
                }
                if (!(obj instanceof Parcelable)) continue;
                bundle2.putParcelable(string2, (Parcelable)obj);
            }
            return bundle2;
        }
        return new Bundle();
    }

    public static String toJsonString(Map<String, String> map, String string2) {
        try {
            return CollectionUtils.toJson(map).toString();
        }
        catch (JSONException jSONException) {
            n.c("CollectionUtils", "Failed to convert map '" + map + "' to JSON string.", jSONException);
            return string2;
        }
    }

    public static JSONObject toJson(Map<String, ?> jSONObject) throws JSONException {
        JSONObject jSONObject2;
        if (jSONObject == null) {
            return new JSONObject();
        }
        JSONObject jSONObject3 = jSONObject;
        jSONObject = jSONObject2;
        jSONObject2 = new JSONObject();
        for (Map.Entry entry : jSONObject3.entrySet()) {
            String string2 = (String)entry.getKey();
            jSONObject.put(string2, entry.getValue());
        }
        return jSONObject;
    }

    @Nullable
    public static JSONArray toJSONArray(String[] stringArray) {
        JSONArray jSONArray;
        if (stringArray == null) {
            return null;
        }
        JSONArray jSONArray2 = jSONArray;
        jSONArray = new JSONArray();
        int n8 = stringArray.length;
        for (int i8 = 0; i8 < n8; ++i8) {
            jSONArray2.put((Object)stringArray[i8]);
        }
        return jSONArray2;
    }

    public static void putObjectToStringIfValid(String string2, Object object, Map map) {
        if (object == null) {
            return;
        }
        CollectionUtils.putStringIfValid(string2, object.toString(), map);
    }

    public static void putStringIfValid(String string2, String string3, Map map) {
        if (StringUtils.isValidString(string2) && StringUtils.isValidString(string3)) {
            map.put(string2, string3);
        }
    }

    public static void putBooleanIfValid(String string2, Boolean bl, Map map) {
        if (StringUtils.isValidString(string2) && bl != null) {
            map.put(string2, bl);
        }
    }

    public static void putIntegerIfValid(String string2, Integer n8, Map map) {
        if (StringUtils.isValidString(string2) && n8 != null) {
            map.put(string2, n8);
        }
    }

    public static void putDoubleIfValid(String string2, Double d9, Map map) {
        if (StringUtils.isValidString(string2) && d9 != null) {
            map.put(string2, d9);
        }
    }

    public static void putLongIfValid(String string2, Long l8, Map map) {
        if (StringUtils.isValidString(string2) && l8 != null) {
            map.put(string2, l8);
        }
    }

    public static void putFloatIfValid(String string2, Float f9, Map map) {
        if (StringUtils.isValidString(string2) && f9 != null) {
            map.put(string2, f9);
        }
    }

    public static void putJsonArrayIfValid(String string2, JSONArray jSONArray, Map map) {
        if (StringUtils.isValidString(string2) && jSONArray != null && jSONArray.length() > 0) {
            map.put(string2, jSONArray);
        }
    }

    public static boolean getBoolean(Map<String, Object> map, String string2) {
        return CollectionUtils.getBoolean(map, string2, false);
    }

    public static boolean getBoolean(Map<String, Object> object, String string2, boolean bl) {
        if (object != null && object.containsKey(string2)) {
            if ((object = object.get(string2)) instanceof String) {
                return Boolean.parseBoolean((String)object);
            }
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (object instanceof Number) {
                return ((Number)object).intValue() >= 1;
            }
        }
        return bl;
    }
}

