/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import com.applovin.adview.AppLovinAdView;
import com.applovin.adview.AppLovinIncentivizedInterstitial;
import com.applovin.adview.AppLovinInterstitialAd;
import com.applovin.adview.AppLovinInterstitialAdDialog;
import com.applovin.impl.adview.AppLovinAppOpenAd;
import com.applovin.impl.adview.AppLovinRewardedInterstitialAd;
import com.applovin.impl.rb;
import com.applovin.impl.sdk.AppLovinError;
import com.applovin.impl.sdk.ad.AppLovinAdImpl;
import com.applovin.impl.sdk.nativeAd.AppLovinNativeAd;
import com.applovin.impl.sdk.nativeAd.AppLovinNativeAdImpl;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.ve;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxAppOpenAdapter;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxRewardedInterstitialAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxAppOpenAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.AppLovinAdapterAdViewListener;
import com.applovin.mediation.adapters.AppLovinAdapterAppOpenListener;
import com.applovin.mediation.adapters.AppLovinAdapterInterstitialListener;
import com.applovin.mediation.adapters.AppLovinAdapterNativeListener;
import com.applovin.mediation.adapters.AppLovinAdapterRewardedInterstitialListener;
import com.applovin.mediation.adapters.AppLovinAdapterRewardedListener;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdRewardListener;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinAdType;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinBidTokenCollectionListener;
import com.applovin.sdk.AppLovinSdk;

public class AppLovinMediationAdapter
extends MediationAdapterBase
implements MaxSignalProvider,
MaxInterstitialAdapter,
MaxAppOpenAdapter,
MaxRewardedAdapter,
MaxRewardedInterstitialAdapter,
MaxAdViewAdapter {
    protected AppLovinAd loadedInterstitialAd;
    protected AppLovinAd loadedAppOpenAd;
    protected AppLovinAd loadedRewardedAd;
    protected AppLovinAd loadedRewardedInterstitialAd;
    protected AppLovinNativeAd loadedNativeAd;
    protected AppLovinAdView loadedAdView;

    public AppLovinMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
    }

    protected static MaxAdapterError toMaxError(AppLovinError appLovinError) {
        Object object = appLovinError.getCode() == -1009 ? MaxAdapterError.NO_CONNECTION : (appLovinError.getCode() == 204 ? MaxAdapterError.NO_FILL : (appLovinError.getCode() == -1 ? MaxAdapterError.INTERNAL_ERROR : (appLovinError.getCode() >= 500 ? MaxAdapterError.SERVER_ERROR : MaxAdapterError.UNSPECIFIED)));
        AppLovinError appLovinError2 = appLovinError;
        MaxAdapterError maxAdapterError = object;
        int n10 = maxAdapterError.getCode();
        object = maxAdapterError.getErrorMessage();
        int n11 = appLovinError2.getCode();
        String string2 = appLovinError2.getMessage();
        return new MaxAdapterError(n10, (String)object, n11, string2);
    }

    protected static Bundle getExtraInfo(AppLovinAd appLovinAd) {
        Bundle bundle = new Bundle(1);
        bundle.putBundle("ad_values", ((AppLovinAdImpl)appLovinAd).getMAXAdValues());
        return bundle;
    }

    private void loadFullscreenAd(String string2, MaxAdapterResponseParameters maxAdapterResponseParameters, MaxAdFormat maxAdFormat, Object object) {
        Object object2;
        if (StringUtils.isValidString(maxAdapterResponseParameters.getBidResponse())) {
            AppLovinMediationAdapter appLovinMediationAdapter = object2;
            appLovinMediationAdapter.log("Loading bidding " + maxAdFormat.getLabel() + " ad...");
            object2 = maxAdapterResponseParameters.getBidResponse();
            appLovinMediationAdapter.getWrappingSdk().getAdService().loadNextAdForAdToken((String)object2, (rb)object);
        } else if (StringUtils.isValidString(maxAdapterResponseParameters.getThirdPartyAdPlacementId())) {
            AppLovinMediationAdapter appLovinMediationAdapter = object2;
            object2 = maxAdapterResponseParameters.getThirdPartyAdPlacementId();
            appLovinMediationAdapter.log("Loading mediated " + maxAdFormat.getLabel() + " ad: " + (String)object2 + "...");
            appLovinMediationAdapter.getWrappingSdk().getAdService().loadNextAdForZoneId((String)object2, (rb)object);
        } else {
            AppLovinMediationAdapter appLovinMediationAdapter = object2;
            appLovinMediationAdapter.log("Loading mediated " + maxAdFormat.getLabel() + " ad...");
            appLovinMediationAdapter.getWrappingSdk().getAdService().loadNextAdForZoneId(string2, (rb)object);
        }
    }

    @Override
    public String getSdkVersion() {
        return AppLovinSdk.VERSION;
    }

    @Override
    public String getAdapterVersion() {
        return this.getSdkVersion();
    }

    @Override
    public void onDestroy() {
        this.loadedInterstitialAd = null;
        this.loadedAppOpenAd = null;
        this.loadedRewardedAd = null;
        this.loadedRewardedInterstitialAd = null;
        Object object = this.loadedAdView;
        if (object != null) {
            object.destroy();
            this.loadedAdView = null;
        }
        if ((object = this.loadedNativeAd) instanceof AppLovinNativeAdImpl) {
            ((AppLovinNativeAdImpl)object).destroy();
            this.loadedNativeAd = null;
        }
    }

    @Override
    public void initialize(MaxAdapterInitializationParameters maxAdapterInitializationParameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.DOES_NOT_APPLY, null);
    }

    @Override
    public void collectSignal(MaxAdapterSignalCollectionParameters maxAdapterSignalCollectionParameters, Activity activity, final MaxSignalCollectionListener maxSignalCollectionListener) {
        AppLovinMediationAdapter appLovinMediationAdapter = this;
        appLovinMediationAdapter.log("Collecting signal...");
        if (((Boolean)appLovinMediationAdapter.getWrappingSdk().a().a(ve.W7)).booleanValue()) {
            this.getWrappingSdk().getAdService().collectBidToken(new AppLovinBidTokenCollectionListener(){

                @Override
                public void onBidTokenCollected(String string2) {
                    1 v02 = this;
                    v02.AppLovinMediationAdapter.this.log("Signal collection successful");
                    v02.maxSignalCollectionListener.onSignalCollected(string2);
                }

                @Override
                public void onBidTokenCollectionFailed(String string2) {
                    1 v02 = this;
                    v02.AppLovinMediationAdapter.this.log("Signal collection failed with error: " + string2);
                    v02.maxSignalCollectionListener.onSignalCollectionFailed(string2);
                }
            });
        } else {
            maxSignalCollectionListener.onSignalCollected(this.getWrappingSdk().getAdService().getBidToken());
        }
    }

    @Override
    public void loadAdViewAd(MaxAdapterResponseParameters object, MaxAdFormat maxAdFormat, Activity object2, MaxAdViewAdapterListener maxAdViewAdapterListener) {
        AppLovinAdapterAdViewListener appLovinAdapterAdViewListener;
        object2 = appLovinAdapterAdViewListener;
        appLovinAdapterAdViewListener = new AppLovinAdapterAdViewListener((AppLovinMediationAdapter)((Object)string2), maxAdFormat, maxAdViewAdapterListener);
        if (StringUtils.isValidString(object.getBidResponse())) {
            AppLovinMediationAdapter appLovinMediationAdapter = string2;
            appLovinMediationAdapter.log("Loading bidding " + maxAdFormat.getLabel() + " ad...");
            appLovinMediationAdapter.getWrappingSdk().getAdService().loadNextAdForAdToken(object.getBidResponse(), (AppLovinAdLoadListener)object2);
        } else if (StringUtils.isValidString(object.getThirdPartyAdPlacementId())) {
            AppLovinMediationAdapter appLovinMediationAdapter = string2;
            String string2 = object.getThirdPartyAdPlacementId();
            appLovinMediationAdapter.log("Loading mediated " + maxAdFormat.getLabel() + " ad: " + (String)string2 + "...");
            appLovinMediationAdapter.getWrappingSdk().getAdService().loadNextAdForZoneId(string2, (AppLovinAdLoadListener)object2);
        } else {
            object = null;
            if (maxAdFormat == MaxAdFormat.BANNER) {
                object = AppLovinAdSize.BANNER;
            } else if (maxAdFormat == MaxAdFormat.MREC) {
                object = AppLovinAdSize.MREC;
            } else if (maxAdFormat == MaxAdFormat.LEADER) {
                object = AppLovinAdSize.LEADER;
            }
            if (object != null) {
                String string3 = string2;
                ((MediationAdapterBase)((Object)string3)).log("Loading regular " + maxAdFormat.getLabel() + " ad...");
                ((MediationAdapterBase)((Object)string3)).getWrappingSdk().getAdService().loadNextAd((AppLovinAdSize)object, (AppLovinAdLoadListener)object2);
            } else {
                ((MediationAdapterBase)((Object)string2)).log("Failed to load ad for format: " + maxAdFormat);
                maxAdViewAdapterListener.onAdViewAdLoadFailed(MaxAdapterError.INTERNAL_ERROR);
            }
        }
    }

    @Override
    public void loadInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity object, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        AppLovinAdapterInterstitialListener appLovinAdapterInterstitialListener;
        object = MaxAdFormat.INTERSTITIAL;
        AppLovinAdapterInterstitialListener appLovinAdapterInterstitialListener2 = appLovinAdapterInterstitialListener;
        appLovinAdapterInterstitialListener = new AppLovinAdapterInterstitialListener(this, maxInterstitialAdapterListener);
        this.loadFullscreenAd("inter_regular", maxAdapterResponseParameters, (MaxAdFormat)object, appLovinAdapterInterstitialListener2);
    }

    @Override
    public void showInterstitialAd(MaxAdapterResponseParameters object, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        AppLovinAdapterInterstitialListener appLovinAdapterInterstitialListener;
        AppLovinMediationAdapter appLovinMediationAdapter = this;
        appLovinMediationAdapter.log("Showing interstitial: " + object.getThirdPartyAdPlacementId() + "...");
        AppLovinInterstitialAdDialog appLovinInterstitialAdDialog = AppLovinInterstitialAd.create(appLovinMediationAdapter.getWrappingSdk(), (Context)activity);
        object = appLovinAdapterInterstitialListener;
        appLovinInterstitialAdDialog.setAdDisplayListener(new AppLovinAdapterInterstitialListener(this, maxInterstitialAdapterListener));
        appLovinInterstitialAdDialog.setAdClickListener((AppLovinAdClickListener)object);
        appLovinInterstitialAdDialog.showAndRender(this.loadedInterstitialAd);
    }

    @Override
    public void showInterstitialAd(MaxAdapterResponseParameters object, ViewGroup viewGroup, Lifecycle lifecycle, Activity activity, MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        AppLovinAdapterInterstitialListener appLovinAdapterInterstitialListener;
        AppLovinMediationAdapter appLovinMediationAdapter = this;
        appLovinMediationAdapter.log("Showing interstitial ad view: " + object.getThirdPartyAdPlacementId() + "...");
        AppLovinInterstitialAdDialog appLovinInterstitialAdDialog = AppLovinInterstitialAd.create(appLovinMediationAdapter.getWrappingSdk(), (Context)activity);
        object = appLovinAdapterInterstitialListener;
        appLovinInterstitialAdDialog.setAdDisplayListener(new AppLovinAdapterInterstitialListener(this, maxInterstitialAdapterListener));
        appLovinInterstitialAdDialog.setAdClickListener((AppLovinAdClickListener)object);
        appLovinInterstitialAdDialog.showAndRender(this.loadedInterstitialAd, viewGroup, lifecycle);
    }

    @Override
    public void loadAppOpenAd(@NonNull MaxAdapterResponseParameters maxAdapterResponseParameters, @Nullable Activity object, @NonNull MaxAppOpenAdapterListener maxAppOpenAdapterListener) {
        AppLovinAdapterAppOpenListener appLovinAdapterAppOpenListener;
        object = MaxAdFormat.APP_OPEN;
        AppLovinAdapterAppOpenListener appLovinAdapterAppOpenListener2 = appLovinAdapterAppOpenListener;
        appLovinAdapterAppOpenListener = new AppLovinAdapterAppOpenListener(this, maxAppOpenAdapterListener);
        this.loadFullscreenAd("inter_appopen", maxAdapterResponseParameters, (MaxAdFormat)object, appLovinAdapterAppOpenListener2);
    }

    @Override
    public void showAppOpenAd(@NonNull MaxAdapterResponseParameters object, @Nullable Activity activity, @NonNull MaxAppOpenAdapterListener maxAppOpenAdapterListener) {
        AppLovinAdapterAppOpenListener appLovinAdapterAppOpenListener;
        this.log("Showing app open ad: " + object.getThirdPartyAdPlacementId() + "...");
        AppLovinAppOpenAd appLovinAppOpenAd = new AppLovinAppOpenAd(this.getWrappingSdk());
        object = appLovinAdapterAppOpenListener;
        appLovinAppOpenAd.setAdDisplayListener(new AppLovinAdapterAppOpenListener(this, maxAppOpenAdapterListener));
        appLovinAppOpenAd.setAdClickListener((AppLovinAdClickListener)object);
        appLovinAppOpenAd.show(this.loadedAppOpenAd);
    }

    @Override
    public void loadRewardedAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity object, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        AppLovinAdapterRewardedListener appLovinAdapterRewardedListener;
        AppLovinMediationAdapter appLovinMediationAdapter = maxAdFormat;
        object = appLovinAdapterRewardedListener;
        appLovinAdapterRewardedListener = new AppLovinAdapterRewardedListener((AppLovinMediationAdapter)((Object)maxAdFormat), maxRewardedAdapterListener);
        MaxAdFormat maxAdFormat = MaxAdFormat.REWARDED;
        appLovinMediationAdapter.loadFullscreenAd("inter_videoa", maxAdapterResponseParameters, maxAdFormat, object);
    }

    @Override
    public void showRewardedAd(MaxAdapterResponseParameters object, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        AppLovinAdapterRewardedListener appLovinAdapterRewardedListener;
        AppLovinMediationAdapter appLovinMediationAdapter = this;
        this.log("Showing rewarded ad: " + object.getThirdPartyAdPlacementId() + "...");
        appLovinMediationAdapter.configureReward((MaxAdapterResponseParameters)object);
        object = appLovinAdapterRewardedListener;
        appLovinAdapterRewardedListener = new AppLovinAdapterRewardedListener(this, maxRewardedAdapterListener);
        Object object2 = object;
        AppLovinIncentivizedInterstitial.create(appLovinMediationAdapter.getWrappingSdk()).show(this.loadedRewardedAd, (Context)activity, (AppLovinAdRewardListener)object2, (AppLovinAdVideoPlaybackListener)object2, (AppLovinAdDisplayListener)object2, (AppLovinAdClickListener)object2);
    }

    @Override
    public void showRewardedAd(MaxAdapterResponseParameters object, ViewGroup viewGroup, Lifecycle lifecycle, Activity activity, MaxRewardedAdapterListener maxRewardedAdapterListener) {
        AppLovinAdapterRewardedListener appLovinAdapterRewardedListener;
        AppLovinMediationAdapter appLovinMediationAdapter = this;
        this.log("Showing rewarded ad view: " + object.getThirdPartyAdPlacementId() + "...");
        appLovinMediationAdapter.configureReward((MaxAdapterResponseParameters)object);
        object = appLovinAdapterRewardedListener;
        appLovinAdapterRewardedListener = new AppLovinAdapterRewardedListener(this, maxRewardedAdapterListener);
        Object object2 = object;
        AppLovinIncentivizedInterstitial.create(appLovinMediationAdapter.getWrappingSdk()).show(this.loadedRewardedAd, viewGroup, lifecycle, (Context)activity, (AppLovinAdRewardListener)object2, (AppLovinAdVideoPlaybackListener)object2, (AppLovinAdDisplayListener)object2, (AppLovinAdClickListener)object2);
    }

    @Override
    public void loadRewardedInterstitialAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity object, MaxRewardedInterstitialAdapterListener maxRewardedInterstitialAdapterListener) {
        AppLovinAdapterRewardedInterstitialListener appLovinAdapterRewardedInterstitialListener;
        AppLovinMediationAdapter appLovinMediationAdapter = maxAdFormat;
        object = appLovinAdapterRewardedInterstitialListener;
        appLovinAdapterRewardedInterstitialListener = new AppLovinAdapterRewardedInterstitialListener((AppLovinMediationAdapter)((Object)maxAdFormat), maxRewardedInterstitialAdapterListener);
        MaxAdFormat maxAdFormat = MaxAdFormat.REWARDED_INTERSTITIAL;
        appLovinMediationAdapter.loadFullscreenAd("inter_autorew", maxAdapterResponseParameters, maxAdFormat, object);
    }

    @Override
    public void showRewardedInterstitialAd(MaxAdapterResponseParameters object, Activity activity, MaxRewardedInterstitialAdapterListener maxRewardedInterstitialAdapterListener) {
        AppLovinAdapterRewardedInterstitialListener appLovinAdapterRewardedInterstitialListener;
        AppLovinMediationAdapter appLovinMediationAdapter = this;
        appLovinMediationAdapter.log("Showing rewarded interstitial ad: " + object.getThirdPartyAdPlacementId() + "...");
        AppLovinAdapterRewardedInterstitialListener appLovinAdapterRewardedInterstitialListener2 = appLovinAdapterRewardedInterstitialListener;
        appLovinAdapterRewardedInterstitialListener = new AppLovinAdapterRewardedInterstitialListener(this, maxRewardedInterstitialAdapterListener);
        if (appLovinMediationAdapter.loadedRewardedInterstitialAd.getType() == AppLovinAdType.AUTO_INCENTIVIZED) {
            AppLovinRewardedInterstitialAd appLovinRewardedInterstitialAd;
            this.configureReward((MaxAdapterResponseParameters)object);
            object = appLovinRewardedInterstitialAd;
            ((AppLovinRewardedInterstitialAd)object)(this.getWrappingSdk());
            ((AppLovinRewardedInterstitialAd)object).setAdDisplayListener(appLovinAdapterRewardedInterstitialListener2);
            ((AppLovinRewardedInterstitialAd)object).setAdClickListener(appLovinAdapterRewardedInterstitialListener2);
            ((AppLovinRewardedInterstitialAd)object).setAdVideoPlaybackListener(appLovinAdapterRewardedInterstitialListener2);
            appLovinRewardedInterstitialAd.show(this.loadedRewardedInterstitialAd, (Context)activity, appLovinAdapterRewardedInterstitialListener2);
        } else {
            AppLovinMediationAdapter appLovinMediationAdapter2 = this;
            appLovinMediationAdapter2.log("Rewarded interstitial is regular interstitial");
            object = AppLovinInterstitialAd.create(appLovinMediationAdapter2.getWrappingSdk(), (Context)activity);
            object.setAdDisplayListener(appLovinAdapterRewardedInterstitialListener2);
            object.setAdClickListener(appLovinAdapterRewardedInterstitialListener2);
            object.setAdVideoPlaybackListener(appLovinAdapterRewardedInterstitialListener2);
            object.showAndRender(this.loadedRewardedInterstitialAd);
        }
    }

    @Override
    public void loadNativeAd(MaxAdapterResponseParameters maxAdapterResponseParameters, Activity activity, MaxNativeAdAdapterListener maxNativeAdAdapterListener) {
        if (TextUtils.isEmpty((CharSequence)maxAdapterResponseParameters.getBidResponse())) {
            maxNativeAdAdapterListener.onNativeAdLoadFailed(MaxAdapterError.INVALID_CONFIGURATION);
            return;
        }
        AppLovinMediationAdapter appLovinMediationAdapter = this;
        appLovinMediationAdapter.d("Loading bidding native ad...");
        appLovinMediationAdapter.getWrappingSdk().a().U().loadNextAdForAdToken(maxAdapterResponseParameters.getBidResponse(), new AppLovinAdapterNativeListener(maxAdapterResponseParameters, this, maxNativeAdAdapterListener));
    }
}

