/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.exoplayer2.common.base;

import com.applovin.exoplayer2.common.base.Objects;
import com.applovin.exoplayer2.common.base.Preconditions;
import com.applovin.exoplayer2.common.base.Predicate;
import com.google.errorprone.annotations.ForOverride;
import java.io.Serializable;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class Equivalence<T> {
    protected Equivalence() {
    }

    public static Equivalence<Object> equals() {
        return b.a;
    }

    public static Equivalence<Object> identity() {
        return d.a;
    }

    public final boolean equivalent(@NullableDecl T t10, @NullableDecl T t11) {
        if (t10 == t11) {
            return true;
        }
        if (t10 != null && t11 != null) {
            return this.doEquivalent(t10, t11);
        }
        return false;
    }

    @ForOverride
    protected abstract boolean doEquivalent(T var1, T var2);

    public final int hash(@NullableDecl T t10) {
        if (t10 == null) {
            return 0;
        }
        return this.doHash(t10);
    }

    @ForOverride
    protected abstract int doHash(T var1);

    public final <S extends T> Wrapper<S> wrap(@NullableDecl S s10) {
        return new Wrapper(this, s10);
    }

    public final Predicate<T> equivalentTo(@NullableDecl T t10) {
        return new c(this, t10);
    }

    public static final class Wrapper<T>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final Equivalence<? super T> equivalence;
        @NullableDecl
        private final T reference;

        private Wrapper(Equivalence<? super T> equivalence, @NullableDecl T t10) {
            this.equivalence = Preconditions.checkNotNull(equivalence);
            this.reference = t10;
        }

        @NullableDecl
        public T get() {
            return this.reference;
        }

        public boolean equals(@NullableDecl Object object) {
            if (object == wrapper) {
                return true;
            }
            if (object instanceof Wrapper) {
                object = (Wrapper)object;
                if (wrapper.equivalence.equals(((Wrapper)object).equivalence)) {
                    Wrapper<T> wrapper = wrapper.reference;
                    return wrapper.equivalence.equivalent(wrapper, (Wrapper)((Wrapper)object).reference);
                }
            }
            return false;
        }

        public int hashCode() {
            return this.equivalence.hash(this.reference);
        }

        public String toString() {
            return this.equivalence + ".wrap(" + this.reference + ")";
        }
    }

    private static final class c
    implements Predicate,
    Serializable {
        private final Equivalence a;
        private final Object b;

        c(Equivalence equivalence, Object object) {
            this.a = Preconditions.checkNotNull(equivalence);
            this.b = object;
        }

        public boolean apply(Object object) {
            return this.a.equivalent(object, this.b);
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof c) {
                object = (c)object;
                return this.a.equals(((c)object).a) && Objects.equal(this.b, ((c)object).b);
            }
            return false;
        }

        public int hashCode() {
            c c10 = equivalence;
            Equivalence equivalence = c10.a;
            Object object = c10.b;
            return Objects.hashCode(equivalence, object);
        }

        public String toString() {
            return this.a + ".equivalentTo(" + this.b + ")";
        }
    }

    static final class b
    extends Equivalence
    implements Serializable {
        static final b a = new b();

        b() {
        }

        protected boolean doEquivalent(Object object, Object object2) {
            return object.equals(object2);
        }

        protected int doHash(Object object) {
            return object.hashCode();
        }
    }

    static final class d
    extends Equivalence
    implements Serializable {
        static final d a = new d();

        d() {
        }

        protected boolean doEquivalent(Object object, Object object2) {
            return false;
        }

        protected int doHash(Object object) {
            return System.identityHashCode(object);
        }
    }
}

