/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.impl.privacy.a.c;
import com.applovin.impl.privacy.a.d;
import com.applovin.impl.sdk.AppLovinSdkSettingsBase;
import com.applovin.impl.sdk.m;
import com.applovin.impl.sdk.utils.CollectionUtils;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.u;
import com.applovin.impl.sdk.w;
import com.applovin.sdk.AppLovinTermsAndPrivacyPolicyFlowSettings;
import com.applovin.sdk.AppLovinTermsFlowSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class AppLovinSdkSettings
extends AppLovinSdkSettingsBase {
    private boolean aZQ;
    private boolean is;
    private boolean aZR = true;
    private boolean aAT = true;
    private boolean aZS = true;
    private boolean aZT = true;
    @Nullable
    private String aZU;
    @Nullable
    private String aZV;
    private final Map<String, Object> localSettings = new HashMap<String, Object>();
    private final Map<String, String> metaData = new HashMap<String, String>();
    private List<String> aAR = Collections.emptyList();
    private List<String> aZW = Collections.emptyList();
    private final Map<String, String> extraParameters = Collections.synchronizedMap(new HashMap());
    @Nullable
    private m sdk;
    private String abl = "";

    public AppLovinSdkSettings(Context context) {
        if (context == null) {
            w.I("AppLovinSdkSettings", "context cannot be null. Please provide a valid context.");
        }
        Context context2 = u.am(context);
        this.aZQ = u.ad(context2);
        this.backingConsentFlowSettings = c.D(context2);
        this.abl = context2.getPackageName();
        this.aq(context2);
    }

    public AppLovinTermsAndPrivacyPolicyFlowSettings getTermsAndPrivacyPolicyFlowSettings() {
        d d2 = (d)this.backingConsentFlowSettings;
        d2.a(d.a.ayH);
        return this.backingConsentFlowSettings;
    }

    public void setVerboseLogging(boolean bl) {
        w.logApiCall("AppLovinSdkSettings", "setVerboseLogging(isVerboseLoggingEnabled=" + bl + ")");
        if (u.ME()) {
            w.I("AppLovinSdkSettings", "Ignoring setting of verbose logging - it is configured from Android manifest already.");
            if (u.ad(null) != bl) {
                w.I("AppLovinSdkSettings", "Attempted to programmatically set verbose logging flag to value different from value configured in Android Manifest.");
            }
        } else {
            this.aZQ = bl;
        }
    }

    public boolean isVerboseLoggingEnabled() {
        return this.aZQ;
    }

    public boolean isMuted() {
        return this.is;
    }

    public void setMuted(boolean bl) {
        w.logApiCall("AppLovinSdkSettings", "setMuted(muted=" + bl + ")");
        this.is = bl;
    }

    public void setCreativeDebuggerEnabled(boolean bl) {
        w.logApiCall("AppLovinSdkSettings", "setCreativeDebuggerEnabled(creativeDebuggerEnabled=" + bl + ")");
        if (this.aZR == bl) {
            return;
        }
        this.aZR = bl;
        if (this.sdk == null) {
            return;
        }
        if (bl) {
            this.sdk.CW().tK();
        } else {
            this.sdk.CW().tL();
        }
    }

    public boolean isCreativeDebuggerEnabled() {
        return this.aZR;
    }

    public void setLocationCollectionEnabled(boolean bl) {
        w.logApiCall("AppLovinSdkSettings", "setLocationCollectionEnabled(locationCollectionEnabled=" + bl + ")");
        this.aZS = bl;
    }

    public boolean isLocationCollectionEnabled() {
        return this.aZS;
    }

    @Nullable
    public String getUserIdentifier() {
        if (this.sdk == null) {
            return this.aZV;
        }
        return this.sdk.CJ().Cm();
    }

    public void setUserIdentifier(String string2) {
        w.logApiCall("AppLovinSdkSettings", "setUserIdentifier(userIdentifier=" + string2 + ")");
        if (StringUtils.isValidString(string2) && string2.length() > u.gZ(8)) {
            w.I("AppLovinSdk", "Provided user id longer than supported (" + string2.length() + " bytes, " + u.gZ(8) + " maximum)");
        }
        if (this.sdk != null) {
            this.sdk.Cv();
            if (w.FV()) {
                this.sdk.Cv().f("AppLovinSdkSettings", "Setting user id: " + string2);
            }
            this.sdk.CJ().cB(string2);
        } else {
            this.aZV = string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getExtraParameters() {
        Map<String, String> map = this.extraParameters;
        synchronized (map) {
            return CollectionUtils.map(this.extraParameters);
        }
    }

    public void setExtraParameter(String string2, @Nullable String string3) {
        String string4;
        w.logApiCall("AppLovinSdkSettings", "setExtraParameter(key=" + string2 + ", value=" + string3 + ")");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            w.I("AppLovinSdkSettings", "Failed to set extra parameter for null or empty key: " + string2);
            return;
        }
        String string5 = string4 = string3 != null ? string3.trim() : null;
        if ("test_mode_network".equalsIgnoreCase(string2)) {
            if (this.sdk != null) {
                if (StringUtils.isValidString(string4)) {
                    this.sdk.Dm().C(Arrays.asList(string4.split(",")));
                } else {
                    this.sdk.Dm().bU(null);
                }
            } else {
                this.aZU = string4;
            }
        } else if ("fan".equals(string2) || "esc".equals(string2)) {
            if (!this.abl.startsWith("com.unity.")) {
                return;
            }
        } else if ("disable_all_logs".equals(string2)) {
            w.aO(Boolean.parseBoolean(string4));
        }
        this.extraParameters.put(string2, string4);
    }

    public void setShouldFailAdDisplayIfDontKeepActivitiesIsEnabled(boolean bl) {
        w.logApiCall("AppLovinSdkSettings", "setShouldFailAdDisplayIfDontKeepActivitiesIsEnabled(shouldFailAdDisplayIfDontKeepActivitiesIsEnabled=" + bl + ")");
        this.aZT = bl;
    }

    public boolean shouldFailAdDisplayIfDontKeepActivitiesIsEnabled() {
        return this.aZT;
    }

    public void attachAppLovinSdk(m m2) {
        this.sdk = m2;
        if (StringUtils.isValidString(this.aZU)) {
            m2.Dm().C(Arrays.asList(this.aZU.split(",")));
            this.aZU = null;
        }
        if (this.aZV != null) {
            m2.Cv();
            if (w.FV()) {
                m2.Cv().f("AppLovinSdkSettings", "Setting user id: " + this.aZV);
            }
            m2.CJ().cB(this.aZV);
            this.aZV = null;
        }
    }

    @SuppressLint(value={"DiscouragedApi"})
    private void aq(Context context) {
        int n2 = context.getResources().getIdentifier("applovin_settings", "raw", context.getPackageName());
        if (n2 == 0) {
            return;
        }
        String string2 = u.a(n2, context, null);
        JSONObject jSONObject = StringUtils.isValidString(string2) ? JsonUtils.jsonObjectFromJsonString(string2, new JSONObject()) : new JSONObject();
        Map<String, String> map = JsonUtils.tryToStringMap(jSONObject);
        this.extraParameters.putAll(map);
    }

    @NonNull
    public String toString() {
        return "AppLovinSdkSettings{isVerboseLoggingEnabled=" + this.aZQ + ", muted=" + this.is + ", testDeviceAdvertisingIds=" + this.aAR.toString() + ", initializationAdUnitIds=" + this.aZW.toString() + ", creativeDebuggerEnabled=" + this.aZR + ", exceptionHandlerEnabled=" + this.aAT + ", locationCollectionEnabled=" + this.aZS + '}';
    }

    @Deprecated
    public AppLovinTermsFlowSettings getTermsFlowSettings() {
        d d2 = (d)this.backingConsentFlowSettings;
        d2.a(d.a.ayG);
        return this.backingConsentFlowSettings;
    }

    @Deprecated
    public void setTestDeviceAdvertisingIds(List<String> list) {
        w.logApiCall("AppLovinSdkSettings", "setTestDeviceAdvertisingIds(testDeviceAdvertisingIds=" + list + ")");
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string2 : list) {
                if (string2 != null && string2.length() == 36) {
                    arrayList.add(string2);
                    continue;
                }
                w.I("AppLovinSdkSettings", "Unable to set test device advertising id (" + string2 + ") - please make sure it is in the format of xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx");
            }
            this.aAR = arrayList;
        } else {
            this.aAR = Collections.emptyList();
        }
    }

    @Deprecated
    public List<String> getTestDeviceAdvertisingIds() {
        return this.aAR;
    }

    @Deprecated
    public void setInitializationAdUnitIds(List<String> list) {
        w.logApiCall("AppLovinSdkSettings", "setInitializationAdUnitIds(initializationAdUnitIds=" + list + ")");
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string2 : list) {
                if (!StringUtils.isValidString(string2) || string2.length() <= 0) continue;
                if (string2.length() == 16) {
                    arrayList.add(string2);
                    continue;
                }
                w.I("AppLovinSdkSettings", "Unable to set initialization ad unit id (" + string2 + ") - please make sure it is in the format of XXXXXXXXXXXXXXXX");
            }
            this.aZW = arrayList;
        } else {
            this.aZW = Collections.emptyList();
        }
    }

    @Deprecated
    public List<String> getInitializationAdUnitIds() {
        return this.aZW;
    }

    @Deprecated
    public void setExceptionHandlerEnabled(boolean bl) {
        w.logApiCall("AppLovinSdkSettings", "setExceptionHandlerEnabled(exceptionHandlerEnabled=" + bl + ")");
        this.aAT = bl;
    }

    @Deprecated
    public boolean isExceptionHandlerEnabled() {
        return this.aAT;
    }
}

