/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.nativeAds.adPlacer;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.applovin.impl.mediation.b.d;
import com.applovin.impl.mediation.nativeAds.a.a;
import com.applovin.impl.mediation.nativeAds.a.b;
import com.applovin.impl.sdk.m;
import com.applovin.impl.sdk.w;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.mediation.nativeAds.MaxNativeAdViewBinder;
import com.applovin.mediation.nativeAds.adPlacer.MaxAdPlacerSettings;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MaxAdPlacer
implements b.a {
    private AppLovinSdkUtils.Size aZu = AppLovinSdkUtils.Size.ZERO;
    private MaxNativeAdViewBinder aZv;
    private final a aZw;
    private final b aZx;
    protected final m sdk;
    protected final w logger;
    private Listener aZy;

    public MaxAdPlacer(MaxAdPlacerSettings maxAdPlacerSettings, Context context) {
        this(maxAdPlacerSettings, AppLovinSdk.getInstance(context), context);
    }

    public MaxAdPlacer(MaxAdPlacerSettings maxAdPlacerSettings, AppLovinSdk appLovinSdk, Context context) {
        this.sdk = appLovinSdk.a();
        this.logger = this.sdk.Cv();
        this.aZw = new a(maxAdPlacerSettings);
        this.aZx = new b(maxAdPlacerSettings, context, this);
        MaxAdPlacer maxAdPlacer = this;
        if (maxAdPlacer.logger.FV()) {
            this.logger.f("MaxAdPlacer", "Initializing ad placer with settings: " + maxAdPlacerSettings);
        }
    }

    public void destroy() {
        MaxAdPlacer maxAdPlacer = this;
        if (maxAdPlacer.logger.FV()) {
            this.logger.f("MaxAdPlacer", "Destroying ad placer");
        }
        this.clearAds();
        this.aZx.destroy();
    }

    public void setAdSize(int n2, int n3) {
        this.aZu = new AppLovinSdkUtils.Size(n2, n3);
    }

    public void setNativeAdViewBinder(MaxNativeAdViewBinder maxNativeAdViewBinder) {
        this.aZv = maxNativeAdViewBinder;
    }

    public void setListener(Listener listener) {
        this.aZy = listener;
    }

    public void loadAds() {
        MaxAdPlacer maxAdPlacer = this;
        if (maxAdPlacer.logger.FV()) {
            this.logger.f("MaxAdPlacer", "Loading ads");
        }
        this.aZx.loadAds();
    }

    public void clearAds() {
        this.a(this.aZw.zm(), () -> {
            MaxAdPlacer maxAdPlacer = this;
            if (maxAdPlacer.logger.FV()) {
                this.logger.f("MaxAdPlacer", "Clearing all cached ads");
            }
            this.aZw.clearAds();
            this.aZx.clearAds();
        });
    }

    public Collection<Integer> clearTrailingAds(int n2) {
        Collection<Integer> collection = this.aZw.gr(n2);
        if (!collection.isEmpty()) {
            this.a(collection, () -> {
                MaxAdPlacer maxAdPlacer = this;
                if (maxAdPlacer.logger.FV()) {
                    this.logger.f("MaxAdPlacer", "Clearing trailing ads after position " + n2);
                }
                this.aZw.g(collection);
            });
        }
        return collection;
    }

    public boolean isAdPosition(int n2) {
        return this.aZw.isAdPosition(n2);
    }

    public boolean isFilledPosition(int n2) {
        return this.aZw.isFilledPosition(n2);
    }

    public long getAdItemId(int n2) {
        if (this.isFilledPosition(n2)) {
            return -System.identityHashCode(this.aZw.gq(n2));
        }
        return 0L;
    }

    public AppLovinSdkUtils.Size getAdSize(int n2, int n3) {
        if (this.isFilledPosition(n2)) {
            boolean bl = this.aZu != AppLovinSdkUtils.Size.ZERO;
            int n4 = Math.min(bl ? this.aZu.getWidth() : 360, n3);
            d d2 = (d)this.aZw.gq(n2);
            if ("small_template_1".equalsIgnoreCase(d2.yJ())) {
                int n5 = bl ? this.aZu.getHeight() : 120;
                return new AppLovinSdkUtils.Size(n4, n5);
            }
            if ("medium_template_1".equalsIgnoreCase(d2.yJ())) {
                double d3 = bl ? (double)this.aZu.getWidth() / (double)this.aZu.getHeight() : 1.2;
                return new AppLovinSdkUtils.Size(n4, (int)((double)n4 / d3));
            }
            if (bl) {
                return this.aZu;
            }
            if (d2.yH() != null) {
                View view = d2.yH().getMainView();
                return new AppLovinSdkUtils.Size(view.getMeasuredWidth(), view.getMeasuredHeight());
            }
        }
        return AppLovinSdkUtils.Size.ZERO;
    }

    public void renderAd(int n2, ViewGroup viewGroup) {
        MaxAd maxAd = this.aZw.gq(n2);
        if (maxAd == null) {
            MaxAdPlacer maxAdPlacer = this;
            if (maxAdPlacer.logger.FV()) {
                this.logger.f("MaxAdPlacer", "An ad is not available for position: " + n2);
            }
            return;
        }
        d d2 = (d)maxAd;
        MaxNativeAdView maxNativeAdView = d2.yH();
        if (maxNativeAdView != null) {
            MaxAdPlacer maxAdPlacer = this;
            if (maxAdPlacer.logger.FV()) {
                this.logger.f("MaxAdPlacer", "Using pre-rendered ad at position: " + n2);
            }
        } else if (this.aZv != null) {
            maxNativeAdView = new MaxNativeAdView(this.aZv, viewGroup.getContext());
            if (this.aZx.render(maxNativeAdView, maxAd)) {
                MaxAdPlacer maxAdPlacer = this;
                if (maxAdPlacer.logger.FV()) {
                    this.logger.f("MaxAdPlacer", "Rendered ad at position: " + n2);
                }
            } else {
                MaxAdPlacer maxAdPlacer = this;
                if (maxAdPlacer.logger.FV()) {
                    this.logger.i("MaxAdPlacer", "Unable to render ad at position: " + n2);
                }
            }
        } else {
            MaxAdPlacer maxAdPlacer = this;
            if (maxAdPlacer.logger.FV()) {
                this.logger.i("MaxAdPlacer", "Unable to render ad at position: " + n2 + ". If you're using a custom ad template, check that nativeAdViewBinder is set.");
            }
            return;
        }
        for (int i2 = viewGroup.getChildCount(); i2 >= 0; --i2) {
            View view = viewGroup.getChildAt(i2);
            if (!(view instanceof MaxNativeAdView)) continue;
            viewGroup.removeViewAt(i2);
        }
        if (maxNativeAdView.getParent() != null) {
            ((ViewGroup)maxNativeAdView.getParent()).removeView((View)maxNativeAdView);
        }
        viewGroup.addView((View)maxNativeAdView, -1, -1);
    }

    public void updateFillablePositions(int n2, int n3) {
        this.aZw.Q(n2, n3);
        if (n2 != -1 && n3 != -1) {
            this.NW();
        }
    }

    public int getAdjustedCount(int n2) {
        return this.aZw.getAdjustedCount(n2);
    }

    public int getAdjustedPosition(int n2) {
        return this.aZw.getAdjustedPosition(n2);
    }

    public int getOriginalPosition(int n2) {
        return this.aZw.getOriginalPosition(n2);
    }

    public void insertItem(int n2) {
        MaxAdPlacer maxAdPlacer = this;
        if (maxAdPlacer.logger.FV()) {
            this.logger.f("MaxAdPlacer", "Inserting item at position: " + n2);
        }
        this.aZw.insertItem(n2);
    }

    public void removeItem(int n2) {
        List<Integer> list = this.isFilledPosition(n2) ? Collections.singletonList(n2) : Collections.emptyList();
        this.a(list, () -> {
            MaxAdPlacer maxAdPlacer = this;
            if (maxAdPlacer.logger.FV()) {
                this.logger.f("MaxAdPlacer", "Removing item at position: " + n2);
            }
            this.aZw.removeItem(n2);
        });
    }

    public void moveItem(int n2, int n3) {
        this.aZw.moveItem(n2, n3);
    }

    private void NW() {
        int n2;
        while (this.aZx.zn() && (n2 = this.aZw.zl()) != -1) {
            MaxAdPlacer maxAdPlacer = this;
            if (maxAdPlacer.logger.FV()) {
                this.logger.f("MaxAdPlacer", "Placing ad at position: " + n2);
            }
            MaxAd maxAd = this.aZx.zo();
            this.aZw.a(maxAd, n2);
            if (this.aZy == null) continue;
            this.aZy.onAdLoaded(n2);
        }
    }

    private void a(Collection<Integer> collection, Runnable runnable) {
        for (Integer n2 : collection) {
            MaxAd maxAd = this.aZw.gq(n2);
            this.aZx.destroyAd(maxAd);
        }
        runnable.run();
        if (!collection.isEmpty()) {
            MaxAdPlacer maxAdPlacer = this;
            if (maxAdPlacer.logger.FV()) {
                this.logger.f("MaxAdPlacer", "Removed " + collection.size() + " ads from stream: " + collection);
            }
            if (this.aZy != null) {
                for (Integer n2 : collection) {
                    this.aZy.onAdRemoved(n2);
                }
            }
        }
    }

    @Override
    public void onNativeAdLoaded() {
        MaxAdPlacer maxAdPlacer = this;
        if (maxAdPlacer.logger.FV()) {
            this.logger.f("MaxAdPlacer", "Native ad enqueued");
        }
        this.NW();
    }

    @Override
    public void onNativeAdLoadFailed(String string2, MaxError maxError) {
        MaxAdPlacer maxAdPlacer = this;
        if (maxAdPlacer.logger.FV()) {
            this.logger.i("MaxAdPlacer", "Native ad failed to load: " + maxError);
        }
    }

    @Override
    public void onNativeAdClicked(MaxAd maxAd) {
        if (this.aZy != null) {
            this.aZy.onAdClicked(maxAd);
        }
    }

    @Override
    public void onAdRevenuePaid(MaxAd maxAd) {
        if (this.aZy != null) {
            this.aZy.onAdRevenuePaid(maxAd);
        }
    }

    public static interface Listener {
        public void onAdLoaded(int var1);

        public void onAdRemoved(int var1);

        public void onAdClicked(MaxAd var1);

        public void onAdRevenuePaid(MaxAd var1);
    }
}

