/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.nativeAds;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.applovin.impl.mediation.ads.a;
import com.applovin.impl.mediation.ads.b;
import com.applovin.impl.mediation.b.d;
import com.applovin.impl.sdk.c.a;
import com.applovin.impl.sdk.m;
import com.applovin.impl.sdk.nativeAd.AppLovinStarRatingView;
import com.applovin.impl.sdk.utils.ImageViewUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.w;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdViewBinder;
import com.applovin.sdk.R;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

@SuppressLint(value={"ViewConstructor"})
public class MaxNativeAdView
extends FrameLayout {
    public static final String MEDIUM_TEMPLATE_1 = "medium_template_1";
    private final View mainView;
    private final TextView aZg;
    private final TextView aZh;
    private final TextView aZi;
    private final Button aZj;
    private final ImageView aZk;
    private final FrameLayout aZl;
    private final ViewGroup aZm;
    private final FrameLayout aZn;
    private final ViewGroup aZo;
    private final ViewGroup aZp;
    private final FrameLayout aZq;
    @Nullable
    private b adViewTracker;

    public MaxNativeAdView(MaxNativeAd maxNativeAd, Activity activity) {
        this(maxNativeAd, (String)null, activity);
    }

    public MaxNativeAdView(String string2, Context context) {
        this(null, string2, context);
    }

    @Deprecated
    public MaxNativeAdView(@Nullable MaxNativeAd maxNativeAd, @Nullable String string2, Activity activity) {
        this(maxNativeAd, string2, activity.getApplicationContext());
    }

    public MaxNativeAdView(@Nullable MaxNativeAd maxNativeAd, @Nullable String string2, Context context) {
        this(maxNativeAd, new MaxNativeAdViewBinder.Builder(-1).setTemplateType(string2).setTitleTextViewId(R.id.applovin_native_title_text_view).setAdvertiserTextViewId(R.id.applovin_native_advertiser_text_view).setBodyTextViewId(R.id.applovin_native_body_text_view).setCallToActionButtonId(R.id.applovin_native_cta_button).setIconImageViewId(R.id.applovin_native_icon_image_view).setIconContentViewId(R.id.applovin_native_icon_view).setOptionsContentViewGroupId(R.id.applovin_native_options_view).setOptionsContentFrameLayoutId(R.id.applovin_native_options_view).setStarRatingContentViewGroupId(R.id.applovin_native_star_rating_view).setMediaContentViewGroupId(R.id.applovin_native_media_content_view).setMediaContentFrameLayoutId(R.id.applovin_native_media_content_view).build(), context);
    }

    public MaxNativeAdView(MaxNativeAdViewBinder maxNativeAdViewBinder, Context context) {
        this(null, maxNativeAdViewBinder, context);
    }

    public MaxNativeAdView(@Nullable MaxNativeAd maxNativeAd, MaxNativeAdViewBinder maxNativeAdViewBinder, Context context) {
        super(context);
        MaxAdFormat maxAdFormat;
        boolean bl = maxNativeAdViewBinder.templateType != null;
        MaxAdFormat maxAdFormat2 = maxAdFormat = maxNativeAd != null ? maxNativeAd.getFormat() : MaxAdFormat.NATIVE;
        if (maxNativeAdViewBinder.mainView != null) {
            this.mainView = maxNativeAdViewBinder.mainView;
        } else {
            int n2 = bl ? this.b(maxNativeAdViewBinder.templateType, maxAdFormat) : maxNativeAdViewBinder.layoutResourceId;
            LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
            this.mainView = layoutInflater.inflate(n2, (ViewGroup)this, false);
        }
        this.addView(this.mainView);
        this.aZg = (TextView)this.findViewById(maxNativeAdViewBinder.titleTextViewId);
        this.aZh = (TextView)this.findViewById(maxNativeAdViewBinder.advertiserTextViewId);
        this.aZi = (TextView)this.findViewById(maxNativeAdViewBinder.bodyTextViewId);
        this.aZj = (Button)this.findViewById(maxNativeAdViewBinder.callToActionButtonId);
        this.aZk = (ImageView)this.findViewById(maxNativeAdViewBinder.iconImageViewId);
        this.aZl = (FrameLayout)this.findViewById(maxNativeAdViewBinder.iconContentViewId);
        this.aZm = (ViewGroup)this.findViewById(maxNativeAdViewBinder.optionsContentViewGroupId);
        this.aZn = (FrameLayout)this.findViewById(maxNativeAdViewBinder.optionsContentFrameLayoutId);
        this.aZo = (ViewGroup)this.findViewById(maxNativeAdViewBinder.starRatingContentViewGroupId);
        this.aZp = (ViewGroup)this.findViewById(maxNativeAdViewBinder.mediaContentViewGroupId);
        this.aZq = (FrameLayout)this.findViewById(maxNativeAdViewBinder.mediaContentFrameLayoutId);
        if (maxNativeAd != null) {
            this.a(maxNativeAd);
        }
    }

    public void render(d d2, a.a a2, m m2) {
        this.recycle();
        if (!d2.yL().get() || !d2.yK().get()) {
            this.adViewTracker = new b(d2, (ViewGroup)this, a2, m2);
        }
        MaxNativeAd maxNativeAd = d2.getNativeAd();
        if (d2.isContainerClickable() && maxNativeAd.isContainerClickable()) {
            m2.Cv();
            if (w.FV()) {
                m2.Cv().f("MaxNativeAdView", "Enabling container click");
            }
            this.setOnClickListener(view -> maxNativeAd.performClick());
        }
        if (StringUtils.isValidString(d2.yJ())) {
            m2.Cv();
            if (w.FV()) {
                m2.Cv().f("MaxNativeAdView", "Rendering template ad view");
            }
            this.a(maxNativeAd);
        } else {
            m2.Cv();
            if (w.FV()) {
                m2.Cv().f("MaxNativeAdView", "Rendering custom ad view");
            }
            this.renderCustomNativeAdView(maxNativeAd);
        }
    }

    public void recycle() {
        this.setOnClickListener(null);
        if (this.adViewTracker != null) {
            this.adViewTracker.destroy();
            this.adViewTracker = null;
        }
        if (this.mainView != null && this.mainView.getParent() != this) {
            ViewGroup viewGroup = (ViewGroup)this.mainView.getParent();
            if (viewGroup != null) {
                viewGroup.removeAllViews();
                this.removeView((View)viewGroup);
            }
            this.addView(this.mainView);
        }
    }

    @Nullable
    public b getAdViewTracker() {
        return this.adViewTracker;
    }

    private int b(String string2, MaxAdFormat maxAdFormat) {
        if (maxAdFormat == MaxAdFormat.NATIVE) {
            if ("small_template_1".equalsIgnoreCase(string2)) {
                return R.layout.max_native_ad_small_template_1;
            }
            if (MEDIUM_TEMPLATE_1.equalsIgnoreCase(string2)) {
                return R.layout.max_native_ad_medium_template_1;
            }
            throw new IllegalArgumentException("Attempting to render MAX native ad with invalid format: " + string2);
        }
        if (maxAdFormat == MaxAdFormat.BANNER) {
            if ("vertical_banner_template".equals(string2)) {
                return R.layout.max_native_ad_vertical_banner_view;
            }
            if ("media_banner_template".equals(string2) || "no_body_banner_template".equals(string2)) {
                return R.layout.max_native_ad_media_banner_view;
            }
            if ("vertical_media_banner_template".equals(string2)) {
                return R.layout.max_native_ad_vertical_media_banner_view;
            }
            return R.layout.max_native_ad_banner_view;
        }
        if (maxAdFormat == MaxAdFormat.LEADER) {
            if ("vertical_leader_template".equals(string2)) {
                return R.layout.max_native_ad_vertical_leader_view;
            }
            return R.layout.max_native_ad_leader_view;
        }
        if (maxAdFormat == MaxAdFormat.MREC) {
            return R.layout.max_native_ad_mrec_view;
        }
        throw new IllegalArgumentException("Unsupported ad format: " + maxAdFormat);
    }

    private void a(MaxNativeAd maxNativeAd) {
        if (this.aZg == null) {
            w.G("MaxNativeAdView", "Rendering template ad view without title text view");
        } else if (StringUtils.isValidString(maxNativeAd.getTitle())) {
            this.aZg.setText((CharSequence)maxNativeAd.getTitle());
        } else {
            this.aZg.setVisibility(8);
        }
        if (this.aZh != null) {
            if (StringUtils.isValidString(maxNativeAd.getAdvertiser())) {
                this.aZh.setText((CharSequence)maxNativeAd.getAdvertiser());
            } else {
                this.aZh.setVisibility(8);
            }
        }
        if (this.aZi != null) {
            if (StringUtils.isValidString(maxNativeAd.getBody())) {
                this.aZi.setText((CharSequence)maxNativeAd.getBody());
            } else if (maxNativeAd.getFormat() == MaxAdFormat.NATIVE || maxNativeAd.getFormat() == MaxAdFormat.MREC) {
                this.aZi.setVisibility(8);
            } else {
                this.aZi.setVisibility(4);
            }
        }
        if (this.aZj != null) {
            if (StringUtils.isValidString(maxNativeAd.getCallToAction())) {
                this.aZj.setText((CharSequence)maxNativeAd.getCallToAction());
            } else if (maxNativeAd.getFormat() == MaxAdFormat.NATIVE || maxNativeAd.getFormat() == MaxAdFormat.MREC) {
                this.aZj.setVisibility(8);
            } else {
                this.aZj.setVisibility(4);
            }
        }
        MaxNativeAd.MaxNativeAdImage maxNativeAdImage = maxNativeAd.getIcon();
        View view = maxNativeAd.getIconView();
        if (this.aZl != null) {
            if (maxNativeAdImage != null && this.aZk != null) {
                if (maxNativeAdImage.getDrawable() != null) {
                    this.aZk.setImageDrawable(maxNativeAdImage.getDrawable());
                } else if (maxNativeAdImage.getUri() != null && StringUtils.isValidString(maxNativeAdImage.getUri().toString())) {
                    if (m.aBD.a(a.aKe).booleanValue()) {
                        ImageViewUtils.setAndDownscaleImageUri(this.aZk, maxNativeAdImage.getUri());
                    } else {
                        ImageViewUtils.setImageUri(this.aZk, maxNativeAdImage.getUri(), m.aBD);
                    }
                } else {
                    this.aZl.setVisibility(8);
                }
            } else if (view != null) {
                view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.aZl.removeAllViews();
                this.aZl.addView(view);
            } else {
                this.aZl.setVisibility(8);
            }
        }
        View view2 = maxNativeAd.getOptionsView();
        if (this.aZn != null && view2 != null) {
            view2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.aZn.addView(view2);
            this.aZn.bringToFront();
        } else if (this.aZn != null) {
            this.aZn.setVisibility(8);
        }
        View view3 = maxNativeAd.getMediaView();
        if (this.aZq != null) {
            if (view3 != null) {
                view3.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.aZq.addView(view3);
            } else if (maxNativeAd.getFormat() == MaxAdFormat.LEADER) {
                this.aZq.setVisibility(8);
            }
        }
        if (this.aZo != null) {
            Double d2 = maxNativeAd.getStarRating();
            if (d2 != null) {
                this.aZo.removeAllViews();
                AppLovinStarRatingView appLovinStarRatingView = new AppLovinStarRatingView(d2, this.getContext());
                appLovinStarRatingView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.aZo.addView((View)appLovinStarRatingView);
            } else {
                this.aZo.setVisibility(8);
            }
        }
        this.NU();
        this.postDelayed(() -> this.setSelected(true), 2000L);
    }

    public void renderCustomNativeAdView(MaxNativeAd maxNativeAd) {
        Object object;
        View view;
        if (this.aZg != null) {
            this.aZg.setText((CharSequence)maxNativeAd.getTitle());
        }
        if (this.aZi != null) {
            this.aZi.setText((CharSequence)maxNativeAd.getBody());
        }
        if (this.aZh != null) {
            this.aZh.setText((CharSequence)maxNativeAd.getAdvertiser());
        }
        if (this.aZj != null) {
            this.aZj.setText((CharSequence)maxNativeAd.getCallToAction());
        }
        MaxNativeAd.MaxNativeAdImage maxNativeAdImage = maxNativeAd.getIcon();
        if (this.aZk != null) {
            if (maxNativeAdImage != null) {
                if (maxNativeAdImage.getDrawable() != null) {
                    this.aZk.setImageDrawable(maxNativeAdImage.getDrawable());
                } else if (maxNativeAdImage.getUri() != null) {
                    if (m.aBD.a(a.aKe).booleanValue()) {
                        ImageViewUtils.setAndDownscaleImageUri(this.aZk, maxNativeAdImage.getUri());
                    } else {
                        ImageViewUtils.setImageUri(this.aZk, maxNativeAdImage.getUri(), m.aBD);
                    }
                } else {
                    this.aZk.setImageDrawable(null);
                }
            } else {
                this.aZk.setImageDrawable(null);
            }
        }
        View view2 = maxNativeAd.getMediaView();
        if (this.aZp != null) {
            this.aZp.removeAllViews();
            if (view2 != null) {
                view = view2.getParent();
                if (view != null) {
                    ((ViewGroup)view).removeAllViews();
                }
                view2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.aZp.addView(view2);
            }
        }
        view = maxNativeAd.getOptionsView();
        if (this.aZm != null) {
            this.aZm.removeAllViews();
            if (view != null) {
                object = view.getParent();
                if (object != null) {
                    ((ViewGroup)object).removeAllViews();
                }
                view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.aZm.addView(view);
                this.aZm.bringToFront();
            }
        }
        if (this.aZo != null) {
            this.aZo.removeAllViews();
            object = maxNativeAd.getStarRating();
            if (object != null) {
                AppLovinStarRatingView appLovinStarRatingView = new AppLovinStarRatingView((Double)object, this.getContext());
                appLovinStarRatingView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.aZo.addView((View)appLovinStarRatingView);
            }
        }
    }

    private void NU() {
        final ViewGroup viewGroup = (ViewGroup)this.findViewById(R.id.applovin_native_inner_parent_layout);
        if (viewGroup == null) {
            return;
        }
        ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
        if (!viewTreeObserver.isAlive()) {
            return;
        }
        final WeakReference<ViewTreeObserver> weakReference = new WeakReference<ViewTreeObserver>(viewTreeObserver);
        viewTreeObserver.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                ViewTreeObserver viewTreeObserver = (ViewTreeObserver)weakReference.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                } else {
                    m.aBD.Cv();
                    if (w.FV()) {
                        m.aBD.Cv().h("MaxNativeAdView", "Failed to remove onPreDrawListener since the view tree observer is not alive.");
                    }
                }
                weakReference.clear();
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)viewGroup.getLayoutParams();
                layoutParams.height = ((View)viewGroup.getParent()).getWidth();
                viewGroup.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                return true;
            }
        });
    }

    public View getMainView() {
        return this.mainView;
    }

    public TextView getTitleTextView() {
        return this.aZg;
    }

    public TextView getAdvertiserTextView() {
        return this.aZh;
    }

    public TextView getBodyTextView() {
        return this.aZi;
    }

    public Button getCallToActionButton() {
        return this.aZj;
    }

    public ImageView getIconImageView() {
        return this.aZk;
    }

    @Deprecated
    public FrameLayout getIconContentView() {
        return this.aZl;
    }

    public ViewGroup getOptionsContentViewGroup() {
        return this.aZm != null ? this.aZm : this.aZn;
    }

    @Deprecated
    public FrameLayout getOptionsContentView() {
        return this.aZn;
    }

    public ViewGroup getStarRatingContentViewGroup() {
        return this.aZo;
    }

    public ViewGroup getMediaContentViewGroup() {
        return this.aZp != null ? this.aZp : this.aZq;
    }

    @Deprecated
    public FrameLayout getMediaContentView() {
        return this.aZq;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.adViewTracker != null) {
            this.adViewTracker.uQ();
        }
        if (!this.isHardwareAccelerated()) {
            w.G("MaxNativeAdView", "Attached to non-hardware accelerated window: some native ad views require hardware accelerated Activities to render properly.");
        }
    }

    public List<View> getClickableViews() {
        ArrayList<View> arrayList = new ArrayList<View>(5);
        if (this.aZg != null) {
            arrayList.add((View)this.aZg);
        }
        if (this.aZh != null) {
            arrayList.add((View)this.aZh);
        }
        if (this.aZi != null) {
            arrayList.add((View)this.aZi);
        }
        if (this.aZj != null) {
            arrayList.add((View)this.aZj);
        }
        if (this.aZk != null) {
            arrayList.add((View)this.aZk);
        }
        return arrayList;
    }
}

