/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.exoplayer2.common.base;

import com.applovin.exoplayer2.common.base.Preconditions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class Throwables {
    private static final String JAVA_LANG_ACCESS_CLASSNAME = "sun.misc.JavaLangAccess";
    static final String SHARED_SECRETS_CLASSNAME = "sun.misc.SharedSecrets";
    private static final Object jla = Throwables.getJLA();
    private static final Method getStackTraceElementMethod = jla == null ? null : Throwables.getGetMethod();
    private static final Method getStackTraceDepthMethod = jla == null ? null : Throwables.getSizeMethod();

    private Throwables() {
    }

    public static <X extends Throwable> void throwIfInstanceOf(Throwable throwable, Class<X> clazz) throws X {
        Preconditions.checkNotNull(throwable);
        if (clazz.isInstance(throwable)) {
            throw (Throwable)clazz.cast(throwable);
        }
    }

    @Deprecated
    public static <X extends Throwable> void propagateIfInstanceOf(Throwable throwable, Class<X> clazz) throws X {
        if (throwable != null) {
            Throwables.throwIfInstanceOf(throwable, clazz);
        }
    }

    public static void throwIfUnchecked(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    @Deprecated
    public static void propagateIfPossible(Throwable throwable) {
        if (throwable != null) {
            Throwables.throwIfUnchecked(throwable);
        }
    }

    public static <X extends Throwable> void propagateIfPossible(Throwable throwable, Class<X> clazz) throws X {
        Throwables.propagateIfInstanceOf(throwable, clazz);
        Throwables.propagateIfPossible(throwable);
    }

    public static <X1 extends Throwable, X2 extends Throwable> void propagateIfPossible(Throwable throwable, Class<X1> clazz, Class<X2> clazz2) throws X1, X2 {
        Preconditions.checkNotNull(clazz2);
        Throwables.propagateIfInstanceOf(throwable, clazz);
        Throwables.propagateIfPossible(throwable, clazz2);
    }

    @Deprecated
    public static RuntimeException propagate(Throwable throwable) {
        Throwables.throwIfUnchecked(throwable);
        throw new RuntimeException(throwable);
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable throwable2;
        Throwable throwable3 = throwable;
        boolean bl = false;
        while ((throwable2 = throwable.getCause()) != null) {
            throwable = throwable2;
            if (throwable == throwable3) {
                throw new IllegalArgumentException("Loop in causal chain detected.", throwable);
            }
            if (bl) {
                throwable3 = throwable3.getCause();
            }
            bl = !bl;
        }
        return throwable;
    }

    public static List<Throwable> getCausalChain(Throwable throwable) {
        Throwable throwable2;
        Preconditions.checkNotNull(throwable);
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>(4);
        arrayList.add(throwable);
        Throwable throwable3 = throwable;
        boolean bl = false;
        while ((throwable2 = throwable.getCause()) != null) {
            throwable = throwable2;
            arrayList.add(throwable);
            if (throwable == throwable3) {
                throw new IllegalArgumentException("Loop in causal chain detected.", throwable);
            }
            if (bl) {
                throwable3 = throwable3.getCause();
            }
            bl = !bl;
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static <X extends Throwable> X getCauseAs(Throwable throwable, Class<X> clazz) {
        try {
            return (X)((Throwable)clazz.cast(throwable.getCause()));
        }
        catch (ClassCastException classCastException) {
            classCastException.initCause(throwable);
            throw classCastException;
        }
    }

    public static String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static List<StackTraceElement> lazyStackTrace(Throwable throwable) {
        return Throwables.lazyStackTraceIsLazy() ? Throwables.jlaStackTrace(throwable) : Collections.unmodifiableList(Arrays.asList(throwable.getStackTrace()));
    }

    public static boolean lazyStackTraceIsLazy() {
        return getStackTraceElementMethod != null && getStackTraceDepthMethod != null;
    }

    private static List<StackTraceElement> jlaStackTrace(final Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        return new AbstractList<StackTraceElement>(){

            public StackTraceElement aR(int n2) {
                return (StackTraceElement)Throwables.invokeAccessibleNonThrowingMethod(getStackTraceElementMethod, jla, new Object[]{throwable, n2});
            }

            @Override
            public int size() {
                return (Integer)Throwables.invokeAccessibleNonThrowingMethod(getStackTraceDepthMethod, jla, new Object[]{throwable});
            }

            @Override
            public /* synthetic */ Object get(int n2) {
                return this.aR(n2);
            }
        };
    }

    private static Object invokeAccessibleNonThrowingMethod(Method method, Object object, Object ... objectArray) {
        try {
            return method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw Throwables.propagate(invocationTargetException.getCause());
        }
    }

    private static Object getJLA() {
        try {
            Class<?> clazz = Class.forName(SHARED_SECRETS_CLASSNAME, false, null);
            Method method = clazz.getMethod("getJavaLangAccess", new Class[0]);
            return method.invoke(null, new Object[0]);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Method getGetMethod() {
        return Throwables.getJlaMethod("getStackTraceElement", Throwable.class, Integer.TYPE);
    }

    private static Method getSizeMethod() {
        try {
            Method method = Throwables.getJlaMethod("getStackTraceDepth", Throwable.class);
            if (method == null) {
                return null;
            }
            method.invoke(Throwables.getJLA(), new Throwable());
            return method;
        }
        catch (IllegalAccessException | UnsupportedOperationException | InvocationTargetException exception) {
            return null;
        }
    }

    private static Method getJlaMethod(String string2, Class<?> ... classArray) throws ThreadDeath {
        try {
            return Class.forName(JAVA_LANG_ACCESS_CLASSNAME, false, null).getMethod(string2, classArray);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

