/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.exoplayer2.common.base;

import com.applovin.exoplayer2.common.base.Function;
import com.applovin.exoplayer2.common.base.Preconditions;
import com.applovin.exoplayer2.common.base.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Predicates {
    private Predicates() {
    }

    public static <T> Predicate<T> alwaysTrue() {
        return g.oH.eY();
    }

    public static <T> Predicate<T> alwaysFalse() {
        return g.oI.eY();
    }

    public static <T> Predicate<T> isNull() {
        return g.oJ.eY();
    }

    public static <T> Predicate<T> notNull() {
        return g.oK.eY();
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return new f<T>(predicate);
    }

    public static <T> Predicate<T> and(Iterable<? extends Predicate<? super T>> iterable) {
        return new a(Predicates.defensiveCopy(iterable));
    }

    @SafeVarargs
    public static <T> Predicate<T> and(Predicate<? super T> ... predicateArray) {
        return new a(Predicates.defensiveCopy(predicateArray));
    }

    public static <T> Predicate<T> and(Predicate<? super T> predicate, Predicate<? super T> predicate2) {
        return new a(Predicates.asList(Preconditions.checkNotNull(predicate), Preconditions.checkNotNull(predicate2)));
    }

    public static <T> Predicate<T> or(Iterable<? extends Predicate<? super T>> iterable) {
        return new h(Predicates.defensiveCopy(iterable));
    }

    @SafeVarargs
    public static <T> Predicate<T> or(Predicate<? super T> ... predicateArray) {
        return new h(Predicates.defensiveCopy(predicateArray));
    }

    public static <T> Predicate<T> or(Predicate<? super T> predicate, Predicate<? super T> predicate2) {
        return new h(Predicates.asList(Preconditions.checkNotNull(predicate), Preconditions.checkNotNull(predicate2)));
    }

    public static <T> Predicate<T> equalTo(@NullableDecl T t2) {
        return t2 == null ? Predicates.isNull() : new e(t2);
    }

    public static Predicate<Object> instanceOf(Class<?> clazz) {
        return new d(clazz);
    }

    public static Predicate<Class<?>> subtypeOf(Class<?> clazz) {
        return new i(clazz);
    }

    public static <T> Predicate<T> in(Collection<? extends T> collection) {
        return new c(collection);
    }

    public static <A, B> Predicate<A> compose(Predicate<B> predicate, Function<A, ? extends B> function) {
        return new b(predicate, function);
    }

    private static String toStringHelper(String string2, Iterable<?> iterable) {
        StringBuilder stringBuilder = new StringBuilder("Predicates.").append(string2).append('(');
        boolean bl = true;
        for (Object obj : iterable) {
            if (!bl) {
                stringBuilder.append(',');
            }
            stringBuilder.append(obj);
            bl = false;
        }
        return stringBuilder.append(')').toString();
    }

    private static <T> List<Predicate<? super T>> asList(Predicate<? super T> predicate, Predicate<? super T> predicate2) {
        return Arrays.asList(predicate, predicate2);
    }

    private static <T> List<T> defensiveCopy(T ... TArray) {
        return Predicates.defensiveCopy(Arrays.asList(TArray));
    }

    static <T> List<T> defensiveCopy(Iterable<T> iterable) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t2 : iterable) {
            arrayList.add(Preconditions.checkNotNull(t2));
        }
        return arrayList;
    }

    private static class b<A, B>
    implements Predicate<A>,
    Serializable {
        final Predicate<B> oD;
        final Function<A, ? extends B> oE;

        private b(Predicate<B> predicate, Function<A, ? extends B> function) {
            this.oD = Preconditions.checkNotNull(predicate);
            this.oE = Preconditions.checkNotNull(function);
        }

        @Override
        public boolean apply(@NullableDecl A a2) {
            return this.oD.apply(this.oE.apply(a2));
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof b) {
                b b2 = (b)object;
                return this.oE.equals(b2.oE) && this.oD.equals(b2.oD);
            }
            return false;
        }

        public int hashCode() {
            return this.oE.hashCode() ^ this.oD.hashCode();
        }

        public String toString() {
            return this.oD + "(" + this.oE + ")";
        }
    }

    private static class c<T>
    implements Predicate<T>,
    Serializable {
        private final Collection<?> oF;

        private c(Collection<?> collection) {
            this.oF = Preconditions.checkNotNull(collection);
        }

        @Override
        public boolean apply(@NullableDecl T t2) {
            try {
                return this.oF.contains(t2);
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                return false;
            }
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof c) {
                c c2 = (c)object;
                return this.oF.equals(c2.oF);
            }
            return false;
        }

        public int hashCode() {
            return this.oF.hashCode();
        }

        public String toString() {
            return "Predicates.in(" + this.oF + ")";
        }
    }

    private static class i
    implements Predicate<Class<?>>,
    Serializable {
        private final Class<?> oG;

        private i(Class<?> clazz) {
            this.oG = Preconditions.checkNotNull(clazz);
        }

        public boolean a(Class<?> clazz) {
            return this.oG.isAssignableFrom(clazz);
        }

        public int hashCode() {
            return this.oG.hashCode();
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof i) {
                i i2 = (i)object;
                return this.oG == i2.oG;
            }
            return false;
        }

        public String toString() {
            return "Predicates.subtypeOf(" + this.oG.getName() + ")";
        }

        @Override
        public /* synthetic */ boolean apply(Object object) {
            return this.a((Class)object);
        }
    }

    private static class d
    implements Predicate<Object>,
    Serializable {
        private final Class<?> oG;

        private d(Class<?> clazz) {
            this.oG = Preconditions.checkNotNull(clazz);
        }

        @Override
        public boolean apply(@NullableDecl Object object) {
            return this.oG.isInstance(object);
        }

        public int hashCode() {
            return this.oG.hashCode();
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof d) {
                d d2 = (d)object;
                return this.oG == d2.oG;
            }
            return false;
        }

        public String toString() {
            return "Predicates.instanceOf(" + this.oG.getName() + ")";
        }
    }

    private static class e<T>
    implements Predicate<T>,
    Serializable {
        private final T ov;

        private e(T t2) {
            this.ov = t2;
        }

        @Override
        public boolean apply(T t2) {
            return this.ov.equals(t2);
        }

        public int hashCode() {
            return this.ov.hashCode();
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof e) {
                e e2 = (e)object;
                return this.ov.equals(e2.ov);
            }
            return false;
        }

        public String toString() {
            return "Predicates.equalTo(" + this.ov + ")";
        }
    }

    private static class h<T>
    implements Predicate<T>,
    Serializable {
        private final List<? extends Predicate<? super T>> oC;

        private h(List<? extends Predicate<? super T>> list) {
            this.oC = list;
        }

        @Override
        public boolean apply(@NullableDecl T t2) {
            for (int i2 = 0; i2 < this.oC.size(); ++i2) {
                if (!this.oC.get(i2).apply(t2)) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.oC.hashCode() + 87855567;
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof h) {
                h h2 = (h)object;
                return this.oC.equals(h2.oC);
            }
            return false;
        }

        public String toString() {
            return Predicates.toStringHelper("or", this.oC);
        }
    }

    private static class a<T>
    implements Predicate<T>,
    Serializable {
        private final List<? extends Predicate<? super T>> oC;

        private a(List<? extends Predicate<? super T>> list) {
            this.oC = list;
        }

        @Override
        public boolean apply(@NullableDecl T t2) {
            for (int i2 = 0; i2 < this.oC.size(); ++i2) {
                if (this.oC.get(i2).apply(t2)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.oC.hashCode() + 306654252;
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof a) {
                a a2 = (a)object;
                return this.oC.equals(a2.oC);
            }
            return false;
        }

        public String toString() {
            return Predicates.toStringHelper("and", this.oC);
        }
    }

    private static class f<T>
    implements Predicate<T>,
    Serializable {
        final Predicate<T> nO;

        f(Predicate<T> predicate) {
            this.nO = Preconditions.checkNotNull(predicate);
        }

        @Override
        public boolean apply(@NullableDecl T t2) {
            return !this.nO.apply(t2);
        }

        public int hashCode() {
            return ~this.nO.hashCode();
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof f) {
                f f2 = (f)object;
                return this.nO.equals(f2.nO);
            }
            return false;
        }

        public String toString() {
            return "Predicates.not(" + this.nO + ")";
        }
    }

    static enum g implements Predicate<Object>
    {
        oH{

            @Override
            public boolean apply(@NullableDecl Object object) {
                return true;
            }

            public String toString() {
                return "Predicates.alwaysTrue()";
            }
        }
        ,
        oI{

            @Override
            public boolean apply(@NullableDecl Object object) {
                return false;
            }

            public String toString() {
                return "Predicates.alwaysFalse()";
            }
        }
        ,
        oJ{

            @Override
            public boolean apply(@NullableDecl Object object) {
                return object == null;
            }

            public String toString() {
                return "Predicates.isNull()";
            }
        }
        ,
        oK{

            @Override
            public boolean apply(@NullableDecl Object object) {
                return object != null;
            }

            public String toString() {
                return "Predicates.notNull()";
            }
        };


        <T> Predicate<T> eY() {
            return this;
        }
    }
}

