/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Point;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.ImageView;
import androidx.annotation.Dimension;
import androidx.annotation.Nullable;
import com.applovin.impl.privacy.b.d;
import com.applovin.impl.sdk.c.e;
import com.applovin.impl.sdk.utils.CollectionUtils;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.h;
import com.applovin.impl.sdk.utils.l;
import com.applovin.impl.sdk.utils.u;
import com.applovin.sdk.AppLovinSdk;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class AppLovinSdkUtils {
    private static final Handler baB = new Handler(Looper.getMainLooper());

    @Dimension(unit=1)
    public static int dpToPx(Context context, @Dimension(unit=0) int n2) {
        return (int)TypedValue.applyDimension((int)1, (float)n2, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    @Dimension(unit=0)
    public static int pxToDp(Context context, @Dimension(unit=1) int n2) {
        return (int)Math.ceil((float)n2 / context.getResources().getDisplayMetrics().density);
    }

    public static boolean isTablet(Context context) {
        Point point = h.Y(context);
        int n2 = Math.min(point.x, point.y);
        return n2 >= AppLovinSdkUtils.dpToPx(context, 600);
    }

    public static boolean isEmulator() {
        return AppLovinSdkUtils.O(Build.DEVICE, "goldfish,vbox") || AppLovinSdkUtils.O(Build.HARDWARE, "ranchu,generic,vbox") || AppLovinSdkUtils.O(Build.MANUFACTURER, "Genymotion") || AppLovinSdkUtils.O(Build.MODEL, "Android SDK built for x86");
    }

    private static boolean O(String string2, String string3) {
        List<String> list = CollectionUtils.explode(string3);
        return StringUtils.startsWithAtLeastOnePrefix(string2, list);
    }

    public static int getOrientation(Context context) {
        Configuration configuration;
        Resources resources;
        if (context != null && (resources = context.getResources()) != null && (configuration = resources.getConfiguration()) != null) {
            return configuration.orientation;
        }
        return 0;
    }

    public static boolean isValidString(String string2) {
        return !TextUtils.isEmpty((CharSequence)string2);
    }

    public static void runOnUiThread(Runnable runnable) {
        AppLovinSdkUtils.runOnUiThread(false, runnable);
    }

    public static void runOnUiThread(boolean bl, Runnable runnable) {
        if (!bl && u.Mp()) {
            runnable.run();
        } else {
            baB.post(runnable);
        }
    }

    public static void runOnUiThreadDelayed(Runnable runnable, long l2) {
        AppLovinSdkUtils.runOnUiThreadDelayed(runnable, l2, baB);
    }

    public static void runOnUiThreadDelayed(Runnable runnable, long l2, Handler handler) {
        if (l2 > 0L) {
            handler.postDelayed(runnable, l2);
        } else if (u.Mp()) {
            runnable.run();
        } else {
            handler.post(runnable);
        }
    }

    public static Map<String, String> toMap(JSONObject jSONObject) throws JSONException {
        return JsonUtils.toStringMap(jSONObject);
    }

    public static boolean isSdkVersionGreaterThanOrEqualTo(String string2) {
        return AppLovinSdk.VERSION_CODE >= u.dN(string2);
    }

    public static boolean isFireOS(Context context) {
        return "amazon".equalsIgnoreCase(Build.MANUFACTURER) || AppLovinSdkUtils.isFireTv(context);
    }

    public static boolean isFireTv(Context context) {
        return context.getPackageManager().hasSystemFeature("amazon.hardware.fire_tv");
    }

    public static boolean isTv(Context context) {
        if (AppLovinSdkUtils.isFireTv(context)) {
            return true;
        }
        PackageManager packageManager = context.getPackageManager();
        if (h.LP()) {
            return packageManager.hasSystemFeature("android.software.leanback");
        }
        return packageManager.hasSystemFeature("android.hardware.type.television");
    }

    public static void setImageUrl(String string2, ImageView imageView, AppLovinSdk appLovinSdk) {
        l.a(imageView, Uri.parse((String)string2), appLovinSdk.a());
    }

    @Deprecated
    @Nullable
    public static Boolean getTcfConsentStatus(int n2, Context context) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        String string2 = e.a(com.applovin.impl.sdk.c.d.aTh, null, sharedPreferences, false);
        if (string2 != null) {
            return d.d(string2, n2 - 1);
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static Boolean getAdditionalConsentStatus(int n2, Context context) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        String string2 = e.a(com.applovin.impl.sdk.c.d.aTg, null, sharedPreferences, false);
        return d.f(n2, string2);
    }

    public static final class Size {
        public static final Size ZERO = new Size(0, 0);
        private int dE;
        private int height;

        private Size() {
        }

        public Size(int n2, int n3) {
            this.dE = n2;
            this.height = n3;
        }

        public int getWidth() {
            return this.dE;
        }

        public int getHeight() {
            return this.height;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Size)) {
                return false;
            }
            Size size = (Size)object;
            return this.dE == size.getWidth() && this.height == size.getHeight();
        }

        public String toString() {
            return this.dE + "x" + this.height;
        }

        public int hashCode() {
            return this.height ^ (this.dE << 16 | this.dE >>> 16);
        }
    }
}

