/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.utils;

import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.x;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CollectionUtils {
    public static <T> boolean addObjectIfExists(@Nullable T t2, List<T> list) {
        if (t2 != null) {
            return list.add(t2);
        }
        return false;
    }

    public static <K, V> Map<K, V> map(Map<K, V> map) {
        if (map == null) {
            return new HashMap();
        }
        return new HashMap<K, V>(map);
    }

    public static List<String> explode(String string2) {
        return CollectionUtils.explode(string2, ",\\s*");
    }

    public static List<String> explode(String string2, String string3) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return Collections.emptyList();
        }
        return Arrays.asList(string2.split(string3));
    }

    public static String implode(Collection<String> collection, int n2) {
        return CollectionUtils.implode(collection, ",", n2);
    }

    public static String implode(Collection<String> collection, String string2, int n2) {
        if (string2 == null) {
            throw new IllegalArgumentException("No glue specified");
        }
        if (collection == null || collection.size() < 1) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        for (String string3 : collection) {
            if (n3 >= n2) break;
            ++n3;
            stringBuilder.append(string3).append(string2);
        }
        if (stringBuilder.length() > string2.length()) {
            stringBuilder.setLength(stringBuilder.length() - string2.length());
        }
        return stringBuilder.toString();
    }

    public static List<String> removeTrimmedEmptyStrings(List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : list) {
            String string3 = string2.trim();
            if (TextUtils.isEmpty((CharSequence)string3)) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public static <T> List<T> synchronizedList() {
        return CollectionUtils.synchronizedList(-1);
    }

    public static <T> List<T> synchronizedList(int n2) {
        if (n2 >= 0) {
            return Collections.synchronizedList(new ArrayList(n2));
        }
        return Collections.synchronizedList(new ArrayList());
    }

    public static <K, V> Map<K, V> map(K k2, V v2) {
        HashMap<K, V> hashMap = new HashMap<K, V>(1);
        hashMap.put(k2, v2);
        return hashMap;
    }

    public static Bundle toBundle(Map<String, ?> map) {
        if (map == null || map.size() == 0) {
            return new Bundle();
        }
        Bundle bundle = new Bundle();
        for (String string2 : map.keySet()) {
            Object obj = map.get(string2);
            if (obj instanceof Map) {
                bundle.putBundle(string2, CollectionUtils.toBundle((Map)obj));
                continue;
            }
            if (obj instanceof Boolean) {
                bundle.putBoolean(string2, ((Boolean)obj).booleanValue());
                continue;
            }
            if (obj instanceof String) {
                bundle.putString(string2, (String)obj);
                continue;
            }
            if (obj instanceof Integer) {
                bundle.putInt(string2, ((Integer)obj).intValue());
                continue;
            }
            if (obj instanceof Long) {
                bundle.putLong(string2, ((Long)obj).longValue());
                continue;
            }
            if (obj instanceof Double) {
                bundle.putDouble(string2, ((Double)obj).doubleValue());
                continue;
            }
            if (!(obj instanceof Parcelable)) continue;
            bundle.putParcelable(string2, (Parcelable)obj);
        }
        return bundle;
    }

    public static String toJsonString(Map<String, Object> map, String string2) {
        try {
            return CollectionUtils.toJson(map).toString();
        }
        catch (JSONException jSONException) {
            x.e("CollectionUtils", "Failed to convert map '" + map + "' to JSON string.", jSONException);
            return string2;
        }
    }

    public static JSONObject toJson(Map<String, ?> map) throws JSONException {
        if (map == null) {
            return new JSONObject();
        }
        JSONObject jSONObject = new JSONObject();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            jSONObject.put(entry.getKey(), entry.getValue());
        }
        return jSONObject;
    }

    public static <T> JSONArray toJSONArray(List<T> list) throws JSONException {
        if (list == null) {
            return new JSONArray();
        }
        JSONArray jSONArray = new JSONArray();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            jSONArray.put(list.get(i2));
        }
        return jSONArray;
    }

    public static void putObjectToStringIfValid(String string2, Object object, Map map) {
        if (object == null) {
            return;
        }
        CollectionUtils.putStringIfValid(string2, object.toString(), map);
    }

    public static void putStringIfValid(String string2, String string3, Map map) {
        if (StringUtils.isValidString(string2) && StringUtils.isValidString(string3)) {
            map.put(string2, string3);
        }
    }

    public static void putBooleanIfValid(String string2, Boolean bl, Map map) {
        if (StringUtils.isValidString(string2) && bl != null) {
            map.put(string2, bl);
        }
    }

    public static void putIntegerIfValid(String string2, Integer n2, Map map) {
        if (StringUtils.isValidString(string2) && n2 != null) {
            map.put(string2, n2);
        }
    }

    public static void putDoubleIfValid(String string2, Double d2, Map map) {
        if (StringUtils.isValidString(string2) && d2 != null) {
            map.put(string2, d2);
        }
    }

    public static void putLongIfValid(String string2, Long l2, Map map) {
        if (StringUtils.isValidString(string2) && l2 != null) {
            map.put(string2, l2);
        }
    }

    public static void putFloatIfValid(String string2, Float f2, Map map) {
        if (StringUtils.isValidString(string2) && f2 != null) {
            map.put(string2, f2);
        }
    }

    public static void putJsonArrayIfValid(String string2, JSONArray jSONArray, Map map) {
        if (StringUtils.isValidString(string2) && jSONArray != null && jSONArray.length() > 0) {
            map.put(string2, jSONArray);
        }
    }

    public static void putStringArrayIfValid(String string2, String[] stringArray, Map map) {
        if (StringUtils.isValidString(string2) && stringArray != null && stringArray.length > 0) {
            map.put(string2, stringArray);
        }
    }

    public static boolean getBoolean(Map<String, Object> map, String string2) {
        return CollectionUtils.getBoolean(map, string2, false);
    }

    public static boolean getBoolean(Map<String, Object> map, String string2, boolean bl) {
        if (map != null && map.containsKey(string2)) {
            Object object = map.get(string2);
            if (object instanceof String) {
                return Boolean.parseBoolean((String)object);
            }
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (object instanceof Number) {
                Number number = (Number)object;
                return number.intValue() >= 1;
            }
        }
        return bl;
    }
}

