/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.hardware.SensorManager;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Environment;
import android.os.LocaleList;
import android.os.PowerManager;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.aa;
import com.applovin.impl.sdk.af;
import com.applovin.impl.sdk.array.ArrayService;
import com.applovin.impl.sdk.c.d;
import com.applovin.impl.sdk.d.f;
import com.applovin.impl.sdk.d.g;
import com.applovin.impl.sdk.e.ab;
import com.applovin.impl.sdk.e.i;
import com.applovin.impl.sdk.e.q;
import com.applovin.impl.sdk.n;
import com.applovin.impl.sdk.network.b;
import com.applovin.impl.sdk.utils.CollectionUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.d;
import com.applovin.impl.sdk.utils.h;
import com.applovin.impl.sdk.utils.p;
import com.applovin.impl.sdk.utils.t;
import com.applovin.impl.sdk.utils.u;
import com.applovin.impl.sdk.w;
import com.applovin.impl.sdk.x;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONObject;

public class o {
    private final n sdk;
    private final x logger;
    private final Context E;
    private final Map<String, Object> aCW;
    private final Object aCX = new Object();
    private final Map<String, Object> avX;
    private boolean aCY;
    private static final AtomicReference<d.a> aCZ = new AtomicReference();
    private final AtomicReference<Integer> aDa = new AtomicReference();
    private static final AtomicReference<a> aDb = new AtomicReference();

    protected o(n n2) {
        if (n2 == null) {
            throw new IllegalArgumentException("No sdk specified");
        }
        this.sdk = n2;
        this.logger = n2.BL();
        this.E = n2.getApplicationContext();
        this.aCW = this.CV();
        this.avX = this.CZ();
    }

    String getBidToken() {
        JSONObject jSONObject = new JSONObject(this.CP());
        byte[] byArray = jSONObject.toString().getBytes(Charset.defaultCharset());
        String string2 = Base64.encodeToString((byte[])byArray, (int)2);
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPI).booleanValue()) {
            long l2 = u.N(this.sdk);
            return p.a(string2, l2, p.a.gU(this.sdk.a(com.applovin.impl.sdk.c.b.aPJ)), this.sdk.getSdkKey(), this.sdk);
        }
        return string2;
    }

    private Map<String, String> CP() {
        return u.s(this.a(null, true, false));
    }

    public Map<String, Object> a(@Nullable Map<String, String> map, boolean bl, boolean bl2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(64);
        Map<String, Object> map2 = this.aL(bl);
        Map<String, Object> map3 = this.CY();
        Map<String, Object> map4 = this.Dc();
        Map<String, Object> map5 = this.Dd();
        Map<String, String> map6 = this.sdk.BA().getAllData();
        if (bl2) {
            hashMap.put("device_info", map2);
            hashMap.put("app_info", map3);
            if (map4 != null) {
                hashMap.put("connection_info", map4);
            }
            if (map != null) {
                hashMap.put("ad_info", map);
            }
            if (map5 != null) {
                hashMap.put("location_info", map5);
            }
            if (!map6.isEmpty()) {
                hashMap.put("targeting_data", map6);
            }
        } else {
            hashMap.putAll(map2);
            hashMap.putAll(map3);
            if (map4 != null) {
                hashMap.putAll(map4);
            }
            if (map != null) {
                hashMap.putAll(map);
            }
            if (map5 != null) {
                hashMap.putAll(map5);
            }
            if (!map6.isEmpty()) {
                hashMap.putAll(map6);
            }
        }
        hashMap.put("accept", "custom_size,launch_app,video");
        hashMap.put("format", "json");
        CollectionUtils.putStringIfValid("mediation_provider", this.sdk.getMediationProvider(), hashMap);
        CollectionUtils.putStringIfValid("mediation_provider_v2", this.sdk.CI(), hashMap);
        CollectionUtils.putStringIfValid("plugin_version", this.sdk.a(com.applovin.impl.sdk.c.b.aOy), hashMap);
        CollectionUtils.putLongIfValid("tssf_ms", this.sdk.Bw(), hashMap);
        if (!this.sdk.a(com.applovin.impl.sdk.c.b.aPG).booleanValue()) {
            hashMap.put("sdk_key", this.sdk.getSdkKey());
        }
        hashMap.putAll(this.Db());
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPi).booleanValue()) {
            g g2 = this.sdk.BP();
            hashMap.put("li", g2.b(f.aSO));
            hashMap.put("si", g2.b(f.aSR));
            hashMap.put("mad", g2.b(f.aSP));
            hashMap.put("msad", g2.b(f.aSS));
            hashMap.put("pf", g2.b(f.aSW));
            hashMap.put("mpf", g2.b(f.aTd));
            hashMap.put("gpf", g2.b(f.aSX));
            hashMap.put("asoac", g2.b(f.aTb));
        }
        hashMap.put("rid", UUID.randomUUID().toString());
        return hashMap;
    }

    public Map<String, Object> CQ() {
        return CollectionUtils.map(this.aCW);
    }

    public Map<String, Object> CR() {
        return CollectionUtils.map(this.avX);
    }

    public Map<String, Object> CS() {
        return this.aL(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> aL(boolean bl) {
        Map<String, Object> map;
        Object object = this.aCX;
        synchronized (object) {
            map = CollectionUtils.map(this.aCW);
        }
        return this.a(map, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void CT() {
        Object object = this.aCX;
        synchronized (object) {
            this.g(this.aCW);
        }
    }

    public String CU() {
        return AppLovinSdkUtils.isFireOS(this.E) ? "fireos" : "android";
    }

    private Map<String, Object> CV() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(34);
        hashMap.put("api_level", Build.VERSION.SDK_INT);
        hashMap.put("brand", Build.MANUFACTURER);
        hashMap.put("brand_name", Build.BRAND);
        hashMap.put("hardware", Build.HARDWARE);
        hashMap.put("sim", AppLovinSdkUtils.isEmulator());
        hashMap.put("aida", com.applovin.impl.sdk.utils.d.KN());
        hashMap.put("locale", Locale.getDefault().toString());
        hashMap.put("model", Build.MODEL);
        hashMap.put("os", Build.VERSION.RELEASE);
        hashMap.put("platform", this.CU());
        hashMap.put("revision", Build.DEVICE);
        hashMap.put("tz_offset", this.Dp());
        hashMap.put("gy", this.Dq());
        hashMap.put("country_code", this.Dr());
        hashMap.put("mcc", this.Ds());
        hashMap.put("mnc", this.Dt());
        hashMap.put("carrier", this.Du());
        hashMap.put("is_tablet", AppLovinSdkUtils.isTablet(this.E));
        hashMap.put("tv", AppLovinSdkUtils.isTv(this.E));
        hashMap.put("pc", Runtime.getRuntime().availableProcessors());
        hashMap.put("hdr", this.Dw());
        hashMap.put("supported_abis", this.Dx());
        DisplayMetrics displayMetrics = this.E.getResources().getDisplayMetrics();
        if (displayMetrics != null) {
            hashMap.put("adns", Float.valueOf(displayMetrics.density));
            hashMap.put("adnsd", displayMetrics.densityDpi);
            hashMap.put("xdpi", Float.valueOf(displayMetrics.xdpi));
            hashMap.put("ydpi", Float.valueOf(displayMetrics.ydpi));
            Point point = h.W(this.E);
            double d2 = Math.sqrt(Math.pow(point.x, 2.0) + Math.pow(point.y, 2.0));
            hashMap.put("screen_size_in", d2 / (double)displayMetrics.xdpi);
            h.a a2 = h.a(this.E, this.sdk);
            if (a2 != null) {
                hashMap.put("tl_cr", a2.Lf());
                hashMap.put("tr_cr", a2.Lg());
                hashMap.put("bl_cr", a2.Lh());
                hashMap.put("br_cr", a2.Li());
            }
        }
        hashMap.put("bt_ms", System.currentTimeMillis() - SystemClock.elapsedRealtime());
        hashMap.put("tbalsi_ms", this.sdk.CG() - n.CE());
        CollectionUtils.putBooleanIfValid("psase", aa.Fr(), hashMap);
        this.g(hashMap);
        return hashMap;
    }

    private void g(Map<String, Object> map) {
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aOF).booleanValue() && !map.containsKey("af")) {
            map.put("af", this.Di());
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aOG).booleanValue() && !map.containsKey("font")) {
            map.put("font", Float.valueOf(this.Dj()));
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aON).booleanValue() && u.Q(this.sdk)) {
            af.A(this.sdk);
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aOM).booleanValue() && !map.containsKey("sua")) {
            map.put("sua", System.getProperty("http.agent"));
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aOI).booleanValue() && !map.containsKey("network_restricted")) {
            map.put("network_restricted", this.De());
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aOQ).booleanValue()) {
            boolean bl = this.E.getResources().getConfiguration().keyboard == 2;
            boolean bl2 = this.E.getPackageManager().hasSystemFeature("com.google.android.play.feature.HPE_EXPERIENCE");
            boolean bl3 = this.E.getPackageManager().hasSystemFeature("android.hardware.type.pc");
            map.put("is_pc", bl && (bl2 || bl3));
        }
    }

    private Map<String, Object> a(Map<String, Object> map, boolean bl) {
        ArrayService arrayService;
        PowerManager powerManager;
        String string2;
        Map<String, Object> map2;
        block37: {
            block36: {
                block35: {
                    Object object;
                    Boolean bl2;
                    Boolean bl3;
                    Boolean bl4;
                    d.a a2;
                    Object object2;
                    map2 = CollectionUtils.map(map);
                    Point point = h.W(this.E);
                    map2.put("dx", point.x);
                    map2.put("dy", point.y);
                    if (bl) {
                        object2 = aCZ.get();
                        if (object2 != null) {
                            a2 = object2;
                            this.DA();
                        } else if (u.Lv()) {
                            a2 = new d.a();
                            map2.put("inc", true);
                        } else {
                            a2 = this.sdk.BQ().Df();
                        }
                    } else {
                        a2 = this.sdk.BQ().Df();
                    }
                    object2 = a2.KP();
                    if (StringUtils.isValidString((String)object2)) {
                        map2.put("idfa", object2);
                    }
                    map2.put("dnt", a2.KO());
                    map2.put("dnt_code", a2.KQ().KR());
                    a a3 = aDb.get();
                    if (this.sdk.a(com.applovin.impl.sdk.c.b.aOn).booleanValue() && a3 != null) {
                        map2.put("idfv", a3.do);
                        map2.put("idfv_scope", a3.aDd);
                    }
                    if ((bl4 = com.applovin.impl.privacy.a.zN().B(this.E)) != null) {
                        map2.put("huc", bl4);
                    }
                    if ((bl3 = com.applovin.impl.privacy.a.zM().B(this.E)) != null) {
                        map2.put("aru", bl3);
                    }
                    if ((bl2 = com.applovin.impl.privacy.a.zO().B(this.E)) != null) {
                        map2.put("dns", bl2);
                    }
                    if (this.sdk.a(com.applovin.impl.sdk.c.b.aOz).booleanValue()) {
                        object = this.Dh();
                        CollectionUtils.putIntegerIfValid("act", ((b)object).aDe, map2);
                        CollectionUtils.putIntegerIfValid("acm", ((b)object).adn, map2);
                        CollectionUtils.putBooleanIfValid("sowpie", ((b)object).aDf, map2);
                    }
                    if (this.sdk.a(com.applovin.impl.sdk.c.b.aOH).booleanValue()) {
                        map2.put("mtl", this.sdk.Cc().getLastTrimMemoryLevel());
                    }
                    if (this.sdk.a(com.applovin.impl.sdk.c.b.aOK).booleanValue()) {
                        map2.put("adr", this.Dv());
                    }
                    Object object3 = object = bl ? this.aDa.get() : this.Dm();
                    if (object != null) {
                        map2.put("volume", object);
                    }
                    CollectionUtils.putBooleanIfValid("ma", this.Dn(), map2);
                    CollectionUtils.putBooleanIfValid("spo", this.Do(), map2);
                    CollectionUtils.putBooleanIfValid("aif", !this.sdk.Cc().isApplicationPaused(), map2);
                    CollectionUtils.putLongIfValid("af_ts_ms", this.sdk.Cc().getAppEnteredForegroundTimeMillis(), map2);
                    CollectionUtils.putLongIfValid("ab_ts_ms", this.sdk.Cc().getAppEnteredBackgroundTimeMillis(), map2);
                    try {
                        int n2 = Settings.System.getInt((ContentResolver)this.E.getContentResolver(), (String)"screen_brightness");
                        float f2 = (float)n2 / 255.0f;
                        map2.put("sb", (int)(f2 * 100.0f));
                    }
                    catch (Settings.SettingNotFoundException settingNotFoundException) {
                        o o2 = this;
                        if (!o2.logger.Fk()) break block35;
                        this.logger.c("DataCollector", "Unable to collect screen brightness", settingNotFoundException);
                    }
                }
                if (this.sdk.a(com.applovin.impl.sdk.c.b.aON).booleanValue() && u.Q(this.sdk)) {
                    af.A(this.sdk);
                    String string3 = af.Fw();
                    if (StringUtils.isValidString(string3)) {
                        map2.put("ua", string3);
                    }
                }
                if (this.sdk.a(com.applovin.impl.sdk.c.b.aOB).booleanValue()) {
                    try {
                        map2.put("fs", Environment.getDataDirectory().getFreeSpace());
                        map2.put("tds", Environment.getDataDirectory().getTotalSpace());
                    }
                    catch (Throwable throwable) {
                        map2.put("fs", -1);
                        map2.put("tds", -1);
                        o o3 = this;
                        if (!o3.logger.Fk()) break block36;
                        this.logger.c("DataCollector", "Unable to collect total & free space.", throwable);
                    }
                }
            }
            if (this.sdk.a(com.applovin.impl.sdk.c.b.aOC).booleanValue()) {
                ActivityManager activityManager = (ActivityManager)this.E.getSystemService("activity");
                ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
                if (activityManager != null) {
                    try {
                        activityManager.getMemoryInfo(memoryInfo);
                        map2.put("fm", memoryInfo.availMem);
                        map2.put("tm", memoryInfo.totalMem);
                        map2.put("lmt", memoryInfo.threshold);
                        map2.put("lm", memoryInfo.lowMemory);
                    }
                    catch (Throwable throwable) {
                        map2.put("fm", -1);
                        map2.put("tm", -1);
                        map2.put("lmt", -1);
                        o o4 = this;
                        if (!o4.logger.Fk()) break block37;
                        this.logger.c("DataCollector", "Unable to collect memory info.", throwable);
                    }
                }
            }
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aOD).booleanValue() && h.d("android.permission.READ_PHONE_STATE", this.E) && h.KX()) {
            TelephonyManager telephonyManager = (TelephonyManager)this.E.getSystemService("phone");
            int n3 = telephonyManager.getDataNetworkType();
            map2.put("rat", n3);
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aOA).booleanValue() && !TextUtils.isEmpty((CharSequence)(string2 = this.Dk()))) {
            map2.put("so", string2);
        }
        map2.put("orientation_lock", this.CW());
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aOE).booleanValue()) {
            map2.put("vs", u.Lx());
        }
        if (h.KV() && (powerManager = (PowerManager)this.E.getSystemService("power")) != null) {
            map2.put("lpm", powerManager.isPowerSaveMode() ? 1 : 0);
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aOO).booleanValue() && this.sdk.Cg() != null) {
            map2.put("da", Float.valueOf(this.sdk.Cg().Lq()));
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aOP).booleanValue() && this.sdk.Cg() != null) {
            map2.put("dm", Float.valueOf(this.sdk.Cg().Lp()));
        }
        map2.put("mute_switch", this.sdk.Ch().AT());
        map2.put("network", com.applovin.impl.sdk.utils.i.G(this.sdk));
        String string4 = this.Dl();
        if (StringUtils.isValidString(string4)) {
            map2.put("kb", string4);
        }
        if ((arrayService = this.sdk.Cp()).isAppHubInstalled()) {
            if (arrayService.getIsDirectDownloadEnabled() != null) {
                map2.put("ah_dd_enabled", arrayService.getIsDirectDownloadEnabled());
            }
            map2.put("ah_sdk_version_code", arrayService.getAppHubVersionCode());
            map2.put("ah_random_user_token", StringUtils.emptyIfNull(arrayService.getRandomUserToken()));
            map2.put("ah_sdk_package_name", StringUtils.emptyIfNull(arrayService.getAppHubPackageName()));
        }
        return map2;
    }

    private String CW() {
        String string2 = "none";
        int n2 = AppLovinSdkUtils.getOrientation(this.E);
        if (n2 == 1) {
            string2 = "portrait";
        } else if (n2 == 2) {
            string2 = "landscape";
        }
        return string2;
    }

    public boolean CX() {
        return this.aCY;
    }

    public Map<String, Object> CY() {
        String string2;
        Map<String, Object> map = CollectionUtils.map(this.avX);
        map.put("first_install", this.sdk.CH());
        map.put("first_install_v2", !this.sdk.BJ());
        map.put("test_ads", this.aCY);
        map.put("muted", this.sdk.getSettings().isMuted());
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aOo).booleanValue()) {
            CollectionUtils.putStringIfValid("cuid", this.sdk.Bx(), map);
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aOr).booleanValue()) {
            map.put("compass_random_token", this.sdk.By());
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aOt).booleanValue()) {
            map.put("applovin_random_token", this.sdk.Bz());
        }
        if (StringUtils.isValidString(string2 = this.sdk.getUserSegment().getName())) {
            map.put("user_segment_name", string2);
        }
        map.putAll(this.Da());
        if (this.sdk.BU() != null) {
            CollectionUtils.putJsonArrayIfValid("ps_topics", this.sdk.BU().Fq(), map);
        }
        return map;
    }

    private Map<String, Object> CZ() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        PackageManager packageManager = this.E.getPackageManager();
        ApplicationInfo applicationInfo = this.E.getApplicationInfo();
        File file = new File(applicationInfo.sourceDir);
        long l2 = file.lastModified();
        PackageInfo packageInfo = null;
        String string2 = null;
        try {
            packageInfo = packageManager.getPackageInfo(this.E.getPackageName(), 0);
            string2 = packageManager.getInstallerPackageName(applicationInfo.packageName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        hashMap.put("app_name", packageManager.getApplicationLabel(applicationInfo));
        hashMap.put("app_version", packageInfo != null ? packageInfo.versionName : "");
        hashMap.put("app_version_code", packageInfo != null ? packageInfo.versionCode : -1);
        hashMap.put("package_name", applicationInfo.packageName);
        hashMap.put("vz", StringUtils.toShortSHA1Hash(applicationInfo.packageName));
        hashMap.put("installer_name", string2 != null ? string2 : "");
        hashMap.put("tg", t.M(this.sdk));
        o o2 = this;
        hashMap.put("debug", u.b(o2.sdk.getApplicationContext(), this.sdk));
        hashMap.put("ia", l2);
        hashMap.put("alts_ms", n.CE());
        hashMap.put("j8", n.CF());
        hashMap.put("ps_tpg", aa.M(this.E));
        hashMap.put("ps_apg", aa.N(this.E));
        hashMap.put("ps_capg", aa.O(this.E));
        hashMap.put("ps_aipg", aa.P(this.E));
        Long l3 = this.sdk.a(d.aRf);
        if (l3 != null) {
            hashMap.put("ia_v2", l3);
        } else {
            this.sdk.a(d.aRf, l2);
        }
        hashMap.put("sdk_version", AppLovinSdk.VERSION);
        hashMap.put("omid_sdk_version", this.sdk.Cn().getSdkVersion());
        hashMap.put("api_did", this.sdk.a(com.applovin.impl.sdk.c.b.aKh));
        hashMap.put("first_install_v3_ms", packageInfo != null ? Long.valueOf(packageInfo.firstInstallTime) : "");
        hashMap.put("target_sdk", applicationInfo.targetSdkVersion);
        hashMap.put("epv", u.LA());
        return hashMap;
    }

    private Map<String, Object> Da() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        CollectionUtils.putIntegerIfValid("IABTCF_gdprApplies", this.sdk.Ck().Ap(), hashMap);
        CollectionUtils.putStringIfValid("IABTCF_TCString", this.sdk.Ck().Aq(), hashMap);
        CollectionUtils.putStringIfValid("IABTCF_AddtlConsent", this.sdk.Ck().Ar(), hashMap);
        return hashMap;
    }

    public Map<String, Object> Db() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("sc", this.sdk.a(com.applovin.impl.sdk.c.b.aKn));
        hashMap.put("sc2", this.sdk.a(com.applovin.impl.sdk.c.b.aKo));
        hashMap.put("sc3", this.sdk.a(com.applovin.impl.sdk.c.b.aKp));
        hashMap.put("server_installed_at", this.sdk.a(com.applovin.impl.sdk.c.b.aKq));
        String string2 = this.sdk.a(d.aRH);
        CollectionUtils.putStringIfValid("persisted_data", string2, hashMap);
        return hashMap;
    }

    @Nullable
    public Map<String, Object> Dc() {
        b.c c2 = this.sdk.BO().HI();
        if (c2 == null) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("lrm_ts_ms", String.valueOf(c2.HK()));
        hashMap.put("lrm_url", c2.HL());
        hashMap.put("lrm_ct_ms", String.valueOf(c2.HN()));
        hashMap.put("lrm_rs", String.valueOf(c2.HM()));
        return hashMap;
    }

    @Nullable
    public Map<String, Object> Dd() {
        if (!this.sdk.getSettings().isLocationCollectionEnabled()) {
            return null;
        }
        if (!this.sdk.a(com.applovin.impl.sdk.c.b.aPf).booleanValue()) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        w w2 = this.sdk.Co();
        boolean bl = w2.Ff();
        hashMap.put("loc_services_enabled", bl);
        if (!bl) {
            return hashMap;
        }
        hashMap.put("loc_auth", w2.Fe());
        if (w2.Fg()) {
            hashMap.put("loc_lat", u.a(w2.Fi(), this.sdk.a(com.applovin.impl.sdk.c.b.aPh)));
            hashMap.put("loc_long", u.a(w2.Fj(), this.sdk.a(com.applovin.impl.sdk.c.b.aPh)));
        }
        return hashMap;
    }

    private boolean De() {
        block4: {
            if (!h.KX()) {
                return false;
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)this.E.getSystemService("connectivity");
            if (connectivityManager != null) {
                try {
                    int n2 = connectivityManager.getRestrictBackgroundStatus();
                    return n2 == 3;
                }
                catch (Throwable throwable) {
                    this.sdk.BL();
                    if (!x.Fk()) break block4;
                    this.sdk.BL().c("DataCollector", "Unable to collect constrained network info.", throwable);
                }
            }
        }
        return false;
    }

    public d.a Df() {
        List<String> list;
        d.a a2 = com.applovin.impl.sdk.utils.d.S(this.E);
        if (a2 == null) {
            return new d.a();
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aOm).booleanValue()) {
            boolean bl = a2.KO();
            if (bl && !this.sdk.a(com.applovin.impl.sdk.c.b.aOl).booleanValue()) {
                a2.dB("");
            }
            aCZ.set(a2);
        } else {
            a2 = new d.a();
        }
        this.aCY = StringUtils.isValidString(a2.KP()) ? (list = this.sdk.getSettings().getTestDeviceAdvertisingIds()) != null && list.contains(a2.KP()) : false;
        return a2;
    }

    public static void a(d.a a2) {
        aCZ.set(a2);
    }

    @Nullable
    public a Dg() {
        return aDb.get();
    }

    public static void a(a a2) {
        aDb.set(a2);
    }

    private b Dh() {
        int n2;
        int n3;
        int n4;
        b b2 = new b();
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = this.E.registerReceiver(null, intentFilter);
        int n5 = intent != null ? intent.getIntExtra("level", -1) : -1;
        int n6 = n4 = intent != null ? intent.getIntExtra("scale", -1) : -1;
        if (n5 > 0 && n4 > 0) {
            float f2 = (float)n5 / (float)n4;
            b2.adn = (int)(f2 * 100.0f);
        } else {
            b2.adn = -1;
        }
        int n7 = b2.aDe = intent != null ? intent.getIntExtra("status", -1) : -1;
        b2.aDf = h.KT() ? Boolean.valueOf(Settings.Global.getInt((ContentResolver)this.E.getContentResolver(), (String)"stay_on_while_plugged_in", (int)-1) > 0) : Boolean.valueOf((n3 = (n2 = intent.getIntExtra("plugged", -1)) & 1 | 2 | 4 | 8) > 0);
        return b2;
    }

    private long Di() {
        int n2;
        int n3;
        String string2 = StringUtils.emptyIfNull(Settings.Secure.getString((ContentResolver)this.E.getContentResolver(), (String)"enabled_accessibility_services"));
        List<String> list = Arrays.asList(string2.split(":"));
        long l2 = 0L;
        if (list.contains("AccessibilityMenuService")) {
            l2 |= 0x100L;
        }
        if (list.contains("SelectToSpeakService")) {
            l2 |= 0x200L;
        }
        if (list.contains("SoundAmplifierService")) {
            l2 |= 2L;
        }
        if (list.contains("SpeechToTextAccessibilityService")) {
            l2 |= 0x80L;
        }
        if (list.contains("SwitchAccessService")) {
            l2 |= 4L;
        }
        if ((n3 = this.E.getResources().getConfiguration().uiMode & 0x30) == 32) {
            l2 |= 0x400L;
        }
        if (this.cH("accessibility_enabled")) {
            l2 |= 8L;
        }
        if (this.cH("touch_exploration_enabled")) {
            l2 |= 0x10L;
        }
        if (h.KV()) {
            if (this.cH("accessibility_display_inversion_enabled")) {
                l2 |= 0x20L;
            }
            if (this.cH("skip_first_use_hints")) {
                l2 |= 0x40L;
            }
        }
        if (this.cH("lock_screen_allow_remote_input")) {
            l2 |= 0x800L;
        }
        if (this.cH("enabled_accessibility_audio_description_by_default")) {
            l2 |= 0x1000L;
        }
        if (this.cH("accessibility_shortcut_on_lock_screen")) {
            l2 |= 0x2000L;
        }
        if (this.cH("wear_talkback_enabled")) {
            l2 |= 0x4000L;
        }
        if (this.cH("hush_gesture_used")) {
            l2 |= 0x8000L;
        }
        if (this.cH("high_text_contrast_enabled")) {
            l2 |= 0x10000L;
        }
        if (this.cH("accessibility_display_magnification_enabled")) {
            l2 |= 0x20000L;
        }
        if (this.cH("accessibility_display_magnification_navbar_enabled")) {
            l2 |= 0x40000L;
        }
        if (this.cH("accessibility_captioning_enabled")) {
            l2 |= 0x80000L;
        }
        if (this.cH("accessibility_display_daltonizer_enabled")) {
            l2 |= 0x100000L;
        }
        if (this.cH("accessibility_autoclick_enabled")) {
            l2 |= 0x200000L;
        }
        if (this.cH("accessibility_large_pointer_icon")) {
            l2 |= 0x400000L;
        }
        if (this.cH("reduce_bright_colors_activated")) {
            l2 |= 0x800000L;
        }
        if (this.cH("reduce_bright_colors_persist_across_reboots")) {
            l2 |= 0x1000000L;
        }
        if (this.cH("tty_mode_enabled")) {
            l2 |= 0x2000000L;
        }
        if (this.cH("rtt_calling_mode")) {
            l2 |= 0x4000000L;
        }
        if (this.cH("accessibility_floating_menu_fade_enabled")) {
            l2 |= 0x8000000L;
        }
        if (this.cH("accessibility_show_window_magnification_prompt")) {
            l2 |= 0x10000000L;
        }
        if (this.cH("accessibility_floating_menu_migration_tooltip_prompt")) {
            l2 |= 0x20000000L;
        }
        if ((n2 = this.cI("accessibility_magnification_mode")) == 0) {
            l2 |= 0x40000000L;
        } else if (n2 == 1) {
            l2 |= 0x80000000L;
        } else if (n2 == 2) {
            l2 |= 0x100000000L;
        } else if (n2 == 3) {
            l2 |= 0x200000000L;
        }
        int n4 = this.cI("accessibility_button_mode");
        if (n4 == 0) {
            l2 |= 0x400000000L;
        } else if (n4 == 1) {
            l2 |= 0x800000000L;
        }
        int n5 = this.cI("accessibility_floating_menu_size");
        if (n5 == 0) {
            l2 |= 0x1000000000L;
        } else if (n5 == 1) {
            l2 |= 0x2000000000L;
        }
        int n6 = this.cI("accessibility_floating_menu_icon_type");
        if (n6 == 0) {
            l2 |= 0x4000000000L;
        } else if (n6 == 1) {
            l2 |= 0x8000000000L;
        }
        return l2;
    }

    private boolean cH(String string2) {
        return this.cI(string2) == 1;
    }

    private int cI(String string2) {
        try {
            return Settings.Secure.getInt((ContentResolver)this.E.getContentResolver(), (String)string2);
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    private float Dj() {
        try {
            return Settings.System.getFloat((ContentResolver)this.E.getContentResolver(), (String)"font_scale");
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            o o2 = this;
            if (o2.logger.Fk()) {
                this.logger.c("DataCollector", "Error collecting font scale", settingNotFoundException);
            }
            return -1.0f;
        }
    }

    private String Dk() {
        AudioManager audioManager = (AudioManager)this.E.getSystemService("audio");
        if (audioManager != null) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            if (h.KW()) {
                for (AudioDeviceInfo audioDeviceInfo : object = audioManager.getDevices(2)) {
                    stringBuilder.append(audioDeviceInfo.getType());
                    stringBuilder.append(",");
                }
            } else {
                if (audioManager.isWiredHeadsetOn()) {
                    stringBuilder.append(3);
                    stringBuilder.append(",");
                }
                if (audioManager.isBluetoothScoOn()) {
                    stringBuilder.append(7);
                    stringBuilder.append(",");
                }
                if (audioManager.isBluetoothA2dpOn()) {
                    stringBuilder.append(8);
                }
            }
            if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            if (TextUtils.isEmpty((CharSequence)(object = stringBuilder.toString()))) {
                o o2 = this;
                if (o2.logger.Fk()) {
                    this.logger.f("DataCollector", "No sound outputs detected");
                }
            }
            return object;
        }
        return null;
    }

    private String Dl() {
        if (!h.KX()) {
            return null;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            LocaleList localeList = this.E.getResources().getConfiguration().getLocales();
            for (int i2 = 0; i2 < localeList.size(); ++i2) {
                stringBuilder.append(localeList.get(i2));
                stringBuilder.append(",");
            }
            if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Nullable
    private Integer Dm() {
        AudioManager audioManager = (AudioManager)this.E.getSystemService("audio");
        if (audioManager == null) {
            return null;
        }
        Float f2 = this.sdk.a(com.applovin.impl.sdk.c.b.aOL);
        try {
            return (int)((float)audioManager.getStreamVolume(3) * f2.floatValue());
        }
        catch (Throwable throwable) {
            this.sdk.BL();
            if (x.Fk()) {
                this.sdk.BL().c("DataCollector", "Unable to collect device volume", throwable);
            }
            return null;
        }
    }

    @Nullable
    private Boolean Dn() {
        AudioManager audioManager = (AudioManager)this.E.getSystemService("audio");
        if (audioManager == null) {
            return null;
        }
        return audioManager.isMusicActive();
    }

    @Nullable
    private Boolean Do() {
        AudioManager audioManager = (AudioManager)this.E.getSystemService("audio");
        if (audioManager == null) {
            return null;
        }
        return audioManager.isSpeakerphoneOn();
    }

    private double Dp() {
        TimeZone timeZone = TimeZone.getDefault();
        Date date = new Date();
        double d2 = timeZone.getOffset(date.getTime());
        return (double)Math.round(10.0 * d2 / 3600000.0) / 10.0;
    }

    private boolean Dq() {
        SensorManager sensorManager = (SensorManager)this.E.getSystemService("sensor");
        return sensorManager != null && sensorManager.getDefaultSensor(4) != null;
    }

    private String Dr() {
        TelephonyManager telephonyManager = (TelephonyManager)this.E.getSystemService("phone");
        return telephonyManager != null ? telephonyManager.getSimCountryIso().toUpperCase(Locale.ENGLISH) : "";
    }

    private String Ds() {
        block3: {
            TelephonyManager telephonyManager = (TelephonyManager)this.E.getSystemService("phone");
            if (telephonyManager != null) {
                try {
                    String string2 = telephonyManager.getNetworkOperator();
                    int n2 = Math.min(3, string2.length());
                    return string2.substring(0, n2);
                }
                catch (Throwable throwable) {
                    o o2 = this;
                    if (!o2.logger.Fk()) break block3;
                    this.logger.c("DataCollector", "Unable to collect mobile country code", throwable);
                }
            }
        }
        return "";
    }

    private String Dt() {
        block3: {
            TelephonyManager telephonyManager = (TelephonyManager)this.E.getSystemService("phone");
            if (telephonyManager != null) {
                try {
                    String string2 = telephonyManager.getNetworkOperator();
                    int n2 = Math.min(3, string2.length());
                    return string2.substring(n2);
                }
                catch (Throwable throwable) {
                    o o2 = this;
                    if (!o2.logger.Fk()) break block3;
                    this.logger.c("DataCollector", "Unable to collect mobile network code", throwable);
                }
            }
        }
        return "";
    }

    private String Du() {
        block3: {
            TelephonyManager telephonyManager = (TelephonyManager)this.E.getSystemService("phone");
            if (telephonyManager != null) {
                try {
                    return telephonyManager.getNetworkOperatorName();
                }
                catch (Throwable throwable) {
                    o o2 = this;
                    if (!o2.logger.Fk()) break block3;
                    this.logger.c("DataCollector", "Unable to collect carrier", throwable);
                }
            }
        }
        return "";
    }

    private boolean Dv() {
        try {
            return this.Dy() || this.Dz();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Nullable
    private Boolean Dw() {
        if (!h.KY()) {
            return null;
        }
        return this.E.getResources().getConfiguration().isScreenHdr();
    }

    @Nullable
    private String[] Dx() {
        if (!h.KV()) {
            return null;
        }
        return Build.SUPPORTED_ABIS;
    }

    private boolean Dy() {
        String string2 = "lz}$blpz";
        String string3 = Build.TAGS;
        return string3 != null && string3.contains(this.cJ("lz}$blpz"));
    }

    private boolean Dz() {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{"&zpz}ld&hyy&Z|yl{|zl{'hyb", "&zk`g&z|", "&zpz}ld&k`g&z|", "&zpz}ld&qk`g&z|", "&mh}h&efjhe&qk`g&z|", "&mh}h&efjhe&k`g&z|", "&zpz}ld&zm&qk`g&z|", "&zpz}ld&k`g&oh`ezhol&z|", "&mh}h&efjhe&z|"}) {
            String string3 = this.cJ(string2);
            if (!new File(string3).exists()) continue;
            return true;
        }
        return false;
    }

    private String cJ(String string2) {
        int n2 = string2.length();
        int[] nArray = new int[]{11, 12, 10, 3, 2, 1, 15, 10, 15, 14};
        int n3 = nArray.length;
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = string2.charAt(i2);
            for (int i3 = n3 - 1; i3 >= 0; --i3) {
                int n4 = i2;
                cArray[n4] = (char)(cArray[n4] ^ nArray[i3]);
            }
        }
        return new String(cArray);
    }

    public void DA() {
        this.sdk.BM().a(new i(this.sdk, new i.a(){

            @Override
            public void b(d.a a2) {
                aCZ.set(a2);
            }
        }), q.b.aUr);
        this.sdk.BM().a(new ab(this.sdk, true, "setDeviceVolume", () -> this.aDa.set(this.Dm())), q.b.aUw);
    }

    public static class b {
        public int aDe = -1;
        public int adn = -1;
        public Boolean aDf = null;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class a {
        public final String do;
        public final int aDd;

        public a(String string2, int n2) {
            this.do = string2;
            this.aDd = n2;
        }
    }
}

