/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.nativeAd;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.view.View;
import com.applovin.impl.sdk.utils.g;
import com.applovin.sdk.AppLovinSdkUtils;
import com.applovin.sdk.R;
import java.util.ArrayList;
import java.util.List;

@SuppressLint(value={"ViewConstructor"})
public class AppLovinStarRatingView
extends View {
    private static final int DEFAULT_TOTAL_NUMBER_OF_STARS = 5;
    private static final int DEFAULT_PADDING_DP = 2;
    private static final float DEFAULT_STROKE_WIDTH = 0.5f;
    private static final float SUM_OF_CENTRAL_ANGLES_IN_CIRCLE_RADIANS = (float)Math.PI * 2;
    private static final float TWELVE_OCLOCK_POSITION_RADIANS = 4.712389f;
    private static final float INTERNAL_ANGLE_OF_PENTAGON_RADIANS = 1.8849556f;
    private static final Paint emptyStarPaint = new Paint(1);
    private static final Paint filledStarPaint = new Paint(1);
    private final Double starRating;
    private float sideLength;
    private final float paddingDp;
    private final float interStarsSpacingDp;

    public AppLovinStarRatingView(Double d2, Context context) {
        super(context);
        this.starRating = d2;
        this.paddingDp = AppLovinSdkUtils.dpToPx(context, 2);
        this.interStarsSpacingDp = AppLovinSdkUtils.dpToPx(context, 2);
        this.setupPaints();
    }

    private void setupPaints() {
        emptyStarPaint.setColor(g.a(R.color.applovin_sdk_starColor, this.getContext()));
        emptyStarPaint.setStyle(Paint.Style.STROKE);
        emptyStarPaint.setStrokeWidth(0.5f);
        filledStarPaint.setColor(g.a(R.color.applovin_sdk_starColor, this.getContext()));
        filledStarPaint.setStyle(Paint.Style.FILL);
    }

    protected void onDraw(Canvas canvas) {
        if (this.starRating == null) {
            return;
        }
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        double d2 = ((double)n2 - this.getTotalHorizontalSpacing()) / 5.0;
        double d3 = (float)n3 - 2.0f * this.paddingDp;
        this.sideLength = (float)Math.min(d2, d3);
        if (this.sideLength <= 0.0f) {
            return;
        }
        Path path = this.getCombinedPathForAllStarsWithSide(this.sideLength);
        this.drawEmptyStars(canvas, path);
        this.drawFilledStars(canvas, path);
    }

    private void drawEmptyStars(Canvas canvas, Path path) {
        canvas.drawPath(path, emptyStarPaint);
    }

    private void drawFilledStars(Canvas canvas, Path path) {
        if (this.starRating == 0.0) {
            return;
        }
        float f2 = (float)this.roundUpToNearestHalfInt(this.starRating);
        float f3 = f2 / 5.0f;
        float f4 = (float)((double)this.paddingDp + Math.ceil(f2 - 1.0f) * (double)this.interStarsSpacingDp);
        canvas.clipPath(path);
        RectF rectF = new RectF(0.0f, 0.0f, f4 + f3 * 5.0f * this.sideLength, (float)this.getHeight());
        canvas.drawRect(rectF, filledStarPaint);
    }

    private Path getCombinedPathForAllStarsWithSide(float f2) {
        PointF pointF = new PointF(0.0f, this.paddingDp);
        float f3 = pointF.x + this.paddingDp;
        Path path = new Path();
        for (int i2 = 0; i2 < 5; ++i2) {
            RectF rectF = new RectF(f3, pointF.y, f3 + f2, pointF.y + f2);
            Path path2 = this.getStarPath(rectF);
            f3 += f2 + this.interStarsSpacingDp;
            path.addPath(path2);
        }
        return path;
    }

    private Path getStarPath(RectF rectF) {
        PointF pointF = new PointF(rectF.centerX(), rectF.centerY());
        float f2 = (float)((double)rectF.width() * 0.5);
        List<PointF> list = this.getStarPointsOnACircle(pointF, f2, 4.712389f);
        PointF pointF2 = list.get(0);
        PointF pointF3 = list.get(1);
        PointF pointF4 = AppLovinStarRatingView.getMidpointBetweenPoints(pointF2, pointF3);
        float f3 = AppLovinStarRatingView.getDistanceBetweenPoints(pointF2, pointF4);
        float f4 = 0.9424778f;
        float f5 = (float)((double)f3 / Math.tan(f4));
        float f6 = AppLovinStarRatingView.getDistanceBetweenPoints(pointF, pointF4) - f5;
        float f7 = 1.2566371f;
        float f8 = 4.712389f + f7 * 0.5f;
        List<PointF> list2 = this.getStarPointsOnACircle(pointF, f6, f8);
        Path path = new Path();
        path.moveTo(pointF2.x, pointF2.y);
        for (int i2 = 0; i2 < 5; ++i2) {
            PointF pointF5 = list.get(i2);
            PointF pointF6 = list2.get(i2);
            path.lineTo(pointF5.x, pointF5.y);
            path.lineTo(pointF6.x, pointF6.y);
        }
        path.close();
        return path;
    }

    private List<PointF> getStarPointsOnACircle(PointF pointF, float f2, float f3) {
        int n2 = 5;
        float f4 = (float)Math.PI * 2 / (float)n2;
        float f5 = f3;
        ArrayList<PointF> arrayList = new ArrayList<PointF>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            float f6 = (float)((double)pointF.x + (double)f2 * Math.cos(f5));
            float f7 = (float)((double)pointF.y + (double)f2 * Math.sin(f5));
            arrayList.add(new PointF(f6, f7));
            f5 += f4;
        }
        return arrayList;
    }

    private double getTotalHorizontalSpacing() {
        return 2.0f * this.paddingDp + 4.0f * this.interStarsSpacingDp;
    }

    private double roundUpToNearestHalfInt(double d2) {
        return Math.ceil(d2 * 2.0) / 2.0;
    }

    private static PointF getMidpointBetweenPoints(PointF pointF, PointF pointF2) {
        float f2 = pointF2.x - pointF.x;
        float f3 = pointF2.y - pointF.y;
        return new PointF((float)((double)pointF.x + (double)f2 * 0.5), (float)((double)pointF.y + (double)f3 * 0.5));
    }

    private static float getDistanceBetweenPoints(PointF pointF, PointF pointF2) {
        return (float)Math.sqrt(Math.pow(pointF.x - pointF2.x, 2.0) + Math.pow(pointF.y - pointF2.y, 2.0));
    }
}

