/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.StrictMode;
import android.text.TextUtils;
import android.view.InputEvent;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.adview.AppLovinAdView;
import com.applovin.impl.sdk.AppLovinError;
import com.applovin.impl.sdk.ad.AppLovinAdImpl;
import com.applovin.impl.sdk.ad.c;
import com.applovin.impl.sdk.ad.d;
import com.applovin.impl.sdk.ad.e;
import com.applovin.impl.sdk.ad.f;
import com.applovin.impl.sdk.ad.i;
import com.applovin.impl.sdk.array.ArrayService;
import com.applovin.impl.sdk.b;
import com.applovin.impl.sdk.e.m;
import com.applovin.impl.sdk.e.o;
import com.applovin.impl.sdk.e.q;
import com.applovin.impl.sdk.e.r;
import com.applovin.impl.sdk.g;
import com.applovin.impl.sdk.n;
import com.applovin.impl.sdk.network.h;
import com.applovin.impl.sdk.utils.CollectionUtils;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.s;
import com.applovin.impl.sdk.utils.u;
import com.applovin.impl.sdk.x;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdService;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinAdType;
import com.applovin.sdk.AppLovinSdkUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONObject;

public class AppLovinAdServiceImpl
implements b.a,
AppLovinAdService {
    private final n sdk;
    private final x logger;
    private final Map<d, c> als;
    private final Object alt = new Object();
    private final Map<String, String> azp = new HashMap<String, String>();
    private final AtomicReference<JSONObject> azq = new AtomicReference();

    AppLovinAdServiceImpl(n n2) {
        this.sdk = n2;
        this.logger = n2.BL();
        this.als = new HashMap<d, c>(6);
        this.als.put(d.FS(), new c());
        this.als.put(d.FT(), new c());
        this.als.put(d.FU(), new c());
        this.als.put(d.FV(), new c());
        this.als.put(d.FW(), new c());
        this.als.put(d.FX(), new c());
    }

    @Override
    public void loadNextAd(AppLovinAdSize appLovinAdSize, AppLovinAdLoadListener appLovinAdLoadListener) {
        this.a(d.a(appLovinAdSize, AppLovinAdType.REGULAR), appLovinAdLoadListener);
    }

    @Override
    public void loadNextAdForZoneId(String string2, AppLovinAdLoadListener appLovinAdLoadListener) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("No zone id specified");
        }
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.Fk()) {
            this.logger.f("AppLovinAdService", "Loading next ad of zone {" + string2 + "}");
        }
        d d2 = d.cU(string2);
        this.a(d2, appLovinAdLoadListener);
    }

    @Override
    public String getBidToken() {
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.Fk()) {
            this.logger.f("AppLovinAdService", "getBidToken()");
        }
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        String string2 = this.sdk.BT() != null ? this.sdk.BT().getBidToken() : this.sdk.BQ().getBidToken();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        if (StringUtils.isValidString(string2)) {
            AppLovinAdServiceImpl appLovinAdServiceImpl2 = this;
            if (appLovinAdServiceImpl2.logger.Fk()) {
                this.logger.f("AppLovinAdService", "Successfully retrieved bid token");
            }
        }
        return string2;
    }

    @Override
    public void loadNextAdForAdToken(String string2, AppLovinAdLoadListener appLovinAdLoadListener) {
        String string3;
        String string4 = string3 = string2 != null ? string2.trim() : null;
        if (TextUtils.isEmpty((CharSequence)string3)) {
            x.H("AppLovinAdService", "Empty ad token");
            AppLovinError appLovinError = new AppLovinError(-8, "Empty ad token");
            this.a(appLovinError, appLovinAdLoadListener);
            return;
        }
        com.applovin.impl.sdk.ad.c c2 = new com.applovin.impl.sdk.ad.c(string3, this.sdk);
        AppLovinAdLoadListener appLovinAdLoadListener2 = this.sdk.a(com.applovin.impl.sdk.c.b.aKA) != false ? new a(appLovinAdLoadListener) : appLovinAdLoadListener;
        if (c2.FN() == c.a.aGj) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.Fk()) {
                this.logger.f("AppLovinAdService", "Loading next ad for token: " + c2);
            }
            o o2 = new o(c2, appLovinAdLoadListener2, this.sdk);
            this.a(o2);
        } else if (c2.FN() == c.a.aGk) {
            JSONObject jSONObject = c2.FP();
            if (jSONObject != null) {
                com.applovin.impl.sdk.utils.i.j(jSONObject, this.sdk);
                com.applovin.impl.sdk.utils.i.i(jSONObject, this.sdk);
                com.applovin.impl.sdk.utils.i.k(jSONObject, this.sdk);
                g.o(this.sdk);
                JSONArray jSONArray = JsonUtils.getJSONArray(jSONObject, "ads", new JSONArray());
                if (jSONArray.length() > 0) {
                    AppLovinAdServiceImpl appLovinAdServiceImpl = this;
                    if (appLovinAdServiceImpl.logger.Fk()) {
                        this.logger.f("AppLovinAdService", "Rendering ad for token: " + c2);
                    }
                    d d2 = u.l(jSONObject, this.sdk);
                    r r2 = new r(jSONObject, d2, com.applovin.impl.sdk.ad.b.aGg, appLovinAdLoadListener2, this.sdk);
                    this.a(r2);
                } else {
                    AppLovinAdServiceImpl appLovinAdServiceImpl = this;
                    if (appLovinAdServiceImpl.logger.Fk()) {
                        this.logger.i("AppLovinAdService", "No ad returned from the server for token: " + c2);
                    }
                    this.a(AppLovinError.NO_FILL, appLovinAdLoadListener);
                }
            } else {
                String string5 = "Unable to retrieve ad response JSON from token: " + c2.mQ();
                AppLovinError appLovinError = new AppLovinError(-8, string5);
                x.H("AppLovinAdService", string5);
                this.a(appLovinError, appLovinAdLoadListener);
            }
        } else {
            String string6 = "Invalid token type";
            AppLovinError appLovinError = new AppLovinError(-8, "Invalid token type");
            x.H("AppLovinAdService", "Invalid token type");
            this.a(appLovinError, appLovinAdLoadListener);
        }
    }

    @Override
    public void loadNextAdForZoneIds(List<String> list, AppLovinAdLoadListener appLovinAdLoadListener) {
        List<String> list2 = CollectionUtils.removeTrimmedEmptyStrings(list);
        if (list2 == null || list2.isEmpty()) {
            x.H("AppLovinAdService", "No zones were provided");
            AppLovinError appLovinError = new AppLovinError(-7, "");
            this.b(appLovinError, appLovinAdLoadListener);
            return;
        }
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.Fk()) {
            this.logger.f("AppLovinAdService", "Loading next ad for zones: " + list2);
        }
        m m2 = new m(list2, appLovinAdLoadListener, this.sdk);
        this.a(m2);
    }

    public void loadNextIncentivizedAd(String string2, AppLovinAdLoadListener appLovinAdLoadListener) {
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.Fk()) {
            this.logger.f("AppLovinAdService", "Loading next incentivized ad of zone {" + string2 + "}");
        }
        d d2 = d.cV(string2);
        this.a(d2, appLovinAdLoadListener);
    }

    public void loadNextAd(String string2, AppLovinAdSize appLovinAdSize, AppLovinAdLoadListener appLovinAdLoadListener) {
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.Fk()) {
            this.logger.f("AppLovinAdService", "Loading next ad of zone {" + string2 + "} with size " + appLovinAdSize);
        }
        d d2 = d.a(appLovinAdSize, AppLovinAdType.REGULAR, string2);
        this.a(d2, appLovinAdLoadListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(d d2, AppLovinAdLoadListener appLovinAdLoadListener) {
        if (d2 == null) {
            throw new IllegalArgumentException("No zone specified");
        }
        if (appLovinAdLoadListener == null) {
            throw new IllegalArgumentException("No callback specified");
        }
        this.sdk.BL();
        if (x.Fk()) {
            this.sdk.BL().f("AppLovinAdService", "Loading next ad of zone {" + d2 + "}...");
        }
        c c2 = this.g(d2);
        Object object = c2.azz;
        synchronized (object) {
            c2.azC.add(appLovinAdLoadListener);
            if (!c2.azA) {
                c2.azA = true;
                b b2 = new b(d2, c2);
                this.a(d2, b2);
            } else {
                AppLovinAdServiceImpl appLovinAdServiceImpl = this;
                if (appLovinAdServiceImpl.logger.Fk()) {
                    this.logger.f("AppLovinAdService", "Already waiting on an ad load...");
                }
            }
        }
    }

    private void a(com.applovin.impl.sdk.e.d d2) {
        if (!this.sdk.isEnabled()) {
            x.F("AppLovinSdk", "Attempted to load ad before SDK initialization. Please wait until after the SDK has initialized, e.g. AppLovinSdk.initializeSdk(Context, SdkInitializationListener).");
        }
        this.sdk.Bj();
        this.sdk.BM().a(d2, q.b.aUo);
    }

    private void a(AppLovinAd appLovinAd, AppLovinAdLoadListener appLovinAdLoadListener) {
        AppLovinSdkUtils.runOnUiThread(true, () -> {
            try {
                appLovinAdLoadListener.adReceived(appLovinAd);
            }
            catch (Throwable throwable) {
                x.e("AppLovinAdService", "Unable to notify listener about a newly loaded ad", throwable);
                this.sdk.Cq().d("AppLovinAdService", "notifyAdLoadedCallback", throwable);
            }
        });
    }

    private void a(AppLovinError appLovinError, AppLovinAdLoadListener appLovinAdLoadListener) {
        if (appLovinAdLoadListener instanceof i) {
            ((i)appLovinAdLoadListener).failedToReceiveAdV2(appLovinError);
        } else {
            appLovinAdLoadListener.failedToReceiveAd(appLovinError.getCode());
        }
    }

    private void b(AppLovinError appLovinError, AppLovinAdLoadListener appLovinAdLoadListener) {
        AppLovinSdkUtils.runOnUiThread(true, () -> {
            try {
                this.a(appLovinError, appLovinAdLoadListener);
            }
            catch (Throwable throwable) {
                x.e("AppLovinAdService", "Unable to notify listener about ad load failure", throwable);
                String string2 = "notifyAdLoadFailedCallback" + (appLovinAdLoadListener instanceof i ? "V2" : "");
                this.sdk.Cq().d("AppLovinAdService", string2, throwable);
            }
        });
    }

    public AppLovinAd dequeueAd(d d2) {
        AppLovinAdImpl appLovinAdImpl = this.sdk.BY().b(d2);
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.Fk()) {
            this.logger.f("AppLovinAdService", "Dequeued ad: " + appLovinAdImpl + " for zone: " + d2 + "...");
        }
        return appLovinAdImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCustomQueryParams(Map<String, String> map) {
        Map<String, String> map2 = this.azp;
        synchronized (map2) {
            this.azp.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getAndResetCustomQueryParams() {
        Map<String, String> map;
        Map<String, String> map2 = this.azp;
        synchronized (map2) {
            map = CollectionUtils.map(this.azp);
            this.azp.clear();
        }
        return map;
    }

    public void setCustomPostBody(JSONObject jSONObject) {
        this.azq.set(jSONObject);
    }

    public JSONObject getAndResetCustomPostBody() {
        return this.azq.getAndSet(null);
    }

    public void trackAndLaunchVideoClick(final e e2, final Uri uri, MotionEvent motionEvent, @Nullable Bundle bundle, final com.applovin.impl.adview.activity.b.a a2, final Context context) {
        if (e2 == null) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.Fk()) {
                this.logger.i("AppLovinAdService", "Unable to track video click. No ad specified");
            }
            return;
        }
        if (bundle != null && Boolean.parseBoolean(bundle.getString("skip_click_tracking"))) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.Fk()) {
                this.logger.f("AppLovinAdService", "Skipping tracking for VIDEO click on an ad...");
            }
        } else {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.Fk()) {
                this.logger.f("AppLovinAdService", "Tracking VIDEO click on an ad...");
            }
            boolean bl = bundle != null && Boolean.parseBoolean(bundle.getString("install_click"));
            this.maybeSubmitPersistentPostbacks(e2.a(motionEvent, bl));
            if (this.sdk.BU() != null) {
                List<String> list = e2.d(motionEvent, true, bl);
                this.sdk.BU().a(list, (InputEvent)motionEvent);
            }
        }
        if (e2.isDirectDownloadEnabled()) {
            this.sdk.Cp().startDirectInstallOrDownloadProcess(e2, bundle, new ArrayService.DirectDownloadListener(){

                @Override
                public void onAppDetailsDisplayed() {
                    AppLovinAdServiceImpl.this.sdk.Cc().pauseForClick();
                }

                @Override
                public void onAppDetailsDismissed() {
                    AppLovinAdServiceImpl.this.sdk.Cc().resumeForClick();
                }

                @Override
                public void onFailure() {
                    AppLovinAdServiceImpl.this.logger;
                    if (x.Fk()) {
                        AppLovinAdServiceImpl.this.logger.f("AppLovinAdService", "Could not execute Direct Install/Direct Download - falling back to normal click logic");
                    }
                    AppLovinAdServiceImpl.this.a(e2, uri, a2, context);
                }
            });
        } else {
            this.a(e2, uri, a2, context);
        }
    }

    public void trackAndLaunchClick(final e e2, final AppLovinAdView appLovinAdView, final com.applovin.impl.adview.b b2, final Uri uri, @Nullable MotionEvent motionEvent, boolean bl, @Nullable Bundle bundle) {
        if (e2 == null) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.Fk()) {
                this.logger.i("AppLovinAdService", "Unable to track ad view click. No ad specified");
            }
            return;
        }
        if (bundle != null && Boolean.parseBoolean(bundle.getString("skip_click_tracking"))) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.Fk()) {
                this.logger.f("AppLovinAdService", "Skipping tracking for click on an ad...");
            }
        } else {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.Fk()) {
                this.logger.f("AppLovinAdService", "Tracking click on an ad...");
            }
            boolean bl2 = bundle != null && Boolean.parseBoolean(bundle.getString("install_click"));
            this.maybeSubmitPersistentPostbacks(e2.a(motionEvent, bl, bl2));
            if (this.sdk.BU() != null) {
                List<String> list = e2.d(motionEvent, false, bl2);
                this.sdk.BU().a(list, (InputEvent)motionEvent);
            }
        }
        if (appLovinAdView != null && uri != null) {
            if (e2.isDirectDownloadEnabled()) {
                this.sdk.Cp().startDirectInstallOrDownloadProcess(e2, bundle, new ArrayService.DirectDownloadListener(){

                    @Override
                    public void onAppDetailsDisplayed() {
                        AppLovinAdServiceImpl.this.sdk.Cc().pauseForClick();
                        if (b2 != null) {
                            b2.qX();
                            com.applovin.impl.sdk.utils.m.a(b2.qQ(), (AppLovinAd)e2, appLovinAdView);
                        }
                    }

                    @Override
                    public void onAppDetailsDismissed() {
                        if (b2 != null) {
                            AppLovinAdServiceImpl.this.sdk.Cc().resumeForClick();
                            com.applovin.impl.sdk.utils.m.b(b2.qQ(), (AppLovinAd)e2, appLovinAdView);
                        }
                    }

                    @Override
                    public void onFailure() {
                        AppLovinAdServiceImpl.this.logger;
                        if (x.Fk()) {
                            AppLovinAdServiceImpl.this.logger.f("AppLovinAdService", "Could not execute Direct Install/Direct Download - falling back to normal click logic");
                        }
                        AppLovinAdServiceImpl.this.a(e2, appLovinAdView, b2, uri);
                    }
                });
            } else {
                this.a(e2, appLovinAdView, b2, uri);
            }
        } else {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.Fk()) {
                this.logger.i("AppLovinAdService", "Unable to launch click - adView has been prematurely destroyed");
            }
        }
    }

    private void a(e e2, Uri uri, com.applovin.impl.adview.activity.b.a a2, Context context) {
        if (this.cB(uri.getScheme())) {
            this.a(uri, e2, null, a2);
        } else if (s.s(uri)) {
            this.a(uri, e2, null, null, context, this.sdk);
        } else {
            s.a(uri, context, this.sdk);
        }
    }

    private void a(e e2, AppLovinAdView appLovinAdView, com.applovin.impl.adview.b b2, Uri uri) {
        if (this.cB(uri.getScheme())) {
            this.a(uri, e2, b2, null);
        } else if (s.s(uri)) {
            this.a(uri, e2, appLovinAdView, b2, appLovinAdView.getContext(), this.sdk);
        } else {
            this.a(uri, e2, appLovinAdView, b2);
        }
    }

    public void trackImpression(e e2) {
        if (e2 == null) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.Fk()) {
                this.logger.i("AppLovinAdService", "Unable to track impression click. No ad specified");
            }
            return;
        }
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.Fk()) {
            this.logger.f("AppLovinAdService", "Tracking impression on ad...");
        }
        this.maybeSubmitPersistentPostbacks(e2.Hh());
        if (this.sdk.BU() != null) {
            this.sdk.BU().I(e2.getPrivacySandboxImpressionAttributionUrls());
        }
    }

    public void trackVideoEnd(e e2, long l2, int n2, boolean bl) {
        List<com.applovin.impl.sdk.d.a> list;
        if (e2 == null) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.Fk()) {
                this.logger.i("AppLovinAdService", "Unable to track video end. No ad specified");
            }
            return;
        }
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.Fk()) {
            this.logger.f("AppLovinAdService", "Tracking video end on ad...");
        }
        if ((list = e2.He()) != null && !list.isEmpty()) {
            String string2 = Long.toString(System.currentTimeMillis());
            for (com.applovin.impl.sdk.d.a a2 : list) {
                if (StringUtils.isValidString(a2.JI())) {
                    String string3 = this.a(a2.JI(), l2, n2, string2, bl);
                    String string4 = this.a(a2.It(), l2, n2, string2, bl);
                    if (string3 != null) {
                        com.applovin.impl.sdk.d.a a3 = new com.applovin.impl.sdk.d.a(string3, string4);
                        this.a(a3);
                        continue;
                    }
                    AppLovinAdServiceImpl appLovinAdServiceImpl2 = this;
                    if (!appLovinAdServiceImpl2.logger.Fk()) continue;
                    this.logger.i("AppLovinAdService", "Failed to parse url: " + a2.JI());
                    continue;
                }
                AppLovinAdServiceImpl appLovinAdServiceImpl3 = this;
                if (!appLovinAdServiceImpl3.logger.Fk()) continue;
                this.logger.h("AppLovinAdService", "Requested a postback dispatch for an empty video end URL; nothing to do...");
            }
        } else {
            AppLovinAdServiceImpl appLovinAdServiceImpl4 = this;
            if (appLovinAdServiceImpl4.logger.Fk()) {
                this.logger.h("AppLovinAdService", "Unable to submit persistent postback for AD #" + e2.getAdIdNumber() + ". Missing video end tracking URL.");
            }
        }
    }

    private String a(String string2, long l2, int n2, String string3, boolean bl) {
        try {
            if (StringUtils.isValidString(string2)) {
                if (n2 < 0 || n2 > 100) {
                    n2 = 0;
                }
                Uri uri = Uri.parse((String)string2);
                Uri uri2 = uri.buildUpon().appendQueryParameter("et_s", Long.toString(l2)).appendQueryParameter("pv", Integer.toString(n2)).appendQueryParameter("vid_ts", string3).appendQueryParameter("uvs", Boolean.toString(bl)).build();
                return uri2.toString();
            }
            return null;
        }
        catch (Throwable throwable) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.Fk()) {
                this.logger.c("AppLovinAdService", "Unknown error parsing the video end url: " + string2, throwable);
            }
            this.sdk.Cq().d("AppLovinAdService", "buildVideoEndUrl", throwable);
            return null;
        }
    }

    private void a(Uri uri, e e2, AppLovinAdView appLovinAdView, com.applovin.impl.adview.b b2) {
        boolean bl = s.a(uri, appLovinAdView.getContext(), this.sdk);
        if (bl) {
            com.applovin.impl.sdk.utils.m.c(b2.qQ(), (AppLovinAd)e2, appLovinAdView);
        }
        b2.qX();
    }

    private boolean cB(String string2) {
        String string3 = this.sdk.getSettings().getExtraParameters().get("forwarding_click_scheme");
        return StringUtils.isValidString(string3) && StringUtils.isValidString(string2) && string2.equalsIgnoreCase(string3);
    }

    private void a(Uri uri, e e2, com.applovin.impl.adview.b b2, com.applovin.impl.adview.activity.b.a a2) {
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.Fk()) {
            this.logger.f("AppLovinAdService", "Forwarding click " + uri);
        }
        e2.setMaxAdValue("forwarding_clicked_url", uri.toString());
        String string2 = this.sdk.getSettings().getExtraParameters().get("close_ad_on_forwarding_click_scheme");
        if (StringUtils.isValidString(string2) && Boolean.parseBoolean(string2)) {
            if (a2 != null) {
                AppLovinSdkUtils.runOnUiThread(true, () -> {
                    if (a2 != null) {
                        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
                        if (appLovinAdServiceImpl.logger.Fk()) {
                            this.logger.f("AppLovinAdService", "Dismissing ad after forwarding click");
                        }
                        a2.dismiss();
                    }
                });
            } else if (b2 != null && !u.b(e2.getSize())) {
                AppLovinAdServiceImpl appLovinAdServiceImpl2 = this;
                if (appLovinAdServiceImpl2.logger.Fk()) {
                    this.logger.f("AppLovinAdService", "Closing ad after forwarding click");
                }
                b2.qU();
            }
        }
    }

    private void a(Uri uri, e e2, @Nullable AppLovinAdView appLovinAdView, @Nullable com.applovin.impl.adview.b b2, Context context, n n2) {
        if (uri != null && StringUtils.isValidString(uri.getQuery())) {
            Uri uri2 = this.a(uri, "primaryUrl");
            List<Uri> list = this.b(uri, "primaryTrackingUrl");
            Uri uri3 = this.a(uri, "fallbackUrl");
            List<Uri> list2 = this.b(uri, "fallbackTrackingUrl");
            if (uri2 == null && uri3 == null) {
                n2.BL();
                if (x.Fk()) {
                    n2.BL().i("AppLovinAdService", "Failed to parse both primary and backup URLs for Deep Link+ command");
                }
                return;
            }
            if (!this.a(uri2, "primary", list, e2, appLovinAdView, b2, context, n2)) {
                this.a(uri3, "backup", list2, e2, appLovinAdView, b2, context, n2);
            }
            if (b2 != null) {
                b2.qX();
            }
        } else {
            n2.BL();
            if (x.Fk()) {
                n2.BL().i("AppLovinAdService", "Failed to execute Deep Link+ command - no query parameters found");
            }
        }
    }

    private boolean a(Uri uri, String string2, List<Uri> list, e e2, @Nullable AppLovinAdView appLovinAdView, @Nullable com.applovin.impl.adview.b b2, Context context, n n2) {
        boolean bl;
        n2.BL();
        if (x.Fk()) {
            n2.BL().f("AppLovinAdService", "Opening " + string2 + " URL: " + uri);
        }
        if (bl = s.a(uri, context, n2)) {
            n2.BL();
            if (x.Fk()) {
                n2.BL().f("AppLovinAdService", "URL opened successfully, dispatching tracking URLs: " + list);
            }
            for (Uri uri2 : list) {
                n2.Cr().dispatchPostbackAsync(uri2.toString(), null);
            }
            if (b2 != null) {
                com.applovin.impl.sdk.utils.m.c(b2.qQ(), (AppLovinAd)e2, appLovinAdView);
            }
        } else {
            n2.BL();
            if (x.Fk()) {
                n2.BL().i("AppLovinAdService", "URL failed to open");
            }
        }
        return bl;
    }

    @Nullable
    private Uri a(Uri uri, String string2) {
        try {
            return Uri.parse((String)uri.getQueryParameter(string2));
        }
        catch (Throwable throwable) {
            this.sdk.BL();
            if (x.Fk()) {
                this.sdk.BL().h("AppLovinAdService", "Unable to parse query parameter into Uri: " + string2);
            }
            this.sdk.Cq().d("AppLovinAdService", "buildDeepLinkPlusUrl", throwable);
            return null;
        }
    }

    private List<Uri> b(Uri uri, String string2) {
        List list = uri.getQueryParameters(string2);
        ArrayList<Uri> arrayList = new ArrayList<Uri>(list.size());
        for (String string3 : list) {
            try {
                arrayList.add(Uri.parse((String)string3));
            }
            catch (Throwable throwable) {
                this.sdk.BL();
                if (x.Fk()) {
                    this.sdk.BL().h("AppLovinAdService", "Unable to parse query parameter into Uri: " + string2);
                }
                this.sdk.Cq().d("AppLovinAdService", "buildDeepLinkPlusUrlList", throwable);
            }
        }
        return arrayList;
    }

    public void trackFullScreenAdClosed(e e2, long l2, List<Long> list, long l3, boolean bl, int n2) {
        List<com.applovin.impl.sdk.d.a> list2;
        if (e2 == null) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.Fk()) {
                this.logger.i("AppLovinAdService", "Unable to track ad closed. No ad specified.");
            }
            return;
        }
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.Fk()) {
            this.logger.f("AppLovinAdService", "Tracking ad closed...");
        }
        if ((list2 = e2.Hf()) != null && !list2.isEmpty()) {
            for (com.applovin.impl.sdk.d.a a2 : list2) {
                String string2 = this.a(a2.JI(), l2, l3, list, bl, n2);
                String string3 = this.a(a2.It(), l2, l3, list, bl, n2);
                if (StringUtils.isValidString(string2)) {
                    com.applovin.impl.sdk.d.a a3 = new com.applovin.impl.sdk.d.a(string2, string3);
                    this.a(a3);
                    continue;
                }
                AppLovinAdServiceImpl appLovinAdServiceImpl2 = this;
                if (!appLovinAdServiceImpl2.logger.Fk()) continue;
                this.logger.i("AppLovinAdService", "Failed to parse url: " + a2.JI());
            }
        } else {
            AppLovinAdServiceImpl appLovinAdServiceImpl3 = this;
            if (appLovinAdServiceImpl3.logger.Fk()) {
                this.logger.h("AppLovinAdService", "Unable to track ad closed for AD #" + e2.getAdIdNumber() + ". Missing ad close tracking URL." + e2.getAdIdNumber());
            }
        }
    }

    private String a(String string2, long l2, long l3, List<Long> list, boolean bl, int n2) {
        if (StringUtils.isValidString(string2)) {
            Uri.Builder builder = Uri.parse((String)string2).buildUpon().appendQueryParameter("et_ms", Long.toString(l2)).appendQueryParameter("vs_ms", Long.toString(l3));
            if (list != null && list.size() > 0) {
                builder.appendQueryParameter("ec_ms", list.toString());
            }
            if (n2 != com.applovin.impl.sdk.i.azY) {
                builder.appendQueryParameter("musw_ch", Boolean.toString(bl));
                builder.appendQueryParameter("musw_st", Boolean.toString(com.applovin.impl.sdk.i.gv(n2)));
            }
            return builder.build().toString();
        }
        return null;
    }

    public void trackAppKilled(e e2) {
        List<com.applovin.impl.sdk.d.a> list;
        if (e2 == null) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.Fk()) {
                this.logger.i("AppLovinAdService", "Unable to track app killed. No ad specified");
            }
            return;
        }
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.Fk()) {
            this.logger.f("AppLovinAdService", "Tracking app killed during ad...");
        }
        if ((list = e2.Hg()) != null && !list.isEmpty()) {
            for (com.applovin.impl.sdk.d.a a2 : list) {
                com.applovin.impl.sdk.d.a a3 = new com.applovin.impl.sdk.d.a(a2.JI(), a2.It());
                this.a(a3);
            }
        } else {
            AppLovinAdServiceImpl appLovinAdServiceImpl2 = this;
            if (appLovinAdServiceImpl2.logger.Fk()) {
                this.logger.h("AppLovinAdService", "Unable to track app killed during AD #" + e2.getAdIdNumber() + ". Missing app killed tracking URL.");
            }
        }
    }

    public void maybeSubmitPersistentPostbacks(List<com.applovin.impl.sdk.d.a> list) {
        if (list != null && !list.isEmpty()) {
            for (com.applovin.impl.sdk.d.a a2 : list) {
                this.a(a2);
            }
        }
    }

    private void a(com.applovin.impl.sdk.d.a a2) {
        if (StringUtils.isValidString(a2.JI())) {
            String string2 = a2.JI();
            String string3 = StringUtils.isValidString(a2.It()) ? a2.It() : null;
            this.sdk.Cs().a(h.IB().dh(string2).di(string3).o(a2.HQ()).aV(false).aY(a2.Iv()).ID());
        } else {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.Fk()) {
                this.logger.h("AppLovinAdService", "Requested a postback dispatch for a null URL; nothing to do...");
            }
        }
    }

    private void a(d d2, b b2) {
        AppLovinAdImpl appLovinAdImpl = this.sdk.BY().a(d2);
        if (appLovinAdImpl != null && !appLovinAdImpl.isExpired()) {
            AppLovinAdServiceImpl appLovinAdServiceImpl = this;
            if (appLovinAdServiceImpl.logger.Fk()) {
                this.logger.f("AppLovinAdService", "Using pre-loaded ad: " + appLovinAdImpl + " for " + d2);
            }
            b2.adReceived(appLovinAdImpl);
        } else {
            com.applovin.impl.sdk.e.n n2 = new com.applovin.impl.sdk.e.n(d2, b2, this.sdk);
            this.a(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private c g(d d2) {
        c c2;
        Object object = this.alt;
        synchronized (object) {
            c2 = this.als.get(d2);
            if (c2 == null) {
                c2 = new c();
                this.als.put(d2, c2);
            }
        }
        return c2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAdExpired(com.applovin.impl.sdk.ad.g g2) {
        AppLovinAdImpl appLovinAdImpl = (AppLovinAdImpl)g2;
        d d2 = appLovinAdImpl.getAdZone();
        AppLovinAdServiceImpl appLovinAdServiceImpl = this;
        if (appLovinAdServiceImpl.logger.Fk()) {
            this.logger.h("AppLovinAdService", "Ad expired for zone: " + d2);
        }
        this.sdk.BY().b(appLovinAdImpl);
        if (this.sdk.Bp() || !this.sdk.a(com.applovin.impl.sdk.c.b.aLZ).booleanValue()) {
            return;
        }
        c c2 = this.g(d2);
        Object object = c2.azz;
        synchronized (object) {
            if (!c2.azA) {
                this.sdk.BL();
                if (x.Fk()) {
                    this.sdk.BL().f("AppLovinAdService", "Reloading ad after expiration for zone {" + d2 + "}...");
                }
                c2.azA = true;
                c2.azB = true;
                b b2 = new b(d2, c2);
                this.a(d2, b2);
            } else {
                AppLovinAdServiceImpl appLovinAdServiceImpl2 = this;
                if (appLovinAdServiceImpl2.logger.Fk()) {
                    this.logger.f("AppLovinAdService", "Cancelled expired ad reload. Already waiting on an ad load...");
                }
            }
        }
    }

    @NonNull
    public String toString() {
        return "AppLovinAdService{adLoadStates=" + this.als + '}';
    }

    private static class c {
        final Object azz = new Object();
        boolean azA;
        int alT;
        boolean azB;
        final Collection<AppLovinAdLoadListener> azC = new HashSet<AppLovinAdLoadListener>();

        private c() {
        }

        @NonNull
        public String toString() {
            return "AdLoadState{, isWaitingForAd=" + this.azA + ", isReloadingExpiredAd=" + this.azB + ", pendingAdListeners=" + this.azC + '}';
        }
    }

    private class a
    implements i {
        private AppLovinAdLoadListener avQ;

        @Override
        public void adReceived(AppLovinAd appLovinAd) {
            if (!(appLovinAd instanceof f)) {
                AppLovinAdImpl appLovinAdImpl = (AppLovinAdImpl)appLovinAd;
                AppLovinAdServiceImpl.this.sdk.BY().a(appLovinAdImpl);
                if (appLovinAdImpl.canExpire()) {
                    AppLovinAdServiceImpl.this.sdk.BZ().a(appLovinAdImpl, AppLovinAdServiceImpl.this);
                }
                appLovinAd = new f(appLovinAdImpl.getAdZone(), AppLovinAdServiceImpl.this.sdk);
            }
            if (this.avQ != null) {
                this.avQ.adReceived(appLovinAd);
            } else if (AppLovinAdServiceImpl.this.sdk.a(com.applovin.impl.sdk.c.b.aKB).booleanValue()) {
                throw new IllegalStateException("Unable to notify listener about ad load");
            }
        }

        @Override
        public void failedToReceiveAd(int n2) {
            AppLovinError appLovinError = new AppLovinError(n2, "");
            this.failedToReceiveAdV2(appLovinError);
        }

        @Override
        public void failedToReceiveAdV2(AppLovinError appLovinError) {
            AppLovinAdServiceImpl.this.b(appLovinError, this.avQ);
            this.avQ = null;
        }

        public a(AppLovinAdLoadListener appLovinAdLoadListener) {
            this.avQ = appLovinAdLoadListener;
        }
    }

    private class b
    implements i {
        private final d azx;
        private final c azy;
        private final int alR;

        private b(d d2, c c2) {
            this.azx = d2;
            this.azy = c2;
            String string2 = AppLovinAdServiceImpl.this.sdk.getSettings().getExtraParameters().get("disable_auto_retries");
            this.alR = Boolean.parseBoolean(string2) ? -1 : AppLovinAdServiceImpl.this.sdk.a(com.applovin.impl.sdk.c.b.aKF);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void adReceived(AppLovinAd appLovinAd) {
            HashSet<AppLovinAdLoadListener> hashSet;
            if (!(appLovinAd instanceof f)) {
                hashSet = (AppLovinAdImpl)appLovinAd;
                AppLovinAdServiceImpl.this.sdk.BY().a((AppLovinAdImpl)((Object)hashSet));
                if (((AppLovinAdImpl)((Object)hashSet)).canExpire()) {
                    AppLovinAdServiceImpl.this.sdk.BZ().a((com.applovin.impl.sdk.ad.g)((Object)hashSet), AppLovinAdServiceImpl.this);
                }
                appLovinAd = new f(((AppLovinAdImpl)((Object)hashSet)).getAdZone(), AppLovinAdServiceImpl.this.sdk);
            }
            hashSet = Collections.emptySet();
            Iterator iterator = this.azy.azz;
            synchronized (iterator) {
                if (!this.azy.azB) {
                    hashSet = new HashSet<AppLovinAdLoadListener>(this.azy.azC);
                    this.azy.azC.clear();
                }
                this.azy.alT = 0;
                this.azy.azA = false;
                this.azy.azB = false;
            }
            for (AppLovinAdLoadListener appLovinAdLoadListener : hashSet) {
                AppLovinAdServiceImpl.this.a(appLovinAd, appLovinAdLoadListener);
            }
        }

        @Override
        public void failedToReceiveAd(int n2) {
            AppLovinError appLovinError = new AppLovinError(n2, "");
            this.failedToReceiveAdV2(appLovinError);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failedToReceiveAdV2(AppLovinError appLovinError) {
            Set<AppLovinAdLoadListener> set = Collections.emptySet();
            Object object = this.azy.azz;
            synchronized (object) {
                if (!AppLovinAdServiceImpl.this.sdk.b(com.applovin.impl.sdk.c.b.aKG).contains(this.azx.getSize().getLabel()) || this.azy.alT >= this.alR) {
                    set = new HashSet<AppLovinAdLoadListener>(this.azy.azC);
                    this.azy.azC.clear();
                    this.azy.alT = 0;
                    this.azy.azA = false;
                    this.azy.azB = false;
                    for (AppLovinAdLoadListener appLovinAdLoadListener : set) {
                        AppLovinAdServiceImpl.this.b(appLovinError, appLovinAdLoadListener);
                    }
                } else {
                    ++this.azy.alT;
                    int n2 = (int)Math.pow(2.0, this.azy.alT);
                    AppLovinAdServiceImpl.this.logger;
                    if (x.Fk()) {
                        AppLovinAdServiceImpl.this.logger.f("AppLovinAdService", "Failed to load ad of zone {" + this.azx.mQ() + "} with size " + this.azx.getSize() + ". Current retry attempt: " + this.azy.alT + " of " + this.alR + ". Retrying again in " + n2 + " seconds...");
                    }
                    AppLovinSdkUtils.runOnUiThreadDelayed(() -> AppLovinAdServiceImpl.this.a(this.azx, this), TimeUnit.SECONDS.toMillis(n2));
                }
            }
        }
    }
}

