/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.exoplayer2.common.base;

import com.applovin.exoplayer2.common.base.Function;
import com.applovin.exoplayer2.common.base.Preconditions;
import com.applovin.exoplayer2.common.base.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Predicates {
    private Predicates() {
    }

    public static <T> Predicate<T> alwaysTrue() {
        return g.oI.eZ();
    }

    public static <T> Predicate<T> alwaysFalse() {
        return g.oJ.eZ();
    }

    public static <T> Predicate<T> isNull() {
        return g.oK.eZ();
    }

    public static <T> Predicate<T> notNull() {
        return g.oL.eZ();
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return new f<T>(predicate);
    }

    public static <T> Predicate<T> and(Iterable<? extends Predicate<? super T>> iterable) {
        return new a(Predicates.defensiveCopy(iterable));
    }

    @SafeVarargs
    public static <T> Predicate<T> and(Predicate<? super T> ... predicateArray) {
        return new a(Predicates.defensiveCopy(predicateArray));
    }

    public static <T> Predicate<T> and(Predicate<? super T> predicate, Predicate<? super T> predicate2) {
        return new a(Predicates.asList(Preconditions.checkNotNull(predicate), Preconditions.checkNotNull(predicate2)));
    }

    public static <T> Predicate<T> or(Iterable<? extends Predicate<? super T>> iterable) {
        return new h(Predicates.defensiveCopy(iterable));
    }

    @SafeVarargs
    public static <T> Predicate<T> or(Predicate<? super T> ... predicateArray) {
        return new h(Predicates.defensiveCopy(predicateArray));
    }

    public static <T> Predicate<T> or(Predicate<? super T> predicate, Predicate<? super T> predicate2) {
        return new h(Predicates.asList(Preconditions.checkNotNull(predicate), Preconditions.checkNotNull(predicate2)));
    }

    public static <T> Predicate<T> equalTo(@NullableDecl T t2) {
        return t2 == null ? Predicates.isNull() : new e(t2);
    }

    public static Predicate<Object> instanceOf(Class<?> clazz) {
        return new d(clazz);
    }

    public static Predicate<Class<?>> subtypeOf(Class<?> clazz) {
        return new i(clazz);
    }

    public static <T> Predicate<T> in(Collection<? extends T> collection) {
        return new c(collection);
    }

    public static <A, B> Predicate<A> compose(Predicate<B> predicate, Function<A, ? extends B> function) {
        return new b(predicate, function);
    }

    private static String toStringHelper(String string2, Iterable<?> iterable) {
        StringBuilder stringBuilder = new StringBuilder("Predicates.").append(string2).append('(');
        boolean bl = true;
        for (Object obj : iterable) {
            if (!bl) {
                stringBuilder.append(',');
            }
            stringBuilder.append(obj);
            bl = false;
        }
        return stringBuilder.append(')').toString();
    }

    private static <T> List<Predicate<? super T>> asList(Predicate<? super T> predicate, Predicate<? super T> predicate2) {
        return Arrays.asList(predicate, predicate2);
    }

    private static <T> List<T> defensiveCopy(T ... TArray) {
        return Predicates.defensiveCopy(Arrays.asList(TArray));
    }

    static <T> List<T> defensiveCopy(Iterable<T> iterable) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t2 : iterable) {
            arrayList.add(Preconditions.checkNotNull(t2));
        }
        return arrayList;
    }

    private static class b<A, B>
    implements Predicate<A>,
    Serializable {
        final Predicate<B> oE;
        final Function<A, ? extends B> oF;

        private b(Predicate<B> predicate, Function<A, ? extends B> function) {
            this.oE = Preconditions.checkNotNull(predicate);
            this.oF = Preconditions.checkNotNull(function);
        }

        @Override
        public boolean apply(@NullableDecl A a2) {
            return this.oE.apply(this.oF.apply(a2));
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof b) {
                b b2 = (b)object;
                return this.oF.equals(b2.oF) && this.oE.equals(b2.oE);
            }
            return false;
        }

        public int hashCode() {
            return this.oF.hashCode() ^ this.oE.hashCode();
        }

        public String toString() {
            return this.oE + "(" + this.oF + ")";
        }
    }

    private static class c<T>
    implements Predicate<T>,
    Serializable {
        private final Collection<?> oG;

        private c(Collection<?> collection) {
            this.oG = Preconditions.checkNotNull(collection);
        }

        @Override
        public boolean apply(@NullableDecl T t2) {
            try {
                return this.oG.contains(t2);
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                return false;
            }
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof c) {
                c c2 = (c)object;
                return this.oG.equals(c2.oG);
            }
            return false;
        }

        public int hashCode() {
            return this.oG.hashCode();
        }

        public String toString() {
            return "Predicates.in(" + this.oG + ")";
        }
    }

    private static class i
    implements Predicate<Class<?>>,
    Serializable {
        private final Class<?> oH;

        private i(Class<?> clazz) {
            this.oH = Preconditions.checkNotNull(clazz);
        }

        public boolean a(Class<?> clazz) {
            return this.oH.isAssignableFrom(clazz);
        }

        public int hashCode() {
            return this.oH.hashCode();
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof i) {
                i i2 = (i)object;
                return this.oH == i2.oH;
            }
            return false;
        }

        public String toString() {
            return "Predicates.subtypeOf(" + this.oH.getName() + ")";
        }

        @Override
        public /* synthetic */ boolean apply(Object object) {
            return this.a((Class)object);
        }
    }

    private static class d
    implements Predicate<Object>,
    Serializable {
        private final Class<?> oH;

        private d(Class<?> clazz) {
            this.oH = Preconditions.checkNotNull(clazz);
        }

        @Override
        public boolean apply(@NullableDecl Object object) {
            return this.oH.isInstance(object);
        }

        public int hashCode() {
            return this.oH.hashCode();
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof d) {
                d d2 = (d)object;
                return this.oH == d2.oH;
            }
            return false;
        }

        public String toString() {
            return "Predicates.instanceOf(" + this.oH.getName() + ")";
        }
    }

    private static class e<T>
    implements Predicate<T>,
    Serializable {
        private final T ow;

        private e(T t2) {
            this.ow = t2;
        }

        @Override
        public boolean apply(T t2) {
            return this.ow.equals(t2);
        }

        public int hashCode() {
            return this.ow.hashCode();
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof e) {
                e e2 = (e)object;
                return this.ow.equals(e2.ow);
            }
            return false;
        }

        public String toString() {
            return "Predicates.equalTo(" + this.ow + ")";
        }
    }

    private static class h<T>
    implements Predicate<T>,
    Serializable {
        private final List<? extends Predicate<? super T>> oD;

        private h(List<? extends Predicate<? super T>> list) {
            this.oD = list;
        }

        @Override
        public boolean apply(@NullableDecl T t2) {
            for (int i2 = 0; i2 < this.oD.size(); ++i2) {
                if (!this.oD.get(i2).apply(t2)) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.oD.hashCode() + 87855567;
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof h) {
                h h2 = (h)object;
                return this.oD.equals(h2.oD);
            }
            return false;
        }

        public String toString() {
            return Predicates.toStringHelper("or", this.oD);
        }
    }

    private static class a<T>
    implements Predicate<T>,
    Serializable {
        private final List<? extends Predicate<? super T>> oD;

        private a(List<? extends Predicate<? super T>> list) {
            this.oD = list;
        }

        @Override
        public boolean apply(@NullableDecl T t2) {
            for (int i2 = 0; i2 < this.oD.size(); ++i2) {
                if (this.oD.get(i2).apply(t2)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.oD.hashCode() + 306654252;
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof a) {
                a a2 = (a)object;
                return this.oD.equals(a2.oD);
            }
            return false;
        }

        public String toString() {
            return Predicates.toStringHelper("and", this.oD);
        }
    }

    private static class f<T>
    implements Predicate<T>,
    Serializable {
        final Predicate<T> nP;

        f(Predicate<T> predicate) {
            this.nP = Preconditions.checkNotNull(predicate);
        }

        @Override
        public boolean apply(@NullableDecl T t2) {
            return !this.nP.apply(t2);
        }

        public int hashCode() {
            return ~this.nP.hashCode();
        }

        @Override
        public boolean equals(@NullableDecl Object object) {
            if (object instanceof f) {
                f f2 = (f)object;
                return this.nP.equals(f2.nP);
            }
            return false;
        }

        public String toString() {
            return "Predicates.not(" + this.nP + ")";
        }
    }

    static enum g implements Predicate<Object>
    {
        oI{

            @Override
            public boolean apply(@NullableDecl Object object) {
                return true;
            }

            public String toString() {
                return "Predicates.alwaysTrue()";
            }
        }
        ,
        oJ{

            @Override
            public boolean apply(@NullableDecl Object object) {
                return false;
            }

            public String toString() {
                return "Predicates.alwaysFalse()";
            }
        }
        ,
        oK{

            @Override
            public boolean apply(@NullableDecl Object object) {
                return object == null;
            }

            public String toString() {
                return "Predicates.isNull()";
            }
        }
        ,
        oL{

            @Override
            public boolean apply(@NullableDecl Object object) {
                return object != null;
            }

            public String toString() {
                return "Predicates.notNull()";
            }
        };


        <T> Predicate<T> eZ() {
            return this;
        }
    }
}

