/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import com.applovin.adview.AppLovinAdView;
import com.applovin.adview.AppLovinAdViewDisplayErrorCode;
import com.applovin.adview.AppLovinAdViewEventListener;
import com.applovin.impl.mediation.b.a.a;
import com.applovin.impl.sdk.ad.AppLovinAdImpl;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

public class NimbusMediationAdapter
extends MediationAdapterBase
implements MaxAdViewAdapter {
    private static final String ADAPTER_VERSION = "1.0.0.0";
    private static final AtomicBoolean initialized = new AtomicBoolean();
    private static a nimbusApiService;
    private static MaxAdapter.InitializationStatus status;
    private AppLovinAdView loadedAdView;

    public NimbusMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
    }

    @Override
    public String getSdkVersion() {
        return "2.0.0";
    }

    @Override
    public String getAdapterVersion() {
        return ADAPTER_VERSION;
    }

    @Override
    public void onDestroy() {
        if (this.loadedAdView != null) {
            this.loadedAdView.destroy();
            this.loadedAdView = null;
        }
    }

    @Override
    public void initialize(MaxAdapterInitializationParameters maxAdapterInitializationParameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        if (initialized.compareAndSet(false, true)) {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            try {
                String string5 = maxAdapterInitializationParameters.getServerParameters().getString("app_id", "");
                JSONObject jSONObject = new JSONObject(string5);
                string3 = JsonUtils.getString(jSONObject, "api_key", null);
                string2 = JsonUtils.getString(jSONObject, "pub_id", null);
                string4 = JsonUtils.getString(jSONObject, "base_url", null);
            }
            catch (JSONException jSONException) {
                status = MaxAdapter.InitializationStatus.INITIALIZED_FAILURE;
                onCompletionListener.onCompletion(status, "Failed to serialize app id json string.");
                return;
            }
            if (TextUtils.isEmpty((CharSequence)string3)) {
                status = MaxAdapter.InitializationStatus.INITIALIZED_FAILURE;
                onCompletionListener.onCompletion(status, "API Key cannot be null.");
                return;
            }
            status = MaxAdapter.InitializationStatus.INITIALIZING;
            nimbusApiService = new a(string3, string2, string4, this.getWrappingSdk().a());
            nimbusApiService.a(maxAdapterInitializationParameters);
            this.log("Nimbus API successfully initialized");
            status = MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS;
        } else {
            onCompletionListener.onCompletion(status, null);
        }
    }

    @Override
    public void loadAdViewAd(MaxAdapterResponseParameters maxAdapterResponseParameters, MaxAdFormat maxAdFormat, Activity activity, MaxAdViewAdapterListener maxAdViewAdapterListener) {
        if (nimbusApiService == null) {
            this.log("Nimbus Service is not initialized");
            maxAdViewAdapterListener.onAdViewAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
            return;
        }
        this.log("Loading mediated " + maxAdFormat.getLabel() + " ad: " + maxAdapterResponseParameters.getThirdPartyAdPlacementId() + "...");
        nimbusApiService.a(maxAdapterResponseParameters, maxAdFormat, new NimbusAdapterAdViewListener(this, maxAdFormat, maxAdViewAdapterListener));
    }

    protected static MaxAdapterError toMaxError(int n2) {
        MaxAdapterError maxAdapterError = n2 == -1009 ? MaxAdapterError.NO_CONNECTION : (n2 == 204 ? MaxAdapterError.NO_FILL : (n2 >= 500 ? MaxAdapterError.SERVER_ERROR : MaxAdapterError.UNSPECIFIED));
        return new MaxAdapterError(maxAdapterError.getCode(), maxAdapterError.getErrorMessage(), n2, "");
    }

    protected static Bundle getExtraInfo(AppLovinAd appLovinAd) {
        Bundle bundle = new Bundle(1);
        bundle.putBundle("ad_values", ((AppLovinAdImpl)appLovinAd).getMAXAdValues());
        return bundle;
    }

    public class NimbusAdapterAdViewListener
    implements AppLovinAdViewEventListener,
    AppLovinAdClickListener,
    AppLovinAdDisplayListener,
    AppLovinAdLoadListener {
        private final NimbusMediationAdapter parentAdapter;
        private final MaxAdFormat adFormat;
        private final MaxAdViewAdapterListener listener;

        public NimbusAdapterAdViewListener(NimbusMediationAdapter nimbusMediationAdapter2, MaxAdFormat maxAdFormat, MaxAdViewAdapterListener maxAdViewAdapterListener) {
            this.parentAdapter = nimbusMediationAdapter2;
            this.adFormat = maxAdFormat;
            this.listener = maxAdViewAdapterListener;
        }

        @Override
        public void adReceived(final AppLovinAd appLovinAd) {
            this.parentAdapter.log(this.adFormat.getLabel() + " ad loaded");
            AppLovinSdkUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    NimbusAdapterAdViewListener.this.parentAdapter.loadedAdView = new AppLovinAdView(NimbusAdapterAdViewListener.this.parentAdapter.getWrappingSdk(), appLovinAd.getSize(), NimbusAdapterAdViewListener.this.parentAdapter.getApplicationContext());
                    NimbusAdapterAdViewListener.this.parentAdapter.loadedAdView.setAdDisplayListener(NimbusAdapterAdViewListener.this);
                    NimbusAdapterAdViewListener.this.parentAdapter.loadedAdView.setAdClickListener(NimbusAdapterAdViewListener.this);
                    NimbusAdapterAdViewListener.this.parentAdapter.loadedAdView.setAdViewEventListener(NimbusAdapterAdViewListener.this);
                    NimbusAdapterAdViewListener.this.listener.onAdViewAdLoaded((View)NimbusAdapterAdViewListener.this.parentAdapter.loadedAdView);
                    NimbusAdapterAdViewListener.this.parentAdapter.loadedAdView.renderAd(appLovinAd);
                }
            });
        }

        @Override
        public void failedToReceiveAd(int n2) {
            MaxAdapterError maxAdapterError = NimbusMediationAdapter.toMaxError(n2);
            this.parentAdapter.log(this.adFormat.getLabel() + " ad failed to load with error code: " + maxAdapterError);
            this.listener.onAdViewAdLoadFailed(maxAdapterError);
        }

        @Override
        public void adDisplayed(AppLovinAd appLovinAd) {
            this.parentAdapter.log(this.adFormat.getLabel() + " ad shown");
            this.listener.onAdViewAdDisplayed();
        }

        @Override
        public void adClicked(AppLovinAd appLovinAd) {
            this.parentAdapter.log(this.adFormat.getLabel() + " ad clicked");
            this.listener.onAdViewAdClicked(NimbusMediationAdapter.getExtraInfo(appLovinAd));
        }

        @Override
        public void adHidden(AppLovinAd appLovinAd) {
            this.parentAdapter.log(this.adFormat.getLabel() + " ad hidden");
            this.listener.onAdViewAdHidden(NimbusMediationAdapter.getExtraInfo(appLovinAd));
        }

        @Override
        public void adOpenedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
            this.parentAdapter.log(this.adFormat.getLabel() + " ad expanded");
            this.listener.onAdViewAdExpanded();
        }

        @Override
        public void adClosedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
            this.parentAdapter.log(this.adFormat.getLabel() + " ad collapsed");
            this.listener.onAdViewAdCollapsed();
        }

        @Override
        public void adLeftApplication(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
            this.parentAdapter.log(this.adFormat.getLabel() + " ad left application");
        }

        @Override
        public void adFailedToDisplay(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView, AppLovinAdViewDisplayErrorCode appLovinAdViewDisplayErrorCode) {
            this.parentAdapter.log(this.adFormat.getLabel() + " failed to display with error code: " + (Object)((Object)appLovinAdViewDisplayErrorCode));
            this.listener.onAdViewAdDisplayFailed(MaxAdapterError.UNSPECIFIED);
        }
    }
}

