/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk.utils;

import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.r;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class BundleUtils {
    public static void putBoolean(Bundle bundle, String string2, @Nullable Boolean bl) {
        if (bl != null) {
            bundle.putBoolean(string2, bl.booleanValue());
        }
    }

    public static void putInt(Bundle bundle, String string2, @Nullable Integer n2) {
        if (n2 != null) {
            bundle.putInt(string2, n2.intValue());
        }
    }

    public static void putLong(Bundle bundle, String string2, @Nullable Long l2) {
        if (l2 != null) {
            bundle.putLong(string2, l2.longValue());
        }
    }

    public static void putDouble(Bundle bundle, String string2, @Nullable Double d2) {
        if (d2 != null) {
            bundle.putDouble(string2, d2.doubleValue());
        }
    }

    public static void putString(Bundle bundle, String string2, @Nullable String string3) {
        if (string3 != null) {
            bundle.putString(string2, string3);
        }
    }

    public static boolean getBoolean(String string2, Bundle bundle) {
        return BundleUtils.getBoolean(string2, false, bundle);
    }

    public static boolean getBoolean(String string2, boolean bl, Bundle bundle) {
        if (TextUtils.isEmpty((CharSequence)string2) || bundle == null || !bundle.containsKey(string2)) {
            return bl;
        }
        Object object = bundle.get(string2);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            int n2 = ((Number)object).intValue();
            return n2 != 0;
        }
        if (object instanceof String) {
            String string3 = (String)object;
            if (string3.equalsIgnoreCase("true") || string3.equalsIgnoreCase("1")) {
                return true;
            }
            if (string3.equalsIgnoreCase("false") || string3.equalsIgnoreCase("0")) {
                return false;
            }
            return bl;
        }
        return bl;
    }

    public static int getInt(String string2, Bundle bundle) {
        return BundleUtils.getInt(string2, 0, bundle);
    }

    public static int getInt(String string2, int n2, Bundle bundle) {
        if (TextUtils.isEmpty((CharSequence)string2) || bundle == null || !bundle.containsKey(string2)) {
            return n2;
        }
        Object object = bundle.get(string2);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return n2;
            }
        }
        return n2;
    }

    public static int getLong(String string2, Bundle bundle) {
        return BundleUtils.getInt(string2, 0, bundle);
    }

    public static long getLong(String string2, long l2, Bundle bundle) {
        if (TextUtils.isEmpty((CharSequence)string2) || bundle == null || !bundle.containsKey(string2)) {
            return l2;
        }
        Object object = bundle.get(string2);
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return l2;
            }
        }
        return l2;
    }

    public static String getString(String string2, Bundle bundle) {
        return BundleUtils.getString(string2, null, bundle);
    }

    public static String getString(String string2, String string3, Bundle bundle) {
        if (TextUtils.isEmpty((CharSequence)string2) || bundle == null || !bundle.containsKey(string2)) {
            return string3;
        }
        Object object = bundle.get(string2);
        if (object instanceof String) {
            return (String)object;
        }
        return String.valueOf(object);
    }

    public static Map<String, Object> toMap(Bundle bundle) {
        if (bundle == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(bundle.size());
        for (String string2 : bundle.keySet()) {
            Object object = bundle.get(string2);
            if (object == null) continue;
            if (object instanceof Bundle) {
                hashMap.put(string2, BundleUtils.toMap((Bundle)object));
                continue;
            }
            if (object instanceof Collection || object instanceof Parcelable[]) {
                List<Parcelable> list = object instanceof Collection ? (List<Parcelable>)object : Arrays.asList((Parcelable[])object);
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                for (Object e2 : list) {
                    if (e2 instanceof Bundle) {
                        arrayList.add(BundleUtils.toMap((Bundle)e2));
                        continue;
                    }
                    arrayList.add((Map<String, Object>)e2);
                }
                hashMap.put(string2, arrayList);
                continue;
            }
            hashMap.put(string2, object);
        }
        return hashMap;
    }

    public static JSONObject toJSONObject(Bundle bundle) {
        if (bundle == null) {
            return new JSONObject();
        }
        JSONObject jSONObject = new JSONObject();
        try {
            for (String string2 : bundle.keySet()) {
                Object object = bundle.get(string2);
                if (object == null) continue;
                if (object instanceof Bundle) {
                    jSONObject.put(string2, (Object)BundleUtils.toJSONObject((Bundle)object));
                    continue;
                }
                if (object instanceof Collection || object instanceof Parcelable[]) {
                    List<Parcelable> list = object instanceof Collection ? (List<Parcelable>)object : Arrays.asList((Parcelable[])object);
                    ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                    for (Object e2 : list) {
                        if (e2 instanceof Bundle) {
                            arrayList.add(BundleUtils.toMap((Bundle)e2));
                            continue;
                        }
                        arrayList.add((Map<String, Object>)e2);
                    }
                    jSONObject.put(string2, arrayList);
                    continue;
                }
                jSONObject.put(string2, object);
            }
        }
        catch (JSONException jSONException) {
            r.c("AppLovinSdk", "Failed to convert Bundle to JSONObject", jSONException);
        }
        return jSONObject;
    }

    public static boolean containsAtLeastOneKey(Bundle bundle, Set<String> set) {
        if (set == null || set.isEmpty()) {
            return false;
        }
        for (String string2 : set) {
            if (!bundle.containsKey(string2)) continue;
            return true;
        }
        return false;
    }
}

