/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.internal.data.mapper;

import com.apphud.sdk.DateTimeFormatter;
import com.apphud.sdk.domain.ApphudKind;
import com.apphud.sdk.domain.ApphudNonRenewingPurchase;
import com.apphud.sdk.domain.ApphudSubscription;
import com.apphud.sdk.domain.ApphudSubscriptionStatus;
import com.apphud.sdk.internal.data.dto.SubscriptionDto;
import java.text.ParseException;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u000f"}, d2={"Lcom/apphud/sdk/internal/data/mapper/SubscriptionMapper;", "", "<init>", "()V", "buildDate", "", "date", "", "(Ljava/lang/String;)Ljava/lang/Long;", "mapRenewable", "Lcom/apphud/sdk/domain/ApphudSubscription;", "dto", "Lcom/apphud/sdk/internal/data/dto/SubscriptionDto;", "mapNonRenewable", "Lcom/apphud/sdk/domain/ApphudNonRenewingPurchase;", "sdk_release"})
@SourceDebugExtension(value={"SMAP\nSubscriptionMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubscriptionMapper.kt\ncom/apphud/sdk/internal/data/mapper/SubscriptionMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n1#2:57\n*E\n"})
public final class SubscriptionMapper {
    private final Long buildDate(String date) {
        Long l;
        try {
            Long l2;
            String string = date;
            if (string != null) {
                String it = string;
                boolean bl = false;
                Date date2 = DateTimeFormatter.INSTANCE.getFormatter().parse(it);
                l2 = date2 != null ? Long.valueOf(date2.getTime()) : null;
            } else {
                l2 = null;
            }
            l = l2;
        }
        catch (ParseException e) {
            l = null;
        }
        return l;
    }

    @Nullable
    public final ApphudSubscription mapRenewable(@NotNull SubscriptionDto dto) {
        ApphudSubscription apphudSubscription;
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Long expires = this.buildDate(dto.getExpiresAt());
        if (expires != null) {
            ApphudSubscriptionStatus apphudSubscriptionStatus = ApphudSubscriptionStatus.Companion.map(dto.getStatus());
            String string = dto.getProductId();
            ApphudKind apphudKind = ApphudKind.Companion.map(dto.getKind());
            Long l = this.buildDate(dto.getStartedAt());
            long l2 = l != null ? l.longValue() : new Date().getTime();
            Long l3 = this.buildDate(dto.getCancelledAt());
            String string2 = dto.getOriginalTransactionId();
            boolean bl = dto.getInRetryBilling();
            boolean bl2 = dto.getIntroductoryActivated();
            boolean bl3 = dto.getAutorenewEnabled();
            String string3 = dto.getPlatform();
            String string4 = dto.getBasePlanId();
            apphudSubscription = new ApphudSubscription(apphudSubscriptionStatus, string, expires, l2, l3, string2, bl, bl3, bl2, string4, string3, "", apphudKind, false, 8192, null);
        } else {
            apphudSubscription = null;
        }
        return apphudSubscription;
    }

    @Nullable
    public final ApphudNonRenewingPurchase mapNonRenewable(@NotNull SubscriptionDto dto) {
        ApphudNonRenewingPurchase apphudNonRenewingPurchase;
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Long purchase2 = this.buildDate(dto.getStartedAt());
        if (purchase2 != null) {
            Boolean bl = dto.isConsumable();
            apphudNonRenewingPurchase = new ApphudNonRenewingPurchase(dto.getProductId(), purchase2, this.buildDate(dto.getCancelledAt()), dto.getOriginalTransactionId(), false, bl != null ? bl : false, dto.getPlatform(), 16, null);
        } else {
            apphudNonRenewingPurchase = null;
        }
        return apphudNonRenewingPurchase;
    }
}

