/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.internal.provider;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import com.apphud.sdk.ApphudExtensionsKt;
import com.apphud.sdk.ApphudInternal;
import com.apphud.sdk.ApphudLog;
import com.apphud.sdk.ApphudUtils;
import com.apphud.sdk.ContextKt;
import com.apphud.sdk.storage.Storage;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\tJ\u0006\u0010\f\u001a\u00020\tJ\u0006\u0010\r\u001a\u00020\tJ\u0006\u0010\u000e\u001a\u00020\tJ\u0006\u0010\u000f\u001a\u00020\tJ\u0006\u0010\u0010\u001a\u00020\tJ\b\u0010\u0011\u001a\u0004\u0018\u00010\tJ\b\u0010\u0012\u001a\u0004\u0018\u00010\tJ\b\u0010\u0013\u001a\u0004\u0018\u00010\tJ\u0006\u0010\u0014\u001a\u00020\tJ\u0006\u0010\u0015\u001a\u00020\tJ\u0006\u0010\u0016\u001a\u00020\u0017J\r\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001b\u001a\u00020\u0019J\u0006\u0010\u001c\u001a\u00020\u0019J\u0006\u0010\u001d\u001a\u00020\tJ\u0006\u0010\u001e\u001a\u00020\u0017J\u0006\u0010\u001f\u001a\u00020\u0017J\u000f\u0010 \u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/apphud/sdk/internal/provider/RegistrationProvider;", "", "applicationContext", "Landroid/content/Context;", "storage", "Lcom/apphud/sdk/storage/Storage;", "<init>", "(Landroid/content/Context;Lcom/apphud/sdk/storage/Storage;)V", "getLocale", "", "getSdkVersion", "getAppVersion", "getDeviceFamily", "getPlatform", "getDeviceType", "getOsVersion", "getStartAppVersion", "getIdfa", "getIdfv", "getAndroidId", "getDeviceId", "getTimeZone", "isSandbox", "", "getFirstSeen", "", "()Ljava/lang/Long;", "getSdkLaunchedAt", "getRequestTime", "getInstallSource", "getObserverMode", "getFromWeb2Web", "getInstallationDate", "Companion", "sdk_release"})
public final class RegistrationProvider {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Context applicationContext;
    @NotNull
    private final Storage storage;
    @Deprecated
    @NotNull
    public static final String PLATFORM = "Android";

    public RegistrationProvider(@NotNull Context applicationContext, @NotNull Storage storage) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.applicationContext = applicationContext;
        this.storage = storage;
    }

    @NotNull
    public final String getLocale() {
        String string = Locale.getDefault().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String getSdkVersion() {
        return "3.0.0-beta3";
    }

    @NotNull
    public final String getAppVersion() {
        return ContextKt.buildAppVersion(this.applicationContext);
    }

    @NotNull
    public final String getDeviceFamily() {
        String string = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MANUFACTURER");
        return string;
    }

    @NotNull
    public final String getPlatform() {
        return PLATFORM;
    }

    @NotNull
    public final String getDeviceType() {
        String string;
        if (ApphudUtils.INSTANCE.getOptOutOfTracking()) {
            string = "Restricted";
        } else {
            String string2 = Build.MODEL;
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MODEL");
        }
        return string;
    }

    @NotNull
    public final String getOsVersion() {
        String string = Build.VERSION.RELEASE;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RELEASE");
        return string;
    }

    @NotNull
    public final String getStartAppVersion() {
        return ContextKt.buildAppVersion(this.applicationContext);
    }

    @Nullable
    public final String getIdfa() {
        String idfa = this.storage.getDeviceIdentifiers()[0];
        return ApphudUtils.INSTANCE.getOptOutOfTracking() || ((CharSequence)idfa).length() == 0 ? null : idfa;
    }

    @Nullable
    public final String getIdfv() {
        String appSetId = this.storage.getDeviceIdentifiers()[1];
        return ApphudUtils.INSTANCE.getOptOutOfTracking() || ((CharSequence)appSetId).length() == 0 ? null : appSetId;
    }

    @Nullable
    public final String getAndroidId() {
        String androidId;
        block1: {
            androidId = null;
            androidId = this.storage.getDeviceIdentifiers()[2];
            if (!(((CharSequence)androidId).length() == 0)) break block1;
            String string = ApphudInternal.INSTANCE.fetchAndroidIdSync();
            if (string != null) {
                String it = string;
                boolean bl = false;
                androidId = it;
            }
        }
        return ApphudUtils.INSTANCE.getOptOutOfTracking() || ((CharSequence)androidId).length() == 0 ? null : androidId;
    }

    @NotNull
    public final String getDeviceId() {
        return ApphudInternal.INSTANCE.getDeviceId();
    }

    @NotNull
    public final String getTimeZone() {
        String string = TimeZone.getDefault().getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
        return string;
    }

    public final boolean isSandbox() {
        return ApphudExtensionsKt.isDebuggable(this.applicationContext);
    }

    @Nullable
    public final Long getFirstSeen() {
        return this.getInstallationDate();
    }

    public final long getSdkLaunchedAt() {
        return ApphudInternal.INSTANCE.getSdkLaunchedAt$sdk_release();
    }

    public final long getRequestTime() {
        return System.currentTimeMillis();
    }

    @NotNull
    public final String getInstallSource() {
        String string = ApphudUtils.INSTANCE.getInstallerPackageName(this.applicationContext);
        if (string == null) {
            string = "unknown";
        }
        return string;
    }

    public final boolean getObserverMode() {
        return ApphudInternal.INSTANCE.getObserverMode$sdk_release();
    }

    public final boolean getFromWeb2Web() {
        return ApphudInternal.INSTANCE.getFromWeb2Web$sdk_release();
    }

    private final Long getInstallationDate() {
        Long dateInSecond;
        block2: {
            dateInSecond = null;
            try {
                PackageManager packageManager = this.applicationContext.getPackageManager();
                if (packageManager == null) break block2;
                PackageManager manager = packageManager;
                boolean bl = false;
                dateInSecond = manager.getPackageInfo((String)this.applicationContext.getPackageName(), (int)0).firstInstallTime / 1000L;
            }
            catch (Exception ex) {
                String string = ex.getMessage();
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                ApphudLog.INSTANCE.logE(it);
            }
        }
        return dateInSecond;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/apphud/sdk/internal/provider/RegistrationProvider$Companion;", "", "<init>", "()V", "PLATFORM", "", "sdk_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

