/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.os.Build;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u0004J\u0015\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u001bR\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\rR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/apphud/sdk/ApphudUtils;", "", "()V", "<set-?>", "", "httpLogging", "getHttpLogging", "()Z", "logging", "getLogging", "optOutOfTracking", "getOptOutOfTracking", "setOptOutOfTracking", "(Z)V", "", "packageName", "getPackageName", "()Ljava/lang/String;", "enableAllLogs", "", "enableDebugLogs", "getInstallerPackageName", "context", "Landroid/content/Context;", "hasInternetConnection", "isEmulator", "setPackageName", "setPackageName$sdk_release", "sdk_release"})
public final class ApphudUtils {
    @NotNull
    public static final ApphudUtils INSTANCE = new ApphudUtils();
    @NotNull
    private static String packageName = "";
    private static boolean logging;
    private static boolean httpLogging;
    private static boolean optOutOfTracking;

    private ApphudUtils() {
    }

    @NotNull
    public final String getPackageName() {
        return packageName;
    }

    public final boolean getLogging() {
        return logging;
    }

    public final boolean getHttpLogging() {
        return httpLogging;
    }

    public final boolean getOptOutOfTracking() {
        return optOutOfTracking;
    }

    public final void setOptOutOfTracking(boolean bl) {
        optOutOfTracking = bl;
    }

    public final void enableDebugLogs() {
        logging = true;
    }

    public final void enableAllLogs() {
        logging = true;
        httpLogging = true;
    }

    public final void setPackageName$sdk_release(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        ApphudUtils.packageName = packageName;
    }

    public final boolean hasInternetConnection(@NotNull Context context) {
        Network network;
        NetworkCapabilities capabilities;
        ConnectivityManager connectivityManager;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        ConnectivityManager connectivityManager2 = connectivityManager = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
        return connectivityManager != null ? (capabilities = connectivityManager.getNetworkCapabilities(network = connectivityManager.getActiveNetwork())) != null && capabilities.hasCapability(12) && capabilities.hasCapability(16) : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEmulator() {
        String string = Build.BRAND;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BRAND");
        if (StringsKt.startsWith$default((String)string, (String)"generic", (boolean)false, (int)2, null)) {
            String string2 = Build.DEVICE;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DEVICE");
            if (StringsKt.startsWith$default((String)string2, (String)"generic", (boolean)false, (int)2, null)) return true;
        }
        String string3 = Build.FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"FINGERPRINT");
        if (StringsKt.startsWith$default((String)string3, (String)"generic", (boolean)false, (int)2, null)) return true;
        String string4 = Build.FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"FINGERPRINT");
        if (StringsKt.startsWith$default((String)string4, (String)"unknown", (boolean)false, (int)2, null)) return true;
        String string5 = Build.HARDWARE;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"HARDWARE");
        if (StringsKt.contains$default((CharSequence)string5, (CharSequence)"goldfish", (boolean)false, (int)2, null)) return true;
        String string6 = Build.HARDWARE;
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"HARDWARE");
        if (StringsKt.contains$default((CharSequence)string6, (CharSequence)"ranchu", (boolean)false, (int)2, null)) return true;
        String string7 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"MODEL");
        if (StringsKt.contains$default((CharSequence)string7, (CharSequence)"google_sdk", (boolean)false, (int)2, null)) return true;
        String string8 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"MODEL");
        if (StringsKt.contains$default((CharSequence)string8, (CharSequence)"Emulator", (boolean)false, (int)2, null)) return true;
        String string9 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"MODEL");
        if (StringsKt.contains$default((CharSequence)string9, (CharSequence)"Android SDK built for x86", (boolean)false, (int)2, null)) return true;
        String string10 = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"MANUFACTURER");
        if (StringsKt.contains$default((CharSequence)string10, (CharSequence)"Genymotion", (boolean)false, (int)2, null)) return true;
        String string11 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string11, (CharSequence)"sdk_google", (boolean)false, (int)2, null)) return true;
        String string12 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string12, (CharSequence)"google_sdk", (boolean)false, (int)2, null)) return true;
        String string13 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string13, (CharSequence)"sdk", (boolean)false, (int)2, null)) return true;
        String string14 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string14, (CharSequence)"sdk_x86", (boolean)false, (int)2, null)) return true;
        String string15 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string15, (CharSequence)"sdk_gphone64_arm64", (boolean)false, (int)2, null)) return true;
        String string16 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string16, (CharSequence)"vbox86p", (boolean)false, (int)2, null)) return true;
        String string17 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"PRODUCT");
        if (StringsKt.contains$default((CharSequence)string17, (CharSequence)"emulator", (boolean)false, (int)2, null)) return true;
        String string18 = Build.PRODUCT;
        Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"PRODUCT");
        if (!StringsKt.contains$default((CharSequence)string18, (CharSequence)"simulator", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @Nullable
    public final String getInstallerPackageName(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            boolean bl = false;
            if (Build.VERSION.SDK_INT >= 30) {
                return context.getPackageManager().getInstallSourceInfo(packageName).getInstallingPackageName();
            }
            return context.getPackageManager().getInstallerPackageName(packageName);
        }
        catch (Throwable throwable) {
            Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            return null;
        }
    }
}

