/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.mappers;

import com.apphud.sdk.DateTimeFormatter;
import com.apphud.sdk.client.dto.SubscriptionDto;
import com.apphud.sdk.domain.ApphudKind;
import com.apphud.sdk.domain.ApphudNonRenewingPurchase;
import com.apphud.sdk.domain.ApphudSubscription;
import com.apphud.sdk.domain.ApphudSubscriptionStatus;
import java.text.ParseException;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u000e"}, d2={"Lcom/apphud/sdk/mappers/SubscriptionMapper;", "", "()V", "buildDate", "", "date", "", "(Ljava/lang/String;)Ljava/lang/Long;", "mapNonRenewable", "Lcom/apphud/sdk/domain/ApphudNonRenewingPurchase;", "dto", "Lcom/apphud/sdk/client/dto/SubscriptionDto;", "mapRenewable", "Lcom/apphud/sdk/domain/ApphudSubscription;", "sdk_release"})
@SourceDebugExtension(value={"SMAP\nSubscriptionMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubscriptionMapper.kt\ncom/apphud/sdk/mappers/SubscriptionMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1#2:48\n*E\n"})
public final class SubscriptionMapper {
    private final Long buildDate(String date) {
        Long l;
        try {
            Long l2;
            String string = date;
            if (string != null) {
                String it = string;
                boolean bl = false;
                Date date2 = DateTimeFormatter.INSTANCE.getFormatter().parse(it);
                l2 = date2 != null ? Long.valueOf(date2.getTime()) : null;
            } else {
                l2 = null;
            }
            l = l2;
        }
        catch (ParseException e) {
            l = null;
        }
        return l;
    }

    @Nullable
    public final ApphudSubscription mapRenewable(@NotNull SubscriptionDto dto) {
        ApphudSubscription apphudSubscription;
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Long expires = this.buildDate(dto.getExpires_at());
        if (expires != null) {
            ApphudSubscriptionStatus apphudSubscriptionStatus = ApphudSubscriptionStatus.Companion.map(dto.getStatus());
            String string = dto.getProduct_id();
            ApphudKind apphudKind = ApphudKind.Companion.map(dto.getKind());
            Long l = this.buildDate(dto.getStarted_at());
            long l2 = l != null ? l.longValue() : new Date().getTime();
            Long l3 = this.buildDate(dto.getCancelled_at());
            boolean bl = dto.getIn_retry_billing();
            boolean bl2 = dto.getIntroductory_activated();
            boolean bl3 = dto.getAutorenew_enabled();
            apphudSubscription = new ApphudSubscription(apphudSubscriptionStatus, string, expires, l2, l3, bl, bl3, bl2, apphudKind, "", false, 1024, null);
        } else {
            apphudSubscription = null;
        }
        return apphudSubscription;
    }

    @Nullable
    public final ApphudNonRenewingPurchase mapNonRenewable(@NotNull SubscriptionDto dto) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Long purchase2 = this.buildDate(dto.getStarted_at());
        return purchase2 != null ? new ApphudNonRenewingPurchase(dto.getProduct_id(), purchase2, this.buildDate(dto.getCancelled_at()), false, 8, null) : null;
    }
}

