/*
 * Decompiled with CFR 0.152.
 */
package com.app.infideap.stylishwidget.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import com.app.infideap.stylishwidget.Log;
import java.util.ArrayList;

public class ARadioGroup
extends RadioGroup {
    private static final String TAG = ARadioGroup.class.getSimpleName();
    private ArrayList<RadioButton> radioButtons;
    private RadioGroup.OnCheckedChangeListener listener;
    private RadioButton selected;
    private int selectedId;
    private boolean trigger;

    public ARadioGroup(Context context) {
        super(context);
        this.init(context, null);
    }

    public ARadioGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.radioButtons = new ArrayList();
        this.search(context, (ViewGroup)this);
        Log.d(TAG, "Size : " + this.radioButtons.size() + ", " + this.getChildCount());
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
        Log.d(TAG, "addView");
        this.search(this.getContext(), child);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        Log.d(TAG, "onLayout() : " + this.selected);
        this.trigger = false;
        if (this.selected != null) {
            this.selected.setChecked(true);
        }
        this.trigger = true;
    }

    private void search(Context context, View view) {
        if (view instanceof RadioButton) {
            final RadioButton radioButton = (RadioButton)view;
            radioButton.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    if (isChecked) {
                        ARadioGroup.this.clearCheck(radioButton);
                        ARadioGroup.this.selected = radioButton;
                        if (ARadioGroup.this.trigger) {
                            ARadioGroup.this.listener.onCheckedChanged((RadioGroup)ARadioGroup.this, buttonView.getId());
                        }
                    }
                }
            });
            this.radioButtons.add(radioButton);
        } else if (view instanceof ViewGroup) {
            this.search(context, (ViewGroup)view);
        }
    }

    private void search(Context context, ViewGroup viewGroup) {
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View view = viewGroup.getChildAt(i);
            this.search(context, view);
        }
    }

    private void clearCheck(RadioButton radioButton) {
        for (RadioButton _radioButton : this.radioButtons) {
            if (radioButton == _radioButton) continue;
            _radioButton.setChecked(false);
        }
    }

    public void clearCheck() {
        for (RadioButton radioButton : this.radioButtons) {
            radioButton.setChecked(false);
        }
    }

    public void setOnCheckedChangeListener(RadioGroup.OnCheckedChangeListener listener) {
        this.listener = listener;
        super.setOnCheckedChangeListener(listener);
    }

    public RadioButton getSelected() {
        return this.selected;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View view, MotionEvent motionEvent) {
                    return true;
                }
            });
        } else {
            this.setOnTouchListener(null);
        }
    }
}

