/*
 * Decompiled with CFR 0.152.
 */
package com.app.infideap.stylishwidget.view;

import android.annotation.SuppressLint;
import android.app.DatePickerDialog;
import android.app.TimePickerDialog;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.v7.appcompat.R;
import android.support.v7.widget.AppCompatEditText;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.DatePicker;
import android.widget.TextView;
import android.widget.TimePicker;
import com.app.infideap.stylishwidget.Log;
import com.app.infideap.stylishwidget.view.Stylish;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class AEditText
extends AppCompatEditText {
    private Calendar calendar;
    private boolean is24Hours;
    private java.text.DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
    private java.text.DateFormat timeFormat = new SimpleDateFormat("hh:mm a", Locale.getDefault());
    private DatePickerDialog datePicker;
    private TimePickerDialog timePicker;

    public AEditText(Context context) {
        super(context);
        this.setCustomTypeface(context, null);
    }

    public AEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setCustomTypeface(context, attrs);
    }

    public AEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setCustomTypeface(context, attrs);
    }

    @SuppressLint(value={"PrivateResource", "CustomViewStyleable"})
    private void setCustomTypeface(Context context, AttributeSet attrs) {
        this.is24Hours = DateFormat.is24HourFormat((Context)this.getContext());
        if (this.isInEditMode()) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TextAppearance);
        int style = a.getInt(R.styleable.TextAppearance_android_textStyle, 0);
        this.setTextStyle(style);
        a.recycle();
    }

    public void setTextStyle(int style) {
        Stylish.getInstance().setTextStyle((TextView)this, style);
    }

    public void setSupportTextAppearance(int resId) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.setTextAppearance(resId);
        } else {
            this.setTextAppearance(this.getContext(), resId);
        }
    }

    public void setRawInputType(int type) {
        Log.e(((Object)((Object)this)).getClass().getSimpleName(), "Type : " + type);
        switch (type) {
            case 36: {
                this.setupTimePicker();
                break;
            }
            case 20: {
                this.setupDatePicker();
                break;
            }
            case 4: {
                this.setupDateTimePicker();
                break;
            }
            default: {
                this.calendar = null;
                super.setRawInputType(type);
            }
        }
    }

    private void setupDateTimePicker() {
        this.calendar = Calendar.getInstance();
        this.disableInput();
        this.createDatePicker(true);
        this.createTimePicker(true);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AEditText.this.setError(null);
                AEditText.this.showDatePicker();
                AEditText.this.hideKeyboard(view);
            }
        });
        this.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean b) {
                if (b) {
                    AEditText.this.performClick();
                }
            }
        });
    }

    private void setupDatePicker() {
        this.calendar = Calendar.getInstance();
        this.disableInput();
        this.createDatePicker(false);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AEditText.this.setError(null);
                AEditText.this.showDatePicker();
                AEditText.this.hideKeyboard(view);
            }
        });
        this.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean b) {
                if (b) {
                    AEditText.this.performClick();
                }
            }
        });
    }

    private void setupTimePicker() {
        this.calendar = Calendar.getInstance();
        this.disableInput();
        this.createTimePicker(false);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AEditText.this.setError(null);
                AEditText.this.showTimePicker();
                AEditText.this.hideKeyboard(view);
            }
        });
        this.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean b) {
                if (b) {
                    AEditText.this.performClick();
                }
            }
        });
    }

    private void createDatePicker(final boolean isDateTime) {
        this.datePicker = new DatePickerDialog(this.getContext(), new DatePickerDialog.OnDateSetListener(){

            public void onDateSet(DatePicker datePicker, int year, int month, int day) {
                AEditText.this.calendar.set(year, month, day);
                if (isDateTime) {
                    AEditText.this.showTimePicker();
                } else {
                    AEditText.this.displayDate();
                }
            }
        }, this.calendar.get(1), this.calendar.get(2), this.calendar.get(5));
    }

    public void createTimePicker(final boolean isDateTimePicker) {
        this.timePicker = new TimePickerDialog(this.getContext(), new TimePickerDialog.OnTimeSetListener(){

            public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
                AEditText.this.calendar.set(11, hourOfDay);
                AEditText.this.calendar.set(12, minute);
                if (isDateTimePicker) {
                    AEditText.this.displayDateTime();
                } else {
                    AEditText.this.displayTime();
                }
            }
        }, this.calendar.get(11), this.calendar.get(12), this.is24Hours);
    }

    public void hideKeyboard(View view) {
        InputMethodManager imm;
        if (view != null && (imm = (InputMethodManager)this.getContext().getSystemService("input_method")) != null) {
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public void showKeyboard(View view) {
        InputMethodManager imm;
        if (view != null && (imm = (InputMethodManager)this.getContext().getSystemService("input_method")) != null) {
            imm.showSoftInputFromInputMethod(view.getWindowToken(), 0);
        }
    }

    private void showDatePicker() {
        this.datePicker.show();
    }

    private void showTimePicker() {
        this.timePicker.show();
    }

    @SuppressLint(value={"SetTextI18n"})
    private void displayDateTime() {
        this.setText(this.dateFormat.format(this.calendar.getTime()) + " " + this.timeFormat.format(this.calendar.getTime()));
    }

    private void displayDate() {
        this.setText(this.dateFormat.format(this.calendar.getTime()));
    }

    private void displayTime() {
        this.setText(this.timeFormat.format(this.calendar.getTime()));
    }

    private void disableInput() {
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setDateFormat(java.text.DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setTimeFormat(java.text.DateFormat timeFormat) {
        this.timeFormat = timeFormat;
    }
}

