/*
 * Decompiled with CFR 0.152.
 */
package com.app.infideap.stylishwidget.util;

import android.widget.TextView;
import java.util.Locale;

public class TextViewUtils {
    private static final String TAG = TextViewUtils.class.getSimpleName();
    private static TextViewUtils instance = new TextViewUtils();

    public static TextViewUtils getInstance() {
        return instance;
    }

    public Thread printIncrement(TextView textView, long endNumber, long millis) {
        return this.printIncrement(textView, 0L, endNumber, millis);
    }

    public Thread printIncrement(TextView textView, long startNumber, long endNumber, long millis) {
        return this.printIncrement(textView, "%d", startNumber, endNumber, millis);
    }

    public Thread printIncrement(TextView textView, String format, long endNumber, long millis) {
        return this.printIncrement(textView, Locale.getDefault(), format, endNumber, millis);
    }

    public Thread printIncrement(TextView textView, String format, long startNumber, long endNumber, long millis) {
        return this.printIncrement(textView, Locale.getDefault(), format, startNumber, endNumber, millis);
    }

    public Thread printIncrement(TextView textView, Locale locale, String format, long endNumber, long millis) {
        return this.printIncrement(textView, locale, format, 0L, endNumber, millis);
    }

    public Thread printIncrement(TextView textView, Locale locale, String format, long startNumber, long endNumber, long millis) {
        final Thread thread = this.printIncrementPostDelayed(textView, locale, format, startNumber, endNumber, millis);
        textView.post(new Runnable(){

            @Override
            public void run() {
                thread.start();
            }
        });
        return thread;
    }

    private Thread printIncrementPostDelayed(final TextView textView, final Locale locale, final String format, final long startNumber, final long endNumber, final long millis) {
        return new Thread(){

            @Override
            public void run() {
                try {
                    long increment;
                    long end;
                    long start;
                    if (startNumber > endNumber) {
                        start = endNumber;
                        end = startNumber;
                    } else {
                        start = startNumber;
                        end = endNumber;
                    }
                    long counter = start;
                    double delayDuration = (double)millis / (double)(end - start);
                    if (delayDuration < 1.0) {
                        increment = (long)Math.ceil(1.0 / delayDuration);
                        delayDuration *= (double)increment;
                    } else {
                        increment = 1L;
                    }
                    TextViewUtils.this.displayText(textView, locale, format, startNumber < endNumber ? counter : startNumber - (counter - start));
                    while (counter < end) {
                        2.sleep((long)delayDuration);
                        counter = (counter += increment) > end ? end : counter;
                        TextViewUtils.this.displayText(textView, locale, format, startNumber < endNumber ? counter : startNumber - (counter - start));
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    private void displayText(final TextView textView, Locale locale, String format, long counter) {
        final String displayText = this.getString(locale, format, counter);
        textView.post(new Runnable(){

            @Override
            public void run() {
                textView.setText((CharSequence)displayText);
            }
        });
    }

    private String getString(Locale locale, String format, long counter) {
        return String.format(locale, format, counter);
    }
}

