/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.subscription.webflux;

import com.apollographql.subscription.callback.SubscriptionCallback;
import com.apollographql.subscription.callback.SubscriptionCallbackHandler;
import graphql.ExecutionResult;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.graphql.server.WebGraphQlHandler;
import org.springframework.graphql.server.WebGraphQlRequest;
import org.springframework.graphql.server.webflux.GraphQlHttpHandler;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

public class CallbackGraphQlHttpHandler
extends GraphQlHttpHandler {
    private static final Log logger = LogFactory.getLog(GraphQlHttpHandler.class);
    private static final ParameterizedTypeReference<Map<String, Object>> MAP_PARAMETERIZED_TYPE_REF = new ParameterizedTypeReference<Map<String, Object>>(){};
    private static final MediaType APPLICATION_GRAPHQL_RESPONSE = MediaType.APPLICATION_GRAPHQL_RESPONSE;
    private static final List<MediaType> SUPPORTED_MEDIA_TYPES = Arrays.asList(APPLICATION_GRAPHQL_RESPONSE, MediaType.APPLICATION_JSON, MediaType.APPLICATION_GRAPHQL);
    private final WebGraphQlHandler graphQlHandler;
    private final SubscriptionCallbackHandler subscriptionCallbackHandler;

    public CallbackGraphQlHttpHandler(WebGraphQlHandler graphQlHandler) {
        this(graphQlHandler, new SubscriptionCallbackHandler(graphQlHandler));
    }

    public CallbackGraphQlHttpHandler(WebGraphQlHandler graphQlHandler, SubscriptionCallbackHandler subscriptionCallbackHandler) {
        super(graphQlHandler);
        this.graphQlHandler = graphQlHandler;
        this.subscriptionCallbackHandler = subscriptionCallbackHandler;
    }

    @NotNull
    public Mono<ServerResponse> handleRequest(@NotNull ServerRequest serverRequest) {
        return serverRequest.bodyToMono(MAP_PARAMETERIZED_TYPE_REF).map(body -> new WebGraphQlRequest(serverRequest.uri(), serverRequest.headers().asHttpHeaders(), serverRequest.cookies(), serverRequest.attributes(), body, serverRequest.exchange().getRequest().getId(), serverRequest.exchange().getLocaleContext().getLocale())).flatMap(graphQlRequest -> {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing: " + graphQlRequest));
            }
            if (graphQlRequest.getDocument().startsWith("subscription")) {
                return SubscriptionCallback.parseSubscriptionCallbackExtension(graphQlRequest.getExtensions()).flatMap(callback -> {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Starting subscription using callback: " + callback));
                    }
                    return this.subscriptionCallbackHandler.handleSubscriptionUsingCallback((WebGraphQlRequest)graphQlRequest, (SubscriptionCallback)callback).flatMap(success -> {
                        if (success.booleanValue()) {
                            ExecutionResult emptyResponse = ExecutionResult.newExecutionResult().data(null).build();
                            ServerResponse.BodyBuilder builder = ServerResponse.ok();
                            builder.header("subscription-protocol", new String[]{"callback/1.0"});
                            builder.contentType(CallbackGraphQlHttpHandler.selectResponseMediaType(serverRequest));
                            return builder.bodyValue((Object)emptyResponse.toSpecification());
                        }
                        return ServerResponse.badRequest().build();
                    });
                }).onErrorResume(error -> {
                    if (logger.isErrorEnabled()) {
                        logger.error((Object)"Unable to start subscription using callback protocol", error);
                    }
                    return ServerResponse.badRequest().build();
                });
            }
            return this.graphQlHandler.handleRequest(graphQlRequest).flatMap(response -> {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Execution complete");
                }
                ServerResponse.BodyBuilder builder = ServerResponse.ok();
                builder.headers(headers -> headers.putAll((Map)response.getResponseHeaders()));
                builder.contentType(CallbackGraphQlHttpHandler.selectResponseMediaType(serverRequest));
                return builder.bodyValue((Object)response.toMap());
            });
        });
    }

    private static MediaType selectResponseMediaType(ServerRequest serverRequest) {
        for (MediaType accepted : serverRequest.headers().accept()) {
            if (!SUPPORTED_MEDIA_TYPES.contains(accepted)) continue;
            return accepted;
        }
        return MediaType.APPLICATION_JSON;
    }
}

