/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.subscription.callback;

import com.apollographql.subscription.exception.CallbackExtensionNotSpecifiedException;
import com.apollographql.subscription.exception.InvalidCallbackExtensionException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Mono;

public record SubscriptionCallback(@NotNull String callback_url, @NotNull String subscription_id, @NotNull String verifier) {
    @NotNull
    public static Mono<SubscriptionCallback> parseSubscriptionCallbackExtension(@NotNull Map<String, Object> extensions) {
        Object subscription_extension = extensions.get("subscription");
        if (subscription_extension instanceof Map) {
            Map subscription = (Map)subscription_extension;
            Object callback_url = subscription.get("callback_url");
            Object subscription_id = subscription.get("subscription_id");
            Object verifier = subscription.get("verifier");
            if (callback_url != null && subscription_id != null && verifier != null) {
                return Mono.just((Object)new SubscriptionCallback((String)callback_url, (String)subscription_id, (String)verifier));
            }
            return Mono.error((Throwable)new InvalidCallbackExtensionException(subscription));
        }
        return Mono.error((Throwable)new CallbackExtensionNotSpecifiedException());
    }
}

