/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.federation.graphqljava;

import com.apollographql.federation.graphqljava._FieldSet;
import com.apollographql.federation.graphqljava.exceptions.UnsupportedFederationVersionException;
import graphql.PublicApi;
import graphql.introspection.Introspection;
import graphql.language.DirectiveDefinition;
import graphql.language.DirectiveLocation;
import graphql.language.Document;
import graphql.language.InputValueDefinition;
import graphql.language.NonNullType;
import graphql.language.SDLNamedDefinition;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.parser.Parser;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@PublicApi
public final class FederationDirectives {
    private static final DirectiveLocation DL_OBJECT = DirectiveLocation.newDirectiveLocation().name("OBJECT").build();
    private static final DirectiveLocation DL_INTERFACE = DirectiveLocation.newDirectiveLocation().name("INTERFACE").build();
    private static final DirectiveLocation DL_FIELD_DEFINITION = DirectiveLocation.newDirectiveLocation().name("FIELD_DEFINITION").build();
    public static final String fieldsArgumentName = "fields";
    private static final GraphQLArgument fieldsArgument = GraphQLArgument.newArgument().name("fields").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)_FieldSet.type)).build();
    private static final InputValueDefinition fieldsDefinition = InputValueDefinition.newInputValueDefinition().name("fields").type((Type)new NonNullType((Type)new TypeName("_FieldSet"))).build();
    public static final String keyName = "key";
    public static final GraphQLDirective key = GraphQLDirective.newDirective().name("key").validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.OBJECT, Introspection.DirectiveLocation.INTERFACE}).argument(fieldsArgument).repeatable(true).build();
    public static final DirectiveDefinition keyDefinitionFed1 = DirectiveDefinition.newDirectiveDefinition().name("key").directiveLocations(Arrays.asList(DL_OBJECT, DL_INTERFACE)).inputValueDefinition(fieldsDefinition).repeatable(true).build();
    public static final String externalName = "external";
    public static final GraphQLDirective external = GraphQLDirective.newDirective().name("external").validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.FIELD_DEFINITION}).build();
    public static final DirectiveDefinition externalDefinition = DirectiveDefinition.newDirectiveDefinition().name("external").directiveLocations(Collections.singletonList(DL_FIELD_DEFINITION)).build();
    public static final String requiresName = "requires";
    public static final GraphQLDirective requires = GraphQLDirective.newDirective().name("requires").validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.FIELD_DEFINITION}).argument(fieldsArgument).build();
    public static final DirectiveDefinition requiresDefinition = DirectiveDefinition.newDirectiveDefinition().name("requires").directiveLocations(Collections.singletonList(DL_FIELD_DEFINITION)).inputValueDefinition(fieldsDefinition).build();
    public static final String providesName = "provides";
    public static final GraphQLDirective provides = GraphQLDirective.newDirective().name("provides").validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.FIELD_DEFINITION}).argument(fieldsArgument).build();
    public static final DirectiveDefinition providesDefinition = DirectiveDefinition.newDirectiveDefinition().name("provides").directiveLocations(Collections.singletonList(DL_FIELD_DEFINITION)).inputValueDefinition(fieldsDefinition).build();
    public static final String extendsName = "extends";
    public static final GraphQLDirective extends_ = GraphQLDirective.newDirective().name("extends").validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.OBJECT, Introspection.DirectiveLocation.INTERFACE}).build();
    public static final DirectiveDefinition extendsDefinition = DirectiveDefinition.newDirectiveDefinition().name("extends").directiveLocations(Arrays.asList(DL_OBJECT, DL_INTERFACE)).build();
    public static final Set<String> allNames;
    public static final Set<GraphQLDirective> allDirectives;
    public static final Set<DirectiveDefinition> allDefinitions;
    @Deprecated
    static final List<SDLNamedDefinition> federation2Definitions;
    public static final Set<DirectiveDefinition> federation1DirectiveDefinitions;

    private static GraphQLArgument fieldsArgument(String value) {
        return GraphQLArgument.newArgument((GraphQLArgument)fieldsArgument).value((Object)value).build();
    }

    public static GraphQLDirective key(String fields) {
        return GraphQLDirective.newDirective((GraphQLDirective)key).argument(FederationDirectives.fieldsArgument(fields)).build();
    }

    public static GraphQLDirective requires(String fields) {
        return GraphQLDirective.newDirective((GraphQLDirective)requires).argument(FederationDirectives.fieldsArgument(fields)).build();
    }

    public static GraphQLDirective provides(String fields) {
        return GraphQLDirective.newDirective((GraphQLDirective)provides).argument(FederationDirectives.fieldsArgument(fields)).build();
    }

    private FederationDirectives() {
    }

    public static List<SDLNamedDefinition> loadFederationSpecDefinitions(String federationSpec) {
        switch (federationSpec) {
            case "https://specs.apollo.dev/federation/v2.0": {
                return FederationDirectives.loadFed2Definitions("definitions_fed2_0.graphqls");
            }
            case "https://specs.apollo.dev/federation/v2.1": {
                return FederationDirectives.loadFed2Definitions("definitions_fed2_1.graphqls");
            }
            case "https://specs.apollo.dev/federation/v2.2": {
                return FederationDirectives.loadFed2Definitions("definitions_fed2_2.graphqls");
            }
            case "https://specs.apollo.dev/federation/v2.3": {
                return FederationDirectives.loadFed2Definitions("definitions_fed2_3.graphqls");
            }
        }
        throw new UnsupportedFederationVersionException(federationSpec);
    }

    private static List<SDLNamedDefinition> loadFed2Definitions(String fileName) {
        InputStream inputStream = FederationDirectives.class.getClassLoader().getResourceAsStream(fileName);
        if (inputStream != null) {
            List<SDLNamedDefinition> list;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            try {
                Document document = new Parser().parseDocument((Reader)reader);
                list = document.getDefinitionsOfType(SDLNamedDefinition.class).stream().sorted(Comparator.comparing(SDLNamedDefinition::getName)).collect(Collectors.toList());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to load federation directive definitions from " + fileName);
                }
            }
            reader.close();
            return list;
        }
        throw new RuntimeException("Unable to load federation directive definitions from " + fileName);
    }

    static {
        federation2Definitions = FederationDirectives.loadFederationSpecDefinitions("https://specs.apollo.dev/federation/v2.0");
        allDirectives = Stream.of(key, external, requires, provides, extends_).sorted(Comparator.comparing(GraphQLDirective::getName)).collect(Collectors.toCollection(LinkedHashSet::new));
        allDefinitions = Stream.of(keyDefinitionFed1, externalDefinition, requiresDefinition, providesDefinition, extendsDefinition).sorted(Comparator.comparing(DirectiveDefinition::getName)).collect(Collectors.toCollection(LinkedHashSet::new));
        allNames = allDefinitions.stream().map(DirectiveDefinition::getName).collect(Collectors.toCollection(LinkedHashSet::new));
        federation1DirectiveDefinitions = Stream.of(keyDefinitionFed1, externalDefinition, requiresDefinition, providesDefinition, extendsDefinition).sorted(Comparator.comparing(DirectiveDefinition::getName)).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

