/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.federation.graphqljava;

import com.apollographql.federation.graphqljava.FederationDirectives;
import com.apollographql.federation.graphqljava.LinkImportsRenamingVisitor;
import com.apollographql.federation.graphqljava.SchemaTransformer;
import com.apollographql.federation.graphqljava._Any;
import com.apollographql.federation.graphqljava._FieldSet;
import com.apollographql.federation.graphqljava.exceptions.UnsupportedLinkImportException;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.AstTransformer;
import graphql.language.Directive;
import graphql.language.FieldDefinition;
import graphql.language.Node;
import graphql.language.NodeVisitor;
import graphql.language.ObjectField;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectValue;
import graphql.language.SDLDefinition;
import graphql.language.SDLNamedDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.Value;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.File;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Federation {
    private static final SchemaGenerator.Options generatorOptions = SchemaGenerator.Options.defaultOptions();

    private Federation() {
    }

    @NotNull
    public static SchemaTransformer transform(GraphQLSchema schema) {
        return new SchemaTransformer(schema, false);
    }

    @NotNull
    public static SchemaTransformer transform(GraphQLSchema schema, boolean queryTypeShouldBeEmpty) {
        return new SchemaTransformer(schema, queryTypeShouldBeEmpty);
    }

    public static SchemaTransformer transform(TypeDefinitionRegistry typeRegistry, RuntimeWiring runtimeWiring) {
        boolean queryTypeShouldBeEmpty = Federation.ensureQueryTypeExists(typeRegistry);
        @Nullable Map<String, String> fed2Imports = Federation.fed2DirectiveImports(typeRegistry);
        RuntimeWiring newRuntimeWiring = fed2Imports != null ? Federation.ensureFederationV2DirectiveDefinitionsExist(typeRegistry, runtimeWiring, fed2Imports) : Federation.ensureFederationDirectiveDefinitionsExist(typeRegistry, runtimeWiring);
        GraphQLSchema original = new SchemaGenerator().makeExecutableSchema(generatorOptions, typeRegistry, newRuntimeWiring);
        return Federation.transform(original, queryTypeShouldBeEmpty).setFederation2(fed2Imports != null);
    }

    public static SchemaTransformer transform(TypeDefinitionRegistry typeRegistry) {
        return Federation.transform(typeRegistry, Federation.emptyWiring());
    }

    public static SchemaTransformer transform(String sdl, RuntimeWiring runtimeWiring) {
        return Federation.transform(new SchemaParser().parse(sdl), runtimeWiring);
    }

    public static SchemaTransformer transform(Reader sdl, RuntimeWiring runtimeWiring) {
        return Federation.transform(new SchemaParser().parse(sdl), runtimeWiring);
    }

    public static SchemaTransformer transform(File sdl, RuntimeWiring runtimeWiring) {
        return Federation.transform(new SchemaParser().parse(sdl), runtimeWiring);
    }

    public static SchemaTransformer transform(String sdl) {
        return Federation.transform(sdl, Federation.emptyWiring());
    }

    public static SchemaTransformer transform(Reader sdl) {
        return Federation.transform(sdl, Federation.emptyWiring());
    }

    public static SchemaTransformer transform(File sdl) {
        return Federation.transform(sdl, Federation.emptyWiring());
    }

    private static RuntimeWiring emptyWiring() {
        return RuntimeWiring.newRuntimeWiring().build();
    }

    private static boolean ensureQueryTypeExists(TypeDefinitionRegistry typeRegistry) {
        boolean addDummyField;
        String queryName = typeRegistry.schemaDefinition().flatMap(sdef -> sdef.getOperationTypeDefinitions().stream().filter(op -> "query".equals(op.getName())).findFirst().map(def -> def.getTypeName().getName())).orElse("Query");
        TypeDefinition newQueryType = (TypeDefinition)typeRegistry.getType(queryName).orElse(ObjectTypeDefinition.newObjectTypeDefinition().name(queryName).build());
        boolean bl = addDummyField = newQueryType instanceof ObjectTypeDefinition && ((ObjectTypeDefinition)newQueryType).getFieldDefinitions().isEmpty() && Optional.ofNullable(typeRegistry.objectTypeExtensions().get(queryName)).map(List::isEmpty).orElse(true) != false;
        if (addDummyField) {
            newQueryType = ((ObjectTypeDefinition)newQueryType).transform((T objectTypeDefinitionBuilder) -> objectTypeDefinitionBuilder.fieldDefinition(FieldDefinition.newFieldDefinition().name("_dummy").type((Type)new TypeName("String")).build()));
        }
        typeRegistry.remove((SDLDefinition)newQueryType);
        typeRegistry.add((SDLDefinition)newQueryType);
        return addDummyField;
    }

    private static Stream<SDLNamedDefinition> renameDefinitions(List<SDLNamedDefinition> sdlNamedDefinition, Map<String, String> fed2Imports) {
        return sdlNamedDefinition.stream().map(definition -> (SDLNamedDefinition)new AstTransformer().transform((Node)definition, (NodeVisitor)new LinkImportsRenamingVisitor(fed2Imports)));
    }

    private static RuntimeWiring ensureFederationV2DirectiveDefinitionsExist(TypeDefinitionRegistry typeRegistry, RuntimeWiring runtimeWiring, @Nullable Map<String, String> fed2Imports) {
        HashSet<GraphQLScalarType> scalarTypesToAdd = new HashSet<GraphQLScalarType>();
        Stream<SDLNamedDefinition> renamedDefinitions = Federation.renameDefinitions(FederationDirectives.federation2Definitions, fed2Imports);
        renamedDefinitions.forEach(def -> {
            if (!typeRegistry.getDirectiveDefinition(def.getName()).isPresent()) {
                typeRegistry.add((SDLDefinition)def);
            }
            if (def instanceof ScalarTypeDefinition && !runtimeWiring.getScalars().containsKey(def.getName())) {
                scalarTypesToAdd.add(GraphQLScalarType.newScalar().name(def.getName()).description(null).coercing(_Any.defaultCoercing).build());
            }
        });
        return Federation.addScalarsToRuntimeWiring(runtimeWiring, scalarTypesToAdd);
    }

    private static RuntimeWiring ensureFederationDirectiveDefinitionsExist(TypeDefinitionRegistry typeRegistry, RuntimeWiring runtimeWiring) {
        FederationDirectives.federation1DirectiveDefinitions.stream().filter(def -> !typeRegistry.getDirectiveDefinition(def.getName()).isPresent()).forEachOrdered(arg_0 -> ((TypeDefinitionRegistry)typeRegistry).add(arg_0));
        if (!typeRegistry.getType("_FieldSet").isPresent()) {
            typeRegistry.add((SDLDefinition)_FieldSet.definition);
        }
        RuntimeWiring newRuntimeWiring = !runtimeWiring.getScalars().containsKey("_FieldSet") ? Federation.addScalarsToRuntimeWiring(runtimeWiring, Collections.singleton(_FieldSet.type)) : runtimeWiring;
        return newRuntimeWiring;
    }

    private static RuntimeWiring addScalarsToRuntimeWiring(RuntimeWiring runtimeWiring, Set<GraphQLScalarType> additionalScalars) {
        RuntimeWiring.Builder builder = RuntimeWiring.newRuntimeWiring((RuntimeWiring)runtimeWiring);
        additionalScalars.forEach(arg_0 -> ((RuntimeWiring.Builder)builder).scalar(arg_0));
        return builder.build();
    }

    @Nullable
    private static Map<String, String> fed2DirectiveImports(TypeDefinitionRegistry typeDefinitionRegistry) {
        List federationLinkDirectives = typeDefinitionRegistry.schemaDefinition().map(Federation::getFederationLinkDirective).map(Collections::singletonList).orElseGet(() -> typeDefinitionRegistry.getSchemaExtensionDefinitions().stream().map(Federation::getFederationLinkDirective).filter(Objects::nonNull).collect(Collectors.toList()));
        if (federationLinkDirectives.isEmpty()) {
            return null;
        }
        HashMap<String, String> imports = new HashMap<String, String>();
        federationLinkDirectives.forEach(directive -> imports.putAll(Federation.parseLinkImports(directive)));
        imports.put("@link", "@link");
        return imports;
    }

    @Nullable
    private static Directive getFederationLinkDirective(SchemaDefinition schemaDefinition) {
        return schemaDefinition.getDirectives("link").stream().filter(directive -> {
            Argument urlArgument = directive.getArgument("url");
            if (urlArgument != null && urlArgument.getValue() instanceof StringValue) {
                StringValue value = (StringValue)urlArgument.getValue();
                return "https://specs.apollo.dev/federation/v2.0".equals(value.getValue());
            }
            return false;
        }).findAny().orElse(null);
    }

    private static Map<String, String> parseLinkImports(Directive linkDirective) {
        HashMap<String, String> imports = new HashMap<String, String>();
        Argument importArgument = linkDirective.getArgument("import");
        if (importArgument != null && importArgument.getValue() instanceof ArrayValue) {
            ArrayValue linkImports = (ArrayValue)importArgument.getValue();
            for (Value importedDefinition : linkImports.getValues()) {
                if (importedDefinition instanceof StringValue) {
                    String name = ((StringValue)importedDefinition).getValue();
                    imports.put(name, name);
                    continue;
                }
                if (importedDefinition instanceof ObjectValue) {
                    ObjectValue importedObjectValue = (ObjectValue)importedDefinition;
                    Optional<ObjectField> nameField = importedObjectValue.getObjectFields().stream().filter(field -> field.getName().equals("name")).findFirst();
                    Optional<ObjectField> renameAsField = importedObjectValue.getObjectFields().stream().filter(field -> field.getName().equals("as")).findFirst();
                    if (!nameField.isPresent() || !(nameField.get().getValue() instanceof StringValue)) {
                        throw new UnsupportedLinkImportException((Value)importedObjectValue);
                    }
                    String name = ((StringValue)nameField.get().getValue()).getValue();
                    if (!renameAsField.isPresent()) {
                        imports.put(name, name);
                        continue;
                    }
                    Value renamedAsValue = renameAsField.get().getValue();
                    if (!(renamedAsValue instanceof StringValue)) {
                        throw new UnsupportedLinkImportException((Value)importedObjectValue);
                    }
                    imports.put(name, ((StringValue)renamedAsValue).getValue());
                    continue;
                }
                throw new UnsupportedLinkImportException(importedDefinition);
            }
        }
        return imports;
    }
}

