/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.federation.graphqljava;

import com.apollographql.federation.graphqljava.FederationError;
import com.apollographql.federation.graphqljava._Any;
import com.apollographql.federation.graphqljava._Entity;
import com.apollographql.federation.graphqljava._Service;
import com.apollographql.federation.graphqljava.printer.ServiceSDLPrinter;
import graphql.schema.Coercing;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactory;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.TypeResolver;
import graphql.schema.idl.errors.SchemaProblem;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class SchemaTransformer {
    private static final Object serviceObject = new Object();
    private final GraphQLSchema originalSchema;
    private final boolean queryTypeShouldBeEmpty;
    private TypeResolver entityTypeResolver = null;
    private DataFetcher entitiesDataFetcher = null;
    private DataFetcherFactory entitiesDataFetcherFactory = null;
    private Coercing coercingForAny = _Any.defaultCoercing;
    private boolean isFederation2 = false;

    SchemaTransformer(GraphQLSchema originalSchema, boolean queryTypeShouldBeEmpty) {
        this.originalSchema = originalSchema;
        this.queryTypeShouldBeEmpty = queryTypeShouldBeEmpty;
    }

    @NotNull
    public SchemaTransformer resolveEntityType(TypeResolver entityTypeResolver) {
        this.entityTypeResolver = entityTypeResolver;
        return this;
    }

    @NotNull
    public SchemaTransformer fetchEntities(DataFetcher entitiesDataFetcher) {
        this.entitiesDataFetcher = entitiesDataFetcher;
        this.entitiesDataFetcherFactory = null;
        return this;
    }

    @NotNull
    public SchemaTransformer fetchEntitiesFactory(DataFetcherFactory entitiesDataFetcherFactory) {
        this.entitiesDataFetcher = null;
        this.entitiesDataFetcherFactory = entitiesDataFetcherFactory;
        return this;
    }

    public SchemaTransformer coercingForAny(Coercing coercing) {
        this.coercingForAny = coercing;
        return this;
    }

    public SchemaTransformer setFederation2(boolean isFederation2) {
        this.isFederation2 = isFederation2;
        return this;
    }

    @NotNull
    public final GraphQLSchema build() throws SchemaProblem {
        ArrayList<FederationError> errors = new ArrayList<FederationError>();
        GraphQLSchema.Builder newSchema = GraphQLSchema.newSchema((GraphQLSchema)this.originalSchema);
        GraphQLObjectType originalQueryType = this.originalSchema.getQueryType();
        GraphQLObjectType.Builder newQueryType = GraphQLObjectType.newObject((GraphQLObjectType)originalQueryType);
        if (this.queryTypeShouldBeEmpty) {
            newQueryType.clearFields();
        }
        newQueryType.field(_Service.field);
        Set<String> entityTypeNames = this.getFederatedEntities();
        if (!entityTypeNames.isEmpty()) {
            newQueryType.field(_Entity.field(entityTypeNames));
            GraphQLType originalAnyType = this.originalSchema.getType("_Any");
            if (originalAnyType == null) {
                newSchema.additionalType((GraphQLType)_Any.type(this.coercingForAny));
            }
        }
        newSchema.query(newQueryType.build());
        GraphQLCodeRegistry.Builder newCodeRegistry = GraphQLCodeRegistry.newCodeRegistry((GraphQLCodeRegistry)this.originalSchema.getCodeRegistry());
        if (!entityTypeNames.isEmpty()) {
            if (this.entityTypeResolver != null) {
                newCodeRegistry.typeResolver("_Entity", this.entityTypeResolver);
            } else if (!newCodeRegistry.hasTypeResolver("_Entity")) {
                errors.add(new FederationError("Missing a type resolver for _Entity"));
            }
            FieldCoordinates _entities = FieldCoordinates.coordinates((String)originalQueryType.getName(), (String)"_entities");
            if (this.entitiesDataFetcher != null) {
                newCodeRegistry.dataFetcher(_entities, this.entitiesDataFetcher);
            } else if (this.entitiesDataFetcherFactory != null) {
                newCodeRegistry.dataFetcher(_entities, this.entitiesDataFetcherFactory);
            } else if (!newCodeRegistry.hasDataFetcher(_entities)) {
                errors.add(new FederationError("Missing a data fetcher for _entities"));
            }
        }
        if (!errors.isEmpty()) {
            throw new SchemaProblem(errors);
        }
        newCodeRegistry.dataFetcher(FieldCoordinates.coordinates((String)originalQueryType.getName(), (String)"_service"), environment -> serviceObject);
        String sdl = this.isFederation2 ? ServiceSDLPrinter.generateServiceSDLV2(newSchema.codeRegistry(newCodeRegistry.build()).build()) : SchemaTransformer.sdl(this.originalSchema, this.queryTypeShouldBeEmpty);
        newCodeRegistry.dataFetcher(FieldCoordinates.coordinates((String)"_Service", (String)"sdl"), environment -> sdl);
        return newSchema.codeRegistry(newCodeRegistry.build()).build();
    }

    Set<String> getFederatedEntities() {
        Set<String> entitiesWithExplicitKeys = this.originalSchema.getAllTypesAsList().stream().filter(this.entityPredicate()).map(GraphQLNamedSchemaElement::getName).collect(Collectors.toSet());
        return this.originalSchema.getAllTypesAsList().stream().filter(this.entityObjectPredicate(entitiesWithExplicitKeys)).map(GraphQLNamedSchemaElement::getName).collect(Collectors.toSet());
    }

    private Predicate<GraphQLNamedType> entityPredicate() {
        return type -> {
            if (type instanceof GraphQLDirectiveContainer) {
                GraphQLDirectiveContainer entityCandidate = (GraphQLDirectiveContainer)type;
                return entityCandidate.getAllAppliedDirectivesByName().containsKey("key") || entityCandidate.getAllDirectivesByName().containsKey("key");
            }
            return false;
        };
    }

    private Predicate<GraphQLNamedType> entityObjectPredicate(Set<String> entityNames) {
        return type -> {
            if (type instanceof GraphQLObjectType) {
                GraphQLObjectType objectType = (GraphQLObjectType)type;
                return entityNames.contains(objectType.getName()) || objectType.getInterfaces().stream().anyMatch(interfaceType -> entityNames.contains(interfaceType.getName()));
            }
            return false;
        };
    }

    @Deprecated
    public static String sdl(GraphQLSchema schema) {
        return SchemaTransformer.sdl(schema, false);
    }

    @Deprecated
    public static String sdl(GraphQLSchema schema, boolean queryTypeShouldBeEmpty) {
        return ServiceSDLPrinter.generateServiceSDL(schema, queryTypeShouldBeEmpty);
    }
}

