/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.internal;

import com.apollographql.apollo3.ApolloCall;
import com.apollographql.apollo3.ApolloQueryWatcher;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.ResponseAdapterCache;
import com.apollographql.apollo3.api.internal.ApolloLogger;
import com.apollographql.apollo3.api.internal.Optional;
import com.apollographql.apollo3.cache.normalized.ApolloStore;
import com.apollographql.apollo3.cache.normalized.Record;
import com.apollographql.apollo3.cache.normalized.internal.OperationCacheExtensionsKt;
import com.apollographql.apollo3.exception.ApolloCanceledException;
import com.apollographql.apollo3.exception.ApolloException;
import com.apollographql.apollo3.exception.ApolloHttpException;
import com.apollographql.apollo3.exception.ApolloNetworkException;
import com.apollographql.apollo3.exception.ApolloParseException;
import com.apollographql.apollo3.fetcher.ResponseFetcher;
import com.apollographql.apollo3.internal.ApolloCallTracker;
import com.apollographql.apollo3.internal.CallState;
import com.apollographql.apollo3.internal.RealApolloCall;
import com.apollographql.apollo3.internal.RealApolloQueryWatcher$WhenMappings;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 7*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u00017B;\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010)\u001a\u00020*2\u0012\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000!0,H\u0002J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0002J\b\u0010.\u001a\u00020*H\u0016J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J\u001c\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0016J\f\u00101\u001a\u0006\u0012\u0002\b\u000302H\u0016J\b\u00103\u001a\u00020*H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00104\u001a\u00020\u000fH\u0016J\u0012\u00105\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000!0,J\u0012\u00106\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000!0,R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001cR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010&\u001a\u0010\u0012\f\u0012\n (*\u0004\u0018\u00010'0'0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/apollographql/apollo3/internal/RealApolloQueryWatcher;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "Lcom/apollographql/apollo3/ApolloQueryWatcher;", "activeCall", "Lcom/apollographql/apollo3/internal/RealApolloCall;", "apolloStore", "Lcom/apollographql/apollo3/cache/normalized/ApolloStore;", "responseAdapterCache", "Lcom/apollographql/apollo3/api/ResponseAdapterCache;", "logger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "tracker", "Lcom/apollographql/apollo3/internal/ApolloCallTracker;", "refetchResponseFetcher", "Lcom/apollographql/apollo3/fetcher/ResponseFetcher;", "(Lcom/apollographql/apollo3/internal/RealApolloCall;Lcom/apollographql/apollo3/cache/normalized/ApolloStore;Lcom/apollographql/apollo3/api/ResponseAdapterCache;Lcom/apollographql/apollo3/api/internal/ApolloLogger;Lcom/apollographql/apollo3/internal/ApolloCallTracker;Lcom/apollographql/apollo3/fetcher/ResponseFetcher;)V", "getApolloStore", "()Lcom/apollographql/apollo3/cache/normalized/ApolloStore;", "dependentKeys", "", "", "getDependentKeys", "()Ljava/util/Set;", "setDependentKeys", "(Ljava/util/Set;)V", "isCanceled", "", "()Z", "getLogger", "()Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "originalCallback", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/apollographql/apollo3/ApolloCall$Callback;", "recordChangeSubscriber", "Lcom/apollographql/apollo3/cache/normalized/ApolloStore$RecordChangeSubscriber;", "getRecordChangeSubscriber", "()Lcom/apollographql/apollo3/cache/normalized/ApolloStore$RecordChangeSubscriber;", "state", "Lcom/apollographql/apollo3/internal/CallState;", "kotlin.jvm.PlatformType", "activate", "", "callback", "Lcom/apollographql/apollo3/api/internal/Optional;", "callbackProxy", "cancel", "clone", "enqueueAndWatch", "operation", "Lcom/apollographql/apollo3/api/Operation;", "refetch", "fetcher", "responseCallback", "terminate", "Companion", "apollo-runtime"})
public final class RealApolloQueryWatcher<D extends Operation.Data>
implements ApolloQueryWatcher<D> {
    @NotNull
    private Set<String> dependentKeys;
    @NotNull
    private final ApolloStore.RecordChangeSubscriber recordChangeSubscriber;
    private final AtomicReference<CallState> state;
    private final AtomicReference<ApolloCall.Callback<D>> originalCallback;
    private RealApolloCall<D> activeCall;
    @NotNull
    private final ApolloStore apolloStore;
    private final ResponseAdapterCache responseAdapterCache;
    @NotNull
    private final ApolloLogger logger;
    private final ApolloCallTracker tracker;
    private ResponseFetcher refetchResponseFetcher;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Set<String> getDependentKeys() {
        return this.dependentKeys;
    }

    public final void setDependentKeys(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.dependentKeys = set;
    }

    @NotNull
    public final ApolloStore.RecordChangeSubscriber getRecordChangeSubscriber() {
        return this.recordChangeSubscriber;
    }

    @Override
    @NotNull
    public ApolloQueryWatcher<D> enqueueAndWatch(@NotNull ApolloCall.Callback<D> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        try {
            this.activate(Optional.Companion.fromNullable(callback));
        }
        catch (ApolloCanceledException e) {
            callback.onCanceledError(e);
            return this;
        }
        this.activeCall.enqueue(this.callbackProxy());
        return this;
    }

    @Override
    @NotNull
    public synchronized RealApolloQueryWatcher<D> refetchResponseFetcher(@NotNull ResponseFetcher fetcher) {
        Intrinsics.checkNotNullParameter((Object)fetcher, (String)"fetcher");
        boolean bl = this.state.get() == CallState.IDLE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Already Executed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.refetchResponseFetcher = fetcher;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void cancel() {
        CallState callState = this.state.get();
        if (callState == null) throw (Throwable)new IllegalStateException("Unknown state");
        switch (RealApolloQueryWatcher$WhenMappings.$EnumSwitchMapping$0[callState.ordinal()]) {
            case 1: {
                try {
                    this.activeCall.cancel();
                    this.apolloStore.unsubscribe(this.recordChangeSubscriber);
                    return;
                }
                finally {
                    this.tracker.unregisterQueryWatcher(this);
                    this.originalCallback.set(null);
                    this.state.set(CallState.CANCELED);
                }
            }
            case 2: {
                this.state.set(CallState.CANCELED);
                return;
            }
            case 3: 
            case 4: {
                return;
            }
            default: {
                throw (Throwable)new IllegalStateException("Unknown state");
            }
        }
    }

    @Override
    public boolean isCanceled() {
        return this.state.get() == CallState.CANCELED;
    }

    @Override
    @NotNull
    public Operation<?> operation() {
        return this.activeCall.operation();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void refetch() {
        CallState callState = this.state.get();
        if (callState == null) throw (Throwable)new IllegalStateException("Unknown state");
        switch (RealApolloQueryWatcher$WhenMappings.$EnumSwitchMapping$1[callState.ordinal()]) {
            case 1: {
                this.apolloStore.unsubscribe(this.recordChangeSubscriber);
                this.activeCall.cancel();
                this.activeCall = ((RealApolloCall)this.activeCall.clone()).responseFetcher(this.refetchResponseFetcher);
                this.activeCall.enqueue(this.callbackProxy());
                return;
            }
            case 2: {
                throw (Throwable)new IllegalStateException("Cannot refetch a watcher which has not first called enqueueAndWatch.");
            }
            case 3: {
                throw (Throwable)new IllegalStateException("Cannot refetch a canceled watcher,");
            }
            case 4: {
                throw (Throwable)new IllegalStateException("Cannot refetch a watcher which has experienced an error.");
            }
            default: {
                throw (Throwable)new IllegalStateException("Unknown state");
            }
        }
    }

    @Override
    @NotNull
    public ApolloQueryWatcher<D> clone() {
        return new RealApolloQueryWatcher<D>(this.activeCall.clone(), this.apolloStore, this.responseAdapterCache, this.logger, this.tracker, this.refetchResponseFetcher);
    }

    private final ApolloCall.Callback<D> callbackProxy() {
        return new ApolloCall.Callback<D>(this){
            final /* synthetic */ RealApolloQueryWatcher this$0;

            public void onResponse(@NotNull ApolloResponse<? extends D> response) {
                Intrinsics.checkNotNullParameter(response, (String)"response");
                Optional<ApolloCall.Callback<D>> callback = this.this$0.responseCallback();
                if (!callback.isPresent()) {
                    this.this$0.getLogger().d("onResponse for watched operation: %s. No callback present.", new Object[]{this.this$0.operation().name()});
                    return;
                }
                this.this$0.getApolloStore().subscribe(this.this$0.getRecordChangeSubscriber());
                callback.get().onResponse(response);
            }

            public void onCached(@NotNull List<Record> records) {
                Intrinsics.checkNotNullParameter(records, (String)"records");
                Optional<ApolloCall.Callback<D>> callback = this.this$0.responseCallback();
                if (!callback.isPresent()) {
                    this.this$0.getLogger().d("onCached for watched operation: %s. No callback present.", new Object[]{this.this$0.operation().name()});
                    return;
                }
                this.this$0.setDependentKeys(OperationCacheExtensionsKt.dependentKeys((Collection)records));
            }

            public void onFailure(@NotNull ApolloException e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Optional<ApolloCall.Callback<D>> callback = this.this$0.terminate();
                if (!callback.isPresent()) {
                    this.this$0.getLogger().d((Throwable)e, "onFailure for operation: %s. No callback present.", new Object[]{this.this$0.operation().name()});
                    return;
                }
                if (e instanceof ApolloHttpException) {
                    callback.get().onHttpError((ApolloHttpException)e);
                } else if (e instanceof ApolloParseException) {
                    callback.get().onParseError((ApolloParseException)e);
                } else if (e instanceof ApolloNetworkException) {
                    callback.get().onNetworkError((ApolloNetworkException)e);
                } else {
                    callback.get().onFailure(e);
                }
            }

            public void onStatusEvent(@NotNull ApolloCall.StatusEvent event) {
                Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
                ApolloCall.Callback callback = (ApolloCall.Callback)RealApolloQueryWatcher.access$getOriginalCallback$p(this.this$0).get();
                if (callback == null) {
                    this.this$0.getLogger().d("onStatusEvent for operation: %s. No callback present.", new Object[]{this.this$0.operation().name()});
                    return;
                }
                callback.onStatusEvent(event);
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final synchronized void activate(Optional<ApolloCall.Callback<D>> callback) throws ApolloCanceledException {
        CallState callState = this.state.get();
        if (callState == null) throw (Throwable)new IllegalStateException("Unknown state");
        switch (RealApolloQueryWatcher$WhenMappings.$EnumSwitchMapping$2[callState.ordinal()]) {
            case 1: {
                this.originalCallback.set(callback.orNull());
                this.tracker.registerQueryWatcher(this);
                break;
            }
            case 2: {
                throw (Throwable)new ApolloCanceledException(null, null, 3, null);
            }
            case 3: 
            case 4: {
                throw (Throwable)new IllegalStateException("Already Executed");
            }
            default: {
                throw (Throwable)new IllegalStateException("Unknown state");
            }
        }
        this.state.set(CallState.ACTIVE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final synchronized Optional<ApolloCall.Callback<D>> responseCallback() {
        CallState callState = this.state.get();
        if (callState == null) throw (Throwable)new IllegalStateException("Unknown state");
        switch (RealApolloQueryWatcher$WhenMappings.$EnumSwitchMapping$3[callState.ordinal()]) {
            case 1: 
            case 2: {
                return Optional.Companion.fromNullable(this.originalCallback.get());
            }
            case 3: 
            case 4: {
                CallState callState2 = this.state.get();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)callState2), (String)"state.get()");
                throw (Throwable)new IllegalStateException(CallState.IllegalStateMessage.Companion.forCurrentState(callState2).expected(CallState.ACTIVE, CallState.CANCELED));
            }
            default: {
                throw (Throwable)new IllegalStateException("Unknown state");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final synchronized Optional<ApolloCall.Callback<D>> terminate() {
        CallState callState = this.state.get();
        if (callState == null) throw (Throwable)new IllegalStateException("Unknown state");
        switch (RealApolloQueryWatcher$WhenMappings.$EnumSwitchMapping$4[callState.ordinal()]) {
            case 1: {
                this.tracker.unregisterQueryWatcher(this);
                this.state.set(CallState.TERMINATED);
                Optional<Object> optional = Optional.Companion.fromNullable(this.originalCallback.getAndSet(null));
                return optional;
            }
            case 2: {
                Optional<Object> optional = Optional.Companion.fromNullable(this.originalCallback.getAndSet(null));
                return optional;
            }
            case 3: 
            case 4: {
                CallState callState2 = this.state.get();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)callState2), (String)"state.get()");
                throw (Throwable)new IllegalStateException(CallState.IllegalStateMessage.Companion.forCurrentState(callState2).expected(CallState.ACTIVE, CallState.CANCELED));
            }
            default: {
                throw (Throwable)new IllegalStateException("Unknown state");
            }
        }
    }

    @NotNull
    public final ApolloStore getApolloStore() {
        return this.apolloStore;
    }

    @NotNull
    public final ApolloLogger getLogger() {
        return this.logger;
    }

    public RealApolloQueryWatcher(@NotNull RealApolloCall<D> activeCall, @NotNull ApolloStore apolloStore, @NotNull ResponseAdapterCache responseAdapterCache, @NotNull ApolloLogger logger, @NotNull ApolloCallTracker tracker, @NotNull ResponseFetcher refetchResponseFetcher) {
        Intrinsics.checkNotNullParameter(activeCall, (String)"activeCall");
        Intrinsics.checkNotNullParameter((Object)apolloStore, (String)"apolloStore");
        Intrinsics.checkNotNullParameter((Object)responseAdapterCache, (String)"responseAdapterCache");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Intrinsics.checkNotNullParameter((Object)refetchResponseFetcher, (String)"refetchResponseFetcher");
        this.activeCall = activeCall;
        this.apolloStore = apolloStore;
        this.responseAdapterCache = responseAdapterCache;
        this.logger = logger;
        this.tracker = tracker;
        this.refetchResponseFetcher = refetchResponseFetcher;
        this.dependentKeys = SetsKt.emptySet();
        this.recordChangeSubscriber = new ApolloStore.RecordChangeSubscriber(this){
            final /* synthetic */ RealApolloQueryWatcher this$0;

            public void onCacheRecordsChanged(@NotNull Set<String> changedRecordKeys) {
                Intrinsics.checkNotNullParameter(changedRecordKeys, (String)"changedRecordKeys");
                if (this.this$0.getDependentKeys().isEmpty() || !com.apollographql.apollo3.internal.RealApolloQueryWatcher$Companion.access$areDisjoint(RealApolloQueryWatcher.Companion, this.this$0.getDependentKeys(), changedRecordKeys)) {
                    this.this$0.refetch();
                }
            }
            {
                this.this$0 = this$0;
            }
        };
        this.state = new AtomicReference<CallState>(CallState.IDLE);
        this.originalCallback = new AtomicReference();
    }

    public static final /* synthetic */ AtomicReference access$getOriginalCallback$p(RealApolloQueryWatcher $this) {
        return $this.originalCallback;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0001\u0010\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\u00072\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/apollographql/apollo3/internal/RealApolloQueryWatcher$Companion;", "", "()V", "areDisjoint", "", "E", "setOne", "", "setTwo", "apollo-runtime"})
    public static final class Companion {
        private final <E> boolean areDisjoint(Set<? extends E> setOne, Set<? extends E> setTwo) {
            if (setOne == null || setTwo == null) {
                return true;
            }
            Set<E> smallerSet = setOne;
            Set<E> largerSet = setTwo;
            if (setOne.size() > setTwo.size()) {
                smallerSet = setTwo;
                largerSet = setOne;
            }
            for (E el : smallerSet) {
                if (!largerSet.contains(el)) continue;
                return false;
            }
            return true;
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$areDisjoint(Companion $this, Set setOne, Set setTwo) {
            return $this.areDisjoint(setOne, setTwo);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

