/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.internal.subscription;

import com.apollographql.apollo3.api.Error;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.Response;
import com.apollographql.apollo3.api.ResponseAdapterCache;
import com.apollographql.apollo3.api.Subscription;
import com.apollographql.apollo3.api.internal.MapResponseParser;
import com.apollographql.apollo3.cache.normalized.CacheKeyResolver;
import com.apollographql.apollo3.exception.ApolloNetworkException;
import com.apollographql.apollo3.internal.subscription.ApolloSubscriptionException;
import com.apollographql.apollo3.internal.subscription.ApolloSubscriptionServerException;
import com.apollographql.apollo3.internal.subscription.SubscriptionManager;
import com.apollographql.apollo3.internal.subscription.SubscriptionResponse;
import com.apollographql.apollo3.subscription.OnSubscriptionManagerStateChangeListener;
import com.apollographql.apollo3.subscription.OperationClientMessage;
import com.apollographql.apollo3.subscription.OperationServerMessage;
import com.apollographql.apollo3.subscription.SubscriptionConnectionParamsProvider;
import com.apollographql.apollo3.subscription.SubscriptionManagerState;
import com.apollographql.apollo3.subscription.SubscriptionTransport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 X2\u00020\u0001:\u0004WXYZB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0017H\u0016J\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020!0,2\u0006\u0010-\u001a\u00020\u000fJ\u0006\u0010.\u001a\u00020)J\u001e\u0010/\u001a\u00020)2\n\u00100\u001a\u0006\u0012\u0002\b\u0003012\n\u00102\u001a\u0006\u0012\u0002\b\u000303J\u0012\u00104\u001a\u00020)2\n\u00100\u001a\u0006\u0012\u0002\b\u000301J\u0018\u00105\u001a\u00020)2\u0006\u00106\u001a\u00020\u00192\u0006\u00107\u001a\u00020\u0019H\u0002J\u0010\u00108\u001a\u00020)2\u0006\u00109\u001a\u00020:H\u0002J\b\u0010;\u001a\u00020)H\u0002J\u0006\u0010<\u001a\u00020)J\u0006\u0010=\u001a\u00020)J\u0006\u0010>\u001a\u00020)J\u0010\u0010?\u001a\u00020)2\u0006\u00109\u001a\u00020@H\u0002J\u0006\u0010A\u001a\u00020)J\u0010\u0010B\u001a\u00020)2\u0006\u00109\u001a\u00020CH\u0002J\u0010\u0010D\u001a\u00020)2\b\u00109\u001a\u0004\u0018\u00010EJ\u0006\u0010F\u001a\u00020)J\u0010\u0010G\u001a\u00020)2\b\u0010H\u001a\u0004\u0018\u00010IJ\b\u0010J\u001a\u00020)H\u0016J\u0010\u0010K\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0017H\u0016J\u0012\u0010L\u001a\u00020!2\b\u0010M\u001a\u0004\u0018\u00010NH\u0002J\b\u0010O\u001a\u00020)H\u0002J\b\u0010P\u001a\u00020)H\u0016J\b\u0010Q\u001a\u00020)H\u0002J\b\u0010R\u001a\u00020)H\u0016J.\u0010S\u001a\u00020)\"\b\b\u0000\u0010T*\u00020U2\f\u00100\u001a\b\u0012\u0004\u0012\u0002HT012\f\u00102\u001a\b\u0012\u0004\u0012\u0002HT03H\u0016J\u0014\u0010V\u001a\u00020)2\n\u00100\u001a\u0006\u0012\u0002\b\u000301H\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lcom/apollographql/apollo3/internal/subscription/RealSubscriptionManager;", "Lcom/apollographql/apollo3/internal/subscription/SubscriptionManager;", "responseAdapterCache", "Lcom/apollographql/apollo3/api/ResponseAdapterCache;", "transportFactory", "Lcom/apollographql/apollo3/subscription/SubscriptionTransport$Factory;", "connectionParams", "Lcom/apollographql/apollo3/subscription/SubscriptionConnectionParamsProvider;", "dispatcher", "Ljava/util/concurrent/Executor;", "connectionHeartbeatTimeoutMs", "", "cacheKeyResolver", "Lcom/apollographql/apollo3/cache/normalized/CacheKeyResolver;", "autoPersistSubscription", "", "(Lcom/apollographql/apollo3/api/ResponseAdapterCache;Lcom/apollographql/apollo3/subscription/SubscriptionTransport$Factory;Lcom/apollographql/apollo3/subscription/SubscriptionConnectionParamsProvider;Ljava/util/concurrent/Executor;JLcom/apollographql/apollo3/cache/normalized/CacheKeyResolver;Z)V", "connectionAcknowledgeTimeoutTimerTask", "Ljava/lang/Runnable;", "connectionHeartbeatTimeoutTimerTask", "inactivityTimeoutTimerTask", "onStateChangeListeners", "", "Lcom/apollographql/apollo3/subscription/OnSubscriptionManagerStateChangeListener;", "state", "Lcom/apollographql/apollo3/subscription/SubscriptionManagerState;", "getState", "()Lcom/apollographql/apollo3/subscription/SubscriptionManagerState;", "setState", "(Lcom/apollographql/apollo3/subscription/SubscriptionManagerState;)V", "subscriptions", "", "Ljava/util/UUID;", "Lcom/apollographql/apollo3/internal/subscription/RealSubscriptionManager$SubscriptionRecord;", "timer", "Lcom/apollographql/apollo3/internal/subscription/RealSubscriptionManager$AutoReleaseTimer;", "getTimer", "()Lcom/apollographql/apollo3/internal/subscription/RealSubscriptionManager$AutoReleaseTimer;", "transport", "Lcom/apollographql/apollo3/subscription/SubscriptionTransport;", "addOnStateChangeListener", "", "onStateChangeListener", "disconnect", "", "force", "doStop", "doSubscribe", "subscription", "Lcom/apollographql/apollo3/api/Subscription;", "callback", "Lcom/apollographql/apollo3/internal/subscription/SubscriptionManager$Callback;", "doUnsubscribe", "notifyStateChanged", "oldState", "newState", "onCompleteServerMessage", "message", "Lcom/apollographql/apollo3/subscription/OperationServerMessage$Complete;", "onConnectionAcknowledgeServerMessage", "onConnectionAcknowledgeTimeout", "onConnectionClosed", "onConnectionHeartbeatTimeout", "onErrorServerMessage", "Lcom/apollographql/apollo3/subscription/OperationServerMessage$Error;", "onInactivityTimeout", "onOperationDataServerMessage", "Lcom/apollographql/apollo3/subscription/OperationServerMessage$Data;", "onOperationServerMessage", "Lcom/apollographql/apollo3/subscription/OperationServerMessage;", "onTransportConnected", "onTransportFailure", "t", "", "reconnect", "removeOnStateChangeListener", "removeSubscriptionById", "subscriptionId", "", "resetConnectionKeepAliveTimerTask", "start", "startInactivityTimer", "stop", "subscribe", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "unsubscribe", "AutoReleaseTimer", "Companion", "SubscriptionRecord", "SubscriptionTransportCallback", "apollo-runtime"})
public final class RealSubscriptionManager
implements SubscriptionManager {
    @JvmField
    @NotNull
    public Map<UUID, SubscriptionRecord> subscriptions;
    @NotNull
    private volatile SubscriptionManagerState state;
    @NotNull
    private final AutoReleaseTimer timer;
    private final SubscriptionTransport transport;
    private final Runnable connectionAcknowledgeTimeoutTimerTask;
    private final Runnable inactivityTimeoutTimerTask;
    private final Runnable connectionHeartbeatTimeoutTimerTask;
    private final List<OnSubscriptionManagerStateChangeListener> onStateChangeListeners;
    private final ResponseAdapterCache responseAdapterCache;
    private final SubscriptionConnectionParamsProvider connectionParams;
    private final Executor dispatcher;
    private final long connectionHeartbeatTimeoutMs;
    private final CacheKeyResolver cacheKeyResolver;
    private final boolean autoPersistSubscription;
    public static final int CONNECTION_ACKNOWLEDGE_TIMEOUT_TIMER_TASK_ID = 1;
    public static final int INACTIVITY_TIMEOUT_TIMER_TASK_ID = 2;
    public static final int CONNECTION_KEEP_ALIVE_TIMEOUT_TIMER_TASK_ID = 3;
    private static final long CONNECTION_ACKNOWLEDGE_TIMEOUT;
    private static final long INACTIVITY_TIMEOUT;
    @NotNull
    public static final String PROTOCOL_NEGOTIATION_ERROR_NOT_FOUND = "PersistedQueryNotFound";
    @NotNull
    public static final String PROTOCOL_NEGOTIATION_ERROR_NOT_SUPPORTED = "PersistedQueryNotSupported";
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public SubscriptionManagerState getState() {
        return this.state;
    }

    public void setState(@NotNull SubscriptionManagerState subscriptionManagerState) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)subscriptionManagerState), (String)"<set-?>");
        this.state = subscriptionManagerState;
    }

    @NotNull
    public final AutoReleaseTimer getTimer() {
        return this.timer;
    }

    @Override
    public <D extends Operation.Data> void subscribe(@NotNull Subscription<D> subscription, @NotNull SubscriptionManager.Callback<D> callback) {
        Intrinsics.checkParameterIsNotNull(subscription, (String)"subscription");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.dispatcher.execute(new Runnable(this, subscription, callback){
            final /* synthetic */ RealSubscriptionManager this$0;
            final /* synthetic */ Subscription $subscription;
            final /* synthetic */ SubscriptionManager.Callback $callback;

            public final void run() {
                this.this$0.doSubscribe(this.$subscription, this.$callback);
            }
            {
                this.this$0 = realSubscriptionManager;
                this.$subscription = subscription;
                this.$callback = callback;
            }
        });
    }

    @Override
    public void unsubscribe(@NotNull Subscription<?> subscription) {
        Intrinsics.checkParameterIsNotNull(subscription, (String)"subscription");
        this.dispatcher.execute(new Runnable(this, subscription){
            final /* synthetic */ RealSubscriptionManager this$0;
            final /* synthetic */ Subscription $subscription;

            public final void run() {
                this.this$0.doUnsubscribe(this.$subscription);
            }
            {
                this.this$0 = realSubscriptionManager;
                this.$subscription = subscription;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        SubscriptionManagerState oldState = null;
        RealSubscriptionManager realSubscriptionManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realSubscriptionManager) {
            boolean bl3 = false;
            oldState = this.getState();
            if (this.getState() == SubscriptionManagerState.STOPPED) {
                this.setState(SubscriptionManagerState.DISCONNECTED);
            }
            Unit unit = Unit.INSTANCE;
        }
        this.notifyStateChanged(oldState, this.getState());
    }

    @Override
    public void stop() {
        this.dispatcher.execute(new Runnable(this){
            final /* synthetic */ RealSubscriptionManager this$0;

            public final void run() {
                this.this$0.doStop();
            }
            {
                this.this$0 = realSubscriptionManager;
            }
        });
    }

    @Override
    public void addOnStateChangeListener(@NotNull OnSubscriptionManagerStateChangeListener onStateChangeListener) {
        Intrinsics.checkParameterIsNotNull((Object)onStateChangeListener, (String)"onStateChangeListener");
        this.onStateChangeListeners.add(onStateChangeListener);
    }

    @Override
    public void removeOnStateChangeListener(@NotNull OnSubscriptionManagerStateChangeListener onStateChangeListener) {
        Intrinsics.checkParameterIsNotNull((Object)onStateChangeListener, (String)"onStateChangeListener");
        this.onStateChangeListeners.remove(onStateChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doSubscribe(@NotNull Subscription<?> subscription, @NotNull SubscriptionManager.Callback<?> callback) {
        Intrinsics.checkParameterIsNotNull(subscription, (String)"subscription");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        SubscriptionManagerState oldState = null;
        RealSubscriptionManager realSubscriptionManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realSubscriptionManager) {
            boolean bl3 = false;
            oldState = this.getState();
            if (this.getState() != SubscriptionManagerState.STOPPING && this.getState() != SubscriptionManagerState.STOPPED) {
                UUID subscriptionId;
                this.timer.cancelTask(2);
                UUID uUID = subscriptionId = UUID.randomUUID();
                Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"subscriptionId");
                this.subscriptions.put(uUID, new SubscriptionRecord(subscriptionId, subscription, callback));
                if (this.getState() == SubscriptionManagerState.DISCONNECTED) {
                    this.setState(SubscriptionManagerState.CONNECTING);
                    this.transport.connect();
                } else if (this.getState() == SubscriptionManagerState.ACTIVE) {
                    String string = subscriptionId.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"subscriptionId.toString()");
                    this.transport.send((OperationClientMessage)new OperationClientMessage.Start(string, subscription, this.responseAdapterCache, this.autoPersistSubscription, false));
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        if (oldState == SubscriptionManagerState.STOPPING || oldState == SubscriptionManagerState.STOPPED) {
            callback.onError(new ApolloSubscriptionException("Illegal state: " + this.getState().name() + " for subscriptions to be created." + " SubscriptionManager.start() must be called to re-enable subscriptions."));
        } else if (oldState == SubscriptionManagerState.CONNECTED) {
            callback.onConnected();
        }
        this.notifyStateChanged(oldState, this.getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doUnsubscribe(@NotNull Subscription<?> subscription) {
        Intrinsics.checkParameterIsNotNull(subscription, (String)"subscription");
        RealSubscriptionManager realSubscriptionManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realSubscriptionManager) {
            boolean bl3 = false;
            SubscriptionRecord subscriptionRecord = null;
            for (SubscriptionRecord record : this.subscriptions.values()) {
                if (record.getSubscription() != subscription) continue;
                subscriptionRecord = record;
            }
            if (subscriptionRecord != null) {
                this.subscriptions.remove(subscriptionRecord.getId());
                if (this.getState() == SubscriptionManagerState.ACTIVE || this.getState() == SubscriptionManagerState.STOPPING) {
                    String string = subscriptionRecord.getId().toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"subscriptionRecord.id.toString()");
                    this.transport.send((OperationClientMessage)new OperationClientMessage.Stop(string));
                }
            }
            if (this.subscriptions.isEmpty() && this.getState() != SubscriptionManagerState.STOPPING) {
                this.startInactivityTimer();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doStop() {
        Collection<SubscriptionRecord> subscriptionRecords = null;
        SubscriptionManagerState oldState = null;
        RealSubscriptionManager realSubscriptionManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realSubscriptionManager) {
            boolean bl3 = false;
            oldState = this.getState();
            this.setState(SubscriptionManagerState.STOPPING);
            subscriptionRecords = this.subscriptions.values();
            if (oldState == SubscriptionManagerState.ACTIVE) {
                for (SubscriptionRecord subscriptionRecord : subscriptionRecords) {
                    String string = subscriptionRecord.getId().toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"subscriptionRecord.id.toString()");
                    this.transport.send((OperationClientMessage)new OperationClientMessage.Stop(string));
                }
            }
            this.setState(SubscriptionManagerState.STOPPED);
            this.transport.disconnect((OperationClientMessage)new OperationClientMessage.Terminate());
            this.subscriptions = new LinkedHashMap();
            Unit unit = Unit.INSTANCE;
        }
        for (SubscriptionRecord record : subscriptionRecords) {
            record.notifyOnCompleted();
        }
        this.notifyStateChanged(oldState, SubscriptionManagerState.STOPPING);
        this.notifyStateChanged(SubscriptionManagerState.STOPPING, this.getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onTransportConnected() {
        Collection subscriptionRecords = new ArrayList();
        SubscriptionManagerState oldState = null;
        RealSubscriptionManager realSubscriptionManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realSubscriptionManager) {
            boolean bl3 = false;
            oldState = this.getState();
            if (this.getState() == SubscriptionManagerState.CONNECTING) {
                subscriptionRecords.addAll(this.subscriptions.values());
                this.setState(SubscriptionManagerState.CONNECTED);
                this.transport.send((OperationClientMessage)new OperationClientMessage.Init((Map)this.connectionParams.provide()));
            }
            if (this.getState() == SubscriptionManagerState.CONNECTED) {
                this.timer.schedule(1, this.connectionAcknowledgeTimeoutTimerTask, CONNECTION_ACKNOWLEDGE_TIMEOUT);
            }
            Unit unit = Unit.INSTANCE;
        }
        for (SubscriptionRecord record : subscriptionRecords) {
            record.getCallback().onConnected();
        }
        this.notifyStateChanged(oldState, this.getState());
    }

    public final void onConnectionAcknowledgeTimeout() {
        this.timer.cancelTask(1);
        this.dispatcher.execute(new Runnable(this){
            final /* synthetic */ RealSubscriptionManager this$0;

            public final void run() {
                this.this$0.onTransportFailure((Throwable)new ApolloNetworkException("Subscription server is not responding", null, 2, null));
            }
            {
                this.this$0 = realSubscriptionManager;
            }
        });
    }

    public final void onInactivityTimeout() {
        this.timer.cancelTask(2);
        this.dispatcher.execute(new Runnable(this){
            final /* synthetic */ RealSubscriptionManager this$0;

            public final void run() {
                this.this$0.disconnect(false);
            }
            {
                this.this$0 = realSubscriptionManager;
            }
        });
    }

    public final void onTransportFailure(@Nullable Throwable t) {
        Collection<SubscriptionRecord> subscriptionRecords = this.disconnect(true);
        for (SubscriptionRecord record : subscriptionRecords) {
            record.notifyOnNetworkError(t);
        }
    }

    public final void onOperationServerMessage(@Nullable OperationServerMessage message) {
        block1: {
            OperationServerMessage operationServerMessage;
            block5: {
                block4: {
                    block3: {
                        block2: {
                            block0: {
                                operationServerMessage = message;
                                if (!(operationServerMessage instanceof OperationServerMessage.ConnectionAcknowledge)) break block0;
                                this.onConnectionAcknowledgeServerMessage();
                                break block1;
                            }
                            if (!(operationServerMessage instanceof OperationServerMessage.Data)) break block2;
                            this.onOperationDataServerMessage((OperationServerMessage.Data)message);
                            break block1;
                        }
                        if (!(operationServerMessage instanceof OperationServerMessage.Error)) break block3;
                        this.onErrorServerMessage((OperationServerMessage.Error)message);
                        break block1;
                    }
                    if (!(operationServerMessage instanceof OperationServerMessage.Complete)) break block4;
                    this.onCompleteServerMessage((OperationServerMessage.Complete)message);
                    break block1;
                }
                if (!(operationServerMessage instanceof OperationServerMessage.ConnectionError)) break block5;
                this.disconnect(true);
                break block1;
            }
            if (!(operationServerMessage instanceof OperationServerMessage.ConnectionKeepAlive)) break block1;
            this.resetConnectionKeepAliveTimerTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Collection<SubscriptionRecord> disconnect(boolean force) {
        SubscriptionManagerState oldState = null;
        Collection<SubscriptionRecord> subscriptionRecords = null;
        RealSubscriptionManager realSubscriptionManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realSubscriptionManager) {
            boolean bl3 = false;
            oldState = this.getState();
            subscriptionRecords = this.subscriptions.values();
            if (force || this.subscriptions.isEmpty()) {
                this.transport.disconnect((OperationClientMessage)new OperationClientMessage.Terminate());
                this.setState(this.getState() == SubscriptionManagerState.STOPPING ? SubscriptionManagerState.STOPPED : SubscriptionManagerState.DISCONNECTED);
                this.subscriptions = new LinkedHashMap();
            }
            Unit unit = Unit.INSTANCE;
        }
        this.notifyStateChanged(oldState, this.getState());
        return subscriptionRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnect() {
        SubscriptionManagerState oldState = null;
        RealSubscriptionManager realSubscriptionManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realSubscriptionManager) {
            boolean bl3 = false;
            oldState = this.getState();
            this.setState(SubscriptionManagerState.DISCONNECTED);
            this.transport.disconnect((OperationClientMessage)new OperationClientMessage.Terminate());
            this.setState(SubscriptionManagerState.CONNECTING);
            this.transport.connect();
            Unit unit = Unit.INSTANCE;
        }
        this.notifyStateChanged(oldState, SubscriptionManagerState.DISCONNECTED);
        this.notifyStateChanged(SubscriptionManagerState.DISCONNECTED, SubscriptionManagerState.CONNECTING);
    }

    public final void onConnectionHeartbeatTimeout() {
        this.reconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onConnectionClosed() {
        Collection<SubscriptionRecord> subscriptionRecords = null;
        SubscriptionManagerState oldState = null;
        RealSubscriptionManager realSubscriptionManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realSubscriptionManager) {
            boolean bl3 = false;
            oldState = this.getState();
            subscriptionRecords = this.subscriptions.values();
            this.setState(SubscriptionManagerState.DISCONNECTED);
            this.subscriptions = new LinkedHashMap();
            Unit unit = Unit.INSTANCE;
        }
        for (SubscriptionRecord record : subscriptionRecords) {
            record.getCallback().onTerminated();
        }
        this.notifyStateChanged(oldState, this.getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void resetConnectionKeepAliveTimerTask() {
        if (this.connectionHeartbeatTimeoutMs <= 0L) {
            return;
        }
        RealSubscriptionManager realSubscriptionManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realSubscriptionManager) {
            boolean bl3 = false;
            this.timer.schedule(3, this.connectionHeartbeatTimeoutTimerTask, this.connectionHeartbeatTimeoutMs);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void startInactivityTimer() {
        this.timer.schedule(2, this.inactivityTimeoutTimerTask, INACTIVITY_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onOperationDataServerMessage(OperationServerMessage.Data message) {
        String string = message.getId();
        if (string == null) {
            string = "";
        }
        String subscriptionId = string;
        SubscriptionRecord subscriptionRecord = null;
        RealSubscriptionManager realSubscriptionManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realSubscriptionManager) {
            SubscriptionRecord subscriptionRecord2;
            boolean bl3 = false;
            try {
                subscriptionRecord2 = this.subscriptions.get(UUID.fromString(subscriptionId));
            }
            catch (IllegalArgumentException e) {
                subscriptionRecord2 = null;
            }
            subscriptionRecord = subscriptionRecord2;
            Unit unit = Unit.INSTANCE;
        }
        if (subscriptionRecord != null) {
            SubscriptionRecord subscriptionRecord3 = subscriptionRecord;
            if (subscriptionRecord3 == null) {
                Intrinsics.throwNpe();
            }
            Subscription<Operation.Data> subscription = subscriptionRecord3.getSubscription();
            try {
                Response response = MapResponseParser.INSTANCE.parse(message.getPayload(), (Operation)subscription, this.responseAdapterCache);
                SubscriptionRecord subscriptionRecord4 = subscriptionRecord;
                if (subscriptionRecord4 == null) {
                    Intrinsics.throwNpe();
                }
                subscriptionRecord4.notifyOnResponse(response);
            }
            catch (Exception e) {
                subscriptionRecord = this.removeSubscriptionById(subscriptionId);
                if (subscriptionRecord != null) {
                    SubscriptionRecord subscriptionRecord5 = subscriptionRecord;
                    if (subscriptionRecord5 == null) {
                        Intrinsics.throwNpe();
                    }
                    subscriptionRecord5.notifyOnError(new ApolloSubscriptionException("Failed to parse server message", e));
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onConnectionAcknowledgeServerMessage() {
        SubscriptionManagerState oldState = null;
        RealSubscriptionManager realSubscriptionManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realSubscriptionManager) {
            boolean bl3 = false;
            oldState = this.getState();
            this.timer.cancelTask(1);
            if (this.getState() == SubscriptionManagerState.CONNECTED) {
                this.setState(SubscriptionManagerState.ACTIVE);
                for (SubscriptionRecord subscriptionRecord : this.subscriptions.values()) {
                    String string = subscriptionRecord.getId().toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"subscriptionRecord.id.toString()");
                    this.transport.send((OperationClientMessage)new OperationClientMessage.Start(string, subscriptionRecord.getSubscription(), this.responseAdapterCache, this.autoPersistSubscription, false));
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        this.notifyStateChanged(oldState, this.getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onErrorServerMessage(OperationServerMessage.Error message) {
        Error error;
        String string = message.getId();
        if (string == null) {
            string = "";
        }
        String subscriptionId = string;
        SubscriptionRecord subscriptionRecord = this.removeSubscriptionById(subscriptionId);
        boolean resendSubscriptionWithDocument = false;
        boolean bl = this.autoPersistSubscription ? StringsKt.equals((String)PROTOCOL_NEGOTIATION_ERROR_NOT_FOUND, (String)(error = MapResponseParser.INSTANCE.parseError(message.getPayload())).getMessage(), (boolean)true) || StringsKt.equals((String)PROTOCOL_NEGOTIATION_ERROR_NOT_SUPPORTED, (String)error.getMessage(), (boolean)true) : (resendSubscriptionWithDocument = false);
        if (resendSubscriptionWithDocument) {
            RealSubscriptionManager realSubscriptionManager = this;
            boolean bl2 = false;
            boolean bl3 = false;
            synchronized (realSubscriptionManager) {
                boolean bl4 = false;
                this.subscriptions.put(subscriptionRecord.getId(), subscriptionRecord);
                String string2 = subscriptionRecord.getId().toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"subscriptionRecord.id.toString()");
                this.transport.send((OperationClientMessage)new OperationClientMessage.Start(string2, subscriptionRecord.getSubscription(), this.responseAdapterCache, true, true));
                Unit unit = Unit.INSTANCE;
            }
        } else {
            subscriptionRecord.notifyOnError(new ApolloSubscriptionServerException(message.getPayload()));
        }
    }

    private final void onCompleteServerMessage(OperationServerMessage.Complete message) {
        String string = message.getId();
        if (string == null) {
            string = "";
        }
        String subscriptionId = string;
        SubscriptionRecord subscriptionRecord = this.removeSubscriptionById(subscriptionId);
        subscriptionRecord.notifyOnCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SubscriptionRecord removeSubscriptionById(String subscriptionId) {
        SubscriptionRecord subscriptionRecord = null;
        RealSubscriptionManager realSubscriptionManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realSubscriptionManager) {
            SubscriptionRecord subscriptionRecord2;
            boolean bl3 = false;
            try {
                subscriptionRecord2 = this.subscriptions.remove(UUID.fromString(subscriptionId));
            }
            catch (IllegalArgumentException e) {
                subscriptionRecord2 = null;
            }
            subscriptionRecord = subscriptionRecord2;
            if (this.subscriptions.isEmpty()) {
                this.startInactivityTimer();
            }
            Unit unit = Unit.INSTANCE;
        }
        SubscriptionRecord subscriptionRecord3 = subscriptionRecord;
        if (subscriptionRecord3 == null) {
            Intrinsics.throwNpe();
        }
        return subscriptionRecord3;
    }

    private final void notifyStateChanged(SubscriptionManagerState oldState, SubscriptionManagerState newState) {
        if (oldState == newState) {
            return;
        }
        for (OnSubscriptionManagerStateChangeListener onStateChangeListener : this.onStateChangeListeners) {
            onStateChangeListener.onStateChange(oldState, newState);
        }
    }

    public RealSubscriptionManager(@NotNull ResponseAdapterCache responseAdapterCache, @NotNull SubscriptionTransport.Factory transportFactory, @NotNull SubscriptionConnectionParamsProvider connectionParams, @NotNull Executor dispatcher, long connectionHeartbeatTimeoutMs, @NotNull CacheKeyResolver cacheKeyResolver, boolean autoPersistSubscription) {
        Intrinsics.checkParameterIsNotNull((Object)responseAdapterCache, (String)"responseAdapterCache");
        Intrinsics.checkParameterIsNotNull((Object)transportFactory, (String)"transportFactory");
        Intrinsics.checkParameterIsNotNull((Object)connectionParams, (String)"connectionParams");
        Intrinsics.checkParameterIsNotNull((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkParameterIsNotNull((Object)cacheKeyResolver, (String)"cacheKeyResolver");
        this.responseAdapterCache = responseAdapterCache;
        this.connectionParams = connectionParams;
        this.dispatcher = dispatcher;
        this.connectionHeartbeatTimeoutMs = connectionHeartbeatTimeoutMs;
        this.cacheKeyResolver = cacheKeyResolver;
        this.autoPersistSubscription = autoPersistSubscription;
        this.subscriptions = new LinkedHashMap();
        this.state = SubscriptionManagerState.DISCONNECTED;
        this.timer = new AutoReleaseTimer();
        this.transport = transportFactory.create(new SubscriptionTransportCallback(this, this.dispatcher));
        this.connectionAcknowledgeTimeoutTimerTask = new Runnable(this){
            final /* synthetic */ RealSubscriptionManager this$0;

            public final void run() {
                this.this$0.onConnectionAcknowledgeTimeout();
            }
            {
                this.this$0 = realSubscriptionManager;
            }
        };
        this.inactivityTimeoutTimerTask = new Runnable(this){
            final /* synthetic */ RealSubscriptionManager this$0;

            public final void run() {
                this.this$0.onInactivityTimeout();
            }
            {
                this.this$0 = realSubscriptionManager;
            }
        };
        this.connectionHeartbeatTimeoutTimerTask = new Runnable(this){
            final /* synthetic */ RealSubscriptionManager this$0;

            public final void run() {
                this.this$0.onConnectionHeartbeatTimeout();
            }
            {
                this.this$0 = realSubscriptionManager;
            }
        };
        this.onStateChangeListeners = new CopyOnWriteArrayList();
    }

    static {
        Companion = new Companion(null);
        CONNECTION_ACKNOWLEDGE_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
        INACTIVITY_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0010\u0010\u0015\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0014\u0010\u0018\u001a\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001aR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/apollographql/apollo3/internal/subscription/RealSubscriptionManager$SubscriptionRecord;", "", "id", "Ljava/util/UUID;", "subscription", "Lcom/apollographql/apollo3/api/Subscription;", "Lcom/apollographql/apollo3/api/Operation$Data;", "callback", "Lcom/apollographql/apollo3/internal/subscription/SubscriptionManager$Callback;", "(Ljava/util/UUID;Lcom/apollographql/apollo3/api/Subscription;Lcom/apollographql/apollo3/internal/subscription/SubscriptionManager$Callback;)V", "getCallback", "()Lcom/apollographql/apollo3/internal/subscription/SubscriptionManager$Callback;", "getId", "()Ljava/util/UUID;", "getSubscription", "()Lcom/apollographql/apollo3/api/Subscription;", "notifyOnCompleted", "", "notifyOnError", "error", "Lcom/apollographql/apollo3/internal/subscription/ApolloSubscriptionException;", "notifyOnNetworkError", "t", "", "notifyOnResponse", "response", "Lcom/apollographql/apollo3/api/Response;", "apollo-runtime"})
    public static final class SubscriptionRecord {
        @NotNull
        private final UUID id;
        @NotNull
        private final Subscription<Operation.Data> subscription;
        @NotNull
        private final SubscriptionManager.Callback<Operation.Data> callback;

        public final void notifyOnResponse(@Nullable Response<?> response) {
            Response<?> response2 = response;
            if (response2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.apollographql.apollo3.api.Response<com.apollographql.apollo3.api.Operation.Data>");
            }
            this.callback.onResponse(new SubscriptionResponse<Operation.Data>(this.subscription, response2));
        }

        public final void notifyOnError(@Nullable ApolloSubscriptionException error) {
            ApolloSubscriptionException apolloSubscriptionException = error;
            if (apolloSubscriptionException == null) {
                Intrinsics.throwNpe();
            }
            this.callback.onError(apolloSubscriptionException);
        }

        public final void notifyOnNetworkError(@Nullable Throwable t) {
            Throwable throwable = t;
            if (throwable == null) {
                Intrinsics.throwNpe();
            }
            this.callback.onNetworkError(throwable);
        }

        public final void notifyOnCompleted() {
            this.callback.onCompleted();
        }

        @NotNull
        public final UUID getId() {
            return this.id;
        }

        @NotNull
        public final Subscription<Operation.Data> getSubscription() {
            return this.subscription;
        }

        @NotNull
        public final SubscriptionManager.Callback<Operation.Data> getCallback() {
            return this.callback;
        }

        public SubscriptionRecord(@NotNull UUID id, @NotNull Subscription<Operation.Data> subscription, @NotNull SubscriptionManager.Callback<Operation.Data> callback) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            Intrinsics.checkParameterIsNotNull(subscription, (String)"subscription");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.id = id;
            this.subscription = subscription;
            this.callback = callback;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/apollographql/apollo3/internal/subscription/RealSubscriptionManager$SubscriptionTransportCallback;", "Lcom/apollographql/apollo3/subscription/SubscriptionTransport$Callback;", "delegate", "Lcom/apollographql/apollo3/internal/subscription/RealSubscriptionManager;", "dispatcher", "Ljava/util/concurrent/Executor;", "(Lcom/apollographql/apollo3/internal/subscription/RealSubscriptionManager;Ljava/util/concurrent/Executor;)V", "onClosed", "", "onConnected", "onFailure", "t", "", "onMessage", "message", "Lcom/apollographql/apollo3/subscription/OperationServerMessage;", "apollo-runtime"})
    private static final class SubscriptionTransportCallback
    implements SubscriptionTransport.Callback {
        private final RealSubscriptionManager delegate;
        private final Executor dispatcher;

        @Override
        public void onConnected() {
            this.dispatcher.execute(new Runnable(this){
                final /* synthetic */ SubscriptionTransportCallback this$0;

                public final void run() {
                    SubscriptionTransportCallback.access$getDelegate$p(this.this$0).onTransportConnected();
                }
                {
                    this.this$0 = subscriptionTransportCallback;
                }
            });
        }

        @Override
        public void onFailure(@NotNull Throwable t) {
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            this.dispatcher.execute(new Runnable(this, t){
                final /* synthetic */ SubscriptionTransportCallback this$0;
                final /* synthetic */ Throwable $t;

                public final void run() {
                    SubscriptionTransportCallback.access$getDelegate$p(this.this$0).onTransportFailure(this.$t);
                }
                {
                    this.this$0 = subscriptionTransportCallback;
                    this.$t = throwable;
                }
            });
        }

        @Override
        public void onMessage(@NotNull OperationServerMessage message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.dispatcher.execute(new Runnable(this, message){
                final /* synthetic */ SubscriptionTransportCallback this$0;
                final /* synthetic */ OperationServerMessage $message;

                public final void run() {
                    SubscriptionTransportCallback.access$getDelegate$p(this.this$0).onOperationServerMessage(this.$message);
                }
                {
                    this.this$0 = subscriptionTransportCallback;
                    this.$message = operationServerMessage;
                }
            });
        }

        @Override
        public void onClosed() {
            this.dispatcher.execute(new Runnable(this){
                final /* synthetic */ SubscriptionTransportCallback this$0;

                public final void run() {
                    SubscriptionTransportCallback.access$getDelegate$p(this.this$0).onConnectionClosed();
                }
                {
                    this.this$0 = subscriptionTransportCallback;
                }
            });
        }

        public SubscriptionTransportCallback(@NotNull RealSubscriptionManager delegate, @NotNull Executor dispatcher) {
            Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
            Intrinsics.checkParameterIsNotNull((Object)dispatcher, (String)"dispatcher");
            this.delegate = delegate;
            this.dispatcher = dispatcher;
        }

        public static final /* synthetic */ RealSubscriptionManager access$getDelegate$p(SubscriptionTransportCallback $this) {
            return $this.delegate;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005J\u001e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/apollographql/apollo3/internal/subscription/RealSubscriptionManager$AutoReleaseTimer;", "", "()V", "tasks", "", "", "Ljava/util/TimerTask;", "getTasks", "()Ljava/util/Map;", "timer", "Ljava/util/Timer;", "getTimer", "()Ljava/util/Timer;", "setTimer", "(Ljava/util/Timer;)V", "cancelTask", "", "taskId", "schedule", "task", "Ljava/lang/Runnable;", "delay", "", "apollo-runtime"})
    public static final class AutoReleaseTimer {
        @NotNull
        private final Map<Integer, TimerTask> tasks = new LinkedHashMap();
        @Nullable
        private Timer timer;

        @NotNull
        public final Map<Integer, TimerTask> getTasks() {
            return this.tasks;
        }

        @Nullable
        public final Timer getTimer() {
            return this.timer;
        }

        public final void setTimer(@Nullable Timer timer) {
            this.timer = timer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void schedule(int taskId, @NotNull Runnable task, long delay) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            TimerTask timerTask2 = new TimerTask(this, task, taskId){
                final /* synthetic */ AutoReleaseTimer this$0;
                final /* synthetic */ Runnable $task;
                final /* synthetic */ int $taskId;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        this.$task.run();
                    }
                    finally {
                        this.this$0.cancelTask(this.$taskId);
                    }
                }
                {
                    this.this$0 = this$0;
                    this.$task = $captured_local_variable$1;
                    this.$taskId = $captured_local_variable$2;
                }
            };
            AutoReleaseTimer autoReleaseTimer = this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (autoReleaseTimer) {
                TimerTask previousTimerTask;
                boolean bl3 = false;
                TimerTask timerTask3 = previousTimerTask = this.tasks.put(taskId, timerTask2);
                if (timerTask3 != null) {
                    timerTask3.cancel();
                }
                if (this.timer == null) {
                    this.timer = new Timer("Subscription SmartTimer", true);
                }
                Timer timer = this.timer;
                if (timer == null) {
                    Intrinsics.throwNpe();
                }
                timer.schedule(timerTask2, delay);
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void cancelTask(int taskId) {
            AutoReleaseTimer autoReleaseTimer = this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (autoReleaseTimer) {
                TimerTask timerTask2;
                boolean bl3 = false;
                TimerTask timerTask3 = timerTask2 = this.tasks.remove(taskId);
                if (timerTask3 != null) {
                    timerTask3.cancel();
                }
                if (this.tasks.isEmpty() && this.timer != null) {
                    Timer timer = this.timer;
                    if (timer == null) {
                        Intrinsics.throwNpe();
                    }
                    timer.cancel();
                    this.timer = null;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0006R\u000e\u0010\f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/apollographql/apollo3/internal/subscription/RealSubscriptionManager$Companion;", "", "()V", "CONNECTION_ACKNOWLEDGE_TIMEOUT", "", "getCONNECTION_ACKNOWLEDGE_TIMEOUT", "()J", "CONNECTION_ACKNOWLEDGE_TIMEOUT_TIMER_TASK_ID", "", "CONNECTION_KEEP_ALIVE_TIMEOUT_TIMER_TASK_ID", "INACTIVITY_TIMEOUT", "getINACTIVITY_TIMEOUT", "INACTIVITY_TIMEOUT_TIMER_TASK_ID", "PROTOCOL_NEGOTIATION_ERROR_NOT_FOUND", "", "PROTOCOL_NEGOTIATION_ERROR_NOT_SUPPORTED", "apollo-runtime"})
    public static final class Companion {
        public final long getCONNECTION_ACKNOWLEDGE_TIMEOUT() {
            return CONNECTION_ACKNOWLEDGE_TIMEOUT;
        }

        public final long getINACTIVITY_TIMEOUT() {
            return INACTIVITY_TIMEOUT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

