/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.internal.fetcher;

import com.apollographql.apollo3.api.internal.ApolloLogger;
import com.apollographql.apollo3.exception.ApolloException;
import com.apollographql.apollo3.fetcher.ResponseFetcher;
import com.apollographql.apollo3.interceptor.ApolloInterceptor;
import com.apollographql.apollo3.interceptor.ApolloInterceptorChain;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/apollographql/apollo3/internal/fetcher/CacheFirstFetcher;", "Lcom/apollographql/apollo3/fetcher/ResponseFetcher;", "()V", "provideInterceptor", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor;", "apolloLogger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "CacheFirstInterceptor", "apollo-runtime"})
public final class CacheFirstFetcher
implements ResponseFetcher {
    @Override
    @NotNull
    public ApolloInterceptor provideInterceptor(@Nullable ApolloLogger apolloLogger) {
        return new CacheFirstInterceptor();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/apollographql/apollo3/internal/fetcher/CacheFirstFetcher$CacheFirstInterceptor;", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor;", "()V", "disposed", "", "getDisposed", "()Z", "setDisposed", "(Z)V", "dispose", "", "interceptAsync", "request", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$InterceptorRequest;", "chain", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptorChain;", "dispatcher", "Ljava/util/concurrent/Executor;", "callBack", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$CallBack;", "apollo-runtime"})
    private static final class CacheFirstInterceptor
    implements ApolloInterceptor {
        private volatile boolean disposed;

        public final boolean getDisposed() {
            return this.disposed;
        }

        public final void setDisposed(boolean bl) {
            this.disposed = bl;
        }

        @Override
        public void interceptAsync(@NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptorChain chain, @NotNull Executor dispatcher, @NotNull ApolloInterceptor.CallBack callBack) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
            Intrinsics.checkParameterIsNotNull((Object)dispatcher, (String)"dispatcher");
            Intrinsics.checkParameterIsNotNull((Object)callBack, (String)"callBack");
            ApolloInterceptor.InterceptorRequest cacheRequest = request.toBuilder().fetchFromCache(true).build();
            chain.proceedAsync(cacheRequest, dispatcher, new ApolloInterceptor.CallBack(this, callBack, request, chain, dispatcher){
                final /* synthetic */ CacheFirstInterceptor this$0;
                final /* synthetic */ ApolloInterceptor.CallBack $callBack;
                final /* synthetic */ ApolloInterceptor.InterceptorRequest $request;
                final /* synthetic */ ApolloInterceptorChain $chain;
                final /* synthetic */ Executor $dispatcher;

                public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                    Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                    this.$callBack.onResponse(response);
                }

                public void onFailure(@NotNull ApolloException e) {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    if (!this.this$0.getDisposed()) {
                        ApolloInterceptor.InterceptorRequest networkRequest = this.$request.toBuilder().fetchFromCache(false).build();
                        this.$chain.proceedAsync(networkRequest, this.$dispatcher, this.$callBack);
                    }
                }

                public void onCompleted() {
                    this.$callBack.onCompleted();
                }

                public void onFetch(@NotNull ApolloInterceptor.FetchSourceType sourceType) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)sourceType), (String)"sourceType");
                    this.$callBack.onFetch(sourceType);
                }
                {
                    this.this$0 = this$0;
                    this.$callBack = $captured_local_variable$1;
                    this.$request = $captured_local_variable$2;
                    this.$chain = $captured_local_variable$3;
                    this.$dispatcher = $captured_local_variable$4;
                }
            });
        }

        @Override
        public void dispose() {
            this.disposed = true;
        }
    }
}

