/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.internal.interceptor;

import com.apollographql.apollo3.ApolloCall;
import com.apollographql.apollo3.ResponseExtensionsKt;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.CustomScalarAdapters;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.exception.ApolloException;
import com.apollographql.apollo3.api.exception.ApolloGenericException;
import com.apollographql.apollo3.api.internal.ApolloLogger;
import com.apollographql.apollo3.cache.CacheHeaders;
import com.apollographql.apollo3.cache.normalized.ApolloStore;
import com.apollographql.apollo3.cache.normalized.Record;
import com.apollographql.apollo3.cache.normalized.internal.RealApolloStore;
import com.apollographql.apollo3.interceptor.ApolloInterceptor;
import com.apollographql.apollo3.interceptor.ApolloInterceptorChain;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B;\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0014\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010#\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010$\u001a\u00020\"H\u0016J(\u0010%\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)H\u0016J\u0016\u0010*\u001a\u00020\"2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bJ\u000e\u0010,\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010.\u001a\u00020\u0013J\u0010\u0010/\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/apollographql/apollo3/internal/interceptor/ApolloCacheInterceptor;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor;", "apolloStore", "Lcom/apollographql/apollo3/cache/normalized/ApolloStore;", "dispatcher", "Ljava/util/concurrent/Executor;", "logger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "responseCallback", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/apollographql/apollo3/ApolloCall$Callback;", "customScalarAdapters", "Lcom/apollographql/apollo3/api/CustomScalarAdapters;", "(Lcom/apollographql/apollo3/cache/normalized/ApolloStore;Ljava/util/concurrent/Executor;Lcom/apollographql/apollo3/api/internal/ApolloLogger;Ljava/util/concurrent/atomic/AtomicReference;Lcom/apollographql/apollo3/api/CustomScalarAdapters;)V", "getApolloStore", "()Lcom/apollographql/apollo3/cache/normalized/ApolloStore;", "disposed", "", "getDisposed", "()Z", "setDisposed", "(Z)V", "getLogger", "()Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "cacheResponse", "", "", "networkResponse", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$InterceptorResponse;", "request", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$InterceptorRequest;", "cacheResponseAndPublish", "", "cacheResponseAndPublishSynchronously", "dispose", "interceptAsync", "chain", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptorChain;", "callBack", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$CallBack;", "publishCacheKeys", "cacheKeys", "resolveFromCache", "rollbackOptimisticUpdates", "publish", "writeOptimisticUpdatesAndPublish", "apollo-runtime"})
public final class ApolloCacheInterceptor<D extends Operation.Data>
implements ApolloInterceptor {
    @NotNull
    private final ApolloStore apolloStore;
    @NotNull
    private final Executor dispatcher;
    @NotNull
    private final ApolloLogger logger;
    @NotNull
    private final AtomicReference<ApolloCall.Callback<D>> responseCallback;
    @NotNull
    private final CustomScalarAdapters customScalarAdapters;
    private volatile boolean disposed;

    public ApolloCacheInterceptor(@NotNull ApolloStore apolloStore, @NotNull Executor dispatcher, @NotNull ApolloLogger logger, @NotNull AtomicReference<ApolloCall.Callback<D>> responseCallback, @NotNull CustomScalarAdapters customScalarAdapters) {
        Intrinsics.checkNotNullParameter((Object)apolloStore, (String)"apolloStore");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(responseCallback, (String)"responseCallback");
        Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
        this.apolloStore = apolloStore;
        this.dispatcher = dispatcher;
        this.logger = logger;
        this.responseCallback = responseCallback;
        this.customScalarAdapters = customScalarAdapters;
    }

    @NotNull
    public final ApolloStore getApolloStore() {
        return this.apolloStore;
    }

    @NotNull
    public final ApolloLogger getLogger() {
        return this.logger;
    }

    public final boolean getDisposed() {
        return this.disposed;
    }

    public final void setDisposed(boolean bl) {
        this.disposed = bl;
    }

    @Override
    public void interceptAsync(@NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptorChain chain, @NotNull Executor dispatcher, @NotNull ApolloInterceptor.CallBack callBack) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        dispatcher.execute(() -> ApolloCacheInterceptor.interceptAsync$lambda-0(this, request, callBack, chain, dispatcher));
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }

    @NotNull
    public final ApolloInterceptor.InterceptorResponse resolveFromCache(@NotNull ApolloInterceptor.InterceptorRequest request) throws ApolloException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Operation.Data data2 = (Operation.Data)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Operation.Data>, Object>(request, this, null){
            int label;
            final /* synthetic */ ApolloInterceptor.InterceptorRequest $request;
            final /* synthetic */ ApolloCacheInterceptor<D> this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Operation<?> operation = this.$request.getOperation();
                        CacheHeaders cacheHeaders = this.$request.getCacheHeaders();
                        CustomScalarAdapters customScalarAdapters = ApolloCacheInterceptor.access$getCustomScalarAdapters$p(this.this$0);
                        this.label = 1;
                        Object object3 = this.this$0.getApolloStore().readOperation(operation, customScalarAdapters, cacheHeaders, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Operation.Data> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        if (data2 != null) {
            Object[] objectArray = new Object[]{request.getOperation().name()};
            this.logger.d("Cache HIT for operation %s", objectArray);
            boolean $i$f$uuid4 = false;
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"UUID.randomUUID()");
            return new ApolloInterceptor.InterceptorResponse(null, ResponseExtensionsKt.withCacheInfo(new ApolloResponse(uUID, request.getOperation(), data2, null, null, null, 56, null), true));
        }
        Object[] objectArray = new Object[]{request.getOperation().name()};
        this.logger.d("Cache MISS for operation %s", objectArray);
        objectArray = StringCompanionObject.INSTANCE;
        String string = "Cache miss for operation %s";
        Object[] objectArray2 = new Object[]{request.getOperation().name()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        throw new ApolloGenericException(string2, null, 2, null);
    }

    private final Set<String> cacheResponse(ApolloInterceptor.InterceptorResponse networkResponse, ApolloInterceptor.InterceptorRequest request) {
        Set set;
        if (networkResponse.parsedResponse.isPresent()) {
            ApolloResponse<?> apolloResponse = networkResponse.parsedResponse.get();
            Intrinsics.checkNotNull(apolloResponse);
            if (apolloResponse.hasErrors() && !request.getCacheHeaders().hasHeader("store-partial-responses")) {
                return SetsKt.emptySet();
            }
        }
        Pair pair = networkResponse.parsedResponse.get();
        Intrinsics.checkNotNull(pair);
        Operation.Data data2 = pair.getData();
        if (data2 != null && this.apolloStore instanceof RealApolloStore) {
            pair = (Pair)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends Set<? extends Record>, ? extends Set<? extends String>>>, Object>(this, request, data2, null){
                int label;
                final /* synthetic */ ApolloCacheInterceptor<D> this$0;
                final /* synthetic */ ApolloInterceptor.InterceptorRequest $request;
                final /* synthetic */ Operation.Data $data;
                {
                    this.this$0 = $receiver;
                    this.$request = $request;
                    this.$data = $data;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = ((RealApolloStore)this.this$0.getApolloStore()).writeOperationWithRecords(this.$request.getOperation(), this.$data, this.$request.getCacheHeaders(), false, ApolloCacheInterceptor.access$getCustomScalarAdapters$p(this.this$0), (Continuation)this);
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Pair<? extends Set<Record>, ? extends Set<String>>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            Set records = (Set)pair.component1();
            Set changedKeys = (Set)pair.component2();
            ApolloCall.Callback<D> callback = this.responseCallback.get();
            if (callback != null) {
                callback.onCached(CollectionsKt.toList((Iterable)records));
            }
            set = changedKeys;
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    public final void cacheResponseAndPublish(@NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptor.InterceptorResponse networkResponse) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)networkResponse, (String)"networkResponse");
        if (request.getWriteToCacheAsynchronously()) {
            this.dispatcher.execute(() -> ApolloCacheInterceptor.cacheResponseAndPublish$lambda-1(this, request, networkResponse));
        } else {
            this.cacheResponseAndPublishSynchronously(request, networkResponse);
        }
    }

    private final void cacheResponseAndPublishSynchronously(ApolloInterceptor.InterceptorRequest request, ApolloInterceptor.InterceptorResponse networkResponse) {
        try {
            Set<String> networkResponseCacheKeys = this.cacheResponse(networkResponse, request);
            Set<String> rolledBackCacheKeys = this.rollbackOptimisticUpdates(request, false);
            this.publishCacheKeys(SetsKt.plus(rolledBackCacheKeys, (Iterable)networkResponseCacheKeys));
        }
        catch (Exception rethrow) {
            this.rollbackOptimisticUpdates(request, true);
            throw rethrow;
        }
    }

    private final void writeOptimisticUpdatesAndPublish(ApolloInterceptor.InterceptorRequest request) {
        this.dispatcher.execute(() -> ApolloCacheInterceptor.writeOptimisticUpdatesAndPublish$lambda-2(request, this));
    }

    @NotNull
    public final Set<String> rollbackOptimisticUpdates(@NotNull ApolloInterceptor.InterceptorRequest request, boolean publish) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            set = (Set)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Set<? extends String>>, Object>(this, request, publish, null){
                int label;
                final /* synthetic */ ApolloCacheInterceptor<D> this$0;
                final /* synthetic */ ApolloInterceptor.InterceptorRequest $request;
                final /* synthetic */ boolean $publish;
                {
                    this.this$0 = $receiver;
                    this.$request = $request;
                    this.$publish = $publish;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ApolloStore apolloStore = this.this$0.getApolloStore();
                            UUID uUID = this.$request.getUniqueId();
                            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"request.uniqueId");
                            this.label = 1;
                            Object object3 = apolloStore.rollbackOptimisticUpdates(uUID, this.$publish, (Continuation)this);
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Set<String>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{request.getOperation()};
            this.logger.e((Throwable)e, "failed to rollback operation optimistic updates, for: %s", objectArray);
            set = SetsKt.emptySet();
        }
        return set;
    }

    public final void publishCacheKeys(@Nullable Set<String> cacheKeys) {
        this.dispatcher.execute(() -> ApolloCacheInterceptor.publishCacheKeys$lambda-3(this, cacheKeys));
    }

    private static final void interceptAsync$lambda-0(ApolloCacheInterceptor this$0, ApolloInterceptor.InterceptorRequest $request, ApolloInterceptor.CallBack $callBack, ApolloInterceptorChain $chain, Executor $dispatcher) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)$callBack, (String)"$callBack");
        Intrinsics.checkNotNullParameter((Object)$chain, (String)"$chain");
        Intrinsics.checkNotNullParameter((Object)$dispatcher, (String)"$dispatcher");
        if (this$0.getDisposed()) {
            return;
        }
        if ($request.getFetchFromCache()) {
            $callBack.onFetch(ApolloInterceptor.FetchSourceType.CACHE);
            ApolloInterceptor.InterceptorResponse cachedResponse = null;
            try {
                cachedResponse = this$0.resolveFromCache($request);
                $callBack.onResponse(cachedResponse);
                $callBack.onCompleted();
            }
            catch (ApolloException e) {
                $callBack.onFailure(e);
            }
        } else {
            this$0.writeOptimisticUpdatesAndPublish($request);
            $chain.proceedAsync($request, $dispatcher, new ApolloInterceptor.CallBack(this$0, $request, $callBack){
                final /* synthetic */ ApolloCacheInterceptor<D> this$0;
                final /* synthetic */ ApolloInterceptor.InterceptorRequest $request;
                final /* synthetic */ ApolloInterceptor.CallBack $callBack;
                {
                    this.this$0 = $receiver;
                    this.$request = $request;
                    this.$callBack = $callBack;
                }

                public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    if (this.this$0.getDisposed()) {
                        return;
                    }
                    this.this$0.cacheResponseAndPublish(this.$request, response);
                    this.$callBack.onResponse(response);
                    this.$callBack.onCompleted();
                }

                public void onFailure(@NotNull ApolloException e) {
                    Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
                    this.this$0.rollbackOptimisticUpdates(this.$request, true);
                    this.$callBack.onFailure(e);
                }

                public void onCompleted() {
                }

                public void onFetch(@NotNull ApolloInterceptor.FetchSourceType sourceType) {
                    Intrinsics.checkNotNullParameter((Object)((Object)sourceType), (String)"sourceType");
                    this.$callBack.onFetch(sourceType);
                }
            });
        }
    }

    private static final void cacheResponseAndPublish$lambda-1(ApolloCacheInterceptor this$0, ApolloInterceptor.InterceptorRequest $request, ApolloInterceptor.InterceptorResponse $networkResponse) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)$networkResponse, (String)"$networkResponse");
        this$0.cacheResponseAndPublishSynchronously($request, $networkResponse);
    }

    private static final void writeOptimisticUpdatesAndPublish$lambda-2(ApolloInterceptor.InterceptorRequest $request, ApolloCacheInterceptor this$0) {
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            if ($request.getOptimisticUpdates().isPresent()) {
                Operation.Data optimisticUpdates = $request.getOptimisticUpdates().get();
                BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Set<? extends String>>, Object>(this$0, $request, optimisticUpdates, null){
                    int label;
                    final /* synthetic */ ApolloCacheInterceptor<D> this$0;
                    final /* synthetic */ ApolloInterceptor.InterceptorRequest $request;
                    final /* synthetic */ Operation.Data $optimisticUpdates;
                    {
                        this.this$0 = $receiver;
                        this.$request = $request;
                        this.$optimisticUpdates = $optimisticUpdates;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                ApolloStore apolloStore = this.this$0.getApolloStore();
                                Operation<?> operation = this.$request.getOperation();
                                UUID uUID = this.$request.getUniqueId();
                                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"request.uniqueId");
                                this.label = 1;
                                Object object3 = apolloStore.writeOptimisticUpdates(operation, this.$optimisticUpdates, uUID, ApolloCacheInterceptor.access$getCustomScalarAdapters$p(this.this$0), true, (Continuation)this);
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Set<String>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
            }
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{$request.getOperation()};
            this$0.getLogger().e((Throwable)e, "failed to write operation optimistic updates, for: %s", objectArray);
        }
    }

    private static final void publishCacheKeys$lambda-3(ApolloCacheInterceptor this$0, Set $cacheKeys) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, (Set<String>)$cacheKeys, null){
                int label;
                final /* synthetic */ ApolloCacheInterceptor<D> this$0;
                final /* synthetic */ Set<String> $cacheKeys;
                {
                    this.this$0 = $receiver;
                    this.$cacheKeys = $cacheKeys;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ApolloStore apolloStore = this.this$0.getApolloStore();
                            Intrinsics.checkNotNull(this.$cacheKeys);
                            this.label = 1;
                            Object object3 = apolloStore.publish(this.$cacheKeys, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
        catch (Exception e) {
            this$0.getLogger().e((Throwable)e, "Failed to publish cache changes", new Object[0]);
        }
    }

    public static final /* synthetic */ CustomScalarAdapters access$getCustomScalarAdapters$p(ApolloCacheInterceptor $this) {
        return $this.customScalarAdapters;
    }
}

