/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.internal;

import com.apollographql.apollo3.ApolloSubscriptionCall;
import com.apollographql.apollo3.ResponseExtensionsKt;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.CustomScalarAdapters;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.Subscription;
import com.apollographql.apollo3.api.exception.ApolloCanceledException;
import com.apollographql.apollo3.api.exception.ApolloException;
import com.apollographql.apollo3.api.exception.ApolloNetworkException;
import com.apollographql.apollo3.api.internal.ApolloLogger;
import com.apollographql.apollo3.cache.CacheHeaders;
import com.apollographql.apollo3.cache.normalized.ApolloStore;
import com.apollographql.apollo3.internal.CallState;
import com.apollographql.apollo3.internal.subscription.ApolloSubscriptionException;
import com.apollographql.apollo3.internal.subscription.SubscriptionManager;
import com.apollographql.apollo3.internal.subscription.SubscriptionResponse;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001%BC\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J\u0016\u0010\u001f\u001a\u00020\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0016J\u0010\u0010\"\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010#H\u0002J\b\u0010$\u001a\u00020\u001dH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00180\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/apollographql/apollo3/internal/RealApolloSubscriptionCall;", "D", "Lcom/apollographql/apollo3/api/Subscription$Data;", "Lcom/apollographql/apollo3/ApolloSubscriptionCall;", "subscription", "Lcom/apollographql/apollo3/api/Subscription;", "subscriptionManager", "Lcom/apollographql/apollo3/internal/subscription/SubscriptionManager;", "apolloStore", "Lcom/apollographql/apollo3/cache/normalized/ApolloStore;", "cachePolicy", "Lcom/apollographql/apollo3/ApolloSubscriptionCall$CachePolicy;", "dispatcher", "Ljava/util/concurrent/Executor;", "logger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "customScalarAdapters", "Lcom/apollographql/apollo3/api/CustomScalarAdapters;", "(Lcom/apollographql/apollo3/api/Subscription;Lcom/apollographql/apollo3/internal/subscription/SubscriptionManager;Lcom/apollographql/apollo3/cache/normalized/ApolloStore;Lcom/apollographql/apollo3/ApolloSubscriptionCall$CachePolicy;Ljava/util/concurrent/Executor;Lcom/apollographql/apollo3/api/internal/ApolloLogger;Lcom/apollographql/apollo3/api/CustomScalarAdapters;)V", "isCanceled", "", "()Z", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/apollographql/apollo3/internal/CallState;", "kotlin.jvm.PlatformType", "subscriptionCallback", "Lcom/apollographql/apollo3/internal/RealApolloSubscriptionCall$SubscriptionManagerCallback;", "cancel", "", "clone", "execute", "callback", "Lcom/apollographql/apollo3/ApolloSubscriptionCall$Callback;", "resolveFromCache", "Lcom/apollographql/apollo3/api/ApolloResponse;", "terminate", "SubscriptionManagerCallback", "apollo-runtime"})
public final class RealApolloSubscriptionCall<D extends Subscription.Data>
implements ApolloSubscriptionCall<D> {
    @NotNull
    private final Subscription<D> subscription;
    @NotNull
    private final SubscriptionManager subscriptionManager;
    @NotNull
    private final ApolloStore apolloStore;
    @NotNull
    private final ApolloSubscriptionCall.CachePolicy cachePolicy;
    @NotNull
    private final Executor dispatcher;
    @NotNull
    private final ApolloLogger logger;
    @NotNull
    private final CustomScalarAdapters customScalarAdapters;
    @NotNull
    private final AtomicReference<CallState> state;
    @Nullable
    private SubscriptionManagerCallback<D> subscriptionCallback;

    public RealApolloSubscriptionCall(@NotNull Subscription<D> subscription, @NotNull SubscriptionManager subscriptionManager, @NotNull ApolloStore apolloStore, @NotNull ApolloSubscriptionCall.CachePolicy cachePolicy, @NotNull Executor dispatcher, @NotNull ApolloLogger logger, @NotNull CustomScalarAdapters customScalarAdapters) {
        Intrinsics.checkNotNullParameter(subscription, (String)"subscription");
        Intrinsics.checkNotNullParameter((Object)subscriptionManager, (String)"subscriptionManager");
        Intrinsics.checkNotNullParameter((Object)apolloStore, (String)"apolloStore");
        Intrinsics.checkNotNullParameter((Object)((Object)cachePolicy), (String)"cachePolicy");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
        this.subscription = subscription;
        this.subscriptionManager = subscriptionManager;
        this.apolloStore = apolloStore;
        this.cachePolicy = cachePolicy;
        this.dispatcher = dispatcher;
        this.logger = logger;
        this.customScalarAdapters = customScalarAdapters;
        this.state = new AtomicReference<CallState>(CallState.IDLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(@NotNull ApolloSubscriptionCall.Callback<D> callback) throws ApolloCanceledException {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this) {
            boolean bl3 = false;
            CallState callState = this.state.get();
            int n = callState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[callState.ordinal()];
            switch (n) {
                case 1: {
                    this.state.set(CallState.ACTIVE);
                    if (this.cachePolicy == ApolloSubscriptionCall.CachePolicy.CACHE_AND_NETWORK) {
                        this.dispatcher.execute(() -> RealApolloSubscriptionCall.execute$lambda-1$lambda-0(this, callback));
                    }
                    SubscriptionManagerCallback<D> subscriptionManagerCallback = this.subscriptionCallback = new SubscriptionManagerCallback<D>(callback, this);
                    Intrinsics.checkNotNull(subscriptionManagerCallback);
                    this.subscriptionManager.subscribe(this.subscription, subscriptionManagerCallback);
                    break;
                }
                case 2: {
                    throw new ApolloCanceledException(null, null, 3, null);
                }
                case 3: 
                case 4: {
                    throw new IllegalStateException("Already Executed");
                }
                default: {
                    throw new IllegalStateException("Unknown state");
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this) {
            boolean bl3 = false;
            CallState callState = this.state.get();
            int n = callState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[callState.ordinal()];
            switch (n) {
                case 1: {
                    this.state.set(CallState.CANCELED);
                    break;
                }
                case 4: {
                    try {
                        this.subscriptionManager.unsubscribe(this.subscription);
                        break;
                    }
                    finally {
                        this.state.set(CallState.CANCELED);
                        SubscriptionManagerCallback<D> subscriptionManagerCallback = this.subscriptionCallback;
                        Intrinsics.checkNotNull(subscriptionManagerCallback);
                        subscriptionManagerCallback.release();
                    }
                }
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state");
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    @NotNull
    public ApolloSubscriptionCall<D> clone() {
        return new RealApolloSubscriptionCall<D>(this.subscription, this.subscriptionManager, this.apolloStore, this.cachePolicy, this.dispatcher, this.logger, this.customScalarAdapters);
    }

    @Override
    public boolean isCanceled() {
        return this.state.get() == CallState.CANCELED;
    }

    @Override
    @NotNull
    public ApolloSubscriptionCall<D> cachePolicy(@NotNull ApolloSubscriptionCall.CachePolicy cachePolicy) {
        Intrinsics.checkNotNullParameter((Object)((Object)cachePolicy), (String)"cachePolicy");
        return new RealApolloSubscriptionCall<D>(this.subscription, this.subscriptionManager, this.apolloStore, cachePolicy, this.dispatcher, this.logger, this.customScalarAdapters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void terminate() {
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this) {
            boolean bl3 = false;
            CallState callState = this.state.get();
            int n = callState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[callState.ordinal()];
            switch (n) {
                case 4: {
                    this.state.set(CallState.TERMINATED);
                    SubscriptionManagerCallback<D> subscriptionManagerCallback = this.subscriptionCallback;
                    Intrinsics.checkNotNull(subscriptionManagerCallback);
                    subscriptionManagerCallback.release();
                    break;
                }
                case 2: {
                    break;
                }
                case 1: 
                case 3: {
                    CallState[] callStateArray = this.state.get();
                    Intrinsics.checkNotNullExpressionValue((Object)callStateArray, (String)"state.get()");
                    CallState.IllegalStateMessage illegalStateMessage = CallState.IllegalStateMessage.Companion.forCurrentState((CallState)callStateArray);
                    callStateArray = new CallState[]{CallState.ACTIVE, CallState.CANCELED};
                    throw new IllegalStateException(illegalStateMessage.expected(callStateArray));
                }
                default: {
                    throw new IllegalStateException("Unknown state");
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final ApolloResponse<D> resolveFromCache() {
        ApolloResponse apolloResponse;
        Subscription.Data data2 = (Subscription.Data)BuildersKt.runBlocking$default(null, (Function2)new Function2<CoroutineScope, Continuation<? super D>, Object>(this, null){
            int label;
            final /* synthetic */ RealApolloSubscriptionCall<D> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = RealApolloSubscriptionCall.access$getApolloStore$p(this.this$0).readOperation((Operation)RealApolloSubscriptionCall.access$getSubscription$p(this.this$0), RealApolloSubscriptionCall.access$getCustomScalarAdapters$p(this.this$0), CacheHeaders.NONE, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super D> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, (int)1, null);
        if (data2 != null) {
            Object[] objectArray = new Object[]{this.subscription};
            this.logger.d("Cache HIT for subscription `%s`", objectArray);
            boolean $i$f$uuid4 = false;
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"UUID.randomUUID()");
            apolloResponse = ResponseExtensionsKt.withCacheInfo(new ApolloResponse(uUID, (Operation)this.subscription, (Operation.Data)data2, null, null, null, 56, null), true);
        } else {
            Object[] objectArray = new Object[]{this.subscription};
            this.logger.d("Cache MISS for subscription `%s`", objectArray);
            apolloResponse = null;
        }
        return apolloResponse;
    }

    private static final void execute$lambda-1$lambda-0(RealApolloSubscriptionCall this$0, ApolloSubscriptionCall.Callback $callback) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        ApolloResponse cachedResponse = this$0.resolveFromCache();
        if (cachedResponse != null) {
            $callback.onResponse(cachedResponse);
        }
    }

    public static final /* synthetic */ ApolloStore access$getApolloStore$p(RealApolloSubscriptionCall $this) {
        return $this.apolloStore;
    }

    public static final /* synthetic */ Subscription access$getSubscription$p(RealApolloSubscriptionCall $this) {
        return $this.subscription;
    }

    public static final /* synthetic */ CustomScalarAdapters access$getCustomScalarAdapters$p(RealApolloSubscriptionCall $this) {
        return $this.customScalarAdapters;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B%\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J\u0006\u0010\u0016\u001a\u00020\nJ\u0006\u0010\u0017\u001a\u00020\nR\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/apollographql/apollo3/internal/RealApolloSubscriptionCall$SubscriptionManagerCallback;", "D", "Lcom/apollographql/apollo3/api/Subscription$Data;", "Lcom/apollographql/apollo3/internal/subscription/SubscriptionManager$Callback;", "originalCallback", "Lcom/apollographql/apollo3/ApolloSubscriptionCall$Callback;", "delegate", "Lcom/apollographql/apollo3/internal/RealApolloSubscriptionCall;", "(Lcom/apollographql/apollo3/ApolloSubscriptionCall$Callback;Lcom/apollographql/apollo3/internal/RealApolloSubscriptionCall;)V", "onCompleted", "", "onConnected", "onError", "error", "Lcom/apollographql/apollo3/internal/subscription/ApolloSubscriptionException;", "onNetworkError", "t", "", "onResponse", "response", "Lcom/apollographql/apollo3/internal/subscription/SubscriptionResponse;", "onTerminated", "release", "terminate", "apollo-runtime"})
    private static final class SubscriptionManagerCallback<D extends Subscription.Data>
    implements SubscriptionManager.Callback<D> {
        @Nullable
        private ApolloSubscriptionCall.Callback<D> originalCallback;
        @Nullable
        private RealApolloSubscriptionCall<D> delegate;

        public SubscriptionManagerCallback(@Nullable ApolloSubscriptionCall.Callback<D> originalCallback, @Nullable RealApolloSubscriptionCall<D> delegate) {
            this.originalCallback = originalCallback;
            this.delegate = delegate;
        }

        @Override
        public void onResponse(@NotNull SubscriptionResponse<D> response) {
            Intrinsics.checkNotNullParameter(response, (String)"response");
            ApolloSubscriptionCall.Callback<D> callback = this.originalCallback;
            Subscription.Data data2 = (Subscription.Data)response.getResponse().getData();
            if (callback != null) {
                if (data2 != null) {
                    RealApolloSubscriptionCall<D> realApolloSubscriptionCall = this.delegate;
                    Intrinsics.checkNotNull(realApolloSubscriptionCall);
                    if (((RealApolloSubscriptionCall)realApolloSubscriptionCall).cachePolicy != ApolloSubscriptionCall.CachePolicy.NO_CACHE) {
                        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Set<? extends String>>, Object>(this, response, data2, null){
                            int label;
                            final /* synthetic */ SubscriptionManagerCallback<D> this$0;
                            final /* synthetic */ SubscriptionResponse<D> $response;
                            final /* synthetic */ D $data;
                            {
                                this.this$0 = $receiver;
                                this.$response = $response;
                                this.$data = $data;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        RealApolloSubscriptionCall realApolloSubscriptionCall = SubscriptionManagerCallback.access$getDelegate$p(this.this$0);
                                        Intrinsics.checkNotNull((Object)realApolloSubscriptionCall);
                                        ApolloStore apolloStore = RealApolloSubscriptionCall.access$getApolloStore$p(realApolloSubscriptionCall);
                                        Operation operation = (Operation)this.$response.getSubscription();
                                        Operation.Data data2 = (Operation.Data)this.$data;
                                        realApolloSubscriptionCall = SubscriptionManagerCallback.access$getDelegate$p(this.this$0);
                                        Intrinsics.checkNotNull((Object)realApolloSubscriptionCall);
                                        this.label = 1;
                                        Object object3 = apolloStore.writeOperation(operation, data2, RealApolloSubscriptionCall.access$getCustomScalarAdapters$p(realApolloSubscriptionCall), CacheHeaders.NONE, true, (Continuation)this);
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Set<String>> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)1, null);
                    }
                }
                callback.onResponse(response.getResponse());
            }
        }

        @Override
        public void onError(@NotNull ApolloSubscriptionException error) {
            ApolloSubscriptionCall.Callback<D> callback;
            Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
            ApolloSubscriptionCall.Callback<D> callback2 = callback = this.originalCallback;
            if (callback2 != null) {
                callback2.onFailure(error);
            }
            this.terminate();
        }

        @Override
        public void onNetworkError(@NotNull Throwable t) {
            ApolloSubscriptionCall.Callback<D> callback;
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            ApolloSubscriptionCall.Callback<D> callback2 = callback = this.originalCallback;
            if (callback2 != null) {
                callback2.onFailure((ApolloException)new ApolloNetworkException("Subscription failed", t));
            }
            this.terminate();
        }

        @Override
        public void onCompleted() {
            ApolloSubscriptionCall.Callback<D> callback = this.originalCallback;
            ApolloSubscriptionCall.Callback<D> callback2 = callback;
            if (callback2 != null) {
                callback2.onCompleted();
            }
            this.terminate();
        }

        @Override
        public void onTerminated() {
            ApolloSubscriptionCall.Callback<D> callback = this.originalCallback;
            ApolloSubscriptionCall.Callback<D> callback2 = callback;
            if (callback2 != null) {
                callback2.onTerminated();
            }
            this.terminate();
        }

        @Override
        public void onConnected() {
            ApolloSubscriptionCall.Callback<D> callback = this.originalCallback;
            ApolloSubscriptionCall.Callback<D> callback2 = callback;
            if (callback2 != null) {
                callback2.onConnected();
            }
        }

        public final void terminate() {
            RealApolloSubscriptionCall<D> delegate = this.delegate;
            RealApolloSubscriptionCall<D> realApolloSubscriptionCall = delegate;
            if (realApolloSubscriptionCall != null) {
                ((RealApolloSubscriptionCall)realApolloSubscriptionCall).terminate();
            }
        }

        public final void release() {
            this.originalCallback = null;
            this.delegate = null;
        }

        public static final /* synthetic */ RealApolloSubscriptionCall access$getDelegate$p(SubscriptionManagerCallback $this) {
            return $this.delegate;
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CallState.values().length];
            nArray[CallState.IDLE.ordinal()] = 1;
            nArray[CallState.CANCELED.ordinal()] = 2;
            nArray[CallState.TERMINATED.ordinal()] = 3;
            nArray[CallState.ACTIVE.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

