/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.internal;

import com.apollographql.apollo3.ApolloCall;
import com.apollographql.apollo3.ApolloMutationCall;
import com.apollographql.apollo3.ApolloPrefetch;
import com.apollographql.apollo3.ApolloQueryCall;
import com.apollographql.apollo3.ApolloQueryWatcher;
import com.apollographql.apollo3.IdleResourceCallback;
import com.apollographql.apollo3.api.Mutation;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.Query;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0013\"\u0004\b\u0000\u0010\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00140\b0\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u00132\u0006\u0010\u0017\u001a\u00020\u0007J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00132\u0006\u0010\u0017\u001a\u00020\u0007J\u0018\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u00132\u0006\u0010\u0017\u001a\u00020\u0007J\u0018\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u00132\u0006\u0010\u0017\u001a\u00020\u0007J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\u00020\u001b2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eJ=\u0010\u001c\u001a\u00020\u001b\"\u0004\b\u0000\u0010\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00140\b0\u00062\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u0002H\u0014H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0012\u0010 \u001a\u00020\u001b2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\tJ\u000e\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u000bJ\u0012\u0010$\u001a\u00020\u001b2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\rJ\u0012\u0010&\u001a\u00020\u001b2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u000fJ\u0010\u0010(\u001a\u00020\u001b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0012\u0010)\u001a\u00020\u001b2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eJ=\u0010)\u001a\u00020\u001b\"\u0004\b\u0000\u0010\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00140\b0\u00062\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u0002H\u0014H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0012\u0010*\u001a\u00020\u001b2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\tJ\u000e\u0010+\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u000bJ\u0012\u0010,\u001a\u00020\u001b2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\rJ\u0012\u0010-\u001a\u00020\u001b2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0005\u001a\u0018\u0012\u0004\u0012\u00020\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u0018\u0012\u0004\u0012\u00020\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00020\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/apollographql/apollo3/internal/ApolloCallTracker;", "", "()V", "activeCallCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "activeMutationCalls", "", "", "", "Lcom/apollographql/apollo3/ApolloMutationCall;", "activePrefetchCalls", "Lcom/apollographql/apollo3/ApolloPrefetch;", "activeQueryCalls", "Lcom/apollographql/apollo3/ApolloQueryCall;", "activeQueryWatchers", "Lcom/apollographql/apollo3/ApolloQueryWatcher;", "idleResourceCallback", "Lcom/apollographql/apollo3/IdleResourceCallback;", "activeCalls", "", "CALL", "registry", "", "operationName", "activeCallsCount", "", "decrementActiveCallCountAndNotify", "", "registerCall", "call", "Lcom/apollographql/apollo3/ApolloCall;", "(Ljava/util/Map;Ljava/lang/String;Ljava/lang/Object;)V", "registerMutationCall", "apolloMutationCall", "registerPrefetchCall", "apolloPrefetch", "registerQueryCall", "apolloQueryCall", "registerQueryWatcher", "queryWatcher", "setIdleResourceCallback", "unregisterCall", "unregisterMutationCall", "unregisterPrefetchCall", "unregisterQueryCall", "unregisterQueryWatcher", "apollo-runtime"})
public final class ApolloCallTracker {
    @NotNull
    private final Map<String, Set<ApolloPrefetch>> activePrefetchCalls = new HashMap();
    @NotNull
    private final Map<String, Set<ApolloQueryCall<?>>> activeQueryCalls = new HashMap();
    @NotNull
    private final Map<String, Set<ApolloMutationCall<?>>> activeMutationCalls = new HashMap();
    @NotNull
    private final Map<String, Set<ApolloQueryWatcher<?>>> activeQueryWatchers = new HashMap();
    @NotNull
    private final AtomicInteger activeCallCount = new AtomicInteger();
    @Nullable
    private IdleResourceCallback idleResourceCallback;

    public final void registerCall(@NotNull ApolloCall<?> call) {
        Intrinsics.checkNotNullParameter(call, (String)"call");
        Operation<?> operation = call.operation();
        if (operation instanceof Query) {
            this.registerQueryCall((ApolloQueryCall)call);
        } else if (operation instanceof Mutation) {
            this.registerMutationCall((ApolloMutationCall)call);
        } else {
            throw new IllegalArgumentException("Unknown call type");
        }
    }

    public final void unregisterCall(@NotNull ApolloCall<?> call) {
        Intrinsics.checkNotNullParameter(call, (String)"call");
        Operation<?> operation = call.operation();
        if (operation instanceof Query) {
            this.unregisterQueryCall((ApolloQueryCall)call);
        } else if (operation instanceof Mutation) {
            this.unregisterMutationCall((ApolloMutationCall)call);
        } else {
            throw new IllegalArgumentException("Unknown call type");
        }
    }

    public final void registerPrefetchCall(@NotNull ApolloPrefetch apolloPrefetch) {
        Intrinsics.checkNotNullParameter((Object)apolloPrefetch, (String)"apolloPrefetch");
        String operationName = apolloPrefetch.operation().name();
        this.registerCall(this.activePrefetchCalls, operationName, apolloPrefetch);
        this.activeCallCount.incrementAndGet();
    }

    public final void unregisterPrefetchCall(@NotNull ApolloPrefetch apolloPrefetch) {
        Intrinsics.checkNotNullParameter((Object)apolloPrefetch, (String)"apolloPrefetch");
        String operationName = apolloPrefetch.operation().name();
        this.unregisterCall(this.activePrefetchCalls, operationName, apolloPrefetch);
        this.decrementActiveCallCountAndNotify();
    }

    @NotNull
    public final Set<ApolloPrefetch> activePrefetchCalls(@NotNull String operationName) {
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        return this.activeCalls(this.activePrefetchCalls, operationName);
    }

    public final void registerQueryCall(@NotNull ApolloQueryCall<?> apolloQueryCall) {
        Intrinsics.checkNotNullParameter(apolloQueryCall, (String)"apolloQueryCall");
        String operationName = apolloQueryCall.operation().name();
        this.registerCall(this.activeQueryCalls, operationName, apolloQueryCall);
        this.activeCallCount.incrementAndGet();
    }

    public final void unregisterQueryCall(@NotNull ApolloQueryCall<?> apolloQueryCall) {
        Intrinsics.checkNotNullParameter(apolloQueryCall, (String)"apolloQueryCall");
        String operationName = apolloQueryCall.operation().name();
        this.unregisterCall(this.activeQueryCalls, operationName, apolloQueryCall);
        this.decrementActiveCallCountAndNotify();
    }

    @NotNull
    public final Set<ApolloQueryCall<?>> activeQueryCalls(@NotNull String operationName) {
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        return this.activeCalls(this.activeQueryCalls, operationName);
    }

    public final void registerMutationCall(@NotNull ApolloMutationCall<?> apolloMutationCall) {
        Intrinsics.checkNotNullParameter(apolloMutationCall, (String)"apolloMutationCall");
        String operationName = apolloMutationCall.operation().name();
        this.registerCall(this.activeMutationCalls, operationName, apolloMutationCall);
        this.activeCallCount.incrementAndGet();
    }

    public final void unregisterMutationCall(@NotNull ApolloMutationCall<?> apolloMutationCall) {
        Intrinsics.checkNotNullParameter(apolloMutationCall, (String)"apolloMutationCall");
        String operationName = apolloMutationCall.operation().name();
        this.unregisterCall(this.activeMutationCalls, operationName, apolloMutationCall);
        this.decrementActiveCallCountAndNotify();
    }

    @NotNull
    public final Set<ApolloMutationCall<?>> activeMutationCalls(@NotNull String operationName) {
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        return this.activeCalls(this.activeMutationCalls, operationName);
    }

    public final void registerQueryWatcher(@NotNull ApolloQueryWatcher<?> queryWatcher) {
        Intrinsics.checkNotNullParameter(queryWatcher, (String)"queryWatcher");
        String operationName = queryWatcher.operation().name();
        this.registerCall(this.activeQueryWatchers, operationName, queryWatcher);
    }

    public final void unregisterQueryWatcher(@NotNull ApolloQueryWatcher<?> queryWatcher) {
        Intrinsics.checkNotNullParameter(queryWatcher, (String)"queryWatcher");
        String operationName = queryWatcher.operation().name();
        this.unregisterCall(this.activeQueryWatchers, operationName, queryWatcher);
    }

    @NotNull
    public final Set<ApolloQueryWatcher<?>> activeQueryWatchers(@NotNull String operationName) {
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        return this.activeCalls(this.activeQueryWatchers, operationName);
    }

    public final synchronized void setIdleResourceCallback(@Nullable IdleResourceCallback idleResourceCallback) {
        this.idleResourceCallback = idleResourceCallback;
    }

    public final int activeCallsCount() {
        return this.activeCallCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <CALL> void registerCall(Map<String, Set<CALL>> registry, String operationName, CALL call) {
        boolean bl = false;
        boolean bl2 = false;
        synchronized (registry) {
            boolean bl3 = false;
            Set calls = registry.get(operationName);
            if (calls == null) {
                calls = new HashSet();
                Map<String, Set<CALL>> map = registry;
                boolean bl4 = false;
                map.put(operationName, calls);
            }
            bl2 = calls.add(call);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <CALL> void unregisterCall(Map<String, Set<CALL>> registry, String operationName, CALL call) {
        boolean bl = false;
        boolean bl2 = false;
        synchronized (registry) {
            boolean bl3 = false;
            Set<CALL> calls = registry.get(operationName);
            if (calls == null || !calls.remove(call)) {
                throw new AssertionError((Object)"Call wasn't registered before");
            }
            if (calls.isEmpty()) {
                registry.remove(operationName);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <CALL> Set<CALL> activeCalls(Map<String, ? extends Set<CALL>> registry, String operationName) {
        boolean bl = false;
        boolean bl2 = false;
        synchronized (registry) {
            boolean bl3 = false;
            Set<CALL> calls = registry.get(operationName);
            Set set = calls != null ? (Set)new HashSet(calls) : SetsKt.emptySet();
            return set;
        }
    }

    private final void decrementActiveCallCountAndNotify() {
        IdleResourceCallback callback;
        IdleResourceCallback idleResourceCallback;
        if (this.activeCallCount.decrementAndGet() == 0 && (idleResourceCallback = (callback = this.idleResourceCallback)) != null) {
            idleResourceCallback.onIdle();
        }
    }
}

