package com.apollographql.apollo3.cache.`internal`.blob.apollonormalizedcachesqlite

import com.apollographql.apollo3.cache.`internal`.blob.BlobDatabase
import com.apollographql.apollo3.cache.`internal`.blob.BlobQueries
import com.apollographql.apollo3.cache.`internal`.blob.Blobs
import com.squareup.sqldelight.Query
import com.squareup.sqldelight.TransacterImpl
import com.squareup.sqldelight.`internal`.copyOnWriteList
import com.squareup.sqldelight.db.SqlCursor
import com.squareup.sqldelight.db.SqlDriver
import kotlin.Any
import kotlin.ByteArray
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Unit
import kotlin.collections.Collection
import kotlin.collections.MutableList
import kotlin.reflect.KClass

internal val KClass<BlobDatabase>.schema: SqlDriver.Schema
  get() = BlobDatabaseImpl.Schema

internal fun KClass<BlobDatabase>.newInstance(driver: SqlDriver): BlobDatabase =
    BlobDatabaseImpl(driver)

private class BlobDatabaseImpl(
  driver: SqlDriver
) : TransacterImpl(driver), BlobDatabase {
  public override val blobQueries: BlobQueriesImpl = BlobQueriesImpl(this, driver)

  public object Schema : SqlDriver.Schema {
    public override val version: Int
      get() = 1

    public override fun create(driver: SqlDriver): Unit {
      driver.execute(null, """
          |CREATE TABLE blobs (
          |  key TEXT NOT NULL PRIMARY KEY,
          |  blob BLOB NOT NULL
          |) WITHOUT ROWID
          """.trimMargin(), 0)
    }

    public override fun migrate(
      driver: SqlDriver,
      oldVersion: Int,
      newVersion: Int
    ): Unit {
    }
  }
}

private class BlobQueriesImpl(
  private val database: BlobDatabaseImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), BlobQueries {
  internal val recordForKey: MutableList<Query<*>> = copyOnWriteList()

  internal val recordsForKeys: MutableList<Query<*>> = copyOnWriteList()

  internal val selectRecords: MutableList<Query<*>> = copyOnWriteList()

  internal val changes: MutableList<Query<*>> = copyOnWriteList()

  public override fun <T : Any> recordForKey(key: String, mapper: (key: String,
      blob: ByteArray) -> T): Query<T> = RecordForKeyQuery(key) { cursor ->
    mapper(
      cursor.getString(0)!!,
      cursor.getBytes(1)!!
    )
  }

  public override fun recordForKey(key: String): Query<Blobs> = recordForKey(key) { key_, blob ->
    Blobs(
      key_,
      blob
    )
  }

  public override fun <T : Any> recordsForKeys(key: Collection<String>, mapper: (key: String,
      blob: ByteArray) -> T): Query<T> = RecordsForKeysQuery(key) { cursor ->
    mapper(
      cursor.getString(0)!!,
      cursor.getBytes(1)!!
    )
  }

  public override fun recordsForKeys(key: Collection<String>): Query<Blobs> = recordsForKeys(key) {
      key_, blob ->
    Blobs(
      key_,
      blob
    )
  }

  public override fun <T : Any> selectRecords(mapper: (key: String, blob: ByteArray) -> T): Query<T>
      = Query(674082744, selectRecords, driver, "blob.sq", "selectRecords", "SELECT * FROM blobs") {
      cursor ->
    mapper(
      cursor.getString(0)!!,
      cursor.getBytes(1)!!
    )
  }

  public override fun selectRecords(): Query<Blobs> = selectRecords { key, blob ->
    Blobs(
      key,
      blob
    )
  }

  public override fun changes(): Query<Long> = Query(-1130735019, changes, driver, "blob.sq",
      "changes", "SELECT changes()") { cursor ->
    cursor.getLong(0)!!
  }

  public override fun insert(key: String, blob: ByteArray): Unit {
    driver.execute(1111199975, """INSERT INTO blobs (key, blob) VALUES (?,?)""", 2) {
      bindString(1, key)
      bindBytes(2, blob)
    }
    notifyQueries(1111199975, {database.blobQueries.recordsForKeys +
        database.blobQueries.selectRecords + database.blobQueries.recordForKey})
  }

  public override fun update(blob: ByteArray, key: String): Unit {
    driver.execute(1456146167, """UPDATE blobs SET blob=? WHERE key=?""", 2) {
      bindBytes(1, blob)
      bindString(2, key)
    }
    notifyQueries(1456146167, {database.blobQueries.recordsForKeys +
        database.blobQueries.selectRecords + database.blobQueries.recordForKey})
  }

  public override fun delete(key: String): Unit {
    driver.execute(959534041, """DELETE FROM blobs WHERE key=?""", 1) {
      bindString(1, key)
    }
    notifyQueries(959534041, {database.blobQueries.recordsForKeys +
        database.blobQueries.selectRecords + database.blobQueries.recordForKey})
  }

  public override fun deleteRecords(key: Collection<String>): Unit {
    val keyIndexes = createArguments(count = key.size)
    driver.execute(null, """DELETE FROM blobs WHERE key IN $keyIndexes""", key.size) {
      key.forEachIndexed { index, key_ ->
          bindString(index + 1, key_)
          }
    }
    notifyQueries(-254145495, {database.blobQueries.recordsForKeys +
        database.blobQueries.selectRecords + database.blobQueries.recordForKey})
  }

  public override fun deleteRecordsWithKeyMatching(`value`: String, value_: String): Unit {
    driver.execute(-2120518803, """DELETE FROM blobs WHERE key LIKE ? ESCAPE ?""", 2) {
      bindString(1, value)
      bindString(2, value_)
    }
    notifyQueries(-2120518803, {database.blobQueries.recordsForKeys +
        database.blobQueries.selectRecords + database.blobQueries.recordForKey})
  }

  public override fun deleteAll(): Unit {
    driver.execute(-1823640824, """DELETE FROM blobs""", 0)
    notifyQueries(-1823640824, {database.blobQueries.recordsForKeys +
        database.blobQueries.selectRecords + database.blobQueries.recordForKey})
  }

  private inner class RecordForKeyQuery<out T : Any>(
    public val key: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(recordForKey, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(1706656821,
        """SELECT key, blob FROM blobs WHERE key=?""", 1) {
      bindString(1, key)
    }

    public override fun toString(): String = "blob.sq:recordForKey"
  }

  private inner class RecordsForKeysQuery<out T : Any>(
    public val key: Collection<String>,
    mapper: (SqlCursor) -> T
  ) : Query<T>(recordsForKeys, mapper) {
    public override fun execute(): SqlCursor {
      val keyIndexes = createArguments(count = key.size)
      return driver.executeQuery(null, """SELECT key, blob FROM blobs WHERE key IN $keyIndexes""",
          key.size) {
        key.forEachIndexed { index, key_ ->
            bindString(index + 1, key_)
            }
      }
    }

    public override fun toString(): String = "blob.sq:recordsForKeys"
  }
}
