/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.sql;

import com.apollographql.apollo3.annotations.ApolloExperimental;
import com.apollographql.apollo3.cache.normalized.api.CacheHeaders;
import com.apollographql.apollo3.cache.normalized.api.CacheKey;
import com.apollographql.apollo3.cache.normalized.api.NormalizedCache;
import com.apollographql.apollo3.cache.normalized.api.Record;
import com.apollographql.apollo3.cache.normalized.api.RecordMerger;
import com.apollographql.apollo3.cache.normalized.sql.internal.RecordDatabase;
import com.apollographql.apollo3.exception.ApolloExceptionHandlerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J)\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tH\u0016J\u0010\u0010\u0018\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0010H\u0016J\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010 J&\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\"2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%H\u0017J,\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%H\u0017J$\u0010'\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030)\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000e0(0(H\u0016J\u0018\u0010*\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\tH\u0002J3\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00100\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0006\u0010$\u001a\u00020%2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002\u00a2\u0006\u0002\u0010,J\u001b\u0010-\u001a\u00020\u000e*\u00020\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002\u00a2\u0006\u0002\u0010.J-\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00100\"2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002\u00a2\u0006\u0002\u00100J\u001c\u00101\u001a\b\u0012\u0004\u0012\u00020\u000e022\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/apollographql/apollo3/cache/normalized/sql/SqlNormalizedCache;", "Lcom/apollographql/apollo3/cache/normalized/api/NormalizedCache;", "recordDatabase", "Lcom/apollographql/apollo3/cache/normalized/sql/internal/RecordDatabase;", "<init>", "(Lcom/apollographql/apollo3/cache/normalized/sql/internal/RecordDatabase;)V", "maybeTransaction", "T", "condition", "", "block", "Lkotlin/Function0;", "(ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "loadRecord", "Lcom/apollographql/apollo3/cache/normalized/api/Record;", "key", "", "cacheHeaders", "Lcom/apollographql/apollo3/cache/normalized/api/CacheHeaders;", "loadRecords", "", "keys", "clearAll", "", "remove", "cacheKey", "Lcom/apollographql/apollo3/cache/normalized/api/CacheKey;", "cascade", "", "pattern", "date", "", "(Lcom/apollographql/apollo3/cache/normalized/api/CacheHeaders;)Ljava/lang/Long;", "merge", "", "record", "recordMerger", "Lcom/apollographql/apollo3/cache/normalized/api/RecordMerger;", "records", "dump", "", "Lkotlin/reflect/KClass;", "internalDeleteRecord", "internalUpdateRecords", "(Ljava/util/Collection;Lcom/apollographql/apollo3/cache/normalized/api/RecordMerger;Ljava/lang/Long;)Ljava/util/Set;", "withDate", "(Lcom/apollographql/apollo3/cache/normalized/api/Record;Ljava/lang/Long;)Lcom/apollographql/apollo3/cache/normalized/api/Record;", "internalUpdateRecord", "(Lcom/apollographql/apollo3/cache/normalized/api/Record;Lcom/apollographql/apollo3/cache/normalized/api/RecordMerger;Ljava/lang/Long;)Ljava/util/Set;", "internalGetRecords", "", "apollo-normalized-cache-sqlite-incubating"})
@SourceDebugExtension(value={"SMAP\nSqlNormalizedCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlNormalizedCache.kt\ncom/apollographql/apollo3/cache/normalized/sql/SqlNormalizedCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,211:1\n1202#2,2:212\n1230#2,4:214\n1863#2,2:218\n1246#2,4:222\n1368#2:226\n1454#2,5:227\n1863#2,2:232\n1557#2:234\n1628#2,3:235\n1202#2,2:238\n1230#2,4:240\n1368#2:244\n1454#2,5:245\n462#3:220\n412#3:221\n*S KotlinDebug\n*F\n+ 1 SqlNormalizedCache.kt\ncom/apollographql/apollo3/cache/normalized/sql/SqlNormalizedCache\n*L\n118#1:212,2\n118#1:214,4\n128#1:218,2\n176#1:222,4\n206#1:226\n206#1:227,5\n57#1:232,2\n148#1:234\n148#1:235,3\n149#1:238,2\n149#1:240,4\n151#1:244\n151#1:245,5\n176#1:220\n176#1:221\n*E\n"})
public final class SqlNormalizedCache
implements NormalizedCache {
    @NotNull
    private final RecordDatabase recordDatabase;

    public SqlNormalizedCache(@NotNull RecordDatabase recordDatabase) {
        Intrinsics.checkNotNullParameter((Object)recordDatabase, (String)"recordDatabase");
        this.recordDatabase = recordDatabase;
    }

    private final <T> T maybeTransaction(boolean condition, Function0<? extends T> block) {
        return (T)(condition ? RecordDatabase.transaction$default(this.recordDatabase, false, () -> SqlNormalizedCache.maybeTransaction$lambda$0(block), 1, null) : block.invoke());
    }

    @Nullable
    public Record loadRecord(@NotNull String key, @NotNull CacheHeaders cacheHeaders) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        boolean evictAfterRead = cacheHeaders.hasHeader("evict-after-read");
        return (Record)this.maybeTransaction(evictAfterRead, () -> SqlNormalizedCache.loadRecord$lambda$2(this, key, evictAfterRead));
    }

    @NotNull
    public Collection<Record> loadRecords(@NotNull Collection<String> keys, @NotNull CacheHeaders cacheHeaders) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        boolean evictAfterRead = cacheHeaders.hasHeader("evict-after-read");
        return (Collection)this.maybeTransaction(evictAfterRead, () -> SqlNormalizedCache.loadRecords$lambda$5(this, keys, evictAfterRead));
    }

    public void clearAll() {
        this.recordDatabase.deleteAll();
    }

    public boolean remove(@NotNull CacheKey cacheKey, boolean cascade) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        return (Boolean)RecordDatabase.transaction$default(this.recordDatabase, false, () -> SqlNormalizedCache.remove$lambda$6(this, cacheKey, cascade), 1, null);
    }

    public int remove(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return ((Number)RecordDatabase.transaction$default(this.recordDatabase, false, () -> SqlNormalizedCache.remove$lambda$7(this, pattern), 1, null)).intValue();
    }

    private final Long date(CacheHeaders $this$date) {
        String string = $this$date.headerValue("apollo-date");
        return string != null ? Long.valueOf(Long.parseLong(string)) : null;
    }

    @ApolloExperimental
    @NotNull
    public Set<String> merge(@NotNull Record record, @NotNull CacheHeaders cacheHeaders, @NotNull RecordMerger recordMerger) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Intrinsics.checkNotNullParameter((Object)recordMerger, (String)"recordMerger");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return SetsKt.emptySet();
        }
        try {
            set = this.internalUpdateRecord(record, recordMerger, this.date(cacheHeaders));
        }
        catch (Exception e) {
            ApolloExceptionHandlerKt.getApolloExceptionHandler().invoke((Object)new Exception("Unable to merge a record from the database", e));
            set = SetsKt.emptySet();
        }
        return set;
    }

    @ApolloExperimental
    @NotNull
    public Set<String> merge(@NotNull Collection<Record> records, @NotNull CacheHeaders cacheHeaders, @NotNull RecordMerger recordMerger) {
        Set set;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Intrinsics.checkNotNullParameter((Object)recordMerger, (String)"recordMerger");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return SetsKt.emptySet();
        }
        try {
            set = this.internalUpdateRecords(records, recordMerger, this.date(cacheHeaders));
        }
        catch (Exception e) {
            ApolloExceptionHandlerKt.getApolloExceptionHandler().invoke((Object)new Exception("Unable to merge records from the database", e));
            set = SetsKt.emptySet();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<KClass<?>, Map<String, Record>> dump() {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Iterable iterable = this.recordDatabase.selectAll();
        KClass kClass = Reflection.getOrCreateKotlinClass(this.getClass());
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var4_5 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Record record = (Record)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getKey(), element$iv$iv);
        }
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)kClass, (Object)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean internalDeleteRecord(String key, boolean cascade) {
        List list;
        Record record;
        if (cascade && (record = this.recordDatabase.select(key)) != null && (list = record.referencedFields()) != null) {
            void $this$forEach$iv;
            Iterable iterable = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CacheKey it = (CacheKey)element$iv;
                boolean bl = false;
                this.internalDeleteRecord(it.getKey(), true);
            }
        }
        this.recordDatabase.delete(key);
        return this.recordDatabase.changes() > 0L;
    }

    private final Set<String> internalUpdateRecords(Collection<Record> records, RecordMerger recordMerger, Long date) {
        Ref.ObjectRef updatedRecordKeys = new Ref.ObjectRef();
        updatedRecordKeys.element = SetsKt.emptySet();
        RecordDatabase.transaction$default(this.recordDatabase, false, () -> SqlNormalizedCache.internalUpdateRecords$lambda$13(this, records, updatedRecordKeys, date, recordMerger), 1, null);
        return (Set)updatedRecordKeys.element;
    }

    /*
     * WARNING - void declaration
     */
    private final Record withDate(Record $this$withDate, Long date) {
        Map map;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        if (date == null) {
            return $this$withDate;
        }
        Map map2 = $this$withDate.getFields();
        UUID uUID = $this$withDate.getMutationId();
        Map map3 = $this$withDate.getFields();
        String string = $this$withDate.getKey();
        boolean $i$f$mapValues = false;
        void var5_8 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = map4;
            boolean bl2 = false;
            Long l = (long)date;
            map.put(k, l);
        }
        map = destination$iv$iv;
        Map map5 = $this$withDate.getMetadata();
        Map map6 = map;
        UUID uUID2 = uUID;
        Map map7 = map3;
        String string2 = string;
        return new Record(string2, map7, uUID2, map6, map5);
    }

    private final Set<String> internalUpdateRecord(Record record, RecordMerger recordMerger, Long date) {
        return (Set)RecordDatabase.transaction$default(this.recordDatabase, false, () -> SqlNormalizedCache.internalUpdateRecord$lambda$15(this, record, date, recordMerger), 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Record> internalGetRecords(Collection<String> keys) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)keys, (int)999);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List chunkedKeys = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.recordDatabase.select(chunkedKeys);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Object maybeTransaction$lambda$0(Function0 $block) {
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        return $block.invoke();
    }

    private static final Record loadRecord$lambda$2(SqlNormalizedCache this$0, String $key, boolean $evictAfterRead) {
        Record record;
        Record record2;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        try {
            record2 = this$0.recordDatabase.select($key);
        }
        catch (Exception e) {
            ApolloExceptionHandlerKt.getApolloExceptionHandler().invoke((Object)new Exception("Unable to read a record from the database", e));
            record2 = null;
        }
        Record record3 = record2;
        if (record3 != null) {
            Record it = record2 = record3;
            boolean bl = false;
            if ($evictAfterRead) {
                this$0.recordDatabase.delete($key);
            }
            record = record2;
        } else {
            record = null;
        }
        return record;
    }

    private static final List loadRecords$lambda$5(SqlNormalizedCache this$0, Collection $keys, boolean $evictAfterRead) {
        List list;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$keys, (String)"$keys");
        try {
            list = this$0.internalGetRecords($keys);
        }
        catch (Exception e) {
            ApolloExceptionHandlerKt.getApolloExceptionHandler().invoke((Object)new Exception("Unable to read records from the database", e));
            list = CollectionsKt.emptyList();
        }
        List it = list;
        boolean bl = false;
        if ($evictAfterRead) {
            Iterable $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Record record = (Record)element$iv;
                boolean bl2 = false;
                this$0.recordDatabase.delete(record.getKey());
            }
        }
        return list;
    }

    private static final boolean remove$lambda$6(SqlNormalizedCache this$0, CacheKey $cacheKey, boolean $cascade) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$cacheKey, (String)"$cacheKey");
        return this$0.internalDeleteRecord($cacheKey.getKey(), $cascade);
    }

    private static final int remove$lambda$7(SqlNormalizedCache this$0, String $pattern) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$pattern, (String)"$pattern");
        this$0.recordDatabase.deleteMatching($pattern);
        return (int)this$0.recordDatabase.changes();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit internalUpdateRecords$lambda$13(SqlNormalizedCache this$0, Collection $records, Ref.ObjectRef $updatedRecordKeys, Long $date, RecordMerger $recordMerger) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$records, (String)"$records");
        Intrinsics.checkNotNullParameter((Object)$updatedRecordKeys, (String)"$updatedRecordKeys");
        Intrinsics.checkNotNullParameter((Object)$recordMerger, (String)"$recordMerger");
        Iterable iterable = $records;
        Object object = this$0;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Record record = (Record)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKey());
        }
        $this$map$iv = ((SqlNormalizedCache)object).internalGetRecords((List)destination$iv$iv);
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Record bl = (Record)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.put(it.getKey(), element$iv$iv);
        }
        Map oldRecords = destination$iv$iv2;
        $this$associateBy$iv = $records;
        object = $updatedRecordKeys;
        boolean $i$f$flatMap = false;
        void capacity$iv22 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Set set;
            Record record = (Record)element$iv$iv;
            boolean bl = false;
            Record oldRecord = (Record)oldRecords.get(record.getKey());
            if (oldRecord == null) {
                this$0.recordDatabase.insert(this$0.withDate(record, $date));
                set = record.fieldKeys();
            } else {
                Pair pair = $recordMerger.merge(oldRecord, record, $date);
                Record mergedRecord = (Record)pair.component1();
                Set changedKeys = (Set)pair.component2();
                if (!((Map)mergedRecord).isEmpty()) {
                    this$0.recordDatabase.update(mergedRecord);
                }
                set = changedKeys;
            }
            Iterable list$iv$iv = set;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        ((Ref.ObjectRef)object).element = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return Unit.INSTANCE;
    }

    private static final Set internalUpdateRecord$lambda$15(SqlNormalizedCache this$0, Record $record, Long $date, RecordMerger $recordMerger) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$record, (String)"$record");
        Intrinsics.checkNotNullParameter((Object)$recordMerger, (String)"$recordMerger");
        Record oldRecord = this$0.recordDatabase.select($record.getKey());
        if (oldRecord == null) {
            this$0.recordDatabase.insert(this$0.withDate($record, $date));
            set = $record.fieldKeys();
        } else {
            Pair pair = $recordMerger.merge(oldRecord, $record, $date);
            Record mergedRecord = (Record)pair.component1();
            Set changedKeys = (Set)pair.component2();
            if (!((Map)mergedRecord).isEmpty()) {
                this$0.recordDatabase.update(mergedRecord);
            }
            set = changedKeys;
        }
        return set;
    }
}

