/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.internal;

import com.apollographql.apollo3.cache.CacheHeaders;
import com.apollographql.apollo3.cache.normalized.CacheKey;
import com.apollographql.apollo3.cache.normalized.CacheReference;
import com.apollographql.apollo3.cache.normalized.NormalizedCache;
import com.apollographql.apollo3.cache.normalized.Record;
import com.apollographql.apollo3.cache.normalized.internal.LruCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J$\u0010\t\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\n0\nH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\u0006\u0010\u0016\u001a\u00020\fJ\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u0012J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\n\u0010!\u001a\u00060\"j\u0002`#J\u0018\u0010$\u001a\u0004\u0018\u00010\f*\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/apollographql/apollo3/cache/normalized/internal/OptimisticCache;", "Lcom/apollographql/apollo3/cache/normalized/NormalizedCache;", "()V", "lruCache", "Lcom/apollographql/apollo3/cache/normalized/internal/LruCache;", "", "Lcom/apollographql/apollo3/cache/normalized/internal/OptimisticCache$RecordJournal;", "clearAll", "", "dump", "", "Lkotlin/reflect/KClass;", "Lcom/apollographql/apollo3/cache/normalized/Record;", "loadRecord", "key", "cacheHeaders", "Lcom/apollographql/apollo3/cache/CacheHeaders;", "loadRecords", "", "keys", "merge", "", "record", "records", "mergeOptimisticUpdate", "mergeOptimisticUpdates", "recordSet", "remove", "", "cacheKey", "Lcom/apollographql/apollo3/cache/normalized/CacheKey;", "cascade", "removeOptimisticUpdates", "mutationId", "Ljava/util/UUID;", "Lcom/benasher44/uuid/Uuid;", "mergeJournalRecord", "RecordJournal", "apollo-normalized-cache"})
public final class OptimisticCache
extends NormalizedCache {
    @NotNull
    private final LruCache<String, RecordJournal> lruCache = new LruCache(Integer.MAX_VALUE, null, 2, null);

    @Nullable
    public Record loadRecord(@NotNull String key, @NotNull CacheHeaders cacheHeaders) {
        Record record;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        try {
            NormalizedCache normalizedCache = this.getNextCache();
            Record nonOptimisticRecord = normalizedCache == null ? null : normalizedCache.loadRecord(key, cacheHeaders);
            record = this.mergeJournalRecord(nonOptimisticRecord, key);
        }
        catch (Exception ignore) {
            record = null;
        }
        return record;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<Record> loadRecords(@NotNull Collection<String> keys, @NotNull CacheHeaders cacheHeaders) {
        void $this$mapNotNullTo$iv$iv;
        Iterable iterable;
        Map map;
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        NormalizedCache normalizedCache = this.getNextCache();
        if (normalizedCache == null) {
            map = null;
        } else {
            iterable = normalizedCache.loadRecords(keys, cacheHeaders);
            if (iterable == null) {
                map = null;
            } else {
                void $this$associateByTo$iv$iv;
                Iterable $this$associateBy$iv = iterable;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable2 = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    Record record = (Record)element$iv$iv;
                    Map map2 = destination$iv$iv;
                    boolean bl = false;
                    String string = it.getKey();
                    map2.put(string, element$iv$iv);
                }
                map = destination$iv$iv;
            }
        }
        Map map3 = map;
        Map nonOptimisticRecords = map3 == null ? MapsKt.emptyMap() : map3;
        Iterable $this$mapNotNull$iv = keys;
        boolean $i$f$mapNotNull = false;
        iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Record record;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String key = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.mergeJournalRecord((Record)nonOptimisticRecords.get(key), key) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Record it$iv$iv = record;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public Set<String> merge(@NotNull Record record, @NotNull CacheHeaders cacheHeaders) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        NormalizedCache normalizedCache = this.getNextCache();
        Set set = normalizedCache == null ? null : normalizedCache.merge(record, cacheHeaders);
        return set == null ? SetsKt.emptySet() : set;
    }

    @NotNull
    public Set<String> merge(@NotNull Collection<Record> records, @NotNull CacheHeaders cacheHeaders) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        NormalizedCache normalizedCache = this.getNextCache();
        Set set = normalizedCache == null ? null : normalizedCache.merge(records, cacheHeaders);
        return set == null ? SetsKt.emptySet() : set;
    }

    public void clearAll() {
        this.lruCache.clear();
        NormalizedCache normalizedCache = this.getNextCache();
        if (normalizedCache != null) {
            normalizedCache.clearAll();
        }
    }

    public boolean remove(@NotNull CacheKey cacheKey, boolean cascade) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        NormalizedCache normalizedCache = this.getNextCache();
        boolean result = normalizedCache == null ? false : (bl = normalizedCache.remove(cacheKey, cascade));
        RecordJournal recordJournal = this.lruCache.get(cacheKey.getKey());
        if (recordJournal != null) {
            this.lruCache.remove(cacheKey.getKey());
            result = true;
            if (cascade) {
                for (CacheReference cacheReference : recordJournal.getSnapshot().referencedFields()) {
                    result = result && this.remove(new CacheKey(cacheReference.getKey()), true);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> mergeOptimisticUpdates(@NotNull Collection<Record> recordSet) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(recordSet, (String)"recordSet");
        Iterable $this$flatMap$iv = recordSet;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Record it = (Record)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.mergeOptimisticUpdate(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final Set<String> mergeOptimisticUpdate(@NotNull Record record) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        RecordJournal journal = this.lruCache.get(record.getKey());
        if (journal == null) {
            this.lruCache.set(record.getKey(), new RecordJournal(record));
            set = SetsKt.setOf((Object)record.getKey());
        } else {
            set = journal.commit(record);
        }
        return set;
    }

    @NotNull
    public final Set<String> removeOptimisticUpdates(@NotNull UUID mutationId) {
        Intrinsics.checkNotNullParameter((Object)mutationId, (String)"mutationId");
        boolean bl = false;
        Set changedCacheKeys = new LinkedHashSet();
        boolean bl2 = false;
        Set removedKeys = new LinkedHashSet();
        Map<String, RecordJournal> $this$forEach$iv = this.lruCache.dump();
        boolean $i$f$forEach = false;
        Map<String, RecordJournal> map = $this$forEach$iv;
        boolean bl3 = false;
        Iterator<Map.Entry<String, RecordJournal>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, RecordJournal> element$iv;
            Map.Entry<String, RecordJournal> $dstr$cacheKey$journal = element$iv = iterator.next();
            boolean bl4 = false;
            Map.Entry<String, RecordJournal> entry = $dstr$cacheKey$journal;
            boolean bl5 = false;
            String cacheKey = entry.getKey();
            Map.Entry<String, RecordJournal> entry2 = $dstr$cacheKey$journal;
            boolean bl6 = false;
            RecordJournal journal = entry2.getValue();
            changedCacheKeys.addAll((Collection)journal.revert(mutationId));
            if (!journal.getHistory().isEmpty()) continue;
            removedKeys.add(cacheKey);
        }
        this.lruCache.remove(removedKeys);
        return changedCacheKeys;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<KClass<?>, Map<String, Record>> dump() {
        Map map;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object object = this.lruCache.dump();
        KClass kClass = Reflection.getOrCreateKotlinClass(((Object)((Object)this)).getClass());
        boolean $i$f$mapValues = false;
        void var3_4 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $dstr$_u24__u24$journal;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            map = map2;
            boolean bl2 = false;
            void var16_17 = $dstr$_u24__u24$journal;
            boolean bl3 = false;
            RecordJournal journal = (RecordJournal)var16_17.getValue();
            Record record = journal.getSnapshot();
            map.put(k2, record);
        }
        map = destination$iv$iv;
        Map map3 = MapsKt.mapOf((Pair)TuplesKt.to((Object)kClass, (Object)map));
        object = this.getNextCache();
        object = object == null ? null : object.dump();
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            object2 = MapsKt.emptyMap();
        }
        return MapsKt.plus((Map)map3, (Map)object2);
    }

    private final Record mergeJournalRecord(Record $this$mergeJournalRecord, String key) {
        Record record;
        RecordJournal journal = this.lruCache.get(key);
        if (journal != null) {
            Pair pair;
            Record record2;
            Record record3 = $this$mergeJournalRecord;
            Record record4 = record3 == null ? null : (record2 = (pair = record3.mergeWith(journal.getSnapshot())) == null ? null : (Record)pair.getFirst());
            record = record2 == null ? journal.getSnapshot() : record2;
        } else {
            record = $this$mergeJournalRecord;
        }
        return record;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0003J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0004\u00a8\u0006\u0015"}, d2={"Lcom/apollographql/apollo3/cache/normalized/internal/OptimisticCache$RecordJournal;", "", "mutationRecord", "Lcom/apollographql/apollo3/cache/normalized/Record;", "(Lcom/apollographql/apollo3/cache/normalized/Record;)V", "history", "", "getHistory", "()Ljava/util/List;", "snapshot", "getSnapshot", "()Lcom/apollographql/apollo3/cache/normalized/Record;", "setSnapshot", "commit", "", "", "record", "revert", "mutationId", "Ljava/util/UUID;", "Lcom/benasher44/uuid/Uuid;", "apollo-normalized-cache"})
    private static final class RecordJournal {
        @NotNull
        private Record snapshot;
        @NotNull
        private final List<Record> history;

        public RecordJournal(@NotNull Record mutationRecord) {
            Intrinsics.checkNotNullParameter((Object)mutationRecord, (String)"mutationRecord");
            this.snapshot = mutationRecord;
            Object[] objectArray = new Record[]{mutationRecord};
            this.history = CollectionsKt.mutableListOf((Object[])objectArray);
        }

        @NotNull
        public final Record getSnapshot() {
            return this.snapshot;
        }

        public final void setSnapshot(@NotNull Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"<set-?>");
            this.snapshot = record;
        }

        @NotNull
        public final List<Record> getHistory() {
            return this.history;
        }

        @NotNull
        public final Set<String> commit(@NotNull Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            Pair pair = this.snapshot.mergeWith(record);
            Record mergedRecord = (Record)pair.component1();
            Set changedKeys2 = (Set)pair.component2();
            this.snapshot = mergedRecord;
            this.history.add(this.history.size(), mergedRecord);
            return changedKeys2;
        }

        @NotNull
        public final Set<String> revert(@NotNull UUID mutationId) {
            int recordIndex;
            int n;
            block6: {
                int n2;
                Intrinsics.checkNotNullParameter((Object)mutationId, (String)"mutationId");
                List<Record> $this$indexOfFirst$iv = this.history;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<Record> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    Record item$iv;
                    Record it = item$iv = iterator.next();
                    n = 0;
                    if (Intrinsics.areEqual((Object)mutationId, (Object)it.getMutationId())) {
                        n2 = index$iv;
                        break block6;
                    }
                    ++index$iv;
                }
                n2 = recordIndex = -1;
            }
            if (recordIndex == -1) {
                return SetsKt.emptySet();
            }
            HashSet<String> result = new HashSet<String>();
            result.add(this.history.remove(recordIndex).getKey());
            int n3 = 0;
            int n4 = recordIndex - 1;
            boolean item$iv = false;
            int n5 = Math.max(n3, n4);
            n3 = this.history.size();
            if (n5 < n3) {
                do {
                    int i = n5++;
                    Record record = this.history.get(i);
                    int n6 = 0;
                    n = recordIndex - 1;
                    boolean bl = false;
                    if (i == Math.max(n6, n)) {
                        this.snapshot = record;
                        continue;
                    }
                    Pair pair = this.snapshot.mergeWith(record);
                    Record mergedRecord = (Record)pair.component1();
                    Set changedKeys2 = (Set)pair.component2();
                    this.snapshot = mergedRecord;
                    result.addAll(changedKeys2);
                } while (n5 < n3);
            }
            return result;
        }
    }
}

