/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.api.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0007\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0001&B;\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012,\b\u0002\u0010\u0006\u001a&\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\u0004\u0012\u00020\u00050\u0007j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\b\u00a2\u0006\u0002\u0010\tJ+\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f2\u0006\u0010\u0012\u001a\u00028\u00002\b\u0010\u0013\u001a\u0004\u0018\u00018\u0001H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0018J\u0018\u0010\u0019\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0012\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u001aJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cJ\u001c\u0010\u001d\u001a\u00020\u00162\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\fH\u0002J\u0015\u0010\u001f\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0014\u0010\u001f\u001a\u00020\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000 J\u0017\u0010!\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0012\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\"\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010#J\u0006\u0010\u000f\u001a\u00020\u0005J\b\u0010$\u001a\u00020\u0016H\u0002J\u001c\u0010%\u001a\u00020\u00162\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\fH\u0002RB\u0010\n\u001a6\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f0\u000bj\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u0006\u001a&\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\u0004\u0012\u00020\u00050\u0007j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/apollographql/apollo3/cache/normalized/api/internal/LruCache;", "Key", "Value", "", "maxSize", "", "weigher", "Lkotlin/Function2;", "Lcom/apollographql/apollo3/cache/normalized/api/internal/Weigher;", "(ILkotlin/jvm/functions/Function2;)V", "cache", "Ljava/util/LinkedHashMap;", "Lcom/apollographql/apollo3/cache/normalized/api/internal/LruCache$Node;", "Lkotlin/collections/LinkedHashMap;", "headNode", "size", "tailNode", "addNode", "key", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Lcom/apollographql/apollo3/cache/normalized/api/internal/LruCache$Node;", "clear", "", "dump", "", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "keys", "", "moveNodeToHead", "node", "remove", "", "removeUnsafe", "set", "(Ljava/lang/Object;Ljava/lang/Object;)V", "trim", "unlinkNode", "Node", "apollo-normalized-cache-api"})
public final class LruCache<Key, Value> {
    private final int maxSize;
    @NotNull
    private final Function2<Key, Value, Integer> weigher;
    @NotNull
    private final LinkedHashMap<Key, Node<Key, Value>> cache;
    @Nullable
    private Node<Key, Value> headNode;
    @Nullable
    private Node<Key, Value> tailNode;
    private int size;

    public LruCache(int maxSize, @NotNull Function2<? super Key, ? super Value, Integer> weigher) {
        Intrinsics.checkNotNullParameter(weigher, (String)"weigher");
        this.maxSize = maxSize;
        this.weigher = weigher;
        this.cache = new LinkedHashMap(0, 0.75f);
    }

    public /* synthetic */ LruCache(int n, Function2 function2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            function2 = 1.INSTANCE;
        }
        this(n, function2);
    }

    @Nullable
    public final Value get(Key key) {
        Node<Key, Value> node = this.cache.get(key);
        if (node != null) {
            this.moveNodeToHead(node);
        }
        Node<Key, Value> node2 = node;
        return (Value)(node2 != null ? node2.getValue() : null);
    }

    public final void set(Key key, Value value) {
        Node<Key, Value> node = this.cache.get(key);
        if (node == null) {
            ((Map)this.cache).put(key, this.addNode(key, value));
        } else {
            node.setValue(value);
            this.moveNodeToHead(node);
        }
        this.trim();
    }

    @Nullable
    public final Value remove(Key key) {
        return this.removeUnsafe(key);
    }

    @NotNull
    public final Set<Key> keys() {
        Set<Key> set = this.cache.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"cache.keys");
        return set;
    }

    private final Value removeUnsafe(Key key) {
        Object value;
        Node nodeToRemove;
        Node node = nodeToRemove = (Node)this.cache.remove(key);
        Object object = value = node != null ? node.getValue() : null;
        if (nodeToRemove != null) {
            this.unlinkNode(nodeToRemove);
        }
        return value;
    }

    public final void remove(@NotNull Collection<? extends Key> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Iterable $this$forEach$iv = keys;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object key = element$iv = iterator.next();
            boolean bl = false;
            this.removeUnsafe(key);
        }
    }

    public final void clear() {
        this.cache.clear();
        this.headNode = null;
        this.tailNode = null;
        this.size = 0;
    }

    public final int size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Key, Value> dump() {
        void $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv = this.cache;
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Node value = (Node)entry2.getValue();
            Object Value = value.getValue();
            map3.put(k, Value);
        }
        return destination$iv$iv;
    }

    private final void trim() {
        Node<Key, Value> nodeToRemove = this.tailNode;
        while (nodeToRemove != null && this.size > this.maxSize) {
            Map map = this.cache;
            Key Key = nodeToRemove.getKey();
            TypeIntrinsics.asMutableMap((Object)map).remove(Key);
            this.unlinkNode(nodeToRemove);
            nodeToRemove = this.tailNode;
        }
    }

    private final Node<Key, Value> addNode(Key key, Value value) {
        Node<Key, Value> node = new Node<Key, Value>(key, value, this.headNode, null);
        this.headNode = node;
        if (node.getNext() == null) {
            this.tailNode = this.headNode;
        } else {
            Node<Key, Value> node2 = node.getNext();
            if (node2 != null) {
                node2.setPrev(this.headNode);
            }
        }
        this.size += ((Number)this.weigher.invoke(key, value)).intValue();
        return node;
    }

    private final void moveNodeToHead(Node<Key, Value> node) {
        if (node.getPrev() == null) {
            return;
        }
        Node<Key, Value> node2 = node.getPrev();
        if (node2 != null) {
            node2.setNext(node.getNext());
        }
        if (node.getNext() == null) {
            this.tailNode = node.getPrev();
        } else {
            Node<Key, Value> node3 = node.getNext();
            if (node3 != null) {
                node3.setPrev(node.getPrev());
            }
        }
        node.setNext(this.headNode);
        node.setPrev(null);
        Node node4 = this.headNode;
        if (node4 != null) {
            node4.setPrev(node);
        }
        this.headNode = node;
    }

    private final void unlinkNode(Node<Key, Value> node) {
        if (node.getPrev() == null) {
            this.headNode = node.getNext();
        } else {
            Node<Key, Value> node2 = node.getPrev();
            if (node2 != null) {
                node2.setNext(node.getNext());
            }
        }
        if (node.getNext() == null) {
            this.tailNode = node.getPrev();
        } else {
            Node<Key, Value> node3 = node.getNext();
            if (node3 != null) {
                node3.setPrev(node.getPrev());
            }
        }
        Key Key = node.getKey();
        Intrinsics.checkNotNull(Key);
        this.size -= ((Number)this.weigher.invoke(Key, node.getValue())).intValue();
        node.setKey(null);
        node.setValue(null);
        node.setNext(null);
        node.setPrev(null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0013\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u00020\u0003BE\u0012\b\u0010\u0004\u001a\u0004\u0018\u00018\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0003\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u0000\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\bR\u001e\u0010\u0004\u001a\u0004\u0018\u00018\u0002X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR(\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R(\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R\u001e\u0010\u0005\u001a\u0004\u0018\u00018\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\u0014\u0010\n\"\u0004\b\u0015\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/apollographql/apollo3/cache/normalized/api/internal/LruCache$Node;", "Key", "Value", "", "key", "value", "next", "prev", "(Ljava/lang/Object;Ljava/lang/Object;Lcom/apollographql/apollo3/cache/normalized/api/internal/LruCache$Node;Lcom/apollographql/apollo3/cache/normalized/api/internal/LruCache$Node;)V", "getKey", "()Ljava/lang/Object;", "setKey", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "getNext", "()Lcom/apollographql/apollo3/cache/normalized/api/internal/LruCache$Node;", "setNext", "(Lcom/apollographql/apollo3/cache/normalized/api/internal/LruCache$Node;)V", "getPrev", "setPrev", "getValue", "setValue", "apollo-normalized-cache-api"})
    private static final class Node<Key, Value> {
        @Nullable
        private Key key;
        @Nullable
        private Value value;
        @Nullable
        private Node<Key, Value> next;
        @Nullable
        private Node<Key, Value> prev;

        public Node(@Nullable Key key, @Nullable Value value, @Nullable Node<Key, Value> next, @Nullable Node<Key, Value> prev) {
            this.key = key;
            this.value = value;
            this.next = next;
            this.prev = prev;
        }

        @Nullable
        public final Key getKey() {
            return this.key;
        }

        public final void setKey(@Nullable Key Key) {
            this.key = Key;
        }

        @Nullable
        public final Value getValue() {
            return this.value;
        }

        public final void setValue(@Nullable Value Value) {
            this.value = Value;
        }

        @Nullable
        public final Node<Key, Value> getNext() {
            return this.next;
        }

        public final void setNext(@Nullable Node<Key, Value> node) {
            this.next = node;
        }

        @Nullable
        public final Node<Key, Value> getPrev() {
            return this.prev;
        }

        public final void setPrev(@Nullable Node<Key, Value> node) {
            this.prev = node;
        }
    }
}

