/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.api;

import com.apollographql.apollo3.annotations.ApolloExperimental;
import com.apollographql.apollo3.cache.normalized.api.Record;
import com.apollographql.apollo3.cache.normalized.api.RecordMerger;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J9\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00062\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/apollographql/apollo3/cache/normalized/api/FieldRecordMerger;", "Lcom/apollographql/apollo3/cache/normalized/api/RecordMerger;", "fieldMerger", "Lcom/apollographql/apollo3/cache/normalized/api/FieldRecordMerger$FieldMerger;", "(Lcom/apollographql/apollo3/cache/normalized/api/FieldRecordMerger$FieldMerger;)V", "merge", "Lkotlin/Pair;", "Lcom/apollographql/apollo3/cache/normalized/api/Record;", "", "", "existing", "incoming", "newDate", "", "(Lcom/apollographql/apollo3/cache/normalized/api/Record;Lcom/apollographql/apollo3/cache/normalized/api/Record;Ljava/lang/Long;)Lkotlin/Pair;", "FieldInfo", "FieldMerger", "apollo-normalized-cache-api-incubating"})
@ApolloExperimental
public final class FieldRecordMerger
implements RecordMerger {
    @NotNull
    private final FieldMerger fieldMerger;

    public FieldRecordMerger(@NotNull FieldMerger fieldMerger) {
        Intrinsics.checkNotNullParameter((Object)fieldMerger, (String)"fieldMerger");
        this.fieldMerger = fieldMerger;
    }

    @Override
    @NotNull
    public Pair<Record, Set<String>> merge(@NotNull Record existing, @NotNull Record incoming, @Nullable Long newDate) {
        Intrinsics.checkNotNullParameter((Object)existing, (String)"existing");
        Intrinsics.checkNotNullParameter((Object)incoming, (String)"incoming");
        Set changedKeys = new LinkedHashSet();
        Map mergedFields = MapsKt.toMutableMap(existing.getFields());
        Map mergedMetadata = MapsKt.toMutableMap(existing.getMetadata());
        Map map = existing.getDate();
        if (map == null || (map = MapsKt.toMutableMap(map)) == null) {
            map = new LinkedHashMap();
        }
        Map date = map;
        for (Map.Entry<String, Object> entry : incoming.getFields().entrySet()) {
            String fieldKey = entry.getKey();
            Object incomingFieldValue = entry.getValue();
            boolean hasExistingFieldValue = existing.getFields().containsKey(fieldKey);
            Object existingFieldValue = existing.getFields().get(fieldKey);
            if (!hasExistingFieldValue) {
                mergedFields.put(fieldKey, incomingFieldValue);
                Map<String, Object> map2 = incoming.getMetadata().get(fieldKey);
                Intrinsics.checkNotNull(map2);
                mergedMetadata.put(fieldKey, map2);
                changedKeys.add(existing.getKey() + '.' + fieldKey);
            } else if (!Intrinsics.areEqual((Object)existingFieldValue, (Object)incomingFieldValue)) {
                Map<String, Object> map3 = existing.getMetadata().get(fieldKey);
                Intrinsics.checkNotNull(map3);
                FieldInfo existingFieldInfo = new FieldInfo(existingFieldValue, map3);
                Map<String, Object> map4 = incoming.getMetadata().get(fieldKey);
                Intrinsics.checkNotNull(map4);
                FieldInfo incomingFieldInfo = new FieldInfo(incomingFieldValue, map4);
                FieldInfo mergeResult = this.fieldMerger.mergeFields(existingFieldInfo, incomingFieldInfo);
                mergedFields.put(fieldKey, mergeResult.getValue());
                mergedMetadata.put(fieldKey, mergeResult.getMetadata());
                changedKeys.add(existing.getKey() + '.' + fieldKey);
            }
            if (newDate == null) continue;
            date.put(fieldKey, newDate);
        }
        return TuplesKt.to((Object)new Record(existing.getKey(), (Map<String, ? extends Object>)mergedFields, incoming.getMutationId(), date, mergedMetadata), (Object)changedKeys);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J\u0017\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004H\u00c6\u0003J-\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/apollographql/apollo3/cache/normalized/api/FieldRecordMerger$FieldInfo;", "", "value", "metadata", "", "", "(Ljava/lang/Object;Ljava/util/Map;)V", "getMetadata", "()Ljava/util/Map;", "getValue", "()Ljava/lang/Object;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "apollo-normalized-cache-api-incubating"})
    @ApolloExperimental
    public static final class FieldInfo {
        @Nullable
        private final Object value;
        @NotNull
        private final Map<String, Object> metadata;

        public FieldInfo(@Nullable Object value, @NotNull Map<String, ? extends Object> metadata) {
            Intrinsics.checkNotNullParameter(metadata, (String)"metadata");
            this.value = value;
            this.metadata = metadata;
        }

        @Nullable
        public final Object getValue() {
            return this.value;
        }

        @NotNull
        public final Map<String, Object> getMetadata() {
            return this.metadata;
        }

        @Nullable
        public final Object component1() {
            return this.value;
        }

        @NotNull
        public final Map<String, Object> component2() {
            return this.metadata;
        }

        @NotNull
        public final FieldInfo copy(@Nullable Object value, @NotNull Map<String, ? extends Object> metadata) {
            Intrinsics.checkNotNullParameter(metadata, (String)"metadata");
            return new FieldInfo(value, metadata);
        }

        public static /* synthetic */ FieldInfo copy$default(FieldInfo fieldInfo, Object object, Map map, int n, Object object2) {
            if ((n & 1) != 0) {
                object = fieldInfo.value;
            }
            if ((n & 2) != 0) {
                map = fieldInfo.metadata;
            }
            return fieldInfo.copy(object, map);
        }

        @NotNull
        public String toString() {
            return "FieldInfo(value=" + this.value + ", metadata=" + this.metadata + ')';
        }

        public int hashCode() {
            int result = this.value == null ? 0 : this.value.hashCode();
            result = result * 31 + ((Object)this.metadata).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FieldInfo)) {
                return false;
            }
            FieldInfo fieldInfo = (FieldInfo)other;
            if (!Intrinsics.areEqual((Object)this.value, (Object)fieldInfo.value)) {
                return false;
            }
            return Intrinsics.areEqual(this.metadata, fieldInfo.metadata);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bg\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H&\u00a8\u0006\u0006"}, d2={"Lcom/apollographql/apollo3/cache/normalized/api/FieldRecordMerger$FieldMerger;", "", "mergeFields", "Lcom/apollographql/apollo3/cache/normalized/api/FieldRecordMerger$FieldInfo;", "existing", "incoming", "apollo-normalized-cache-api-incubating"})
    @ApolloExperimental
    public static interface FieldMerger {
        @NotNull
        public FieldInfo mergeFields(@NotNull FieldInfo var1, @NotNull FieldInfo var2);
    }
}

