/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.api.internal;

import com.apollographql.apollo3.annotations.ApolloInternal;
import com.apollographql.apollo3.cache.normalized.api.CacheKey;
import com.apollographql.apollo3.cache.normalized.api.Record;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0001*\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\u0010*\u00020\u0016H\u0002J\u0016\u0010\u0018\u001a\u00020\u0019*\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0002J\u0014\u0010\u001b\u001a\u00020\u0019*\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/apollographql/apollo3/cache/normalized/api/internal/BlobRecordSerializer;", "", "()V", "BOOLEAN", "", "CACHE_KEY", "DOUBLE", "INT", "LIST", "LONG", "MAP", "NULL", "STRING", "deserialize", "Lcom/apollographql/apollo3/cache/normalized/api/Record;", "key", "", "bytes", "", "serialize", "record", "readAny", "Lokio/Buffer;", "readString", "writeAny", "", "value", "writeString", "apollo-normalized-cache-api-incubating"})
@ApolloInternal
@SourceDebugExtension(value={"SMAP\nBlobRecordSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlobRecordSerializer.kt\ncom/apollographql/apollo3/cache/normalized/api/internal/BlobRecordSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,164:1\n1855#2,2:165\n1549#2:169\n1620#2,3:170\n1179#2,2:173\n1253#2,4:175\n215#3,2:167\n*S KotlinDebug\n*F\n+ 1 BlobRecordSerializer.kt\ncom/apollographql/apollo3/cache/normalized/api/internal/BlobRecordSerializer\n*L\n107#1:165,2\n139#1:169\n139#1:170,3\n145#1:173,2\n145#1:175,4\n116#1:167,2\n*E\n"})
public final class BlobRecordSerializer {
    @NotNull
    public static final BlobRecordSerializer INSTANCE = new BlobRecordSerializer();
    private static final int STRING = 0;
    private static final int INT = 1;
    private static final int LONG = 2;
    private static final int BOOLEAN = 3;
    private static final int DOUBLE = 4;
    private static final int LIST = 5;
    private static final int MAP = 6;
    private static final int CACHE_KEY = 7;
    private static final int NULL = 8;

    private BlobRecordSerializer() {
    }

    @NotNull
    public final byte[] serialize(@NotNull Record record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Buffer buffer = new Buffer();
        this.writeAny(buffer, record.getMetadata());
        Set<String> keys = record.getFields().keySet();
        buffer.writeInt(keys.size());
        for (String key : keys) {
            this.writeString(buffer, key);
            Map<String, Long> map = record.getDate();
            this.writeAny(buffer, map != null ? map.get(key) : null);
            this.writeAny(buffer, record.getFields().get(key));
        }
        return buffer.readByteArray();
    }

    @NotNull
    public final Record deserialize(@NotNull String key, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Buffer buffer = new Buffer().write(bytes);
        Object object = this.readAny(buffer);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.collections.Map<kotlin.String, kotlin.Any?>>");
        Map metadata = (Map)object;
        Map fields = new LinkedHashMap();
        Map dates = new LinkedHashMap();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            String name = this.readString(buffer);
            dates.put(name, (Long)this.readAny(buffer));
            fields.put(name, this.readAny(buffer));
        }
        return new Record(key, (Map<String, ? extends Object>)fields, null, dates, metadata);
    }

    private final void writeString(Buffer $this$writeString, String value) {
        $this$writeString.writeInt(value.length());
        $this$writeString.writeUtf8(value);
    }

    private final String readString(Buffer $this$readString) {
        return $this$readString.readUtf8((long)$this$readString.readInt());
    }

    private final void writeAny(Buffer $this$writeAny, Object value) {
        Object object = value;
        if (object instanceof String) {
            $this$writeAny.getBuffer().writeByte(0);
            this.writeString($this$writeAny.getBuffer(), (String)value);
        } else if (object instanceof Integer) {
            $this$writeAny.getBuffer().writeByte(1);
            $this$writeAny.getBuffer().writeInt(((Number)value).intValue());
        } else if (object instanceof Long) {
            $this$writeAny.getBuffer().writeByte(2);
            $this$writeAny.getBuffer().writeLong(((Number)value).longValue());
        } else if (object instanceof Double) {
            $this$writeAny.getBuffer().writeByte(4);
            this.writeString($this$writeAny.getBuffer(), String.valueOf(((Number)value).doubleValue()));
        } else if (object instanceof Boolean) {
            $this$writeAny.getBuffer().writeByte(3);
            $this$writeAny.getBuffer().writeByte((Boolean)value != false ? 1 : 0);
        } else if (object instanceof CacheKey) {
            $this$writeAny.getBuffer().writeByte(7);
            this.writeString($this$writeAny.getBuffer(), ((CacheKey)value).getKey());
        } else if (object instanceof List) {
            $this$writeAny.getBuffer().writeByte(5);
            $this$writeAny.getBuffer().writeInt(((List)value).size());
            Iterable $this$forEach$iv = (Iterable)value;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                INSTANCE.writeAny($this$writeAny.getBuffer(), it);
            }
        } else if (object instanceof Map) {
            $this$writeAny.getBuffer().writeByte(6);
            $this$writeAny.getBuffer().writeInt(((Map)value).size());
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            Map cfr_ignored_0 = (Map)value;
            Map $this$forEach$iv = (Map)value;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                boolean bl = false;
                INSTANCE.writeString($this$writeAny.getBuffer(), (String)it.getKey());
                INSTANCE.writeAny($this$writeAny.getBuffer(), it.getValue());
            }
        } else if (object == null) {
            $this$writeAny.getBuffer().writeByte(8);
        } else {
            throw new IllegalStateException(("Trying to write unsupported Record value: " + value).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Object readAny(Buffer $this$readAny) {
        Object object;
        byte what = $this$readAny.readByte();
        switch (what) {
            case 0: {
                object = this.readString($this$readAny);
                break;
            }
            case 1: {
                object = $this$readAny.readInt();
                break;
            }
            case 2: {
                object = $this$readAny.readLong();
                break;
            }
            case 4: {
                object = Double.parseDouble(this.readString($this$readAny));
                break;
            }
            case 3: {
                object = $this$readAny.readByte() > 0;
                break;
            }
            case 7: {
                object = new CacheKey(this.readString($this$readAny));
                break;
            }
            case 5: {
                void $this$mapTo$iv$iv;
                int size = $this$readAny.readInt();
                Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)size);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(INSTANCE.readAny($this$readAny));
                }
                object = (List)destination$iv$iv;
                break;
            }
            case 6: {
                void $this$associateTo$iv$iv;
                int size = $this$readAny.readInt();
                Iterable $this$associate$iv = (Iterable)RangesKt.until((int)0, (int)size);
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable destination$iv$iv = $this$associate$iv;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                Iterator iterator = $this$associateTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv$iv = ((IntIterator)iterator).nextInt();
                    Map map = destination$iv$iv2;
                    int it = element$iv$iv;
                    boolean bl = false;
                    Pair pair = TuplesKt.to((Object)INSTANCE.readString($this$readAny), (Object)INSTANCE.readAny($this$readAny));
                    map.put(pair.getFirst(), pair.getSecond());
                }
                object = destination$iv$iv2;
                break;
            }
            case 8: {
                object = null;
                break;
            }
            default: {
                throw new IllegalStateException(("Trying to read unsupported Record value: " + what).toString());
            }
        }
        return object;
    }
}

