(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'okio-parent-okio-js-legacy', 'kotlinx-coroutines-core', 'http'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('okio-parent-okio-js-legacy'), require('kotlinx-coroutines-core'), require('http'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'apollo-kotlin-apollo-mockserver-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'apollo-kotlin-apollo-mockserver-js-legacy'.");
    }if (typeof this['okio-parent-okio-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'apollo-kotlin-apollo-mockserver-js-legacy'. Its dependency 'okio-parent-okio-js-legacy' was not found. Please, check whether 'okio-parent-okio-js-legacy' is loaded prior to 'apollo-kotlin-apollo-mockserver-js-legacy'.");
    }if (typeof this['kotlinx-coroutines-core'] === 'undefined') {
      throw new Error("Error loading module 'apollo-kotlin-apollo-mockserver-js-legacy'. Its dependency 'kotlinx-coroutines-core' was not found. Please, check whether 'kotlinx-coroutines-core' is loaded prior to 'apollo-kotlin-apollo-mockserver-js-legacy'.");
    }if (typeof http === 'undefined') {
      throw new Error("Error loading module 'apollo-kotlin-apollo-mockserver-js-legacy'. Its dependency 'http' was not found. Please, check whether 'http' is loaded prior to 'apollo-kotlin-apollo-mockserver-js-legacy'.");
    }root['apollo-kotlin-apollo-mockserver-js-legacy'] = factory(typeof this['apollo-kotlin-apollo-mockserver-js-legacy'] === 'undefined' ? {} : this['apollo-kotlin-apollo-mockserver-js-legacy'], kotlin, this['okio-parent-okio-js-legacy'], this['kotlinx-coroutines-core'], http);
  }
}(this, function (_, Kotlin, $module$okio_parent_okio_js_legacy, $module$kotlinx_coroutines_core, $module$http) {
  'use strict';
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var unboxChar = Kotlin.unboxChar;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var emptyMap = Kotlin.kotlin.collections.emptyMap_q3lmfv$;
  var ByteString = $module$okio_parent_okio_js_legacy.okio.ByteString;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var mapOf = Kotlin.kotlin.collections.mapOf_x2b85n$;
  var plus = Kotlin.kotlin.collections.plus_iwxh38$;
  var delay = $module$kotlinx_coroutines_core.kotlinx.coroutines.delay_s8cxhz$;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var L0 = Kotlin.Long.ZERO;
  var toLongOrNull = Kotlin.kotlin.text.toLongOrNull_pdl1vz$;
  var equals = Kotlin.equals;
  var toString = Kotlin.toString;
  var Buffer_0 = $module$okio_parent_okio_js_legacy.okio.Buffer;
  var toLong = Kotlin.kotlin.text.toLong_6ic1pp$;
  var Regex_init = Kotlin.kotlin.text.Regex_init_61zpoe$;
  var listOf = Kotlin.kotlin.collections.listOf_i5x0yv$;
  var Triple = Kotlin.kotlin.Triple;
  var get_indices = Kotlin.kotlin.text.get_indices_gw00vp$;
  var toBoxedChar = Kotlin.toBoxedChar;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var throwCCE = Kotlin.throwCCE;
  var trim = Kotlin.kotlin.text.trim_gw00vp$;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var isBlank = Kotlin.kotlin.text.isBlank_gw00vp$;
  var get_lastIndex = Kotlin.kotlin.collections.get_lastIndex_55thoc$;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var checkIndexOverflow = Kotlin.kotlin.collections.checkIndexOverflow_za3lpa$;
  var ArrayDeque_init = Kotlin.kotlin.collections.ArrayDeque_init_287e2$;
  var Unit = Kotlin.kotlin.Unit;
  var ensureNotNull = Kotlin.ensureNotNull;
  var removeFirst = Kotlin.kotlin.collections.removeFirst_vvxzk3$;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init;
  var println = Kotlin.kotlin.io.println_s8jyv4$;
  var toList = Kotlin.kotlin.collections.toList_us0mfu$;
  var zipWithNext = Kotlin.kotlin.collections.zipWithNext_7wnvza$;
  var toMap = Kotlin.kotlin.collections.toMap_6hr0sd$;
  var encodeToByteArray = Kotlin.kotlin.text.encodeToByteArray_pdl1vz$;
  var Exception = Kotlin.kotlin.Exception;
  var createServer = $module$http.createServer;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var copyToArray = Kotlin.kotlin.collections.copyToArray;
  var Result = Kotlin.kotlin.Result;
  var intercepted = Kotlin.kotlin.coroutines.intrinsics.intercepted_f9mg25$;
  var SafeContinuation_init = Kotlin.kotlin.coroutines.SafeContinuation_init_wj8d80$;
  function MockServerInterface() {
  }
  MockServerInterface.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'MockServerInterface',
    interfaces: []
  };
  function parseHeader(line) {
    var indexOfFirst$result;
    indexOfFirst$break: do {
      var tmp$, tmp$_0, tmp$_1, tmp$_2;
      tmp$ = get_indices(line);
      tmp$_0 = tmp$.first;
      tmp$_1 = tmp$.last;
      tmp$_2 = tmp$.step;
      for (var index = tmp$_0; index <= tmp$_1; index += tmp$_2) {
        if (unboxChar(toBoxedChar(line.charCodeAt(index))) === 58) {
          indexOfFirst$result = index;
          break indexOfFirst$break;
        }}
      indexOfFirst$result = -1;
    }
     while (false);
    var index_0 = indexOfFirst$result;
    if (!(index_0 >= 0)) {
      var message = 'Invalid header: ' + line;
      throw IllegalStateException_init(message.toString());
    }var $receiver = line.substring(0, index_0);
    var tmp$_3;
    var tmp$_4 = trim(Kotlin.isCharSequence(tmp$_3 = $receiver) ? tmp$_3 : throwCCE()).toString();
    var startIndex = index_0 + 1 | 0;
    var endIndex = line.length;
    var $receiver_0 = line.substring(startIndex, endIndex);
    var tmp$_5;
    return to(tmp$_4, trim(Kotlin.isCharSequence(tmp$_5 = $receiver_0) ? tmp$_5 : throwCCE()).toString());
  }
  function MockRequest(method, path, version, headers, body) {
    if (headers === void 0)
      headers = emptyMap();
    if (body === void 0)
      body = ByteString.Companion.EMPTY;
    this.method = method;
    this.path = path;
    this.version = version;
    this.headers = headers;
    this.body = body;
  }
  MockRequest.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MockRequest',
    interfaces: []
  };
  function Coroutine$writeResponse(sink_0, mockResponse_0, version_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$tmp$_1 = void 0;
    this.local$chunk = void 0;
    this.local$sink = sink_0;
    this.local$mockResponse = mockResponse_0;
    this.local$version = version_0;
  }
  Coroutine$writeResponse.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$writeResponse.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$writeResponse.prototype.constructor = Coroutine$writeResponse;
  Coroutine$writeResponse.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$, tmp$_0;
            this.local$sink.writeUtf8_61zpoe$(this.local$version + ' ' + this.local$mockResponse.statusCode + '\r' + '\n');
            var isChunked = !this.local$mockResponse.chunks.isEmpty();
            tmp$_0 = this.local$mockResponse.headers;
            if (isChunked) {
              tmp$ = mapOf(to('Transfer-Encoding', 'chunked'));
            } else {
              tmp$ = mapOf(to('Content-Length', this.local$mockResponse.body.size.toString()));
            }

            var headers = plus(plus(tmp$_0, tmp$), mapOf(to('Connection', 'close')));
            var tmp$_1;
            tmp$_1 = headers.entries.iterator();
            while (tmp$_1.hasNext()) {
              var element = tmp$_1.next();
              this.local$sink.writeUtf8_61zpoe$(element.key + ': ' + element.value + '\r' + '\n');
            }

            this.local$sink.writeUtf8_61zpoe$('\r\n');
            this.local$sink.flush();
            if (isChunked) {
              this.local$tmp$_1 = this.local$mockResponse.chunks.iterator();
              this.state_0 = 2;
              continue;
            } else {
              if (this.local$mockResponse.body.size > 0) {
                this.local$sink.write_9ovubf$(this.local$mockResponse.body);
                this.local$sink.flush();
              }this.state_0 = 5;
              continue;
            }

          case 1:
            throw this.exception_0;
          case 2:
            if (!this.local$tmp$_1.hasNext()) {
              this.state_0 = 4;
              continue;
            }
            this.local$chunk = this.local$tmp$_1.next();
            this.state_0 = 3;
            this.result_0 = delay(this.local$chunk.delayMillis, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            this.local$sink.writeHexadecimalUnsignedLong_s8cxhz$(Kotlin.Long.fromInt(this.local$chunk.body.size));
            this.local$sink.writeUtf8_61zpoe$('\r\n');
            this.local$sink.write_9ovubf$(this.local$chunk.body);
            this.local$sink.writeUtf8_61zpoe$('\r\n');
            this.local$sink.flush();
            this.state_0 = 2;
            continue;
          case 4:
            this.local$sink.writeUtf8_61zpoe$('0\r\n\r\n');
            this.local$sink.flush();
            this.state_0 = 5;
            continue;
          case 5:
            return;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function writeResponse(sink_0, mockResponse_0, version_0, continuation_0, suspended) {
    var instance = new Coroutine$writeResponse(sink_0, mockResponse_0, version_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function MockResponse(statusCode, body, chunks, headers, delayMillis) {
    if (statusCode === void 0)
      statusCode = 200;
    if (body === void 0)
      body = ByteString.Companion.EMPTY;
    if (chunks === void 0)
      chunks = emptyList();
    if (headers === void 0)
      headers = emptyMap();
    if (delayMillis === void 0)
      delayMillis = L0;
    this.statusCode = statusCode;
    this.body = body;
    this.chunks = chunks;
    this.headers = headers;
    this.delayMillis = delayMillis;
  }
  MockResponse.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MockResponse',
    interfaces: []
  };
  function MockResponse_init(body, chunks, statusCode, headers, delayMillis, $this) {
    if (chunks === void 0)
      chunks = emptyList();
    if (statusCode === void 0)
      statusCode = 200;
    if (headers === void 0)
      headers = emptyMap();
    if (delayMillis === void 0)
      delayMillis = L0;
    $this = $this || Object.create(MockResponse.prototype);
    MockResponse.call($this, statusCode, ByteString.Companion.encodeUtf8_pdl1vz$(body), chunks, headers, delayMillis);
    return $this;
  }
  function MockChunk(body, delayMillis) {
    if (body === void 0)
      body = ByteString.Companion.EMPTY;
    if (delayMillis === void 0)
      delayMillis = L0;
    this.body = body;
    this.delayMillis = delayMillis;
  }
  MockChunk.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MockChunk',
    interfaces: []
  };
  function MockChunk_init(body, delayMillis, $this) {
    if (delayMillis === void 0)
      delayMillis = L0;
    $this = $this || Object.create(MockChunk.prototype);
    MockChunk.call($this, ByteString.Companion.encodeUtf8_pdl1vz$(body), delayMillis);
    return $this;
  }
  function MockServerHandler() {
  }
  MockServerHandler.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'MockServerHandler',
    interfaces: []
  };
  function readRequest(source) {
    var tmp$, tmp$_0, tmp$_1;
    var line = source.readUtf8Line();
    if (line == null) {
      return null;
    }var tmp$_2 = parseRequestLine(line);
    var method = tmp$_2.component1()
    , path = tmp$_2.component2()
    , version = tmp$_2.component3();
    var headers = LinkedHashMap_init();
    while (true) {
      line = source.readUtf8Line();
      var $receiver = line;
      if ($receiver == null || isBlank($receiver)) {
        break;
      }var tmp$_3 = parseHeader(line);
      var key = tmp$_3.component1()
      , value = tmp$_3.component2();
      headers.put_xwzc9p$(key, value);
    }
    var contentLength = (tmp$_0 = (tmp$ = headers.get_11rb$('Content-Length')) != null ? toLongOrNull(tmp$) : null) != null ? tmp$_0 : L0;
    var transferEncoding = (tmp$_1 = headers.get_11rb$('Transfer-Encoding')) != null ? tmp$_1.toLowerCase() : null;
    if (!(transferEncoding == null || equals(transferEncoding, 'identity') || equals(transferEncoding, 'chunked'))) {
      var message = 'Transfer-Encoding ' + toString(transferEncoding) + ' is not supported';
      throw IllegalStateException_init(message.toString());
    }var buffer = new Buffer_0();
    if (contentLength.toNumber() > 0) {
      source.read_u27jpl$(buffer, contentLength);
    } else if (equals(transferEncoding, 'chunked')) {
      readChunked(source, buffer);
    }return new MockRequest(method, path, version, headers, buffer.readByteString());
  }
  function readChunked($receiver, buffer) {
    while (true) {
      var line = $receiver.readUtf8Line();
      if (line == null || isBlank(line))
        break;
      var chunkSize = toLong(line, 16);
      if (equals(chunkSize, L0))
        break;
      $receiver.read_u27jpl$(buffer, chunkSize);
      $receiver.readUtf8Line();
    }
  }
  function parseRequestLine(line) {
    var regex = Regex_init('([A-Z-a-z]*) ([^ ]*) (.*)');
    var match = regex.matchEntire_6bul2c$(line);
    if (!(match != null)) {
      var message = 'Cannot match request line: ' + line;
      throw IllegalStateException_init(message.toString());
    }var method = match.groupValues.get_za3lpa$(1).toUpperCase();
    if (!listOf(['GET', 'POST', 'PUT', 'DELETE', 'HEAD', 'OPTIONS', 'PATCH']).contains_11rb$(method)) {
      var message_0 = 'Unkown method ' + method;
      throw IllegalStateException_init(message_0.toString());
    }return new Triple(method, match.groupValues.get_za3lpa$(2), match.groupValues.get_za3lpa$(3));
  }
  function enqueue($receiver, string, delayMs) {
    if (delayMs === void 0)
      delayMs = L0;
    var byteString = ByteString.Companion.encodeUtf8_pdl1vz$(string);
    $receiver.enqueue_wvyhoh$(new MockResponse(200, byteString, void 0, mapOf(to('Content-Length', byteString.size.toString())), delayMs));
  }
  function enqueueMultipart($receiver, parts, statusCode, partsContentType, headers, responseDelayMillis, chunksDelayMillis, boundary) {
    if (statusCode === void 0)
      statusCode = 200;
    if (partsContentType === void 0)
      partsContentType = 'application/json; charset=utf-8';
    if (headers === void 0)
      headers = emptyMap();
    if (responseDelayMillis === void 0)
      responseDelayMillis = L0;
    if (chunksDelayMillis === void 0)
      chunksDelayMillis = L0;
    if (boundary === void 0)
      boundary = '-';
    $receiver.enqueue_wvyhoh$(createMultipartMixedChunkedResponse(parts, statusCode, partsContentType, headers, responseDelayMillis, chunksDelayMillis, boundary));
  }
  function createMultipartMixedChunkedResponse(parts, statusCode, partsContentType, headers, responseDelayMillis, chunksDelayMillis, boundary) {
    if (statusCode === void 0)
      statusCode = 200;
    if (partsContentType === void 0)
      partsContentType = 'application/json; charset=utf-8';
    if (headers === void 0)
      headers = emptyMap();
    if (responseDelayMillis === void 0)
      responseDelayMillis = L0;
    if (chunksDelayMillis === void 0)
      chunksDelayMillis = L0;
    if (boundary === void 0)
      boundary = '-';
    var tmp$;
    tmp$ = plus(headers, mapOf(to('Content-Type', 'multipart/mixed; boundary=' + '"' + boundary + '"')));
    var destination = ArrayList_init(collectionSizeOrDefault(parts, 10));
    var tmp$_0, tmp$_0_0;
    var index = 0;
    tmp$_0 = parts.iterator();
    while (tmp$_0.hasNext()) {
      var item = tmp$_0.next();
      var tmp$_1 = destination.add_11rb$;
      var index_0 = checkIndexOverflow((tmp$_0_0 = index, index = tmp$_0_0 + 1 | 0, tmp$_0_0));
      var startBoundary = index_0 === 0 ? '--' + boundary + '\r' + '\n' : '';
      var contentLengthHeader = 'Content-Length: ' + item.length;
      var contentTypeHeader = 'Content-Type: ' + partsContentType;
      var endBoundary = index_0 === get_lastIndex(parts) ? '--' + boundary + '--' : '--' + boundary;
      tmp$_1.call(destination, MockChunk_init(startBoundary + (contentLengthHeader + '\r' + '\n') + (contentTypeHeader + '\r' + '\n') + '\r\n' + (item + '\r' + '\n') + (endBoundary + '\r' + '\n'), chunksDelayMillis));
    }
    return new MockResponse(statusCode, void 0, destination, tmp$, responseDelayMillis);
  }
  function CommonQueueMockServerHandler() {
    this.queue_0 = ArrayDeque_init();
  }
  CommonQueueMockServerHandler.prototype.enqueue_wvyhoh$ = function (response) {
    this.queue_0.add_11rb$(response);
  };
  CommonQueueMockServerHandler.prototype.handle_cpqzap$ = function (request) {
    var tmp$;
    var tmp$_0;
    if ((tmp$ = this.queue_0.removeFirstOrNull()) != null)
      tmp$_0 = tmp$;
    else {
      throw IllegalStateException_init('No more responses in queue'.toString());
    }
    return tmp$_0;
  };
  CommonQueueMockServerHandler.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CommonQueueMockServerHandler',
    interfaces: [MockServerHandler]
  };
  function suspendCoroutine$lambda(closure$block) {
    return function (c) {
      var safe = SafeContinuation_init(intercepted(c));
      closure$block(safe);
      return safe.getOrThrow();
    };
  }
  function MockServer(mockServerHandler) {
    if (mockServerHandler === void 0)
      mockServerHandler = new CommonQueueMockServerHandler();
    this.mockServerHandler_v3r0js$_0 = mockServerHandler;
    this.requests_0 = ArrayList_init_0();
    this.url_0 = null;
    this.server_0 = createServer(MockServer$server$lambda(this)).listen();
  }
  Object.defineProperty(MockServer.prototype, 'mockServerHandler', {
    get: function () {
      return this.mockServerHandler_v3r0js$_0;
    }
  });
  function MockServer$sendChunksWithDelays$lambda(closure$res, closure$chunk) {
    return function () {
      closure$res.write(closure$chunk.body.utf8());
      return Unit;
    };
  }
  function MockServer$sendChunksWithDelays$lambda_0(closure$res) {
    return function (it) {
      closure$res.end();
      return Unit;
    };
  }
  MockServer.prototype.sendChunksWithDelays_0 = function (res, chunks) {
    var tmp$;
    var promises = ArrayList_init_0();
    var delayMillis = L0;
    tmp$ = chunks.iterator();
    while (tmp$.hasNext()) {
      var chunk = tmp$.next();
      delayMillis = delayMillis.add(chunk.delayMillis);
      var element = this.schedule_0(delayMillis, MockServer$sendChunksWithDelays$lambda(res, chunk));
      promises.add_11rb$(element);
    }
    Promise.all(copyToArray(promises)).then(MockServer$sendChunksWithDelays$lambda_0(res));
  };
  function MockServer$schedule$lambda$lambda(closure$block, closure$resolve) {
    return function (it) {
      closure$block();
      closure$resolve(Unit);
      return Unit;
    };
  }
  function MockServer$schedule$lambda(closure$block, closure$delayMillis) {
    return function (resolve, f) {
      setTimeout(MockServer$schedule$lambda$lambda(closure$block, resolve), closure$delayMillis);
      return Unit;
    };
  }
  MockServer.prototype.schedule_0 = function (delayMillis, block) {
    return new Promise(MockServer$schedule$lambda(block, delayMillis));
  };
  function MockServer$url$lambda$lambda(closure$cont, this$MockServer) {
    return function (f) {
      var $receiver = closure$cont;
      var value = ensureNotNull(this$MockServer.url_0);
      $receiver.resumeWith_tl1gpc$(new Result(value));
      return Unit;
    };
  }
  function MockServer$url$lambda(this$MockServer) {
    return function (cont) {
      this$MockServer.url_0 = 'http://localhost:' + this$MockServer.server_0.address().port.toString() + '/';
      this$MockServer.server_0.on('listening', MockServer$url$lambda$lambda(cont, this$MockServer));
      return Unit;
    };
  }
  function Coroutine$url($this, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$tmp$ = void 0;
  }
  Coroutine$url.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$url.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$url.prototype.constructor = Coroutine$url;
  Coroutine$url.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$tmp$ = this.$this.url_0;
            if (this.local$tmp$ == null) {
              this.state_0 = 2;
              this.result_0 = suspendCoroutine$lambda(MockServer$url$lambda(this.$this))(this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              this.state_0 = 3;
              continue;
            }

          case 1:
            throw this.exception_0;
          case 2:
            this.result_0;
            this.local$tmp$ = this.result_0;
            this.state_0 = 3;
            continue;
          case 3:
            return this.local$tmp$;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  MockServer.prototype.url = function (continuation_0, suspended) {
    var instance = new Coroutine$url(this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  MockServer.prototype.enqueue_wvyhoh$ = function (mockResponse) {
    var tmp$, tmp$_0;
    if (((tmp$_0 = Kotlin.isType(tmp$ = this.mockServerHandler, CommonQueueMockServerHandler) ? tmp$ : null) != null ? (tmp$_0.enqueue_wvyhoh$(mockResponse), Unit) : null) == null) {
      throw IllegalStateException_init('Apollo: cannot call MockServer.enqueue() with a custom handler'.toString());
    }};
  MockServer.prototype.takeRequest = function () {
    return removeFirst(this.requests_0);
  };
  function MockServer$stop$lambda$lambda(closure$cont) {
    return function (it) {
      closure$cont.resumeWith_tl1gpc$(new Result(Unit));
      return Unit;
    };
  }
  function MockServer$stop$lambda(this$MockServer) {
    return function (cont) {
      this$MockServer.server_0.close(MockServer$stop$lambda$lambda(cont));
      return Unit;
    };
  }
  function Coroutine$stop($this, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
  }
  Coroutine$stop.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$stop.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$stop.prototype.constructor = Coroutine$stop;
  Coroutine$stop.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = suspendCoroutine$lambda(MockServer$stop$lambda(this.$this))(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.result_0;
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  MockServer.prototype.stop = function (continuation_0, suspended) {
    var instance = new Coroutine$stop(this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function MockServer$server$lambda$lambda(closure$requestBody) {
    return function (chunk) {
      if (typeof chunk === 'string')
        closure$requestBody.append_pdl1vj$(chunk);
      else if (Kotlin.isType(chunk, Buffer))
        closure$requestBody.append_pdl1vj$(chunk.toString('utf8'));
      else
        println('WTF');
      return Unit;
    };
  }
  function MockServer$server$lambda$lambda$lambda(closure$mockResponse, closure$res, this$MockServer) {
    return function () {
      closure$res.statusCode = closure$mockResponse.statusCode;
      var $receiver = closure$mockResponse.headers;
      var tmp$;
      tmp$ = $receiver.entries.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        closure$res.setHeader(element.key, element.value);
      }
      if (!closure$mockResponse.chunks.isEmpty()) {
        this$MockServer.sendChunksWithDelays_0(closure$res, closure$mockResponse.chunks);
      } else {
        closure$res.end(closure$mockResponse.body.utf8());
      }
      return Unit;
    };
  }
  function MockServer$server$lambda$lambda_0(closure$req, closure$requestBody, this$MockServer, closure$res) {
    return function (f) {
      var tmp$;
      var request = new MockRequest(closure$req.method, closure$req.url, closure$req.httpVersion, toMap(zipWithNext(toList(closure$req.rawHeaders))), ByteString.Companion.toByteString_ietg8x$(encodeToByteArray(closure$requestBody.toString())));
      this$MockServer.requests_0.add_11rb$(request);
      try {
        tmp$ = this$MockServer.mockServerHandler.handle_cpqzap$(request);
      } catch (e) {
        if (Kotlin.isType(e, Exception)) {
          throw new Exception('MockServerHandler.handle() threw an exception: ' + toString(e.message), e);
        } else
          throw e;
      }
      var mockResponse = tmp$;
      this$MockServer.schedule_0(mockResponse.delayMillis, MockServer$server$lambda$lambda$lambda(mockResponse, closure$res, this$MockServer));
      return Unit;
    };
  }
  function MockServer$server$lambda(this$MockServer) {
    return function (req, res) {
      var requestBody = StringBuilder_init();
      req.on('data', MockServer$server$lambda$lambda(requestBody));
      req.on('end', MockServer$server$lambda$lambda_0(req, requestBody, this$MockServer, res));
      return Unit;
    };
  }
  MockServer.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MockServer',
    interfaces: [MockServerInterface]
  };
  var package$com = _.com || (_.com = {});
  var package$apollographql = package$com.apollographql || (package$com.apollographql = {});
  var package$apollo3 = package$apollographql.apollo3 || (package$apollographql.apollo3 = {});
  var package$mockserver = package$apollo3.mockserver || (package$apollo3.mockserver = {});
  package$mockserver.MockServerInterface = MockServerInterface;
  package$mockserver.parseHeader_61zpoe$ = parseHeader;
  package$mockserver.MockRequest = MockRequest;
  package$mockserver.writeResponse_t309ff$ = writeResponse;
  package$mockserver.MockResponse_init_8g8q1q$ = MockResponse_init;
  package$mockserver.MockResponse = MockResponse;
  package$mockserver.MockChunk_init_4wgjuj$ = MockChunk_init;
  package$mockserver.MockChunk = MockChunk;
  package$mockserver.MockServerHandler = MockServerHandler;
  package$mockserver.readRequest_7yjnbr$ = readRequest;
  package$mockserver.parseRequestLine_61zpoe$ = parseRequestLine;
  package$mockserver.enqueue_sfupap$ = enqueue;
  package$mockserver.enqueueMultipart_x3s6tm$ = enqueueMultipart;
  package$mockserver.createMultipartMixedChunkedResponse_w7f726$ = createMultipartMixedChunkedResponse;
  package$mockserver.CommonQueueMockServerHandler = CommonQueueMockServerHandler;
  package$mockserver.MockServer = MockServer;
  Kotlin.defineModule('apollo-kotlin-apollo-mockserver-js-legacy', _);
  return _;
}));

//# sourceMappingURL=apollo-kotlin-apollo-mockserver-js-legacy.js.map
