/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.http;

import com.apollographql.apollo3.api.cache.http.HttpCachePolicy;
import com.apollographql.apollo3.cache.http.internal.HttpDate;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010 \u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010!\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\"\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010#\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010%\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bJ\u0012\u0010&\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010'\u001a\u00020\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020,2\u0006\u0010+\u001a\u00020,H\u0002J\u000e\u0010-\u001a\u00020,2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010/\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/apollographql/apollo3/cache/http/Utils;", "", "()V", "EMPTY_BYTE_ARRAY", "", "EMPTY_RESPONSE", "Lokhttp3/ResponseBody;", "kotlin.jvm.PlatformType", "closeQuietly", "", "source", "Ljava/io/Closeable;", "copyResponseBody", "response", "Lokhttp3/Response;", "sink", "Lokio/Sink;", "discard", "", "Lokio/Source;", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "fetchStrategy", "Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$FetchStrategy;", "request", "Lokhttp3/Request;", "isNetworkFirst", "isNetworkOnly", "isPrefetchResponse", "isStale", "shouldExpireAfterRead", "shouldSkipCache", "shouldSkipNetwork", "skipAll", "duration", "skipStoreResponse", "strip", "unsatisfiableCacheRequest", "varyFields", "", "", "responseHeaders", "Lokhttp3/Headers;", "varyHeaders", "requestHeaders", "withServedDateHeader", "apollo-http-cache"})
public final class Utils {
    private static final byte[] EMPTY_BYTE_ARRAY;
    private static final ResponseBody EMPTY_RESPONSE;
    @NotNull
    public static final Utils INSTANCE;

    @Nullable
    public final Response strip(@Nullable Response response) {
        Response response2 = response;
        return response2 != null && (response2 = response2.newBuilder()) != null && (response2 = response2.body(null)) != null && (response2 = response2.networkResponse(null)) != null && (response2 = response2.cacheResponse(null)) != null ? response2.build() : null;
    }

    @NotNull
    public final Response withServedDateHeader(@NotNull Response response) throws IOException {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Response response2 = response.newBuilder().addHeader("X-APOLLO-SERVED-DATE", HttpDate.INSTANCE.format(new Date())).build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"response.newBuilder()\n  \u2026Date()))\n        .build()");
        return response2;
    }

    public final boolean isPrefetchResponse(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return StringsKt.equals((String)String.valueOf(Boolean.TRUE), (String)request.header("X-APOLLO-PREFETCH"), (boolean)true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldSkipCache(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String cacheKey = request.header("X-APOLLO-CACHE-KEY");
        HttpCachePolicy.FetchStrategy fetchStrategy = this.fetchStrategy(request);
        if (cacheKey == null) return true;
        CharSequence charSequence = cacheKey;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        if (fetchStrategy != null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldSkipNetwork(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String cacheKey = request.header("X-APOLLO-CACHE-KEY");
        HttpCachePolicy.FetchStrategy fetchStrategy = this.fetchStrategy(request);
        if (cacheKey == null) return false;
        CharSequence charSequence = cacheKey;
        boolean bl = false;
        if (charSequence.length() <= 0) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        if (fetchStrategy != HttpCachePolicy.FetchStrategy.CACHE_ONLY) return false;
        return true;
    }

    public final boolean isNetworkOnly(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        HttpCachePolicy.FetchStrategy fetchStrategy = this.fetchStrategy(request);
        return fetchStrategy == HttpCachePolicy.FetchStrategy.NETWORK_ONLY;
    }

    public final boolean isNetworkFirst(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        HttpCachePolicy.FetchStrategy fetchStrategy = this.fetchStrategy(request);
        return fetchStrategy == HttpCachePolicy.FetchStrategy.NETWORK_FIRST;
    }

    public final boolean shouldExpireAfterRead(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return StringsKt.equals((String)String.valueOf(Boolean.TRUE), (String)request.header("X-APOLLO-EXPIRE-AFTER-READ"), (boolean)true);
    }

    public final boolean skipStoreResponse(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return StringsKt.equals((String)String.valueOf(Boolean.TRUE), (String)request.header("X-APOLLO-CACHE-DO-NOT-STORE"), (boolean)true);
    }

    @NotNull
    public final Response unsatisfiableCacheRequest(@Nullable Request request) {
        Response response = new Response.Builder().request(request).protocol(Protocol.HTTP_1_1).code(504).message("Unsatisfiable Request (cache-only)").body(EMPTY_RESPONSE).sentRequestAtMillis(-1L).receivedResponseAtMillis(System.currentTimeMillis()).build();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"Response.Builder()\n     \u2026illis())\n        .build()");
        return response;
    }

    public final void copyResponseBody(@NotNull Response response, @NotNull Sink sink) throws IOException {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        int bufferSize = 8192;
        ResponseBody responseBody = response.body();
        Intrinsics.checkNotNull((Object)responseBody);
        BufferedSource responseBodySource = responseBody.source();
        BufferedSink cacheResponseBody = Okio.buffer((Sink)sink);
        while (responseBodySource.read(cacheResponseBody.getBuffer(), (long)bufferSize) > 0L) {
            cacheResponseBody.emit();
        }
        BufferedSource bufferedSource = responseBodySource;
        Intrinsics.checkNotNullExpressionValue((Object)bufferedSource, (String)"responseBodySource");
        this.closeQuietly((Closeable)bufferedSource);
    }

    public final void closeQuietly(@NotNull Closeable source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        try {
            source.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final boolean discard(@NotNull Source source, int timeout, @NotNull TimeUnit timeUnit) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        try {
            bl = this.skipAll(source, timeout, timeUnit);
        }
        catch (IOException e) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean skipAll(@NotNull Source source, int duration, @NotNull TimeUnit timeUnit) throws IOException {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        long now = System.nanoTime();
        long originalDuration = source.timeout().hasDeadline() ? source.timeout().deadlineNanoTime() - now : Long.MAX_VALUE;
        source.timeout().deadlineNanoTime(now + RangesKt.coerceAtMost((long)originalDuration, (long)timeUnit.toNanos(duration)));
        try {
            Buffer skipBuffer = new Buffer();
            while (source.read(skipBuffer, 8192L) != -1L) {
                skipBuffer.clear();
            }
            bl = true;
        }
        catch (InterruptedIOException e) {
            bl = false;
        }
        finally {
            if (originalDuration == Long.MAX_VALUE) {
                source.timeout().clearDeadline();
            } else {
                source.timeout().deadlineNanoTime(now + originalDuration);
            }
        }
        return bl;
    }

    public final boolean isStale(@NotNull Request request, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String timeoutStr = request.header("X-APOLLO-EXPIRE-TIMEOUT");
        String servedDateStr = response.header("X-APOLLO-SERVED-DATE");
        if (servedDateStr == null || timeoutStr == null) {
            return true;
        }
        String string = timeoutStr;
        boolean bl = false;
        long timeout = Long.parseLong(string);
        if (timeout == 0L) {
            return false;
        }
        Date servedDate = HttpDate.INSTANCE.parse(servedDateStr);
        long now = System.currentTimeMillis();
        return servedDate == null || now - servedDate.getTime() > timeout;
    }

    @NotNull
    public final Headers varyHeaders(@NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Response response2 = response.networkResponse();
        Intrinsics.checkNotNull((Object)response2);
        Headers requestHeaders = response2.request().headers();
        Headers responseHeaders = response.headers();
        Headers headers = requestHeaders;
        Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"requestHeaders");
        Headers headers2 = responseHeaders;
        Intrinsics.checkNotNullExpressionValue((Object)headers2, (String)"responseHeaders");
        return this.varyHeaders(headers, headers2);
    }

    private final Headers varyHeaders(Headers requestHeaders, Headers responseHeaders) {
        Set<String> varyFields = this.varyFields(responseHeaders);
        if (varyFields.isEmpty()) {
            Headers headers = new Headers.Builder().build();
            Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"Headers.Builder().build()");
            return headers;
        }
        Headers.Builder result = new Headers.Builder();
        int size = requestHeaders.size();
        for (int i = 0; i < size; ++i) {
            String fieldName = requestHeaders.name(i);
            if (!varyFields.contains(fieldName)) continue;
            result.add(fieldName, requestHeaders.value(i));
        }
        Headers headers = result.build();
        Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"result.build()");
        return headers;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> varyFields(Headers responseHeaders) {
        boolean bl = false;
        Set result = new LinkedHashSet();
        int i = 0;
        int size = responseHeaders.size();
        while (i < size) {
            String[] stringArray;
            if (!StringsKt.equals((String)"Vary", (String)responseHeaders.name(i), (boolean)true)) {
                ++i;
                continue;
            }
            String value = responseHeaders.value(i);
            if (result.isEmpty()) {
                result = new TreeSet(String.CASE_INSENSITIVE_ORDER);
            }
            String string = value;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value");
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)string, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray2 = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            if (thisCollection$iv.toArray(new String[0]) == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                void $this$trim$iv;
                String varyField;
                String $i$f$toTypedArray2 = varyField = stringArray[j];
                Set set = result;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl2 = false;
                    boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                String string2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                set.add(string2);
            }
            ++i;
        }
        return result;
    }

    private final HttpCachePolicy.FetchStrategy fetchStrategy(Request request) {
        String fetchStrategyHeader;
        block4: {
            block3: {
                fetchStrategyHeader = request.header("X-APOLLO-CACHE-FETCH-STRATEGY");
                if (fetchStrategyHeader == null) break block3;
                CharSequence charSequence = fetchStrategyHeader;
                int n = 0;
                if (!(charSequence.length() == 0)) break block4;
            }
            return null;
        }
        for (HttpCachePolicy.FetchStrategy fetchStrategy : HttpCachePolicy.FetchStrategy.values()) {
            if (!Intrinsics.areEqual((Object)fetchStrategy.name(), (Object)fetchStrategyHeader)) continue;
            return fetchStrategy;
        }
        return null;
    }

    private Utils() {
    }

    static {
        Utils utils;
        INSTANCE = utils = new Utils();
        EMPTY_BYTE_ARRAY = new byte[0];
        EMPTY_RESPONSE = ResponseBody.create(null, (byte[])EMPTY_BYTE_ARRAY);
    }
}

